# -*-rpm-spec-mode-*-

%define info yes
%define docdir %{_docdir}/lilypond/

Name: lilypond
Version: 2.9.20
Release: 1
License: GPL
Group: Applications/Publishing
Source0: http://lilypond.org/download/development/lilypond-2.9.20.tar.gz
Summary: Create and print music notation 
URL: http://lilypond.org/
BuildRoot: %{_tmppath}/%{name}-%{version}-root


Buildrequires: t1utils bison flex mftrace ImageMagick
Buildrequires: texinfo >= 4.7
Buildrequires: guile-devel >= 1.6.4-8 
Buildrequires: freetype-devel >= 2.1

Buildrequires: fontforge
#fontforge must be >= 20041211 urg. 0.0.0-fdr.1.20041211

Buildrequires: pango-devel >= 1.6.0
Buildrequires: fontconfig-devel

Requires: libstdc++ python 
Requires: guile >= 1.6.4-8 ghostscript >= 8.15

%description
LilyPond lets you create music notation.  It produces
beautiful sheet music from a high-level description file.

%package documentation
Summary:  All LilyPond documentation, in HTML
Group: Applications/Publishing
# BuildArchitectures: noarch

%description documentation
Documentation and example files of LilyPond.  An index is available at
%{docdir}/web/Documentation/index.html

%prep
%setup

%build

# DO NOT use % { configure } , it hardcodes all paths, runs libtool,
# so we can't do make prefixix=/tmp/ install.

# In fact, do not take out the spaces between % and { in the above comment,
# because RPM will gladly do a substitution anyway.

# compile with static libstdc++ for better platform portability.
./configure --enable-static-gxx --disable-checking --prefix=%{_prefix} --enable-optimising


make -j2 all
make web
make -C Documentation/user local_package_docdir=%{docdir} omf

%install


rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/tmp/lilypond-rpm-doc

make prefix="$RPM_BUILD_ROOT%{_prefix}" \
	infodir="$RPM_BUILD_ROOT%{_infodir}"  \
	mandir="$RPM_BUILD_ROOT%{_mandir}" install

#emacs
mkdir -p $RPM_BUILD_ROOT%{_datadir}/emacs/site-lisp/site-start.d
install -m 644 elisp/lilypond-init.el  $RPM_BUILD_ROOT%{_datadir}/emacs/site-lisp/site-start.d

#manual pages
gzip -9fn $RPM_BUILD_ROOT%{_mandir}/man1/*


# profile scripts.


# web doc
make prefix="$RPM_BUILD_ROOT%{_prefix}" \
  infodir="$RPM_BUILD_ROOT%{_infodir}"  \
  webdir="$RPM_BUILD_ROOT%{_prefix}/share/doc/lilypond/" web-install

ln -sf ../../doc/lilypond/Documentation/user/*png $RPM_BUILD_ROOT%{_infodir}/lilypond/

# info 
%if %{info}
rm -f $RPM_BUILD_ROOT/%{_infodir}/dir
gzip -9fn `find $RPM_BUILD_ROOT%{_infodir}/ -name '*.info'`
%endif



%post

touch /tmp/.lilypond-install

%if %{info}
  /sbin/install-info %{_infodir}/lilypond/lilypond.info.gz %{_infodir}/dir 
  /sbin/install-info %{_infodir}/lilypond/lilypond-internals.info.gz %{_infodir}/dir 
  /sbin/install-info %{_infodir}/lilypond/music-glossary.info.gz %{_infodir}/dir 
%endif

export PACKAGEDIR=%{_datadir}/lilypond/2.9.20
if [ -d /usr/share/vim ]; then
  VIMDIR=`find /usr/share/vim -name bugreport.vim`
  VIMDIR=`dirname $VIMDIR`
  for a in `cd $PACKAGEDIR/vim/ ; find -type d -name '*' ` ; do
     mkdir -p  $VIMDIR/$a
     ln -s $PACKAGEDIR/vim/$a/*.vim $VIMDIR/$a/
  done
fi


%preun
if [ -f /usr/share/lilypond/%{version}/ls-R ]; then
  rm -f /usr/share/lilypond/%{version}/ls-R
fi


if [ -d /usr/share/vim ]; then
	rm `find /usr/share/vim -name 'lilypond*.vim'`
fi


%if %{info}
    /sbin/install-info --delete %{_infodir}/lilypond/lilypond.info.gz %{_infodir}/dir 
    /sbin/install-info --delete %{_infodir}/lilypond/lilypond-internals.info.gz %{_infodir}/dir 
    /sbin/install-info --delete %{_infodir}/lilypond/music-glossary.info.gz %{_infodir}/dir 
%endif

# chkfontpath --remove=%{_datadir}/share/lilypond/2.9.20/fonts/type1n/

%postun

%post documentation
scrollkeeper-update

%postun documentation
scrollkeeper-update



%files
%defattr(-, root, root)
%{_datadir}/emacs/site-lisp/lilypond*
%{_datadir}/emacs/site-lisp/site-start.d/lilypond*

%{_bindir}/abc2ly
%{_bindir}/convert-ly
%{_bindir}/etf2ly
%{_bindir}/lilypond
%{_bindir}/midi2ly
%{_bindir}/lilypond-book
%{_bindir}/mup2ly
%{_bindir}/musicxml2ly
%{_bindir}/lilypond-invoke-editor

%doc THANKS
%doc COPYING
%doc DEDICATION
%doc README.txt
%doc AUTHORS.txt
%doc INSTALL.txt
%doc NEWS.txt

%if %{info}
%{_infodir}/lilypond/
%endif

%{_mandir}/man1/abc2ly.1.gz
%{_mandir}/man1/musicxml2ly.1.gz
%{_mandir}/man1/convert-ly.1.gz
%{_mandir}/man1/etf2ly.1.gz
%{_mandir}/man1/lilypond.1.gz
%{_mandir}/man1/midi2ly.1.gz
%{_mandir}/man1/lilypond-book.1.gz
%{_mandir}/man1/mup2ly.1.gz
%{_mandir}/man1/lilypond-invoke-editor.1.gz

%{_datadir}/lilypond/2.9.20/
%{_datadir}/locale/*/LC_MESSAGES/lilypond.mo
%{_libdir}/lilypond/


%files documentation

%defattr(-, root, root)

%{docdir}
%{_datadir}/omf/lilypond/2.9.20


%clean
rm -rf %{buildroot
