/* A Bison parser, made by GNU Bison 2.0a.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 1



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     PREC_TOP = 258,
     ADDLYRICS = 259,
     PREC_BOT = 260,
     ACCEPTS = 261,
     ADDQUOTE = 262,
     ALIAS = 263,
     ALTERNATIVE = 264,
     BAR = 265,
     BOOK = 266,
     CHANGE = 267,
     CHORDMODE = 268,
     CHORDS = 269,
     CLEF = 270,
     CONSISTS = 271,
     CONTEXT = 272,
     DEFAULT = 273,
     DEFAULTCHILD = 274,
     DENIES = 275,
     DESCRIPTION = 276,
     DRUMMODE = 277,
     DRUMS = 278,
     FIGUREMODE = 279,
     FIGURES = 280,
     GROBDESCRIPTIONS = 281,
     HEADER = 282,
     INVALID = 283,
     KEY = 284,
     LAYOUT = 285,
     LYRICMODE = 286,
     LYRICS = 287,
     LYRICSTO = 288,
     MARK = 289,
     MARKUP = 290,
     MIDI = 291,
     NAME = 292,
     NOTEMODE = 293,
     OBJECTID = 294,
     OCTAVE = 295,
     ONCE = 296,
     OVERRIDE = 297,
     PAPER = 298,
     PARTIAL = 299,
     RELATIVE = 300,
     REMOVE = 301,
     REPEAT = 302,
     REST = 303,
     REVERT = 304,
     SCORE = 305,
     SEQUENTIAL = 306,
     SET = 307,
     SIMULTANEOUS = 308,
     SKIP = 309,
     TAG = 310,
     TEMPO = 311,
     TIMES = 312,
     TRANSPOSE = 313,
     TRANSPOSITION = 314,
     TYPE = 315,
     UNSET = 316,
     WITH = 317,
     TIME_T = 318,
     NEWCONTEXT = 319,
     CHORD_BASS = 320,
     CHORD_CARET = 321,
     CHORD_COLON = 322,
     CHORD_MINUS = 323,
     CHORD_SLASH = 324,
     DOUBLE_ANGLE_CLOSE = 325,
     DOUBLE_ANGLE_OPEN = 326,
     E_BACKSLASH = 327,
     E_ANGLE_CLOSE = 328,
     E_CHAR = 329,
     E_CLOSE = 330,
     E_EXCLAMATION = 331,
     E_BRACKET_OPEN = 332,
     E_OPEN = 333,
     E_BRACKET_CLOSE = 334,
     E_ANGLE_OPEN = 335,
     E_PLUS = 336,
     E_TILDE = 337,
     EXTENDER = 338,
     FIGURE_CLOSE = 339,
     FIGURE_OPEN = 340,
     FIGURE_SPACE = 341,
     HYPHEN = 342,
     CHORDMODIFIERS = 343,
     LYRIC_MARKUP = 344,
     MULTI_MEASURE_REST = 345,
     SCM_T = 346,
     DIGIT = 347,
     E_UNSIGNED = 348,
     UNSIGNED = 349,
     BOOK_IDENTIFIER = 350,
     CHORDMODIFIER_PITCH = 351,
     CHORD_MODIFIER = 352,
     CONTEXT_DEF_IDENTIFIER = 353,
     DRUM_PITCH = 354,
     DURATION_IDENTIFIER = 355,
     EVENT_IDENTIFIER = 356,
     FRACTION = 357,
     LYRICS_STRING = 358,
     LYRIC_MARKUP_IDENTIFIER = 359,
     MARKUP_HEAD_EMPTY = 360,
     MARKUP_HEAD_LIST0 = 361,
     MARKUP_HEAD_MARKUP0 = 362,
     MARKUP_HEAD_MARKUP0_MARKUP1 = 363,
     MARKUP_HEAD_SCM0 = 364,
     MARKUP_HEAD_SCM0_MARKUP1 = 365,
     MARKUP_HEAD_SCM0_SCM1 = 366,
     MARKUP_HEAD_SCM0_SCM1_MARKUP2 = 367,
     MARKUP_HEAD_SCM0_SCM1_SCM2 = 368,
     MARKUP_IDENTIFIER = 369,
     MUSIC_FUNCTION = 370,
     MUSIC_FUNCTION_MARKUP = 371,
     MUSIC_FUNCTION_MARKUP_MARKUP = 372,
     MUSIC_FUNCTION_MARKUP_MARKUP_MUSIC = 373,
     MUSIC_FUNCTION_MARKUP_MUSIC = 374,
     MUSIC_FUNCTION_MARKUP_MUSIC_MUSIC = 375,
     MUSIC_FUNCTION_MUSIC = 376,
     MUSIC_FUNCTION_MUSIC_MUSIC = 377,
     MUSIC_FUNCTION_SCM = 378,
     MUSIC_FUNCTION_SCM_MUSIC = 379,
     MUSIC_FUNCTION_SCM_MUSIC_MUSIC = 380,
     MUSIC_FUNCTION_SCM_SCM = 381,
     MUSIC_FUNCTION_SCM_SCM_MUSIC = 382,
     MUSIC_FUNCTION_SCM_SCM_SCM = 383,
     MUSIC_IDENTIFIER = 384,
     NOTENAME_PITCH = 385,
     NUMBER_IDENTIFIER = 386,
     OUTPUT_DEF_IDENTIFIER = 387,
     REAL = 388,
     RESTNAME = 389,
     SCM_IDENTIFIER = 390,
     SCORE_IDENTIFIER = 391,
     STRING = 392,
     STRING_IDENTIFIER = 393,
     TONICNAME_PITCH = 394,
     UNARY_MINUS = 395
   };
#endif
#define PREC_TOP 258
#define ADDLYRICS 259
#define PREC_BOT 260
#define ACCEPTS 261
#define ADDQUOTE 262
#define ALIAS 263
#define ALTERNATIVE 264
#define BAR 265
#define BOOK 266
#define CHANGE 267
#define CHORDMODE 268
#define CHORDS 269
#define CLEF 270
#define CONSISTS 271
#define CONTEXT 272
#define DEFAULT 273
#define DEFAULTCHILD 274
#define DENIES 275
#define DESCRIPTION 276
#define DRUMMODE 277
#define DRUMS 278
#define FIGUREMODE 279
#define FIGURES 280
#define GROBDESCRIPTIONS 281
#define HEADER 282
#define INVALID 283
#define KEY 284
#define LAYOUT 285
#define LYRICMODE 286
#define LYRICS 287
#define LYRICSTO 288
#define MARK 289
#define MARKUP 290
#define MIDI 291
#define NAME 292
#define NOTEMODE 293
#define OBJECTID 294
#define OCTAVE 295
#define ONCE 296
#define OVERRIDE 297
#define PAPER 298
#define PARTIAL 299
#define RELATIVE 300
#define REMOVE 301
#define REPEAT 302
#define REST 303
#define REVERT 304
#define SCORE 305
#define SEQUENTIAL 306
#define SET 307
#define SIMULTANEOUS 308
#define SKIP 309
#define TAG 310
#define TEMPO 311
#define TIMES 312
#define TRANSPOSE 313
#define TRANSPOSITION 314
#define TYPE 315
#define UNSET 316
#define WITH 317
#define TIME_T 318
#define NEWCONTEXT 319
#define CHORD_BASS 320
#define CHORD_CARET 321
#define CHORD_COLON 322
#define CHORD_MINUS 323
#define CHORD_SLASH 324
#define DOUBLE_ANGLE_CLOSE 325
#define DOUBLE_ANGLE_OPEN 326
#define E_BACKSLASH 327
#define E_ANGLE_CLOSE 328
#define E_CHAR 329
#define E_CLOSE 330
#define E_EXCLAMATION 331
#define E_BRACKET_OPEN 332
#define E_OPEN 333
#define E_BRACKET_CLOSE 334
#define E_ANGLE_OPEN 335
#define E_PLUS 336
#define E_TILDE 337
#define EXTENDER 338
#define FIGURE_CLOSE 339
#define FIGURE_OPEN 340
#define FIGURE_SPACE 341
#define HYPHEN 342
#define CHORDMODIFIERS 343
#define LYRIC_MARKUP 344
#define MULTI_MEASURE_REST 345
#define SCM_T 346
#define DIGIT 347
#define E_UNSIGNED 348
#define UNSIGNED 349
#define BOOK_IDENTIFIER 350
#define CHORDMODIFIER_PITCH 351
#define CHORD_MODIFIER 352
#define CONTEXT_DEF_IDENTIFIER 353
#define DRUM_PITCH 354
#define DURATION_IDENTIFIER 355
#define EVENT_IDENTIFIER 356
#define FRACTION 357
#define LYRICS_STRING 358
#define LYRIC_MARKUP_IDENTIFIER 359
#define MARKUP_HEAD_EMPTY 360
#define MARKUP_HEAD_LIST0 361
#define MARKUP_HEAD_MARKUP0 362
#define MARKUP_HEAD_MARKUP0_MARKUP1 363
#define MARKUP_HEAD_SCM0 364
#define MARKUP_HEAD_SCM0_MARKUP1 365
#define MARKUP_HEAD_SCM0_SCM1 366
#define MARKUP_HEAD_SCM0_SCM1_MARKUP2 367
#define MARKUP_HEAD_SCM0_SCM1_SCM2 368
#define MARKUP_IDENTIFIER 369
#define MUSIC_FUNCTION 370
#define MUSIC_FUNCTION_MARKUP 371
#define MUSIC_FUNCTION_MARKUP_MARKUP 372
#define MUSIC_FUNCTION_MARKUP_MARKUP_MUSIC 373
#define MUSIC_FUNCTION_MARKUP_MUSIC 374
#define MUSIC_FUNCTION_MARKUP_MUSIC_MUSIC 375
#define MUSIC_FUNCTION_MUSIC 376
#define MUSIC_FUNCTION_MUSIC_MUSIC 377
#define MUSIC_FUNCTION_SCM 378
#define MUSIC_FUNCTION_SCM_MUSIC 379
#define MUSIC_FUNCTION_SCM_MUSIC_MUSIC 380
#define MUSIC_FUNCTION_SCM_SCM 381
#define MUSIC_FUNCTION_SCM_SCM_MUSIC 382
#define MUSIC_FUNCTION_SCM_SCM_SCM 383
#define MUSIC_IDENTIFIER 384
#define NOTENAME_PITCH 385
#define NUMBER_IDENTIFIER 386
#define OUTPUT_DEF_IDENTIFIER 387
#define REAL 388
#define RESTNAME 389
#define SCM_IDENTIFIER 390
#define SCORE_IDENTIFIER 391
#define STRING 392
#define STRING_IDENTIFIER 393
#define TONICNAME_PITCH 394
#define UNARY_MINUS 395




/* Copy the first part of user declarations.  */
#line 1 "parser.yy"
 // -*-Fundamental-*-

/*
  parser.yy -- Bison/C++ parser for LilyPond

  source file of the GNU LilyPond music typesetter

  (c) 1997--2005 Han-Wen Nienhuys <hanwen@xs4all.nl>
                 Jan Nieuwenhuizen <janneke@gnu.org>
*/

/*
FIXME:

   * The rules for who is protecting what are very shady.  Uniformise
     this.

   * There are too many lexical modes?
*/

#include "config.hh"

#include <cctype>
#include <cstdlib>
#include <cstdio>
using namespace std;

#include "book.hh"
#include "context-def.hh"
#include "dimensions.hh"
#include "music.hh"
#include "file-path.hh"
#include "input-smob.hh"
#include "input.hh"
#include "lily-guile.hh"
#include "lilypond-input-version.hh"
#include "main.hh"
#include "misc.hh"
#include "lily-lexer.hh"
#include "lily-parser.hh"
#include "paper-book.hh"
#include "output-def.hh"
#include "scm-hash.hh"
#include "program-option.hh"
#include "score.hh"
#include "text-interface.hh"
#include "warn.hh"
#include "music.hh"

#define MY_MAKE_MUSIC(x)  make_music_by_name (ly_symbol2scm (x))

Music *property_op_to_music (SCM op);
Music *context_spec_music (SCM type, SCM id, Music *m, SCM ops);
SCM get_next_unique_context_id ();
SCM get_next_unique_lyrics_context_id ();

#undef _
#if !HAVE_GETTEXT
#define _(x) x
#else
#include <libintl.h>
#define _(x) gettext (x)
#endif

#define YYERROR_VERBOSE 1

#define YYPARSE_PARAM my_lily_parser
#define YYLEX_PARAM my_lily_parser
#define THIS\
	((Lily_parser *) my_lily_parser)

#define yyerror THIS->parser_error

/* We use custom location type: Input objects */
#define YYLTYPE Input
#define YYLLOC_DEFAULT(Current,Rhs,N) \
	((Current).set_location ((Rhs)[1], (Rhs)[N]))


/* Add symbols to the TAGS field of a music object.  */

void
tag_music (Music *m, SCM tag, Input ip)
{
	SCM tags = m->get_property ("tags");
	if (scm_is_symbol (tag))
		tags = scm_cons (tag, tags);
	else if (ly_is_list (tag))
		tags = ly_append2 (tag, tags);
	else
		ip.warning (_ ("tag must be symbol or list of symbols"));

	m->set_property ("tags", tags);
}

bool
is_regular_identifier (SCM id)
{
  String str = ly_scm2string (id);
  char const *s = str.to_str0 ();

  bool v = true;
#if 0
  isalpha (*s);
  s++;
#endif
  while (*s && v)
   {
        v = v && isalnum (*s);
        s++;
   }
  return v;
}


SCM
get_first_context_id (SCM type, Music *m)
{
	SCM id = m->get_property ("context-id");
	if (SCM_BOOL_T == scm_equal_p (m->get_property ("context-type"), type)
	    && scm_is_string (m->get_property ("context-id"))
	    && scm_c_string_length (id) > 0)
	{
		return id;
	}
	return SCM_EOL;
}

SCM
make_simple_markup (SCM a)
{
	return a;
}

bool
is_duration (int t)
{
  return t && t == 1 << intlog2 (t);
}

void
set_music_properties (Music *p, SCM a)
{
  for (SCM k = a; scm_is_pair (k); k = scm_cdr (k))
 	p->internal_set_property (scm_caar (k), scm_cdar (k));
}

SCM
make_chord_step (int step, int alter)
{
	if (step == 7)
		alter += FLAT;

	while (step < 0)
		step += 7;
	Pitch m ((step -1) / 7, (step - 1) % 7, alter);
	return m.smobbed_copy ();
}


SCM
make_chord (SCM pitch, SCM dur, SCM modification_list)
{
	SCM chord_ctor = ly_lily_module_constant ("construct-chord");
	SCM ch = scm_call_3 (chord_ctor, pitch, dur, modification_list);

	unsmob_music (ch)->protect();	
	return ch;
}

/* Todo: actually also use apply iso. call too ...  */
bool
ly_input_procedure_p (SCM x)
{
	return ly_is_procedure (x)
		|| (scm_is_pair (x) && ly_is_procedure (scm_car (x)));
}

Music*
set_property_music (SCM sym, SCM value)
{
	Music *p = MY_MAKE_MUSIC ("PropertySet");
	p->set_property ("symbol", sym);
	p->set_property ("value", value);
	return p;
}

Music*
make_music_relative (Pitch start, Music *music)
{
	Music *relative = MY_MAKE_MUSIC ("RelativeOctaveMusic");
 	relative->set_property ("element", music->self_scm ());
	
 	Pitch last = music->to_relative_octave (start);
 	if (lily_1_8_relative)
 		music->set_property ("last-pitch", last.smobbed_copy ());
	return relative;
}

Music*
make_lyric_combine_music (SCM name, Music *music)
{
	Music *combine = MY_MAKE_MUSIC ("LyricCombineMusic");
	combine->set_property ("element", music->self_scm ());
 	combine->set_property ("associated-context", name);
	return combine;
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 219 "parser.yy"
typedef union YYSTYPE {
	Book *book;
	Output_def *outputdef;
	SCM scm;
	String *string;
 	Music *music;
 	Score *score;
 	int i;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 576 "out/parser.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */
#line 228 "parser.yy"


int
yylex (YYSTYPE *s, YYLTYPE *loc, void *v)
{
	Lily_parser *pars = (Lily_parser*) v;
	Lily_lexer *lex = pars->lexer_;

	lex->lexval = (void*) s;
	lex->lexloc = loc;
	lex->prepare_for_next_token ();
	return lex->yylex ();
}




/* Line 214 of yacc.c.  */
#line 616 "out/parser.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2005 */
#  endif
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  else
#   define YYSIZE_T unsigned long int
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM ((YYSIZE_T) -1)
#  endif
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYLTYPE_IS_TRIVIAL) && YYLTYPE_IS_TRIVIAL \
             && defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2102

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  164
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  129
/* YYNRULES -- Number of rules. */
#define YYNRULES  380
/* YYNRULES -- Number of states. */
#define YYNSTATES  563

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   395

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   162,     2,     2,     2,     2,     2,   155,
     153,   154,   159,   141,   156,   140,   146,   160,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   161,     2,
     147,   145,   148,   163,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   150,     2,   151,   157,   158,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   143,   149,   144,   152,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   142
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     4,     7,    10,    13,    16,    19,    21,
      23,    25,    27,    29,    31,    33,    35,    37,    39,    40,
      43,    48,    50,    52,    56,    58,    60,    62,    64,    66,
      68,    70,    72,    74,    76,    78,    80,    85,    86,    88,
      92,    95,   100,   101,   103,   106,   109,   112,   115,   118,
     121,   126,   128,   130,   133,   136,   139,   142,   144,   147,
     149,   151,   153,   156,   160,   163,   166,   169,   172,   177,
     178,   181,   184,   187,   189,   191,   192,   197,   203,   208,
     212,   217,   221,   223,   225,   227,   229,   230,   231,   237,
     238,   241,   243,   245,   247,   249,   251,   254,   257,   260,
     264,   268,   273,   278,   282,   286,   290,   295,   300,   302,
     304,   311,   316,   321,   325,   327,   332,   335,   339,   341,
     343,   347,   349,   351,   353,   355,   357,   359,   361,   363,
     365,   369,   372,   373,   377,   378,   383,   386,   387,   392,
     397,   401,   404,   410,   417,   421,   423,   425,   427,   429,
     431,   433,   435,   437,   439,   441,   444,   446,   450,   456,
     463,   467,   472,   475,   478,   480,   482,   486,   488,   490,
     492,   494,   496,   498,   500,   502,   504,   505,   509,   511,
     513,   517,   519,   521,   523,   525,   529,   530,   533,   539,
     542,   546,   548,   551,   554,   556,   558,   560,   562,   565,
     568,   571,   574,   577,   580,   582,   585,   587,   590,   594,
     595,   598,   601,   606,   608,   610,   612,   615,   618,   620,
     622,   624,   626,   628,   630,   632,   634,   636,   638,   640,
     642,   644,   646,   648,   650,   652,   653,   655,   658,   661,
     663,   666,   668,   671,   673,   676,   679,   681,   684,   687,
     689,   691,   693,   695,   697,   699,   701,   703,   705,   707,
     709,   711,   713,   715,   717,   719,   721,   723,   724,   726,
     729,   732,   734,   738,   742,   744,   748,   749,   752,   754,
     757,   759,   761,   763,   765,   767,   769,   771,   773,   775,
     778,   781,   784,   786,   788,   790,   792,   795,   796,   799,
     803,   804,   806,   813,   816,   819,   822,   825,   828,   830,
     832,   834,   837,   842,   843,   846,   848,   850,   853,   856,
     858,   860,   862,   864,   868,   870,   873,   876,   880,   884,
     886,   888,   892,   896,   899,   901,   903,   905,   907,   910,
     913,   915,   917,   918,   921,   922,   925,   927,   928,   932,
     934,   935,   939,   941,   944,   946,   948,   950,   953,   957,
     958,   961,   964,   966,   969,   973,   975,   978,   980,   982,
     984,   986,   987,   993,   996,  1001,  1005,  1007,  1010,  1014,
    1017
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     165,     0,    -1,    -1,   165,   167,    -1,   165,   173,    -1,
     165,     1,    -1,   165,    28,    -1,    39,   137,    -1,   171,
      -1,   228,    -1,   177,    -1,   179,    -1,   168,    -1,   281,
      -1,   182,    -1,   196,    -1,    91,    -1,   135,    -1,    -1,
     170,   173,    -1,    27,   143,   170,   144,    -1,   137,    -1,
     103,    -1,   172,   145,   174,    -1,   169,    -1,   179,    -1,
     177,    -1,   182,    -1,   175,    -1,   187,    -1,   233,    -1,
     272,    -1,   215,    -1,   169,    -1,   281,    -1,    92,    -1,
      17,   143,   176,   144,    -1,    -1,    98,    -1,   176,    26,
     169,    -1,   176,   212,    -1,    11,   143,   178,   144,    -1,
      -1,    95,    -1,   178,   181,    -1,   178,   179,    -1,   178,
     281,    -1,   178,   171,    -1,   178,     1,    -1,   178,   166,
      -1,    50,   143,   180,   144,    -1,   187,    -1,   136,    -1,
     180,   166,    -1,   180,   171,    -1,   180,   182,    -1,   180,
       1,    -1,   182,    -1,   184,   144,    -1,    43,    -1,    36,
      -1,    30,    -1,   183,   143,    -1,   183,   143,   132,    -1,
     184,   173,    -1,   184,   175,    -1,   184,   185,    -1,   184,
       1,    -1,    56,   251,   145,   276,    -1,    -1,   186,   187,
      -1,   186,   169,    -1,   186,     1,    -1,   192,    -1,   196,
      -1,    -1,     9,   143,   186,   144,    -1,    47,   216,   276,
     187,   188,    -1,    51,   143,   186,   144,    -1,   143,   186,
     144,    -1,    53,   143,   186,   144,    -1,   223,   186,   224,
      -1,   219,    -1,   129,    -1,   214,    -1,   209,    -1,    -1,
      -1,    62,   194,   143,   195,   144,    -1,    -1,   195,   212,
      -1,   200,    -1,   197,    -1,   191,    -1,   190,    -1,   115,
      -1,   123,   169,    -1,   116,   281,    -1,   121,   187,    -1,
     124,   169,   187,    -1,   126,   169,   169,    -1,   128,   169,
     169,   169,    -1,   127,   169,   169,   187,    -1,   119,   281,
     187,    -1,   117,   281,   281,    -1,   122,   187,   187,    -1,
     125,   169,   187,   187,    -1,   120,   281,   187,   187,    -1,
     198,    -1,   199,    -1,    17,   216,   145,   216,   193,   187,
      -1,    17,   216,   193,   187,    -1,    64,   216,   193,   187,
      -1,    57,   253,   187,    -1,   189,    -1,    58,   244,   244,
     187,    -1,   201,   197,    -1,   202,   193,   197,    -1,   203,
      -1,   207,    -1,    55,   169,   187,    -1,    38,    -1,    22,
      -1,    24,    -1,    13,    -1,    31,    -1,    23,    -1,    25,
      -1,    14,    -1,    32,    -1,    45,   248,   187,    -1,    45,
     196,    -1,    -1,     4,   205,   197,    -1,    -1,   204,     4,
     206,   197,    -1,   197,   204,    -1,    -1,    33,   216,   208,
     187,    -1,    12,   137,   145,   137,    -1,   137,   145,   217,
      -1,    61,   216,    -1,    42,   216,   169,   145,   169,    -1,
      42,   216,   169,   169,   145,   169,    -1,    49,   216,   169,
      -1,    16,    -1,    46,    -1,     6,    -1,    19,    -1,    20,
      -1,     8,    -1,    60,    -1,    21,    -1,    37,    -1,   210,
      -1,   211,   137,    -1,   216,    -1,   216,   146,   216,    -1,
      42,   213,   169,   145,   217,    -1,    42,   213,   169,   169,
     145,   217,    -1,    49,   213,   169,    -1,    52,   213,   145,
     217,    -1,    61,   213,    -1,    41,   214,    -1,   137,    -1,
     138,    -1,   215,   141,   215,    -1,   137,    -1,   103,    -1,
     138,    -1,   215,    -1,   103,    -1,   275,    -1,   169,    -1,
     281,    -1,    92,    -1,    -1,   218,   264,   231,    -1,   229,
      -1,   220,    -1,   225,   250,   231,    -1,   147,    -1,   148,
      -1,    71,    -1,    70,    -1,   221,   226,   222,    -1,    -1,
     226,   227,    -1,   243,   277,   278,   238,   231,    -1,    99,
     231,    -1,     7,   215,   187,    -1,   230,    -1,    54,   249,
      -1,    40,   243,    -1,    77,    -1,    79,    -1,    72,    -1,
     149,    -1,    59,   243,    -1,    10,   137,    -1,    44,   249,
      -1,    15,   137,    -1,    63,   253,    -1,    34,   217,    -1,
      82,    -1,    34,    18,    -1,   185,    -1,    29,    18,    -1,
      29,   130,   135,    -1,    -1,   231,   233,    -1,   231,   232,
      -1,   140,    55,   169,   233,    -1,   236,    -1,    87,    -1,
      83,    -1,   247,   237,    -1,   247,   236,    -1,   234,    -1,
      93,    -1,   150,    -1,   151,    -1,   152,    -1,   153,    -1,
     154,    -1,    76,    -1,    78,    -1,    75,    -1,    73,    -1,
      80,    -1,   235,    -1,   101,    -1,   255,    -1,   245,    -1,
     246,    -1,    -1,   145,    -1,   145,   240,    -1,   145,   239,
      -1,   155,    -1,   239,   155,    -1,   156,    -1,   240,   156,
      -1,   130,    -1,   130,   239,    -1,   130,   240,    -1,   139,
      -1,   139,   239,    -1,   139,   240,    -1,   241,    -1,   243,
      -1,   242,    -1,   281,    -1,   215,    -1,    92,    -1,   157,
      -1,   141,    -1,   140,    -1,   149,    -1,   148,    -1,   146,
      -1,   158,    -1,   158,    -1,   157,    -1,   140,    -1,   241,
      -1,   252,    -1,    -1,   252,    -1,   276,   254,    -1,   100,
     254,    -1,   251,    -1,   252,   159,   276,    -1,   252,   159,
     102,    -1,   102,    -1,    94,   160,    94,    -1,    -1,   254,
     146,    -1,   161,    -1,   161,   276,    -1,    92,    -1,    94,
      -1,   137,    -1,   281,    -1,   140,    -1,   141,    -1,   162,
      -1,    86,    -1,   256,    -1,   258,   151,    -1,   258,   257,
      -1,   258,   259,    -1,    81,    -1,    76,    -1,   160,    -1,
     258,    -1,   150,   258,    -1,    -1,   261,   260,    -1,    85,
     261,    84,    -1,    -1,    48,    -1,   243,   277,   278,   238,
     250,   263,    -1,    99,   250,    -1,   262,   250,    -1,   134,
     250,    -1,    90,   250,    -1,   265,   250,    -1,   266,    -1,
     279,    -1,   103,    -1,   242,   250,    -1,   242,   250,   268,
     267,    -1,    -1,   267,   269,    -1,    67,    -1,    66,    -1,
      69,   242,    -1,    65,   242,    -1,   268,    -1,   270,    -1,
      97,    -1,   271,    -1,   270,   146,   271,    -1,   276,    -1,
     276,   141,    -1,   276,    68,    -1,   272,   141,   273,    -1,
     272,   140,   273,    -1,   273,    -1,   274,    -1,   274,   159,
     274,    -1,   274,   160,   274,    -1,   140,   274,    -1,   275,
      -1,    94,    -1,   133,    -1,   131,    -1,   133,   131,    -1,
      94,   131,    -1,    94,    -1,    92,    -1,    -1,   277,   162,
      -1,    -1,   278,   163,    -1,   104,    -1,    -1,    89,   280,
     283,    -1,   114,    -1,    -1,    35,   282,   283,    -1,   284,
      -1,   289,   290,    -1,   290,    -1,   285,    -1,   286,    -1,
     289,   286,    -1,   143,   287,   144,    -1,    -1,   287,   292,
      -1,   287,   284,    -1,   107,    -1,   110,   169,    -1,   112,
     169,   169,    -1,   288,    -1,   289,   288,    -1,   137,    -1,
     114,    -1,   104,    -1,   138,    -1,    -1,    50,   291,   143,
     180,   144,    -1,   109,   169,    -1,   113,   169,   169,   169,
      -1,   111,   169,   169,    -1,   105,    -1,   106,   284,    -1,
     108,   292,   292,    -1,   289,   290,    -1,   290,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   551,   551,   552,   554,   556,   559,   566,   570,   573,
     576,   582,   589,   595,   599,   616,   621,   622,   627,   631,
     637,   646,   647,   651,   667,   672,   676,   680,   684,   687,
     691,   695,   698,   701,   704,   707,   713,   720,   724,   728,
     739,   747,   756,   763,   767,   771,   776,   779,   782,   786,
     792,   798,   809,   813,   816,   819,   831,   842,   854,   863,
     868,   873,   883,   888,   897,   900,   903,   913,   919,   934,
     937,   948,   951,   968,   969,   973,   976,   983,  1042,  1047,
    1055,  1061,  1069,  1070,  1073,  1074,  1079,  1080,  1080,  1089,
    1090,  1097,  1098,  1102,  1103,  1107,  1110,  1113,  1116,  1120,
    1124,  1127,  1130,  1133,  1137,  1140,  1145,  1150,  1158,  1195,
    1198,  1202,  1205,  1210,  1226,  1227,  1237,  1251,  1263,  1264,
    1265,  1272,  1278,  1285,  1290,  1298,  1305,  1311,  1316,  1323,
    1331,  1337,  1347,  1347,  1356,  1356,  1365,  1393,  1393,  1405,
    1416,  1420,  1424,  1428,  1432,  1439,  1440,  1442,  1443,  1444,
    1446,  1447,  1448,  1449,  1453,  1454,  1460,  1469,  1476,  1483,
    1490,  1498,  1505,  1511,  1521,  1524,  1527,  1532,  1535,  1538,
    1543,  1546,  1549,  1552,  1555,  1558,  1582,  1586,  1599,  1600,
    1605,  1621,  1624,  1627,  1630,  1634,  1644,  1645,  1652,  1680,
    1695,  1704,  1712,  1718,  1724,  1734,  1744,  1748,  1758,  1767,
    1776,  1786,  1793,  1800,  1810,  1813,  1817,  1820,  1824,  1842,
    1845,  1850,  1859,  1867,  1870,  1875,  1880,  1885,  1890,  1894,
    1903,  1906,  1909,  1912,  1915,  1918,  1921,  1924,  1927,  1930,
    1936,  1950,  1953,  1962,  1965,  1976,  1977,  1978,  1979,  1983,
    1986,  1992,  1995,  2001,  2004,  2009,  2021,  2024,  2029,  2038,
    2044,  2045,  2049,  2055,  2063,  2072,  2075,  2078,  2081,  2084,
    2087,  2090,  2096,  2097,  2098,  2103,  2109,  2115,  2119,  2126,
    2135,  2144,  2147,  2150,  2158,  2159,  2165,  2168,  2174,  2177,
    2185,  2188,  2191,  2192,  2196,  2197,  2198,  2202,  2207,  2218,
    2222,  2233,  2252,  2255,  2258,  2264,  2267,  2274,  2277,  2283,
    2293,  2294,  2298,  2330,  2343,  2352,  2372,  2379,  2392,  2400,
    2403,  2409,  2412,  2419,  2422,  2428,  2431,  2434,  2437,  2443,
    2446,  2449,  2455,  2456,  2462,  2465,  2468,  2480,  2483,  2486,
    2490,  2493,  2496,  2502,  2505,  2510,  2513,  2516,  2519,  2522,
    2529,  2532,  2538,  2539,  2543,  2544,  2552,  2556,  2555,  2564,
    2568,  2567,  2576,  2579,  2582,  2588,  2591,  2597,  2604,  2610,
    2611,  2614,  2620,  2623,  2626,  2632,  2635,  2641,  2644,  2647,
    2650,  2653,  2653,  2662,  2665,  2668,  2671,  2674,  2677,  2683,
    2687
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "PREC_TOP", "\\addlyrics", "PREC_BOT",
  "\\accepts", "\\addquote", "\\alias", "\\alternative", "\\bar", "\book",
  "\\change", "\\chordmode", "\\chords", "\\clef", "\\consists",
  "\\context", "\\default", "\\defaultchild", "\\denies", "\\description",
  "\\drummode", "\\drums", "\\figuremode", "\\figures",
  "\\grobdescriptions", "\\header", "\\invalid", "\\key", "\\layout",
  "\\lyricmode", "\\lyrics", "\\lyricsto", "\\mark", "\\markup", "\\midi",
  "\\name", "\\notemode", "\\objectid", "\\octave", "\\once", "\\override",
  "\\paper", "\\partial", "\\relative", "\\remove", "\\repeat", "\\rest",
  "\\revert", "\\score", "\\sequential", "\\set", "\\simultaneous",
  "\\skip", "\\tag", "\\tempo", "\\times", "\\transpose",
  "\\transposition", "\\type", "\\unset", "\\with", "\\time", "\\new",
  "/+", "^", ":", "-", "/", ">>", "<<", "\\", "\\>", "\\C[haracter]",
  "\\)", "\\!", "\\[", "\\(", "\\]", "\\<", "\\+", "\\~", "__",
  "FIGURE_CLOSE", "FIGURE_OPEN", "_", "--", "CHORDMODIFIERS",
  "LYRIC_MARKUP", "MULTI_MEASURE_REST", "SCM_T", "DIGIT", "E_UNSIGNED",
  "UNSIGNED", "BOOK_IDENTIFIER", "CHORDMODIFIER_PITCH", "CHORD_MODIFIER",
  "CONTEXT_DEF_IDENTIFIER", "DRUM_PITCH", "DURATION_IDENTIFIER",
  "EVENT_IDENTIFIER", "FRACTION", "LYRICS_STRING",
  "LYRIC_MARKUP_IDENTIFIER", "MARKUP_HEAD_EMPTY", "MARKUP_HEAD_LIST0",
  "MARKUP_HEAD_MARKUP0", "MARKUP_HEAD_MARKUP0_MARKUP1", "MARKUP_HEAD_SCM0",
  "MARKUP_HEAD_SCM0_MARKUP1", "MARKUP_HEAD_SCM0_SCM1",
  "MARKUP_HEAD_SCM0_SCM1_MARKUP2", "MARKUP_HEAD_SCM0_SCM1_SCM2",
  "MARKUP_IDENTIFIER", "MUSIC_FUNCTION", "MUSIC_FUNCTION_MARKUP",
  "MUSIC_FUNCTION_MARKUP_MARKUP", "MUSIC_FUNCTION_MARKUP_MARKUP_MUSIC",
  "MUSIC_FUNCTION_MARKUP_MUSIC", "MUSIC_FUNCTION_MARKUP_MUSIC_MUSIC",
  "MUSIC_FUNCTION_MUSIC", "MUSIC_FUNCTION_MUSIC_MUSIC",
  "MUSIC_FUNCTION_SCM", "MUSIC_FUNCTION_SCM_MUSIC",
  "MUSIC_FUNCTION_SCM_MUSIC_MUSIC", "MUSIC_FUNCTION_SCM_SCM",
  "MUSIC_FUNCTION_SCM_SCM_MUSIC", "MUSIC_FUNCTION_SCM_SCM_SCM",
  "MUSIC_IDENTIFIER", "NOTENAME_PITCH", "NUMBER_IDENTIFIER",
  "OUTPUT_DEF_IDENTIFIER", "REAL", "RESTNAME", "SCM_IDENTIFIER",
  "SCORE_IDENTIFIER", "STRING", "STRING_IDENTIFIER", "TONICNAME_PITCH",
  "'-'", "'+'", "UNARY_MINUS", "'{'", "'}'", "'='", "'.'", "'<'", "'>'",
  "'|'", "'['", "']'", "'~'", "'('", "')'", "'''", "','", "'^'", "'_'",
  "'*'", "'/'", "':'", "'!'", "'?'", "$accept", "lilypond",
  "object_id_setting", "toplevel_expression", "toplevel_music",
  "embedded_scm", "lilypond_header_body", "lilypond_header",
  "assignment_id", "assignment", "identifier_init",
  "context_def_spec_block", "context_def_spec_body", "book_block",
  "book_body", "score_block", "score_body", "paper_block", "output_def",
  "output_def_head", "output_def_body", "tempo_event", "Music_list",
  "Music", "Alternative_music", "Repeated_music", "Sequential_music",
  "Simultaneous_music", "Simple_music", "optional_context_mod", "@1",
  "context_mod_list", "Composite_music", "Grouped_music_list",
  "Generic_prefix_music_scm", "Generic_prefix_music",
  "Prefix_composite_music", "mode_changing_head",
  "mode_changing_head_with_context", "relative_music", "new_lyrics", "@2",
  "@3", "re_rhythmed_music", "@4", "context_change", "property_operation",
  "context_def_mod", "context_mod", "context_prop_spec",
  "music_property_def", "string", "simple_string", "scalar", "pre_events",
  "event_chord", "note_chord_element", "chord_open", "chord_close",
  "simul_open", "simul_close", "chord_body", "chord_body_elements",
  "chord_body_element", "add_quote", "command_element", "command_event",
  "post_events", "tagged_post_event", "post_event", "string_number_event",
  "direction_less_char", "direction_less_event", "direction_reqd_event",
  "octave_check", "sup_quotes", "sub_quotes", "steno_pitch",
  "steno_tonic_pitch", "pitch", "pitch_also_in_chords", "gen_text_def",
  "script_abbreviation", "script_dir", "absolute_pitch", "duration_length",
  "optional_notemode_duration", "steno_duration", "multiplied_duration",
  "fraction", "dots", "tremolo_type", "bass_number",
  "figured_bass_alteration", "bass_figure", "figured_bass_modification",
  "br_bass_figure", "figure_list", "figure_spec", "optional_rest",
  "simple_element", "lyric_element", "new_chord", "chord_items",
  "chord_separator", "chord_item", "step_numbers", "step_number",
  "number_expression", "number_term", "number_factor", "bare_number",
  "bare_unsigned", "exclamations", "questions", "lyric_markup", "@5",
  "full_markup", "@6", "markup_top", "markup_list", "markup_composed_list",
  "markup_braced_list", "markup_braced_list_body", "markup_head_1_item",
  "markup_head_1_list", "simple_markup", "@7", "markup", 0
};
#endif

/* INFRINGES ON USER NAME SPACE */
#ifndef _
# define _(msgid) msgid
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
      45,    43,   395,   123,   125,    61,    46,    60,    62,   124,
      91,    93,   126,    40,    41,    39,    44,    94,    95,    42,
      47,    58,    33,    63
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   164,   165,   165,   165,   165,   165,   166,   167,   167,
     167,   167,   167,   167,   167,   168,   169,   169,   170,   170,
     171,   172,   172,   173,   173,   174,   174,   174,   174,   174,
     174,   174,   174,   174,   174,   174,   175,   176,   176,   176,
     176,   177,   178,   178,   178,   178,   178,   178,   178,   178,
     179,   180,   180,   180,   180,   180,   180,   181,   182,   183,
     183,   183,   184,   184,   184,   184,   184,   184,   185,   186,
     186,   186,   186,   187,   187,   188,   188,   189,   190,   190,
     191,   191,   192,   192,   192,   192,   193,   194,   193,   195,
     195,   196,   196,   197,   197,   198,   198,   198,   198,   198,
     198,   198,   198,   198,   198,   198,   198,   198,   199,   200,
     200,   200,   200,   200,   200,   200,   200,   200,   200,   200,
     200,   201,   201,   201,   201,   201,   202,   202,   202,   202,
     203,   203,   205,   204,   206,   204,   207,   208,   207,   209,
     210,   210,   210,   210,   210,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   212,   212,   213,   213,   214,   214,
     214,   214,   214,   214,   215,   215,   215,   216,   216,   216,
     217,   217,   217,   217,   217,   217,   218,   219,   219,   219,
     220,   221,   222,   223,   224,   225,   226,   226,   227,   227,
     228,   229,   229,   229,   229,   229,   229,   229,   229,   229,
     229,   229,   229,   229,   230,   230,   230,   230,   230,   231,
     231,   231,   232,   233,   233,   233,   233,   233,   233,   234,
     235,   235,   235,   235,   235,   235,   235,   235,   235,   235,
     236,   236,   236,   237,   237,   238,   238,   238,   238,   239,
     239,   240,   240,   241,   241,   241,   242,   242,   242,   243,
     244,   244,   245,   245,   245,   246,   246,   246,   246,   246,
     246,   246,   247,   247,   247,   248,   249,   250,   250,   251,
     251,   252,   252,   252,   253,   253,   254,   254,   255,   255,
     256,   256,   256,   256,   257,   257,   257,   258,   258,   258,
     258,   258,   259,   259,   259,   260,   260,   261,   261,   262,
     263,   263,   264,   264,   264,   264,   264,   264,   264,   265,
     265,   266,   266,   267,   267,   268,   268,   268,   268,   269,
     269,   269,   270,   270,   271,   271,   271,   272,   272,   272,
     273,   273,   273,   274,   274,   275,   275,   275,   275,   275,
     276,   276,   277,   277,   278,   278,   279,   280,   279,   281,
     282,   281,   283,   283,   283,   284,   284,   285,   286,   287,
     287,   287,   288,   288,   288,   289,   289,   290,   290,   290,
     290,   291,   290,   290,   290,   290,   290,   290,   290,   292,
     292
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     2,     2,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     2,
       4,     1,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     0,     1,     3,
       2,     4,     0,     1,     2,     2,     2,     2,     2,     2,
       4,     1,     1,     2,     2,     2,     2,     1,     2,     1,
       1,     1,     2,     3,     2,     2,     2,     2,     4,     0,
       2,     2,     2,     1,     1,     0,     4,     5,     4,     3,
       4,     3,     1,     1,     1,     1,     0,     0,     5,     0,
       2,     1,     1,     1,     1,     1,     2,     2,     2,     3,
       3,     4,     4,     3,     3,     3,     4,     4,     1,     1,
       6,     4,     4,     3,     1,     4,     2,     3,     1,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     2,     0,     3,     0,     4,     2,     0,     4,     4,
       3,     2,     5,     6,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     3,     5,     6,
       3,     4,     2,     2,     1,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     3,     1,     1,
       3,     1,     1,     1,     1,     3,     0,     2,     5,     2,
       3,     1,     2,     2,     1,     1,     1,     1,     2,     2,
       2,     2,     2,     2,     1,     2,     1,     2,     3,     0,
       2,     2,     4,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     2,     2,     1,
       2,     1,     2,     1,     2,     2,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     2,
       2,     1,     3,     3,     1,     3,     0,     2,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     1,     1,     1,     1,     2,     0,     2,     3,
       0,     1,     6,     2,     2,     2,     2,     2,     1,     1,
       1,     2,     4,     0,     2,     1,     1,     2,     2,     1,
       1,     1,     1,     3,     1,     2,     2,     3,     3,     1,
       1,     3,     3,     2,     1,     1,     1,     1,     2,     2,
       1,     1,     0,     2,     0,     2,     1,     0,     3,     1,
       0,     3,     1,     2,     1,     1,     1,     2,     3,     0,
       2,     2,     1,     2,     3,     1,     2,     1,     1,     1,
       1,     0,     5,     2,     4,     3,     1,     2,     3,     2,
       1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       2,     0,     1,     5,     0,     0,   124,   128,     0,   122,
     126,   123,   127,     0,     6,    61,   125,   129,     0,   350,
      60,   121,    59,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   183,    16,    22,   349,    95,     0,     0,     0,
       0,   176,   176,     0,     0,     0,     0,     0,     0,    17,
      21,    69,     3,    12,    24,     8,     0,     4,    10,    11,
      14,     0,     0,   114,    94,    93,    15,    92,   108,   109,
      91,     0,    86,   118,   119,    69,     9,    13,   164,   165,
     176,    42,   168,   167,   169,    86,    18,   137,     0,   243,
     131,   265,   176,     0,   176,    69,    69,   176,     0,   274,
     176,   246,   249,   251,   250,     0,    86,    97,     0,   176,
     176,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,   194,   195,
     204,    83,   181,   197,   206,    98,    73,    74,    85,    84,
       0,    82,   179,   186,   267,   178,   191,   176,    96,   176,
     176,     0,     0,     0,     0,   176,    62,    67,     0,    58,
      64,    65,    66,   132,   136,   116,    87,     0,     0,     0,
     190,    43,     0,     0,   176,     0,   176,   371,   369,   376,
       0,   362,     0,     0,     0,     0,     0,     0,   368,   367,
     370,   359,   351,   352,   355,   356,   365,     0,   354,   239,
     241,   244,   245,   130,   341,   340,   176,    52,     0,    51,
       0,     0,   120,     0,   113,   247,   248,   176,   176,   104,
     103,   176,   199,     0,   201,   207,     0,   205,   175,   335,
     171,   337,   336,   173,   170,   203,   172,   174,   193,   163,
       0,   156,   276,   200,   271,   266,   276,     0,     0,   192,
       0,   198,   162,   202,   297,   347,   267,   267,   310,   346,
     267,   267,   342,   267,   209,   267,   308,   309,     0,   209,
     268,   105,    99,   176,   100,   176,     0,    72,    79,    71,
      70,     0,   228,   227,   225,   226,   229,   215,   214,    35,
     219,   231,   264,   220,   221,   222,   223,   224,   263,   262,
     278,    33,    23,    28,    26,    25,    27,    29,    32,    30,
     218,   230,   213,     0,   232,    31,   329,   330,   334,    34,
      63,    37,     0,   134,     0,   117,   184,    81,   166,    48,
       0,    41,    49,    47,    45,    44,    57,    46,    86,   111,
      20,    19,   138,     0,   377,     0,     0,   380,     0,   373,
     363,     0,     0,     0,     0,   357,   366,   353,   240,   242,
      75,    56,    50,    53,    54,    55,    78,    80,   275,   115,
     112,   107,     0,   208,   339,   338,     0,     0,   270,     0,
     269,   160,     0,     0,     0,     0,   306,   303,   305,   311,
     344,   304,   177,   307,   209,   182,   185,   187,   342,   180,
     106,   102,   101,     0,   333,   279,   254,   257,   256,   260,
     259,   258,   255,   261,   253,   217,   216,   233,   234,   252,
       0,     0,     0,     0,    38,     0,   133,     0,    89,     7,
     176,   176,   379,   378,   375,   364,     0,   358,   361,     0,
     360,     0,    77,   139,     0,     0,   157,   277,   273,   272,
     161,    68,   299,   287,   280,   281,   282,     0,   288,   295,
     298,   283,   348,     0,   316,   315,     0,   313,   343,   235,
     264,   211,   210,   189,   344,   328,   327,   331,   332,   147,
     150,   145,   148,   149,   152,     0,   153,     0,   146,     0,
     151,     0,     0,    36,   154,     0,    40,   135,     0,   110,
       0,   374,    69,   158,     0,   296,   293,   292,   284,   285,
     289,   294,   286,   290,   291,   318,   317,   312,   236,   345,
     267,     0,   235,    39,     0,     0,   141,     0,   155,    88,
      90,   372,     0,   159,   321,   319,   314,   320,   322,   324,
     238,   237,   300,     0,   209,     0,   144,   140,    76,     0,
     326,   325,   301,   302,   264,   212,   188,     0,     0,   323,
     142,     0,   143
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,     1,   363,    52,    53,   233,   175,   364,    56,    57,
     302,   161,   425,    58,   172,    59,   208,   335,   365,    61,
      62,   134,   154,   280,   442,    63,    64,    65,   136,   167,
     324,   498,   137,    67,    68,    69,    70,    71,    72,    73,
     164,   322,   427,    74,   176,   138,   494,   495,   496,   240,
     139,   234,   241,   235,   140,   141,   142,   143,   396,    75,
     327,   144,   268,   397,    76,   145,   146,   392,   471,   472,
     310,   311,   312,   416,   520,   201,   202,   102,   103,   104,
     105,   417,   418,   313,    92,   243,   269,   244,   270,   100,
     378,   314,   458,   513,   459,   514,   460,   384,   263,   553,
     264,   265,   266,   517,   467,   536,   537,   538,   315,   316,
     317,   318,   246,   390,   469,   267,   385,   237,    88,   192,
     193,   194,   195,   354,   196,   197,   347,   343,   348
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -349
static const short int yypact[] =
{
    -349,  1395,  -349,  -349,     8,   -54,  -349,  -349,    10,  -349,
    -349,  -349,  -349,   -17,  -349,  -349,  -349,  -349,    10,  -349,
    -349,  -349,  -349,  1931,    10,   -14,     1,    12,   -61,   154,
     -67,    10,  -349,  -349,  -349,  -349,  -349,    21,    21,    21,
      21,  1803,  1803,   -61,   -61,   -61,   -61,   -61,   -61,  -349,
    -349,  -349,  -349,  -349,  -349,  -349,   -72,  -349,  -349,  -349,
    -349,    23,    86,  -349,  -349,  -349,  -349,    96,  -349,  -349,
    -349,    14,   109,  -349,  -349,  -349,  -349,  -349,  -349,  -349,
    1527,    45,  -349,  -349,  -349,   -43,  -349,  -349,  1520,     9,
    -349,  -349,  1803,    -4,  1665,  -349,  -349,  1803,    18,  -349,
    1803,     9,  -349,  -349,  -349,   -67,   109,  -349,    21,  1803,
    1803,    56,    58,    67,    -6,   235,    76,   225,    10,    49,
      10,    10,    49,    49,    76,    10,   154,  -349,  -349,  -349,
    -349,  -349,  -349,  -349,  -349,  -349,  -349,  -349,  -349,  -349,
     697,  -349,  -349,  -349,    49,  -349,  -349,  1803,  -349,  1803,
    1803,   -61,   -61,   -61,   694,   540,    84,  -349,    75,  -349,
    -349,  -349,  -349,  -349,   227,  -349,  -349,    14,   834,     8,
    -349,  -349,    82,    10,  1803,   108,  1803,  -349,  -349,  -349,
     137,  -349,  1658,   -61,   -61,   -61,   -61,   -61,  -349,  -349,
    -349,  -349,  -349,  -349,  -349,  -349,  -349,  1520,  -349,  -349,
    -349,    80,    85,  -349,  -349,  -349,  1803,  -349,    68,  -349,
     974,  1114,  -349,   144,  -349,    80,    85,  1803,  1803,  -349,
    -349,  1803,  -349,   113,  -349,  -349,   119,  -349,  -349,   132,
    -349,  -349,   140,  -349,   120,  -349,  -349,  -349,  -349,  -349,
     -61,   127,  -349,  -349,  -349,   110,  -349,   -61,   131,  -349,
     148,  -349,  -349,  -349,  -349,  -349,    49,    49,  -349,  -349,
      49,    49,  -349,    49,  -349,    49,  -349,  -349,   -29,  -349,
     110,  -349,  -349,  1803,  -349,  1803,   -61,  -349,  -349,  -349,
    -349,    91,  -349,  -349,  -349,  -349,  -349,  -349,  -349,  -349,
    -349,  -349,   -34,  -349,  -349,  -349,  -349,  -349,  -349,  -349,
      -4,  -349,  -349,  -349,  -349,  -349,  -349,  -349,   120,  -349,
    -349,  -349,  -349,   312,  -349,   138,  -349,   124,  -349,  -349,
    -349,   187,    14,  -349,   151,  -349,  -349,  -349,  -349,  -349,
     158,  -349,  -349,  -349,  -349,  -349,  -349,  -349,   109,  -349,
    -349,  -349,  -349,   155,  -349,   137,  1658,  -349,  1658,  -349,
    -349,   -61,   -61,   -61,  1363,  -349,  -349,  -349,  -349,  -349,
     291,  -349,  -349,  -349,  -349,  -349,  -349,  -349,  -349,  -349,
    -349,  -349,   165,  -349,  -349,  -349,   -53,    10,   164,   123,
     164,  -349,   401,    -4,    22,  1520,  -349,  -349,  -349,   239,
     149,  -349,  1925,  -349,  -349,  -349,  -349,  -349,  -349,  1925,
    -349,  -349,  -349,    -3,  -349,  -349,  -349,  -349,  -349,  -349,
    -349,  -349,  -349,  -349,   120,  -349,  -349,  -349,  -349,  -349,
      -3,    -3,    -3,    -3,  -349,   293,  -349,    14,  -349,  -349,
    1803,  1665,  -349,  -349,  -349,  -349,   -61,  -349,  -349,  1520,
    -349,   172,  -349,  -349,   401,   176,  -349,  -349,  -349,  -349,
    -349,  -349,  -349,  -349,  -349,  -349,  -349,   128,  -349,   156,
    -349,  -349,  -349,   178,  -349,  -349,   178,  -349,  -349,   -77,
     267,  -349,  -349,  1925,   149,  -349,  -349,  -349,  -349,  -349,
    -349,  -349,  -349,  -349,  -349,   -61,  -349,    10,  -349,    10,
    -349,    10,   179,  -349,  -349,   186,  -349,  -349,   363,  -349,
     197,  -349,  -349,  -349,   401,   156,  -349,  -349,  -349,  -349,
    -349,  -349,  -349,  -349,  -349,  -349,  -349,   409,     9,  -349,
      49,   -61,   -77,  -349,   -61,   -61,  -349,   401,  -349,  -349,
    -349,  -349,  1254,  -349,  -349,  -349,  -349,   185,  -349,   -19,
      80,    85,   277,  1941,  -349,   -25,  -349,  -349,  -349,    -4,
    -349,  -349,  -349,  -349,  -349,  -349,  1925,   -61,   192,  -349,
    -349,   -61,  -349
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -349,  -349,   160,  -349,  -349,    -1,  -349,    47,  -349,   -48,
    -349,   188,  -349,   189,  -349,   -93,   -91,  -349,    20,  -349,
    -349,   283,   -73,   -16,  -349,  -349,  -349,  -349,  -349,   -70,
    -349,  -349,    57,   -62,  -349,  -349,  -349,  -349,  -349,  -349,
    -349,  -349,  -349,  -349,  -349,  -349,  -349,  -349,  -152,   130,
     231,     7,     0,  -348,  -349,  -349,  -349,  -349,  -349,  -349,
    -349,  -349,  -349,  -349,  -349,  -349,  -349,  -256,  -349,  -148,
    -349,  -349,    42,  -349,  -166,   -98,   -97,   335,  -130,   -65,
     254,  -349,  -349,  -349,  -349,   238,  -228,   240,    78,   236,
     115,  -349,  -349,  -349,   -90,  -349,  -349,  -349,  -349,  -349,
    -349,  -349,  -349,  -349,  -153,  -349,  -349,  -175,  -349,  -131,
    -242,  -110,   -92,   -22,   -96,  -349,  -349,    15,  -349,    -5,
    -163,  -349,  -157,  -349,  -177,  -141,   -82,  -349,  -277
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -177
static const short int yytable[] =
{
      54,   206,   168,   215,   216,   236,   198,   309,    85,   165,
     261,    80,   225,   399,   160,   174,    77,   344,    87,   166,
     356,    60,   210,   211,    93,   135,   147,    97,   386,   387,
      33,   106,   388,   389,   450,   391,   218,   393,    33,   345,
     355,   346,   148,   149,   150,   151,   152,   153,    55,   550,
     404,   238,   107,   108,   109,   110,    19,    19,    66,   251,
     229,    54,   305,    89,   170,    26,    33,    27,   518,   361,
     394,   433,   101,   155,    49,   262,   203,   440,   209,   334,
      90,   212,    49,   329,   214,    32,   519,   157,   204,    81,
     205,   229,   444,   220,   221,    13,   503,   231,    15,   232,
     163,    89,   173,   158,    20,   325,   452,   330,   453,    13,
      49,    22,    15,    82,   454,   357,   455,    19,    20,   395,
     557,   330,   551,   219,   226,    22,    86,   341,   231,    94,
     232,   271,    25,   272,   273,    35,    35,   403,   473,   307,
     171,   204,   123,   205,    95,    78,    79,    83,    84,   242,
     274,   275,   276,   279,   301,    96,   533,    51,   339,   456,
     342,   404,   308,    19,   199,   200,   156,   279,   356,   356,
     319,   166,   457,   338,    54,   306,   328,    33,   213,   547,
     477,   478,   349,   350,   351,   352,   353,   337,   355,    34,
     360,   438,   336,   222,    82,   223,    35,   245,   361,    33,
     245,   369,   370,   398,   224,   371,    89,   346,   405,   279,
     279,    34,   362,   439,   453,   204,   320,   205,   321,   333,
     454,    49,   455,    50,    13,   448,   331,    15,    83,    84,
     159,   323,   506,    20,   321,   358,   330,   507,   368,   376,
      22,   359,    35,    49,   181,    50,   381,   184,    98,   186,
     247,   248,   340,   227,   373,   252,    99,   400,   372,   401,
     426,   169,   356,   374,   432,   456,   117,   118,   430,   379,
      19,   375,   236,   377,   120,   402,   382,   121,   420,   421,
     191,    85,   355,   422,   423,   424,   125,   449,   556,   475,
     476,   451,   542,   383,   428,   429,   508,   509,   431,   479,
     441,   480,   443,   198,   463,   464,   465,   510,   466,   481,
     447,   468,   482,   483,   484,   502,   511,   101,   512,   485,
     414,   504,   521,   528,   527,   552,    33,   228,   419,   229,
     486,   549,   332,   515,   236,   487,   516,   561,   230,   488,
     500,   531,   489,   303,   304,   162,   530,    19,   239,    35,
     434,   435,   436,   490,   491,   415,   544,   432,    91,   217,
     249,   380,   253,   250,   535,   497,   231,   505,   232,   479,
      49,   480,    78,    79,   559,   445,   474,   446,   522,   481,
     462,     0,   482,   483,   484,   282,     0,   283,   284,     0,
     285,     0,   286,     0,   236,   555,     0,     0,     0,   461,
     486,     0,     0,     0,   406,   487,     0,     0,     0,   488,
       0,     0,   489,   291,   499,   209,     0,   236,     0,     0,
     540,   541,     0,   490,   491,   539,    35,     0,     0,   532,
     492,     0,     0,     0,     0,   501,    19,   493,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    78,
      79,     0,   407,   408,     0,     0,     0,   539,   409,     0,
     410,   411,   293,   294,   295,   296,   297,     0,     0,   412,
     413,     0,   461,   300,   463,   464,   465,     0,   466,     0,
       0,     0,     0,     0,   523,     0,     0,   524,     0,   525,
       0,   526,    33,   228,     0,   229,     0,     0,     0,     0,
     492,   204,     0,   205,   230,     0,   534,   529,     0,     0,
       0,     0,     0,     0,     0,    35,     0,     0,     0,     0,
     543,     0,     0,   545,   546,     0,     0,     0,     0,     0,
       0,   279,   231,     0,   232,     0,    49,     0,    78,    79,
       0,     0,     0,     0,   558,     0,     0,     0,     0,     0,
     111,     5,   112,     6,     7,   113,   560,   281,     0,     0,
     562,     0,     9,    10,    11,    12,     0,     0,     0,   114,
      15,    16,    17,    18,   115,    19,    20,     0,    21,     0,
     116,   117,   118,    22,   119,    23,     0,    24,     0,   120,
      25,    26,   121,    27,   122,    28,   123,    29,    30,   124,
       0,   125,     0,   126,    31,     0,     0,     0,     0,     0,
       0,    32,   127,   282,     0,   283,   284,   128,   285,   129,
     286,     0,   130,   287,     0,     0,     0,   288,     0,     0,
       0,    33,   289,   290,   229,     0,     0,     0,     0,     0,
       0,   291,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,    36,    37,    38,     0,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,   131,
       0,   231,     0,   232,     0,    49,     0,    78,    79,     0,
     292,     0,     0,    51,     0,     0,     0,   132,     0,   133,
     293,   294,   295,   296,   297,   277,     0,   298,   299,     0,
       0,   300,     0,     0,   111,     0,   112,     6,     7,   113,
       0,     8,     0,     0,     0,     0,     9,    10,    11,    12,
       0,     0,     0,   114,     0,    16,    17,    18,   115,     0,
       0,     0,    21,     0,   116,   117,   118,     0,   119,    23,
       0,    24,     0,   120,     0,    26,   121,    27,   122,    28,
     123,    29,    30,   124,     0,   125,     0,   126,    31,     0,
       0,     0,     0,     0,     0,    32,   127,     0,     0,     0,
       0,   128,     0,   129,     0,     0,   130,     0,     0,  -176,
       0,     0,   254,  -176,  -176,    33,   255,   256,     0,     0,
       0,     0,     0,  -176,     0,     0,   257,  -176,  -176,     0,
     258,   259,     0,     0,     0,     0,     0,     0,     0,    36,
      37,    38,     0,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,   131,  -176,     0,     0,    89,  -176,    49,
       0,   260,     0,  -176,     0,   277,   101,    51,   278,     0,
       0,   132,     0,   133,   111,     0,   112,     6,     7,   113,
       0,     8,     0,     0,     0,     0,     9,    10,    11,    12,
       0,     0,     0,   114,     0,    16,    17,    18,   115,     0,
       0,     0,    21,     0,   116,   117,   118,     0,   119,    23,
       0,    24,     0,   120,     0,    26,   121,    27,   122,    28,
     123,    29,    30,   124,     0,   125,     0,   126,    31,     0,
       0,     0,     0,     0,   326,    32,   127,     0,     0,     0,
       0,   128,     0,   129,     0,     0,   130,     0,     0,  -176,
       0,     0,     0,  -176,  -176,    33,     0,     0,     0,     0,
       0,     0,     0,  -176,     0,     0,     0,  -176,  -176,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
      37,    38,     0,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,   131,  -176,     0,     0,     0,  -176,    49,
       0,     0,     0,  -176,     0,   277,     0,    51,     0,     0,
       0,   132,     0,   133,   111,     0,   112,     6,     7,   113,
       0,     8,     0,     0,     0,     0,     9,    10,    11,    12,
       0,     0,     0,   114,     0,    16,    17,    18,   115,     0,
       0,     0,    21,     0,   116,   117,   118,     0,   119,    23,
       0,    24,     0,   120,     0,    26,   121,    27,   122,    28,
     123,    29,    30,   124,     0,   125,     0,   126,    31,     0,
       0,     0,     0,     0,     0,    32,   127,     0,     0,     0,
       0,   128,     0,   129,     0,     0,   130,     0,     0,  -176,
       0,     0,     0,  -176,  -176,    33,     0,     0,     0,     0,
       0,     0,     0,  -176,     0,     0,     0,  -176,  -176,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
      37,    38,     0,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,   131,  -176,     0,     0,     0,  -176,    49,
       0,     0,     0,  -176,     0,   277,     0,    51,   366,     0,
       0,   132,     0,   133,   111,     0,   112,     6,     7,   113,
       0,     8,     0,     0,     0,     0,     9,    10,    11,    12,
       0,     0,     0,   114,     0,    16,    17,    18,   115,     0,
       0,     0,    21,     0,   116,   117,   118,     0,   119,    23,
       0,    24,     0,   120,     0,    26,   121,    27,   122,    28,
     123,    29,    30,   124,     0,   125,     0,   126,    31,     0,
       0,     0,     0,     0,     0,    32,   127,     0,     0,     0,
       0,   128,     0,   129,     0,     0,   130,     0,     0,  -176,
       0,     0,     0,  -176,  -176,    33,     0,     0,     0,     0,
       0,     0,     0,  -176,     0,     0,     0,  -176,  -176,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
      37,    38,     0,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,   131,  -176,     0,     0,     0,  -176,    49,
       0,     0,     0,  -176,     0,   277,     0,    51,   367,     0,
       0,   132,     0,   133,   111,     0,   112,     6,     7,   113,
       0,     8,     0,     0,     0,     0,     9,    10,    11,    12,
       0,     0,     0,   114,     0,    16,    17,    18,   115,     0,
       0,     0,    21,     0,   116,   117,   118,     0,   119,    23,
       0,    24,     0,   120,     0,    26,   121,    27,   122,    28,
     123,    29,    30,   124,     0,   125,     0,   126,    31,     0,
       0,     0,     0,     0,     0,    32,   127,     0,     0,     0,
       0,   128,     0,   129,     0,     0,   130,     0,     0,  -176,
       0,     0,     0,  -176,  -176,    33,     0,     0,     0,     0,
       0,     0,     0,  -176,     0,     0,     0,  -176,  -176,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
      37,    38,     0,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,   131,  -176,     0,     0,     0,  -176,    49,
       0,     0,     0,  -176,     0,     2,     3,    51,   548,     0,
       0,   132,     4,   133,     0,     0,     5,     0,     6,     7,
       0,     0,     8,   177,     0,     0,     0,     9,    10,    11,
      12,     0,    13,    14,     0,    15,    16,    17,    18,     0,
      19,    20,     0,    21,     0,     0,     0,     0,    22,     0,
      23,     0,    24,     0,     0,    25,    26,     0,    27,     0,
      28,     0,    29,    30,     0,     0,     0,     0,     0,    31,
       0,     0,     0,     0,     0,     0,    32,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187,   188,     0,     0,
       0,     0,     0,     0,     0,     0,    33,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    34,     0,
     189,   190,     0,     0,     0,     0,   191,   437,     0,    35,
      36,    37,    38,     0,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,     0,     0,     0,     0,     0,     0,
      49,     0,    50,     0,     0,     0,     0,   111,    51,   112,
       6,     7,   113,     0,     8,     0,     0,     0,     0,     9,
      10,    11,    12,     0,     0,     0,   114,     0,    16,    17,
      18,   115,     0,     0,     0,    21,     0,   116,   117,   118,
     177,   119,    23,     0,    24,     0,   120,     0,    26,   121,
      27,   122,    28,   123,    29,    30,   124,     0,   125,     0,
     126,    31,     0,     0,     0,     0,     0,     0,    32,   127,
       0,     0,     0,     0,   128,     0,   129,     0,     0,   130,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   178,   179,   180,   181,   182,   183,
     184,   185,   186,   187,   188,     0,     0,     0,     0,     0,
       0,     0,    36,    37,    38,     0,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,   131,   189,   190,     0,
       0,     0,     0,   191,     0,     0,     0,     0,   169,     0,
      51,     0,     0,     0,   132,   111,   133,   112,     6,     7,
     113,     0,     8,     0,     0,     0,     0,     9,    10,    11,
      12,     0,     0,     0,   114,     0,    16,    17,    18,   115,
       0,     0,     0,    21,     0,   116,   117,   118,   177,   119,
      23,     0,    24,     0,   120,     0,    26,   121,    27,   122,
      28,   123,    29,    30,   124,     0,   125,     0,   126,    31,
       0,     0,     0,     0,     0,     0,    32,   127,     0,     0,
       0,     0,   128,     0,   129,     0,     0,   130,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   178,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,     0,     0,     0,     0,     0,     0,     0,
      36,    37,    38,     0,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,   131,   189,   190,     0,     0,     0,
       0,   207,     0,     0,     0,     0,     0,     0,    51,     0,
       0,     0,   132,   111,   133,   112,     6,     7,   113,     0,
       8,     0,     0,     0,     0,     9,    10,    11,    12,     0,
       0,     0,   114,     0,    16,    17,    18,   115,     0,     0,
       0,    21,     0,   116,   117,   118,     0,   119,    23,     0,
      24,     0,   120,     0,    26,   121,    27,   122,    28,   123,
      29,    30,   124,     0,   125,     0,   126,    31,     0,     0,
       0,     0,     0,     0,    32,   127,     0,     0,     0,     0,
     128,     0,   129,     0,     0,   130,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,    37,
      38,     0,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,   131,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     6,     7,    51,     0,     8,     0,
     132,     0,   133,     9,    10,    11,    12,     0,     0,     0,
       0,     0,    16,    17,    18,     0,     0,     0,     0,    21,
       0,     0,     0,     0,     0,     0,    23,     0,    24,     0,
       0,     0,    26,     0,    27,     0,    28,     0,    29,    30,
       0,     0,     0,     0,     0,    31,     0,     0,   282,     0,
     283,   284,    32,   285,     0,   286,     0,     0,   287,     0,
       0,     0,   288,     0,   282,     0,   283,   284,   290,   285,
       0,   286,     0,     0,   287,     0,   291,     0,   288,     0,
       0,     0,     0,     0,   290,     0,     0,     0,     0,     0,
       0,     0,   291,     0,     0,     0,    36,    37,    38,     0,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
       0,    89,     0,     0,     0,   470,     0,     0,     0,     0,
       0,     0,     0,     0,    51,   293,   294,   295,   296,   297,
       0,   554,   298,   299,     0,     0,   300,     0,     0,     0,
       0,   293,   294,   295,   296,   297,     0,     0,   298,   299,
       0,     0,   300
};

static const short int yycheck[] =
{
       1,    93,    75,   101,   101,   115,    88,   155,     8,    71,
     140,     4,    18,   269,    62,    85,     1,   180,    18,    62,
     197,     1,    95,    96,    24,    41,    42,    28,   256,   257,
      91,    31,   260,   261,   382,   263,   106,   265,    91,   180,
     197,   182,    43,    44,    45,    46,    47,    48,     1,    68,
     292,   116,    37,    38,    39,    40,    35,    35,     1,   124,
      94,    62,   155,   130,    80,    51,    91,    53,   145,     1,
      99,   348,   139,   145,   135,   140,    92,   354,    94,   172,
      23,    97,   135,     1,   100,    71,   163,     1,    92,   143,
      94,    94,   145,   109,   110,    27,   444,   131,    30,   133,
       4,   130,   145,    17,    36,   167,    84,    39,    86,    27,
     135,    43,    30,   103,    92,   197,    94,    35,    36,   148,
     145,    39,   141,   108,   130,    43,   143,   175,   131,   143,
     133,   147,    50,   149,   150,   114,   114,   140,   394,   155,
      95,    92,    56,    94,   143,   137,   138,   137,   138,   100,
     151,   152,   153,   154,   155,   143,   504,   143,   174,   137,
     176,   403,   155,    35,   155,   156,   143,   168,   345,   346,
     155,    62,   150,   173,   175,   155,   169,    91,   160,   527,
     422,   423,   183,   184,   185,   186,   187,   172,   345,   103,
     206,   354,   172,   137,   103,   137,   114,   119,     1,    91,
     122,   217,   218,   268,   137,   221,   130,   348,   300,   210,
     211,   103,   144,   354,    86,    92,   132,    94,   143,   172,
      92,   135,    94,   137,    27,   102,   144,    30,   137,   138,
     144,     4,    76,    36,   143,   155,    39,    81,    94,   240,
      43,   156,   114,   135,   107,   137,   247,   110,    94,   112,
     120,   121,   144,    18,   135,   125,   102,   273,   145,   275,
     322,   141,   439,   131,   346,   137,    41,    42,   338,   159,
      35,   131,   382,   146,    49,   276,   145,    52,   140,   141,
     143,   281,   439,   159,   160,    98,    61,   379,   544,   420,
     421,   383,   520,   145,   143,   137,   140,   141,   143,     6,
       9,     8,   137,   385,    65,    66,    67,   151,    69,    16,
     146,   162,    19,    20,    21,   143,   160,   139,   162,    26,
     313,   145,    55,   137,   145,    48,    91,    92,   313,    94,
      37,   146,   172,   463,   444,    42,   466,   145,   103,    46,
     431,   144,    49,   155,   155,    62,   498,    35,   117,   114,
     351,   352,   353,    60,    61,   313,   522,   439,    23,   105,
     122,   246,   126,   123,   517,   427,   131,   457,   133,     6,
     135,     8,   137,   138,   549,   376,   398,   377,   474,    16,
     385,    -1,    19,    20,    21,    73,    -1,    75,    76,    -1,
      78,    -1,    80,    -1,   504,   543,    -1,    -1,    -1,   384,
      37,    -1,    -1,    -1,    92,    42,    -1,    -1,    -1,    46,
      -1,    -1,    49,   101,   430,   431,    -1,   527,    -1,    -1,
     518,   518,    -1,    60,    61,   517,   114,    -1,    -1,   502,
     137,    -1,    -1,    -1,    -1,   436,    35,   144,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
     138,    -1,   140,   141,    -1,    -1,    -1,   549,   146,    -1,
     148,   149,   150,   151,   152,   153,   154,    -1,    -1,   157,
     158,    -1,   457,   161,    65,    66,    67,    -1,    69,    -1,
      -1,    -1,    -1,    -1,   485,    -1,    -1,   487,    -1,   489,
      -1,   491,    91,    92,    -1,    94,    -1,    -1,    -1,    -1,
     137,    92,    -1,    94,   103,    -1,    97,   144,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   114,    -1,    -1,    -1,    -1,
     521,    -1,    -1,   524,   525,    -1,    -1,    -1,    -1,    -1,
      -1,   532,   131,    -1,   133,    -1,   135,    -1,   137,   138,
      -1,    -1,    -1,    -1,   545,    -1,    -1,    -1,    -1,    -1,
      10,    11,    12,    13,    14,    15,   557,    17,    -1,    -1,
     561,    -1,    22,    23,    24,    25,    -1,    -1,    -1,    29,
      30,    31,    32,    33,    34,    35,    36,    -1,    38,    -1,
      40,    41,    42,    43,    44,    45,    -1,    47,    -1,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    61,    -1,    63,    64,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    72,    73,    -1,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    -1,    -1,    87,    -1,    -1,
      -1,    91,    92,    93,    94,    -1,    -1,    -1,    -1,    -1,
      -1,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
      -1,   131,    -1,   133,    -1,   135,    -1,   137,   138,    -1,
     140,    -1,    -1,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,   151,   152,   153,   154,     1,    -1,   157,   158,    -1,
      -1,   161,    -1,    -1,    10,    -1,    12,    13,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,
      -1,    -1,    -1,    29,    -1,    31,    32,    33,    34,    -1,
      -1,    -1,    38,    -1,    40,    41,    42,    -1,    44,    45,
      -1,    47,    -1,    49,    -1,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    61,    -1,    63,    64,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    72,    -1,    -1,    -1,
      -1,    77,    -1,    79,    -1,    -1,    82,    -1,    -1,    85,
      -1,    -1,    85,    89,    90,    91,    89,    90,    -1,    -1,
      -1,    -1,    -1,    99,    -1,    -1,    99,   103,   104,    -1,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,    -1,    -1,   130,   134,   135,
      -1,   134,    -1,   139,    -1,     1,   139,   143,   144,    -1,
      -1,   147,    -1,   149,    10,    -1,    12,    13,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,
      -1,    -1,    -1,    29,    -1,    31,    32,    33,    34,    -1,
      -1,    -1,    38,    -1,    40,    41,    42,    -1,    44,    45,
      -1,    47,    -1,    49,    -1,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    61,    -1,    63,    64,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    -1,    -1,    -1,
      -1,    77,    -1,    79,    -1,    -1,    82,    -1,    -1,    85,
      -1,    -1,    -1,    89,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    99,    -1,    -1,    -1,   103,   104,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,    -1,    -1,    -1,   134,   135,
      -1,    -1,    -1,   139,    -1,     1,    -1,   143,    -1,    -1,
      -1,   147,    -1,   149,    10,    -1,    12,    13,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,
      -1,    -1,    -1,    29,    -1,    31,    32,    33,    34,    -1,
      -1,    -1,    38,    -1,    40,    41,    42,    -1,    44,    45,
      -1,    47,    -1,    49,    -1,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    61,    -1,    63,    64,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    72,    -1,    -1,    -1,
      -1,    77,    -1,    79,    -1,    -1,    82,    -1,    -1,    85,
      -1,    -1,    -1,    89,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    99,    -1,    -1,    -1,   103,   104,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,    -1,    -1,    -1,   134,   135,
      -1,    -1,    -1,   139,    -1,     1,    -1,   143,   144,    -1,
      -1,   147,    -1,   149,    10,    -1,    12,    13,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,
      -1,    -1,    -1,    29,    -1,    31,    32,    33,    34,    -1,
      -1,    -1,    38,    -1,    40,    41,    42,    -1,    44,    45,
      -1,    47,    -1,    49,    -1,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    61,    -1,    63,    64,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    72,    -1,    -1,    -1,
      -1,    77,    -1,    79,    -1,    -1,    82,    -1,    -1,    85,
      -1,    -1,    -1,    89,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    99,    -1,    -1,    -1,   103,   104,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,    -1,    -1,    -1,   134,   135,
      -1,    -1,    -1,   139,    -1,     1,    -1,   143,   144,    -1,
      -1,   147,    -1,   149,    10,    -1,    12,    13,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,
      -1,    -1,    -1,    29,    -1,    31,    32,    33,    34,    -1,
      -1,    -1,    38,    -1,    40,    41,    42,    -1,    44,    45,
      -1,    47,    -1,    49,    -1,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    61,    -1,    63,    64,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    72,    -1,    -1,    -1,
      -1,    77,    -1,    79,    -1,    -1,    82,    -1,    -1,    85,
      -1,    -1,    -1,    89,    90,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    99,    -1,    -1,    -1,   103,   104,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,    -1,    -1,    -1,   134,   135,
      -1,    -1,    -1,   139,    -1,     0,     1,   143,   144,    -1,
      -1,   147,     7,   149,    -1,    -1,    11,    -1,    13,    14,
      -1,    -1,    17,    50,    -1,    -1,    -1,    22,    23,    24,
      25,    -1,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    36,    -1,    38,    -1,    -1,    -1,    -1,    43,    -1,
      45,    -1,    47,    -1,    -1,    50,    51,    -1,    53,    -1,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    64,
      -1,    -1,    -1,    -1,    -1,    -1,    71,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,    -1,
     137,   138,    -1,    -1,    -1,    -1,   143,   144,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,    -1,    -1,    -1,    -1,    -1,    -1,
     135,    -1,   137,    -1,    -1,    -1,    -1,    10,   143,    12,
      13,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,    22,
      23,    24,    25,    -1,    -1,    -1,    29,    -1,    31,    32,
      33,    34,    -1,    -1,    -1,    38,    -1,    40,    41,    42,
      50,    44,    45,    -1,    47,    -1,    49,    -1,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    61,    -1,
      63,    64,    -1,    -1,    -1,    -1,    -1,    -1,    71,    72,
      -1,    -1,    -1,    -1,    77,    -1,    79,    -1,    -1,    82,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   137,   138,    -1,
      -1,    -1,    -1,   143,    -1,    -1,    -1,    -1,   141,    -1,
     143,    -1,    -1,    -1,   147,    10,   149,    12,    13,    14,
      15,    -1,    17,    -1,    -1,    -1,    -1,    22,    23,    24,
      25,    -1,    -1,    -1,    29,    -1,    31,    32,    33,    34,
      -1,    -1,    -1,    38,    -1,    40,    41,    42,    50,    44,
      45,    -1,    47,    -1,    49,    -1,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    61,    -1,    63,    64,
      -1,    -1,    -1,    -1,    -1,    -1,    71,    72,    -1,    -1,
      -1,    -1,    77,    -1,    79,    -1,    -1,    82,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   137,   138,    -1,    -1,    -1,
      -1,   136,    -1,    -1,    -1,    -1,    -1,    -1,   143,    -1,
      -1,    -1,   147,    10,   149,    12,    13,    14,    15,    -1,
      17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,    -1,
      -1,    -1,    29,    -1,    31,    32,    33,    34,    -1,    -1,
      -1,    38,    -1,    40,    41,    42,    -1,    44,    45,    -1,
      47,    -1,    49,    -1,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    -1,    61,    -1,    63,    64,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    72,    -1,    -1,    -1,    -1,
      77,    -1,    79,    -1,    -1,    82,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    13,    14,   143,    -1,    17,    -1,
     147,    -1,   149,    22,    23,    24,    25,    -1,    -1,    -1,
      -1,    -1,    31,    32,    33,    -1,    -1,    -1,    -1,    38,
      -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    47,    -1,
      -1,    -1,    51,    -1,    53,    -1,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    64,    -1,    -1,    73,    -1,
      75,    76,    71,    78,    -1,    80,    -1,    -1,    83,    -1,
      -1,    -1,    87,    -1,    73,    -1,    75,    76,    93,    78,
      -1,    80,    -1,    -1,    83,    -1,   101,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    93,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,    -1,    -1,    -1,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
      -1,   130,    -1,    -1,    -1,   140,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   143,   150,   151,   152,   153,   154,
      -1,   140,   157,   158,    -1,    -1,   161,    -1,    -1,    -1,
      -1,   150,   151,   152,   153,   154,    -1,    -1,   157,   158,
      -1,    -1,   161
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,   165,     0,     1,     7,    11,    13,    14,    17,    22,
      23,    24,    25,    27,    28,    30,    31,    32,    33,    35,
      36,    38,    43,    45,    47,    50,    51,    53,    55,    57,
      58,    64,    71,    91,   103,   114,   115,   116,   117,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   135,
     137,   143,   167,   168,   169,   171,   172,   173,   177,   179,
     182,   183,   184,   189,   190,   191,   196,   197,   198,   199,
     200,   201,   202,   203,   207,   223,   228,   281,   137,   138,
     215,   143,   103,   137,   138,   216,   143,   216,   282,   130,
     196,   241,   248,   216,   143,   143,   143,   169,    94,   102,
     253,   139,   241,   242,   243,   244,   216,   281,   281,   281,
     281,    10,    12,    15,    29,    34,    40,    41,    42,    44,
      49,    52,    54,    56,    59,    61,    63,    72,    77,    79,
      82,   129,   147,   149,   185,   187,   192,   196,   209,   214,
     218,   219,   220,   221,   225,   229,   230,   187,   169,   169,
     169,   169,   169,   169,   186,   145,   143,     1,    17,   144,
     173,   175,   185,     4,   204,   197,    62,   193,   186,   141,
     187,    95,   178,   145,   193,   170,   208,    50,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   137,
     138,   143,   283,   284,   285,   286,   288,   289,   290,   155,
     156,   239,   240,   187,    92,    94,   276,   136,   180,   187,
     186,   186,   187,   160,   187,   239,   240,   244,   193,   281,
     187,   187,   137,   137,   137,    18,   130,    18,    92,    94,
     103,   131,   133,   169,   215,   217,   275,   281,   243,   214,
     213,   216,   100,   249,   251,   252,   276,   213,   213,   249,
     251,   243,   213,   253,    85,    89,    90,    99,   103,   104,
     134,   242,   243,   262,   264,   265,   266,   279,   226,   250,
     252,   187,   187,   187,   169,   169,   169,     1,   144,   169,
     187,    17,    73,    75,    76,    78,    80,    83,    87,    92,
      93,   101,   140,   150,   151,   152,   153,   154,   157,   158,
     161,   169,   174,   175,   177,   179,   182,   187,   215,   233,
     234,   235,   236,   247,   255,   272,   273,   274,   275,   281,
     132,   143,   205,     4,   194,   197,    70,   224,   215,     1,
      39,   144,   166,   171,   179,   181,   182,   281,   216,   187,
     144,   173,   187,   291,   284,   289,   289,   290,   292,   169,
     169,   169,   169,   169,   287,   286,   288,   290,   155,   156,
     187,     1,   144,   166,   171,   182,   144,   144,    94,   187,
     187,   187,   145,   135,   131,   131,   169,   146,   254,   159,
     254,   169,   145,   145,   261,   280,   250,   250,   250,   250,
     277,   250,   231,   250,    99,   148,   222,   227,   243,   231,
     187,   187,   169,   140,   274,   276,    92,   140,   141,   146,
     148,   149,   157,   158,   215,   236,   237,   245,   246,   281,
     140,   141,   159,   160,    98,   176,   197,   206,   143,   137,
     193,   143,   290,   292,   169,   169,   169,   144,   284,   289,
     292,     9,   188,   137,   145,   169,   216,   146,   102,   276,
     217,   276,    84,    86,    92,    94,   137,   150,   256,   258,
     260,   281,   283,    65,    66,    67,    69,   268,   162,   278,
     140,   232,   233,   231,   277,   273,   273,   274,   274,     6,
       8,    16,    19,    20,    21,    26,    37,    42,    46,    49,
      60,    61,   137,   144,   210,   211,   212,   197,   195,   187,
     180,   169,   143,   217,   145,   258,    76,    81,   140,   141,
     151,   160,   162,   257,   259,   242,   242,   267,   145,   163,
     238,    55,   278,   169,   216,   216,   216,   145,   137,   144,
     212,   144,   186,   217,    97,   268,   269,   270,   271,   276,
     239,   240,   250,   169,   238,   169,   169,   217,   144,   146,
      68,   141,    48,   263,   140,   233,   231,   145,   169,   271,
     169,   145,   169
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror (_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, &yylloc, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, &yylloc)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value, Location);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, _("Stack now"));
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, _("Reducing stack by rule %d (line %u), "),
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep, yylocationp)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;
  (void) yylocationp;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  fprintf (yyoutput, ": ");

# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, yylocationp)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;
  (void) yylocationp;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;
/* Location data for the look-ahead symbol.  */
YYLTYPE yylloc;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;

  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
  /* The locations where the error started and ended. */
  YYLTYPE yyerror_range[2];

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
  yylsp = yyls;
#if YYLTYPE_IS_TRIVIAL
  /* Initialize the default location before parsing starts.  */
  yylloc.first_line   = yylloc.last_line   = 1;
  yylloc.first_column = yylloc.last_column = 0;
#endif


  yyvsp[0] = yylval;
    yylsp[0] = yylloc;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;
	YYLTYPE *yyls1 = yyls;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (_("parser stack overflow"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
	YYSTACK_RELOCATE (yyls);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, _("Stack size increased to %lu\n"),
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, _("Entering state %d\n"), yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, _("Reading a token: ")));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, _("Now at end of input.\n")));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT (_("Next token is"), yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT (_("Shifting"), yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
  *++yylsp = yylloc;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, yylsp - yylen, yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:
#line 552 "parser.yy"
    {
	;}
    break;

  case 4:
#line 554 "parser.yy"
    {
	;}
    break;

  case 5:
#line 556 "parser.yy"
    {
		THIS->error_level_ = 1;
	;}
    break;

  case 6:
#line 559 "parser.yy"
    {
		THIS->error_level_ = 1;
	;}
    break;

  case 7:
#line 566 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 8:
#line 570 "parser.yy"
    {
		THIS->lexer_->set_identifier (ly_symbol2scm ("$defaultheader"), (yyvsp[0].scm));
	;}
    break;

  case 9:
#line 573 "parser.yy"
    {
	
	;}
    break;

  case 10:
#line 576 "parser.yy"
    {
		Book *book = (yyvsp[0].book);
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-book-handler");
		scm_call_2 (proc, THIS->self_scm (), book->self_scm ());
		book->unprotect ();
	;}
    break;

  case 11:
#line 582 "parser.yy"
    {
		Score *score = (yyvsp[0].score);
		
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-score-handler");
		scm_call_2 (proc, THIS->self_scm (), score->self_scm ());
		score->unprotect ();
	;}
    break;

  case 12:
#line 589 "parser.yy"
    {
		Music *music = (yyvsp[0].music);
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-music-handler");
		scm_call_2 (proc, THIS->self_scm (), music->self_scm ());
		music->unprotect (); 
	;}
    break;

  case 13:
#line 595 "parser.yy"
    {
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-text-handler");
		scm_call_2 (proc, THIS->self_scm (), (yyvsp[0].scm));
	;}
    break;

  case 14:
#line 599 "parser.yy"
    {
		SCM id = SCM_EOL;
		Output_def * od = (yyvsp[0].outputdef);

		if ((yyvsp[0].outputdef)->c_variable ("is-paper") == SCM_BOOL_T)
			id = ly_symbol2scm ("$defaultpaper");
		else if ((yyvsp[0].outputdef)->c_variable ("is-midi") == SCM_BOOL_T)
			id = ly_symbol2scm ("$defaultmidi");
		else if ((yyvsp[0].outputdef)->c_variable ("is-layout") == SCM_BOOL_T)
			id = ly_symbol2scm ("$defaultlayout");

		THIS->lexer_->set_identifier (id, od->self_scm ());
		od->unprotect();
	;}
    break;

  case 15:
#line 616 "parser.yy"
    {
	;}
    break;

  case 18:
#line 627 "parser.yy"
    {
		(yyval.scm) = get_header(THIS);
		THIS->lexer_->add_scope ((yyval.scm));
	;}
    break;

  case 19:
#line 631 "parser.yy"
    {
		
	;}
    break;

  case 20:
#line 637 "parser.yy"
    {
		(yyval.scm) = THIS->lexer_->remove_scope ();
	;}
    break;

  case 21:
#line 646 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 22:
#line 647 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 23:
#line 651 "parser.yy"
    {
		if (! is_regular_identifier ((yyvsp[-2].scm)))
		{
			(yylsp[-2]).warning (_ ("identifier should have alphabetic characters only"));
		}

	        THIS->lexer_->set_identifier ((yyvsp[-2].scm), (yyvsp[0].scm));

/*
 TODO: devise standard for protection in parser.

  The parser stack lives on the C-stack, which means that
all objects can be unprotected as soon as they're here.

*/
	;}
    break;

  case 24:
#line 667 "parser.yy"
    { ;}
    break;

  case 25:
#line 672 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].score)->self_scm ();
		(yyvsp[0].score)->unprotect ();
	;}
    break;

  case 26:
#line 676 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].book)->self_scm ();
		(yyvsp[0].book)->unprotect ();
	;}
    break;

  case 27:
#line 680 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].outputdef)->self_scm ();
		(yyvsp[0].outputdef)->unprotect ();
	;}
    break;

  case 28:
#line 684 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 29:
#line 687 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].music)->self_scm ();
		(yyvsp[0].music)->unprotect();
	;}
    break;

  case 30:
#line 691 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].music)->self_scm ();
		(yyvsp[0].music)->unprotect();
	;}
    break;

  case 31:
#line 695 "parser.yy"
    {
 		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 32:
#line 698 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 33:
#line 701 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 34:
#line 704 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 35:
#line 707 "parser.yy"
    {
		(yyval.scm) = scm_from_int ((yyvsp[0].i));
	;}
    break;

  case 36:
#line 714 "parser.yy"
    {
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 37:
#line 720 "parser.yy"
    {
		(yyval.scm) = Context_def::make_scm ();
		unsmob_context_def ((yyval.scm))->set_spot ((yyloc));
	;}
    break;

  case 38:
#line 724 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		unsmob_context_def ((yyval.scm))->set_spot ((yyloc));
	;}
    break;

  case 39:
#line 728 "parser.yy"
    {
		Context_def*td = unsmob_context_def ((yyval.scm));

		for (SCM p = (yyvsp[0].scm); scm_is_pair (p); p = scm_cdr (p)) {
			SCM tag = scm_caar (p);

			/* TODO: should make new tag "grob-definition" ? */
			td->add_context_mod (scm_list_3 (ly_symbol2scm ("assign"),
							tag, scm_cons (scm_cdar (p), SCM_EOL)));
		}
	;}
    break;

  case 40:
#line 739 "parser.yy"
    {
		unsmob_context_def ((yyval.scm))->add_context_mod ((yyvsp[0].scm));		
	;}
    break;

  case 41:
#line 747 "parser.yy"
    {
		(yyval.book) = (yyvsp[-1].book);
	;}
    break;

  case 42:
#line 756 "parser.yy"
    {
		(yyval.book) = new Book;
		(yyval.book)->set_spot ((yyloc));
		(yyval.book)->paper_ = dynamic_cast<Output_def*> (unsmob_output_def (THIS->lexer_->lookup_identifier ("$defaultpaper"))->clone ());
		(yyval.book)->paper_->unprotect ();
		(yyval.book)->header_ = THIS->lexer_->lookup_identifier ("$defaultheader"); 
	;}
    break;

  case 43:
#line 763 "parser.yy"
    {
		(yyval.book) = unsmob_book ((yyvsp[0].scm));
		(yyval.book)->set_spot ((yyloc));
	;}
    break;

  case 44:
#line 767 "parser.yy"
    {
		(yyval.book)->paper_ = (yyvsp[0].outputdef);
		(yyvsp[0].outputdef)->unprotect ();
	;}
    break;

  case 45:
#line 771 "parser.yy"
    {
		SCM s = (yyvsp[0].score)->self_scm ();
		(yyval.book)->add_score (s);
		(yyvsp[0].score)->unprotect();
	;}
    break;

  case 46:
#line 776 "parser.yy"
    {
		(yyval.book)->add_score ((yyvsp[0].scm));
	;}
    break;

  case 47:
#line 779 "parser.yy"
    {
		(yyval.book)->header_ = (yyvsp[0].scm);
	;}
    break;

  case 48:
#line 782 "parser.yy"
    {
		(yyval.book)->paper_ = 0;
		(yyval.book)->scores_ = SCM_EOL;
	;}
    break;

  case 49:
#line 786 "parser.yy"
    {
		(yyval.book)->user_key_ = ly_scm2string ((yyvsp[0].scm));
	;}
    break;

  case 50:
#line 792 "parser.yy"
    {
		(yyval.score) = (yyvsp[-1].score);
	;}
    break;

  case 51:
#line 798 "parser.yy"
    {
		SCM m = (yyvsp[0].music)->self_scm ();
		(yyvsp[0].music)->unprotect();
		SCM scorify = ly_lily_module_constant ("scorify-music");
		SCM score = scm_call_2 (scorify, m, THIS->self_scm ());

		// pass ownernship to C++ again.
		(yyval.score) = unsmob_score (score);
		(yyval.score)->protect ();
		(yyval.score)->set_spot ((yyloc));
	;}
    break;

  case 52:
#line 809 "parser.yy"
    {
		(yyval.score) = unsmob_score ((yyvsp[0].scm));
		(yyval.score)->set_spot ((yyloc));
	;}
    break;

  case 53:
#line 813 "parser.yy"
    {
		(yyval.score)->user_key_ = ly_scm2string ((yyvsp[0].scm));
	;}
    break;

  case 54:
#line 816 "parser.yy"
    {
		(yyval.score)->header_ = (yyvsp[0].scm);
	;}
    break;

  case 55:
#line 819 "parser.yy"
    {
		if ((yyvsp[0].outputdef)->lookup_variable (ly_symbol2scm ("is-paper")) == SCM_BOOL_T)
		{
			THIS->parser_error ((yylsp[0]), _("\\paper cannot be used in \\score, use \\layout instead"));
		
		}
		else
		{
			(yyval.score)->defs_.push ((yyvsp[0].outputdef));
		}
		(yyvsp[0].outputdef)->unprotect ();
	;}
    break;

  case 56:
#line 831 "parser.yy"
    {
		(yyval.score)->error_found_ = true;
	;}
    break;

  case 57:
#line 842 "parser.yy"
    {
		(yyval.outputdef) = (yyvsp[0].outputdef);
		if ((yyval.outputdef)->lookup_variable (ly_symbol2scm ("is-paper")) != SCM_BOOL_T)
		{
			THIS->parser_error ((yylsp[0]), _ ("need \\paper for paper block"));
			(yyval.outputdef) = get_paper (THIS);
		}
	;}
    break;

  case 58:
#line 854 "parser.yy"
    {
		(yyval.outputdef) = (yyvsp[-1].outputdef);

		THIS->lexer_->remove_scope ();
		THIS->lexer_->pop_state ();
	;}
    break;

  case 59:
#line 863 "parser.yy"
    {
		(yyval.outputdef) = get_paper (THIS);
		(yyval.outputdef)->input_origin_ = (yyloc);
		THIS->lexer_->add_scope ((yyval.outputdef)->scope_);
	;}
    break;

  case 60:
#line 868 "parser.yy"
    {
		Output_def *p = get_midi (THIS);
		(yyval.outputdef) = p;
		THIS->lexer_->add_scope (p->scope_);
	;}
    break;

  case 61:
#line 873 "parser.yy"
    {
		Output_def *p = get_layout (THIS);

		THIS->lexer_->add_scope (p->scope_);
		(yyval.outputdef) = p;
	;}
    break;

  case 62:
#line 883 "parser.yy"
    {
		(yyval.outputdef) = (yyvsp[-1].outputdef);
		(yyval.outputdef)->input_origin_.set_spot ((yyloc));
		THIS->lexer_->push_initial_state ();
	;}
    break;

  case 63:
#line 888 "parser.yy"
    {
		(yyvsp[-2].outputdef)->unprotect ();
		Output_def *o = unsmob_output_def ((yyvsp[0].scm));
		o->input_origin_.set_spot ((yyloc));
		(yyval.outputdef) = o;
		THIS->lexer_->remove_scope ();
		THIS->lexer_->add_scope (o->scope_);
		THIS->lexer_->push_initial_state ();
	;}
    break;

  case 64:
#line 897 "parser.yy"
    {

	;}
    break;

  case 65:
#line 900 "parser.yy"
    {
		assign_context_def ((yyval.outputdef), (yyvsp[0].scm));
	;}
    break;

  case 66:
#line 903 "parser.yy"
    {
		/*
			junk this ? there already is tempo stuff in
			music.
		*/
		int m = scm_to_int ((yyvsp[0].music)->get_property ("metronome-count"));
		Duration *d = unsmob_duration ((yyvsp[0].music)->get_property ("tempo-unit"));
		set_tempo ((yyval.outputdef), d->get_length (), m);
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 67:
#line 913 "parser.yy"
    {

	;}
    break;

  case 68:
#line 919 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("MetronomeChangeEvent");
		(yyval.music)->set_property ("tempo-unit", (yyvsp[-2].scm));
		(yyval.music)->set_property ("metronome-count", scm_from_int ( (yyvsp[0].i)));
	;}
    break;

  case 69:
#line 934 "parser.yy"
    {
		(yyval.scm) = scm_cons (SCM_EOL, SCM_EOL);
	;}
    break;

  case 70:
#line 937 "parser.yy"
    {
		SCM s = (yyval.scm);
 		SCM c = scm_cons ((yyvsp[0].music)->self_scm (), SCM_EOL);
		(yyvsp[0].music)->unprotect (); /* UGH */

		if (scm_is_pair (scm_cdr (s)))
			scm_set_cdr_x (scm_cdr (s), c); /* append */
		else
			scm_set_car_x (s, c); /* set first cons */
		scm_set_cdr_x (s, c);  /* remember last cell */
	;}
    break;

  case 71:
#line 948 "parser.yy"
    {

	;}
    break;

  case 72:
#line 951 "parser.yy"
    {
		Music * m = MY_MAKE_MUSIC("Music");
		// ugh. code dup 
		m->set_property ("error-found", SCM_BOOL_T);
		SCM s = (yyval.scm);
 		SCM c = scm_cons (m->self_scm (), SCM_EOL);
		m->unprotect (); /* UGH */

		if (scm_is_pair (scm_cdr (s)))
			scm_set_cdr_x (scm_cdr (s), c); /* append */
		else
			scm_set_car_x (s, c); /* set first cons */
		scm_set_cdr_x (s, c);  /* remember last cell */
	;}
    break;

  case 75:
#line 973 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;
	;}
    break;

  case 76:
#line 976 "parser.yy"
    {
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 77:
#line 984 "parser.yy"
    {
		Music *beg = (yyvsp[-1].music);
		int times = (yyvsp[-2].i);
		SCM alts = scm_is_pair ((yyvsp[0].scm)) ? scm_car ((yyvsp[0].scm)) : SCM_EOL;
		if (times < scm_ilength (alts)) {
		  unsmob_music (scm_car (alts))
		    ->origin ()->warning (
		    _ ("more alternatives than repeats"));
		    warning ("junking excess alternatives");
		  alts = ly_truncate_list (times, alts);
		}


		SCM proc = ly_lily_module_constant ("make-repeated-music");

		SCM mus = scm_call_1 (proc, (yyvsp[-3].scm));
		Music *r = unsmob_music (mus);
		r->protect ();
		if (beg)
			{
			r-> set_property ("element", beg->self_scm ());
			beg->unprotect ();
			}
		r->set_property ("repeat-count", scm_from_int (max (times, 1)));

		r-> set_property ("elements",alts);
		if (ly_is_equal ((yyvsp[-3].scm), scm_makfrom0str ("tremolo"))) {
			/*
			TODO: move this code to Scheme.
			*/

			/* we cannot get durations and other stuff
			   correct down the line,
			   so we have to add to the duration log here. */
			SCM func = ly_lily_module_constant ("shift-duration-log");

			int dots = ((yyvsp[-2].i) % 3) ? 0 : 1;
			int shift = -intlog2 ((dots) ? ((yyvsp[-2].i)*2/3) : (yyvsp[-2].i));

			
			if ((yyvsp[-1].music)->is_mus_type ("sequential-music"))
			{
				int list_len = scm_ilength ((yyvsp[-1].music)->get_property ("elements"));
				if (list_len != 2)
					(yyvsp[-1].music)->origin ()->warning (_f ("expect 2 elements for Chord tremolo, found %d", list_len));
				shift -= 1;
				r->compress (Moment (Rational (1, list_len)));
			}
			scm_call_3 (func, r->self_scm (), scm_from_int (shift), scm_from_int (dots));

		}
		r->set_spot (*(yyvsp[-1].music)->origin ());

		(yyval.music) = r;
	;}
    break;

  case 78:
#line 1042 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SequentialMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 79:
#line 1047 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SequentialMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 80:
#line 1055 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SimultaneousMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));

	;}
    break;

  case 81:
#line 1061 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SimultaneousMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 82:
#line 1069 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 83:
#line 1070 "parser.yy"
    {
		(yyval.music) = unsmob_music ((yyvsp[0].scm));
	;}
    break;

  case 86:
#line 1079 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 87:
#line 1080 "parser.yy"
    { THIS->lexer_->push_initial_state (); ;}
    break;

  case 88:
#line 1082 "parser.yy"
    {
		THIS->lexer_->pop_state ();
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 89:
#line 1089 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 90:
#line 1090 "parser.yy"
    {
		 (yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 91:
#line 1097 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 92:
#line 1098 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 93:
#line 1102 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 94:
#line 1103 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 95:
#line 1107 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[0].scm), make_input ((yyloc)));
	;}
    break;

  case 96:
#line 1110 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-1].scm), make_input ((yyloc)), (yyvsp[0].scm));
	;}
    break;

  case 97:
#line 1113 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-1].scm), make_input ((yyloc)), (yyvsp[0].scm));
	;}
    break;

  case 98:
#line 1116 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-1].scm), make_input ((yyloc)), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 99:
#line 1120 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 100:
#line 1124 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 101:
#line 1127 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 102:
#line 1130 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
	;}
    break;

  case 103:
#line 1133 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 104:
#line 1137 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 105:
#line 1140 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].music)->self_scm (), (yyvsp[0].music)->self_scm ());
		(yyvsp[-1].music)->unprotect ();
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 106:
#line 1145 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].music)->self_scm (), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect ();
		(yyvsp[-1].music)->unprotect ();
	;}
    break;

  case 107:
#line 1150 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].music)->self_scm (), (yyvsp[0].music)->self_scm ());
		(yyvsp[-1].music)->unprotect ();
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 108:
#line 1158 "parser.yy"
    {
		SCM func = scm_car ((yyvsp[0].scm));
		Input *loc = unsmob_input (scm_cadr ((yyvsp[0].scm)));
		SCM args = scm_cddr ((yyvsp[0].scm));
		SCM sig = scm_object_property (func, ly_symbol2scm ("music-function-signature"));

		SCM type_check_proc = ly_lily_module_constant ("type-check-list");
		bool ok  = true;

		if (!to_boolean (scm_call_3  (type_check_proc, scm_cadr ((yyvsp[0].scm)), sig, args)))
		{
			THIS->error_level_ = 1;
			ok = false;
		}

		SCM m = SCM_EOL;
  		if (ok)
			m = scm_apply_0 (func, scm_cons (THIS->self_scm(),
							 scm_cdr ((yyvsp[0].scm))));

		if (unsmob_music (m))
			{
			(yyval.music) = unsmob_music (m);
			(yyval.music)->protect ();
			}
		else
			{
			if (ok)
 				loc->error (_ ("music head function must return Music object")); 
			(yyval.music) = MY_MAKE_MUSIC ("Music");
			}
		(yyval.music)->set_spot (*loc);
	;}
    break;

  case 109:
#line 1195 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 110:
#line 1198 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-4].scm), (yyvsp[-2].scm), (yyvsp[0].music), (yyvsp[-1].scm));

	;}
    break;

  case 111:
#line 1202 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-2].scm), SCM_UNDEFINED, (yyvsp[0].music), (yyvsp[-1].scm));
	;}
    break;

  case 112:
#line 1205 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-2].scm), get_next_unique_context_id (), (yyvsp[0].music),
			(yyvsp[-1].scm));
	;}
    break;

  case 113:
#line 1212 "parser.yy"
    {
		int n = scm_to_int (scm_car ((yyvsp[-1].scm))); int d = scm_to_int (scm_cdr ((yyvsp[-1].scm)));
		Music *mp = (yyvsp[0].music);

		(yyval.music)= MY_MAKE_MUSIC ("TimeScaledMusic");
		(yyval.music)->set_spot ((yyloc));

		(yyval.music)->set_property ("element", mp->self_scm ());
		mp->unprotect();
		(yyval.music)->set_property ("numerator", scm_from_int (n));
		(yyval.music)->set_property ("denominator", scm_from_int (d));
		(yyval.music)->compress (Moment (Rational (n,d)));

	;}
    break;

  case 114:
#line 1226 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 115:
#line 1227 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("TransposedMusic");
		Music *p = (yyvsp[0].music);
		Pitch from = *unsmob_pitch ((yyvsp[-2].scm));
		Pitch to = *unsmob_pitch ((yyvsp[-1].scm));

		p->transpose (pitch_interval (from, to));
		(yyval.music)->set_property ("element", p->self_scm ());
		p->unprotect();
	;}
    break;

  case 116:
#line 1237 "parser.yy"
    {
		if ((yyvsp[-1].scm) == ly_symbol2scm ("chords"))
		{
		  Music *chm = MY_MAKE_MUSIC ("UnrelativableMusic");
		  chm->set_property ("element", (yyvsp[0].music)->self_scm ());
		  (yyval.music) = chm;
		  (yyvsp[0].music)->unprotect();
		}
		else
		{
		  (yyval.music) = (yyvsp[0].music);
		}
		THIS->lexer_->pop_state ();
	;}
    break;

  case 117:
#line 1251 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-2].scm), get_next_unique_context_id (),
					 (yyvsp[0].music), (yyvsp[-1].scm));
		if ((yyvsp[-2].scm) == ly_symbol2scm ("ChordNames"))
		{
		  Music *chm = MY_MAKE_MUSIC ("UnrelativableMusic");
		  chm->set_property ("element", (yyval.music)->self_scm ());
		  (yyval.music)->unprotect();
		  (yyval.music) = chm;
		}
		THIS->lexer_->pop_state ();
	;}
    break;

  case 118:
#line 1263 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 119:
#line 1264 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 120:
#line 1265 "parser.yy"
    {
		tag_music ((yyvsp[0].music), (yyvsp[-1].scm), (yyloc));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 121:
#line 1272 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));

		(yyval.scm) = ly_symbol2scm ("notes");
	;}
    break;

  case 122:
#line 1279 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("drumPitchNames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));

		(yyval.scm) = ly_symbol2scm ("drums");
	;}
    break;

  case 123:
#line 1285 "parser.yy"
    {
		THIS->lexer_->push_figuredbass_state ();

		(yyval.scm) = ly_symbol2scm ("figures");
	;}
    break;

  case 124:
#line 1290 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("chordmodifiers");
		THIS->lexer_->chordmodifier_tab_ = alist_to_hashq (nn);
		nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_chord_state (alist_to_hashq (nn));
		(yyval.scm) = ly_symbol2scm ("chords");

	;}
    break;

  case 125:
#line 1299 "parser.yy"
    { THIS->lexer_->push_lyric_state ();
		(yyval.scm) = ly_symbol2scm ("lyrics");
	;}
    break;

  case 126:
#line 1305 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("drumPitchNames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));

		(yyval.scm) = ly_symbol2scm ("DrumStaff");
	;}
    break;

  case 127:
#line 1311 "parser.yy"
    {
		THIS->lexer_->push_figuredbass_state ();

		(yyval.scm) = ly_symbol2scm ("FiguredBass");
	;}
    break;

  case 128:
#line 1316 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("chordmodifiers");
		THIS->lexer_->chordmodifier_tab_ = alist_to_hashq (nn);
		nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_chord_state (alist_to_hashq (nn));
		(yyval.scm) = ly_symbol2scm ("ChordNames");
	;}
    break;

  case 129:
#line 1324 "parser.yy"
    { THIS->lexer_->push_lyric_state ();
		(yyval.scm) = ly_symbol2scm ("Lyrics");
	;}
    break;

  case 130:
#line 1331 "parser.yy"
    {
		Music *m = (yyvsp[0].music);
		Pitch start = *unsmob_pitch ((yyvsp[-1].scm));
		(yyval.music) = make_music_relative (start, m);
		m->unprotect();
	;}
    break;

  case 131:
#line 1337 "parser.yy"
    {
		Music *m = (yyvsp[0].music);

		Pitch middle_c (0, 0, 0);
		(yyval.music) = make_music_relative (middle_c, m);
		m->unprotect();
	;}
    break;

  case 132:
#line 1347 "parser.yy"
    { THIS->lexer_->push_lyric_state (); ;}
    break;

  case 133:
#line 1349 "parser.yy"
    {
	/* Can also use Music at the expensive of two S/Rs similar to
           \repeat \alternative */
		THIS->lexer_->pop_state ();

		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), SCM_EOL);
	;}
    break;

  case 134:
#line 1356 "parser.yy"
    {
		THIS->lexer_->push_lyric_state ();
	;}
    break;

  case 135:
#line 1358 "parser.yy"
    {
		THIS->lexer_->pop_state ();
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyvsp[-3].scm));
	;}
    break;

  case 136:
#line 1365 "parser.yy"
    {
		Music * voice = (yyvsp[-1].music);
		SCM name = get_first_context_id (scm_makfrom0str ("Voice"), voice); 
		if (!scm_is_string (name))
		{
			name = get_next_unique_lyrics_context_id ();
			voice = context_spec_music (scm_makfrom0str ("Voice"),
						    name,
						    voice, SCM_EOL);
		}

		SCM context = scm_makfrom0str ("Lyrics");
		Music *all = MY_MAKE_MUSIC ("SimultaneousMusic");

		SCM lst = SCM_EOL;
		for (SCM s = (yyvsp[0].scm); scm_is_pair (s); s = scm_cdr (s))
		{
			Music *music = unsmob_music (scm_car (s));
			Music *com = make_lyric_combine_music (name, music);
			Music *csm = context_spec_music (context,
				get_next_unique_context_id (), com, SCM_EOL);
			lst = scm_cons (csm->self_scm (), lst);
		}
		all->set_property ("elements", scm_cons (voice->self_scm (),
			lst));
		(yyval.music) = all;
		voice->unprotect ();
	;}
    break;

  case 137:
#line 1393 "parser.yy"
    {
		THIS->lexer_->push_lyric_state ();
	;}
    break;

  case 138:
#line 1395 "parser.yy"
    {
		THIS->lexer_->pop_state ();
		Music *music = (yyvsp[0].music);
		SCM name = (yyvsp[-2].scm);
		(yyval.music) = make_lyric_combine_music (name, music);
		music->unprotect();
	;}
    break;

  case 139:
#line 1405 "parser.yy"
    {
		Music*t = MY_MAKE_MUSIC ("ContextChange");
		t-> set_property ("change-to-type", scm_string_to_symbol ((yyvsp[-2].scm)));
		t-> set_property ("change-to-id", (yyvsp[0].scm));

		(yyval.music) = t;
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 140:
#line 1416 "parser.yy"
    {
		(yyval.scm) = scm_list_3 (ly_symbol2scm ("assign"),
			scm_string_to_symbol ((yyvsp[-2].scm)), (yyvsp[0].scm));
	;}
    break;

  case 141:
#line 1420 "parser.yy"
    {
		(yyval.scm) = scm_list_2 (ly_symbol2scm ("unset"),
			scm_string_to_symbol ((yyvsp[0].scm)));
	;}
    break;

  case 142:
#line 1424 "parser.yy"
    {
		(yyval.scm) = scm_list_4 (ly_symbol2scm ("push"),
			scm_string_to_symbol ((yyvsp[-3].scm)), (yyvsp[0].scm), (yyvsp[-2].scm));
	;}
    break;

  case 143:
#line 1428 "parser.yy"
    {
		(yyval.scm) = scm_list_5 (ly_symbol2scm ("push"),
				scm_string_to_symbol ((yyvsp[-4].scm)), (yyvsp[0].scm), (yyvsp[-2].scm), (yyvsp[-3].scm));
	;}
    break;

  case 144:
#line 1432 "parser.yy"
    {
		(yyval.scm) = scm_list_3 (ly_symbol2scm ("pop"),
			scm_string_to_symbol ((yyvsp[-1].scm)), (yyvsp[0].scm));
	;}
    break;

  case 145:
#line 1439 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("consists"); ;}
    break;

  case 146:
#line 1440 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("remove"); ;}
    break;

  case 147:
#line 1442 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("accepts"); ;}
    break;

  case 148:
#line 1443 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("default-child"); ;}
    break;

  case 149:
#line 1444 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("denies"); ;}
    break;

  case 150:
#line 1446 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("alias"); ;}
    break;

  case 151:
#line 1447 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("translator-type"); ;}
    break;

  case 152:
#line 1448 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("description"); ;}
    break;

  case 153:
#line 1449 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("context-name"); ;}
    break;

  case 154:
#line 1453 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 155:
#line 1454 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 156:
#line 1460 "parser.yy"
    {
		if (!is_regular_identifier ((yyvsp[0].scm)))
		{
			(yyloc).error (_("Grob name should be alphanumeric"));
		}

		(yyval.scm) = scm_list_2 (ly_symbol2scm ("Bottom"),
			scm_string_to_symbol ((yyvsp[0].scm)));
	;}
    break;

  case 157:
#line 1469 "parser.yy"
    {
		(yyval.scm) = scm_list_2 (scm_string_to_symbol ((yyvsp[-2].scm)),
			scm_string_to_symbol ((yyvsp[0].scm)));
	;}
    break;

  case 158:
#line 1476 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_4 (
			ly_symbol2scm ("push"),
			scm_cadr ((yyvsp[-3].scm)),
			(yyvsp[0].scm), (yyvsp[-2].scm)));
		(yyval.music) = context_spec_music (scm_car ((yyvsp[-3].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 159:
#line 1483 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_5 (
			ly_symbol2scm ("push"),
			scm_cadr ((yyvsp[-4].scm)),
			(yyvsp[0].scm), (yyvsp[-2].scm), (yyvsp[-3].scm)));
		(yyval.music) = context_spec_music (scm_car ((yyvsp[-4].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 160:
#line 1490 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_3 (
			ly_symbol2scm ("pop"),
			scm_cadr ((yyvsp[-1].scm)),
			(yyvsp[0].scm)));

		(yyval.music)= context_spec_music (scm_car ((yyvsp[-1].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 161:
#line 1498 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_3 (
			ly_symbol2scm ("assign"),
			scm_cadr ((yyvsp[-2].scm)),
			(yyvsp[0].scm)));
		(yyval.music)= context_spec_music (scm_car ((yyvsp[-2].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 162:
#line 1505 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_2 (
			ly_symbol2scm ("unset"),
			scm_cadr ((yyvsp[0].scm))));
		(yyval.music)= context_spec_music (scm_car ((yyvsp[0].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 163:
#line 1511 "parser.yy"
    {
		SCM e = (yyvsp[0].music)->get_property ("element");
                unsmob_music (e)->set_property ("once", SCM_BOOL_T);
		(yyval.music) = (yyvsp[0].music);

	;}
    break;

  case 164:
#line 1521 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 165:
#line 1524 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 166:
#line 1527 "parser.yy"
    {
		(yyval.scm) = scm_string_append (scm_list_2 ((yyvsp[-2].scm), (yyvsp[0].scm)));
	;}
    break;

  case 167:
#line 1532 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 168:
#line 1535 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 169:
#line 1538 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 170:
#line 1543 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 171:
#line 1546 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 172:
#line 1549 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 173:
#line 1552 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 174:
#line 1555 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 175:
#line 1558 "parser.yy"
    {
		(yyval.scm) = scm_from_int ((yyvsp[0].i));
	;}
    break;

  case 177:
#line 1586 "parser.yy"
    {
		SCM elts = (yyvsp[-1].music)-> get_property ("elements");

		elts = ly_append2 (elts, scm_reverse_x ((yyvsp[0].scm), SCM_EOL));

		(yyvsp[-1].music)->set_property ("elements", elts);
		/* why is this giving wrong start location? -ns
		 * $2->set_spot (@$); */
		Input i;
		i.set_location ((yylsp[-1]), (yylsp[0]));
		(yyvsp[-1].music)->set_spot (i);
		(yyval.music) = (yyvsp[-1].music);
	;}
    break;

  case 180:
#line 1606 "parser.yy"
    {
		SCM dur = unsmob_duration ((yyvsp[-1].scm))->smobbed_copy ();
		SCM es = (yyvsp[-2].music)->get_property ("elements");
		SCM postevs = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);

		for (SCM s = es; scm_is_pair (s); s = scm_cdr (s))
		  unsmob_music (scm_car (s))->set_property ("duration", dur);
		es = ly_append2 (es, postevs);

		(yyvsp[-2].music)-> set_property ("elements", es);
		(yyvsp[-2].music)->set_spot ((yyloc));
		(yyval.music) = (yyvsp[-2].music);
	;}
    break;

  case 185:
#line 1635 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_spot ((yyloc));
		(yyval.music)->set_property ("elements",
			scm_reverse_x ((yyvsp[-1].scm), SCM_EOL));
	;}
    break;

  case 186:
#line 1644 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 187:
#line 1645 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyvsp[-1].scm));
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 188:
#line 1653 "parser.yy"
    {
		int q = (yyvsp[-2].i);
		int ex = (yyvsp[-3].i);
		SCM check = (yyvsp[-1].scm);
		SCM post = (yyvsp[0].scm);

		Music *n = MY_MAKE_MUSIC ("NoteEvent");
		n->set_property ("pitch", (yyvsp[-4].scm));
		n->set_spot ((yyloc));
		if (q % 2)
			n->set_property ("cautionary", SCM_BOOL_T);
		if (ex % 2 || q % 2)
			n->set_property ("force-accidental", SCM_BOOL_T);

		if (scm_is_pair (post)) {
			SCM arts = scm_reverse_x (post, SCM_EOL);
			n->set_property ("articulations", arts);
		}
		if (scm_is_number (check))
		{
			int q = scm_to_int (check);
			n->set_property ("absolute-octave", scm_from_int (q-1));
		}

		
		(yyval.music) = n;
	;}
    break;

  case 189:
#line 1680 "parser.yy"
    {
		Music *n = MY_MAKE_MUSIC ("NoteEvent");
		n->set_property ("duration", (yyvsp[0].scm));
		n->set_property ("drum-type", (yyvsp[-1].scm));
		n->set_spot ((yyloc));

		if (scm_is_pair ((yyvsp[0].scm))) {
			SCM arts = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);
			n->set_property ("articulations", arts);
		}
		(yyval.music) = n;
	;}
    break;

  case 190:
#line 1695 "parser.yy"
    {
		SCM adder = ly_lily_module_constant ("add-quotable");
		
		scm_call_2 (adder, (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect();
	;}
    break;

  case 191:
#line 1704 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_property ("elements", scm_cons ((yyvsp[0].music)->self_scm (), SCM_EOL));
		(yyvsp[0].music)->unprotect();

		(yyval.music)-> set_spot ((yyloc));
		(yyvsp[0].music)-> set_spot ((yyloc));
	;}
    break;

  case 192:
#line 1712 "parser.yy"
    {
		Music *skip = MY_MAKE_MUSIC ("SkipMusic");
		skip->set_property ("duration", (yyvsp[0].scm));
		skip->set_spot ((yyloc));
		(yyval.music) = skip;
	;}
    break;

  case 193:
#line 1718 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("RelativeOctaveCheck");
		(yyval.music) = m;
		(yyval.music)->set_spot ((yyloc));
		(yyval.music)->set_property ("pitch", (yyvsp[0].scm));
	;}
    break;

  case 194:
#line 1724 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("LigatureEvent");
		m->set_property ("span-direction", scm_from_int (START));
		m->set_spot ((yyloc));

		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_property ("elements", scm_cons (m->self_scm (), SCM_EOL));
		m->unprotect();
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 195:
#line 1734 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("LigatureEvent");
		m->set_property ("span-direction", scm_from_int (STOP));
		m->set_spot ((yyloc));

		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_property ("elements", scm_cons (m->self_scm (), SCM_EOL));
		(yyval.music)->set_spot ((yyloc));
		m->unprotect ();
	;}
    break;

  case 196:
#line 1744 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("VoiceSeparator");
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 197:
#line 1748 "parser.yy"
    {
		SCM pipe = THIS->lexer_->lookup_identifier ("pipeSymbol");

		if (Music * m = unsmob_music (pipe))
			(yyval.music) = m->clone ();
		else
			(yyval.music) = MY_MAKE_MUSIC ("BarCheck");

		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 198:
#line 1758 "parser.yy"
    {
		Pitch middle_c;
		Pitch sounds_as_c = pitch_interval (*unsmob_pitch ((yyvsp[0].scm)), middle_c);
		(yyval.music) = set_property_music (ly_symbol2scm ("instrumentTransposition"),
					 sounds_as_c.smobbed_copy());
		(yyval.music)->set_spot ((yyloc));
		(yyval.music) = context_spec_music (ly_symbol2scm ("Staff"), SCM_UNDEFINED,
			(yyval.music), SCM_EOL);
	;}
    break;

  case 199:
#line 1767 "parser.yy"
    {
		Music *t = set_property_music (ly_symbol2scm ("whichBar"), (yyvsp[0].scm));

		Music *csm = context_spec_music (ly_symbol2scm ("Timing"), SCM_UNDEFINED,
					t, SCM_EOL);
		(yyval.music) = context_spec_music (ly_symbol2scm ("Score"), SCM_UNDEFINED, csm, SCM_EOL);
		(yyval.music)->set_spot ((yyloc));
		t->set_spot ((yyloc));
	;}
    break;

  case 200:
#line 1776 "parser.yy"
    {
		Moment m = - unsmob_duration ((yyvsp[0].scm))->get_length ();
		Music *p = set_property_music (ly_symbol2scm ( "measurePosition"),m.smobbed_copy ());
		p->set_spot ((yyloc));
		p = context_spec_music (ly_symbol2scm ("Timing"), SCM_UNDEFINED,
					p, SCM_EOL);
		p = context_spec_music (ly_symbol2scm ("Score"), SCM_UNDEFINED,
					p, SCM_EOL);
		(yyval.music) = p;
	;}
    break;

  case 201:
#line 1786 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-clef-set");

		SCM result = scm_call_1 (proc, (yyvsp[0].scm));
		(yyval.music) = unsmob_music (result);
		(yyval.music)->protect ();
	;}
    break;

  case 202:
#line 1793 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-time-signature-set");

		SCM result = scm_apply_2   (proc, scm_car ((yyvsp[0].scm)), scm_cdr ((yyvsp[0].scm)), SCM_EOL);
		(yyval.music) = unsmob_music (result);
		(yyval.music)->protect ();
	;}
    break;

  case 203:
#line 1800 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-mark-set");

		SCM result = scm_call_1 (proc, (yyvsp[0].scm));
		(yyval.music) = unsmob_music (result);
		(yyval.music)->protect ();
	;}
    break;

  case 204:
#line 1810 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("PesOrFlexaEvent");
	;}
    break;

  case 205:
#line 1813 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("MarkEvent");
		(yyval.music) = m;
	;}
    break;

  case 206:
#line 1817 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 207:
#line 1820 "parser.yy"
    {
		Music *key = MY_MAKE_MUSIC ("KeyChangeEvent");
		(yyval.music) = key;
	;}
    break;

  case 208:
#line 1824 "parser.yy"
    {

		Music *key = MY_MAKE_MUSIC ("KeyChangeEvent");
		if (scm_ilength ((yyvsp[0].scm)) > 0)
		{		
			key->set_property ("pitch-alist", (yyvsp[0].scm));
			key->set_property ("tonic", Pitch (0, 0, 0).smobbed_copy ());
			key->transpose (* unsmob_pitch ((yyvsp[-1].scm)));
		} else {
			THIS->parser_error ((yylsp[0]), _ ("second argument must be pitch list"));
		}

		(yyval.music) = key;
	;}
    break;

  case 209:
#line 1842 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;
	;}
    break;

  case 210:
#line 1845 "parser.yy"
    {
		(yyvsp[0].music)->set_spot ((yylsp[0]));
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyval.scm));
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 211:
#line 1850 "parser.yy"
    {
		(yyvsp[0].music) -> set_spot ((yylsp[0]));
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyval.scm));
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 212:
#line 1859 "parser.yy"
    {
		tag_music ((yyvsp[0].music), (yyvsp[-1].scm), (yyloc));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 213:
#line 1867 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 214:
#line 1870 "parser.yy"
    {
		if (!THIS->lexer_->is_lyric_state ())
			THIS->parser_error ((yylsp[0]), _ ("have to be in Lyric mode for lyrics"));
		(yyval.music) = MY_MAKE_MUSIC ("HyphenEvent");
	;}
    break;

  case 215:
#line 1875 "parser.yy"
    {
		if (!THIS->lexer_->is_lyric_state ())
			THIS->parser_error ((yylsp[0]), _ ("have to be in Lyric mode for lyrics"));
		(yyval.music) = MY_MAKE_MUSIC ("ExtenderEvent");
	;}
    break;

  case 216:
#line 1880 "parser.yy"
    {
		if ((yyvsp[-1].i))
			(yyvsp[0].music)->set_property ("direction", scm_from_int ((yyvsp[-1].i)));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 217:
#line 1885 "parser.yy"
    {
		if ((yyvsp[-1].i))
			(yyvsp[0].music)->set_property ("direction", scm_from_int ((yyvsp[-1].i)));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 219:
#line 1894 "parser.yy"
    {
		Music *s = MY_MAKE_MUSIC ("StringNumberEvent");
		s->set_property ("string-number", scm_from_int ((yyvsp[0].i)));
		s->set_spot ((yyloc));
		(yyval.music) = s;
	;}
    break;

  case 220:
#line 1903 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("bracketOpenSymbol");
	;}
    break;

  case 221:
#line 1906 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("bracketCloseSymbol"); 
	;}
    break;

  case 222:
#line 1909 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("tildeSymbol");
	;}
    break;

  case 223:
#line 1912 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("parenthesisOpenSymbol");
	;}
    break;

  case 224:
#line 1915 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("parenthesisCloseSymbol");
	;}
    break;

  case 225:
#line 1918 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedExclamationSymbol");
	;}
    break;

  case 226:
#line 1921 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedParenthesisOpenSymbol");
	;}
    break;

  case 227:
#line 1924 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedParenthesisCloseSymbol");
	;}
    break;

  case 228:
#line 1927 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedBiggerSymbol");
	;}
    break;

  case 229:
#line 1930 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedSmallerSymbol");
	;}
    break;

  case 230:
#line 1936 "parser.yy"
    {
		SCM predefd = THIS->lexer_->lookup_identifier_symbol ((yyvsp[0].scm));
		Music * m = 0;
		if (unsmob_music (predefd))
		{
			m = unsmob_music (predefd)->clone ();
		}
		else
		{
			m = MY_MAKE_MUSIC ("Music");
		}
		m->set_spot ((yyloc));
		(yyval.music) = m;		
	;}
    break;

  case 231:
#line 1950 "parser.yy"
    {
		(yyval.music) = unsmob_music ((yyvsp[0].scm));
	;}
    break;

  case 232:
#line 1953 "parser.yy"
    {
               Music *a = MY_MAKE_MUSIC ("TremoloEvent");
               a->set_spot ((yyloc));
               a->set_property ("tremolo-type", scm_from_int ((yyvsp[0].i)));
               (yyval.music) = a;
        ;}
    break;

  case 233:
#line 1962 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 234:
#line 1965 "parser.yy"
    {
		SCM s = THIS->lexer_->lookup_identifier ("dash" + ly_scm2string ((yyvsp[0].scm)));
		Music *a = MY_MAKE_MUSIC ("ArticulationEvent");
		if (scm_is_string (s))
			a->set_property ("articulation-type", s);
		else THIS->parser_error ((yylsp[0]), _ ("expecting string as script definition"));
		(yyval.music) = a;
	;}
    break;

  case 235:
#line 1976 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 236:
#line 1977 "parser.yy"
    { (yyval.scm) = scm_from_int (0); ;}
    break;

  case 237:
#line 1978 "parser.yy"
    { (yyval.scm) = scm_from_int ((yyvsp[0].i)); ;}
    break;

  case 238:
#line 1979 "parser.yy"
    { (yyval.scm) = scm_from_int ((yyvsp[0].i)); ;}
    break;

  case 239:
#line 1983 "parser.yy"
    {
		(yyval.i) = 1;
	;}
    break;

  case 240:
#line 1986 "parser.yy"
    {
		(yyval.i) ++;
	;}
    break;

  case 241:
#line 1992 "parser.yy"
    {
		(yyval.i) = 1;
	;}
    break;

  case 242:
#line 1995 "parser.yy"
    {
		(yyval.i)++;
	;}
    break;

  case 243:
#line 2001 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 244:
#line 2004 "parser.yy"
    {
		Pitch p = *unsmob_pitch ((yyvsp[-1].scm));
		p = p.transposed (Pitch ((yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 245:
#line 2009 "parser.yy"
    {
		Pitch p =* unsmob_pitch ((yyvsp[-1].scm));
		p = p.transposed (Pitch (-(yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 246:
#line 2021 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 247:
#line 2024 "parser.yy"
    {
		Pitch p = *unsmob_pitch ((yyvsp[-1].scm));
		p = p.transposed (Pitch ((yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 248:
#line 2029 "parser.yy"
    {
		Pitch p =* unsmob_pitch ((yyvsp[-1].scm));

		p = p.transposed (Pitch (-(yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 249:
#line 2038 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 252:
#line 2049 "parser.yy"
    {
		Music *t = MY_MAKE_MUSIC ("TextScriptEvent");
		t->set_property ("text", (yyvsp[0].scm));
		t->set_spot ((yyloc));
		(yyval.music) = t;	
	;}
    break;

  case 253:
#line 2055 "parser.yy"
    {
		Music *t = MY_MAKE_MUSIC ("TextScriptEvent");
		t->set_property ("text",
			make_simple_markup ((yyvsp[0].scm)));
		t->set_spot ((yyloc));
		(yyval.music) = t;
	
	;}
    break;

  case 254:
#line 2063 "parser.yy"
    {
		Music *t = MY_MAKE_MUSIC ("FingerEvent");
		t->set_property ("digit", scm_from_int ((yyvsp[0].i)));
		t->set_spot ((yyloc));
		(yyval.music) = t;
	;}
    break;

  case 255:
#line 2072 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Hat");
	;}
    break;

  case 256:
#line 2075 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Plus");
	;}
    break;

  case 257:
#line 2078 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Dash");
	;}
    break;

  case 258:
#line 2081 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Bar");
	;}
    break;

  case 259:
#line 2084 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Larger");
	;}
    break;

  case 260:
#line 2087 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Dot");
	;}
    break;

  case 261:
#line 2090 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Underscore");
	;}
    break;

  case 262:
#line 2096 "parser.yy"
    { (yyval.i) = DOWN; ;}
    break;

  case 263:
#line 2097 "parser.yy"
    { (yyval.i) = UP; ;}
    break;

  case 264:
#line 2098 "parser.yy"
    { (yyval.i) = CENTER; ;}
    break;

  case 265:
#line 2103 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 266:
#line 2109 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 267:
#line 2115 "parser.yy"
    {
		Duration dd = THIS->default_duration_;
		(yyval.scm) = dd.smobbed_copy ();
	;}
    break;

  case 268:
#line 2119 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		THIS->default_duration_ = *unsmob_duration ((yyval.scm));
	;}
    break;

  case 269:
#line 2126 "parser.yy"
    {
		int len = 0;
		if (!is_duration ((yyvsp[-1].i)))
			THIS->parser_error ((yylsp[-1]), _f ("not a duration: %d", (yyvsp[-1].i)));
		else
			len = intlog2 ((yyvsp[-1].i));

		(yyval.scm) = Duration (len, (yyvsp[0].i)).smobbed_copy ();
	;}
    break;

  case 270:
#line 2135 "parser.yy"
    {
		Duration *d = unsmob_duration ((yyvsp[-1].scm));
		Duration k (d->duration_log (), d->dot_count () + (yyvsp[0].i));
		*d = k;
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 271:
#line 2144 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 272:
#line 2147 "parser.yy"
    {
		(yyval.scm) = unsmob_duration ((yyval.scm))->compressed ( (yyvsp[0].i)) .smobbed_copy ();
	;}
    break;

  case 273:
#line 2150 "parser.yy"
    {
		Rational  m (scm_to_int (scm_car ((yyvsp[0].scm))), scm_to_int (scm_cdr ((yyvsp[0].scm))));

		(yyval.scm) = unsmob_duration ((yyval.scm))->compressed (m).smobbed_copy ();
	;}
    break;

  case 274:
#line 2158 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 275:
#line 2159 "parser.yy"
    {
		(yyval.scm) = scm_cons (scm_from_int ((yyvsp[-2].i)), scm_from_int ((yyvsp[0].i)));
	;}
    break;

  case 276:
#line 2165 "parser.yy"
    {
		(yyval.i) = 0;
	;}
    break;

  case 277:
#line 2168 "parser.yy"
    {
		(yyval.i) ++;
	;}
    break;

  case 278:
#line 2174 "parser.yy"
    {
		(yyval.i) = 0;
	;}
    break;

  case 279:
#line 2177 "parser.yy"
    {
		if (!is_duration ((yyvsp[0].i)))
			THIS->parser_error ((yylsp[0]), _f ("not a duration: %d", (yyvsp[0].i)));
		(yyval.i) = (yyvsp[0].i);
	;}
    break;

  case 280:
#line 2185 "parser.yy"
    {
		(yyval.scm) = scm_from_int ((yyvsp[0].i));
	;}
    break;

  case 281:
#line 2188 "parser.yy"
    {
		(yyval.scm) = scm_from_int ((yyvsp[0].i));
	;}
    break;

  case 282:
#line 2191 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 283:
#line 2192 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 284:
#line 2196 "parser.yy"
    { (yyval.i) = -2; ;}
    break;

  case 285:
#line 2197 "parser.yy"
    { (yyval.i) = 2; ;}
    break;

  case 286:
#line 2198 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 287:
#line 2202 "parser.yy"
    {
		Music *bfr = MY_MAKE_MUSIC ("BassFigureEvent");
		(yyval.scm) = bfr->self_scm ();
		bfr->unprotect ();
	;}
    break;

  case 288:
#line 2207 "parser.yy"
    {
		Music *bfr = MY_MAKE_MUSIC ("BassFigureEvent");
		(yyval.scm) = bfr->self_scm ();

		if (scm_is_number ((yyvsp[0].scm)))
			bfr->set_property ("figure", (yyvsp[0].scm));
		else if (Text_interface::is_markup ((yyvsp[0].scm)))
			bfr->set_property ("text", (yyvsp[0].scm));

		bfr->unprotect ();
	;}
    break;

  case 289:
#line 2218 "parser.yy"
    {
		(yyval.scm) = (yyvsp[-1].scm);
		unsmob_music ((yyvsp[-1].scm))->set_property ("bracket-stop", SCM_BOOL_T);
	;}
    break;

  case 290:
#line 2222 "parser.yy"
    {
		Music *m = unsmob_music ((yyvsp[-1].scm));
		if ((yyvsp[0].i)) {
			SCM salter = m->get_property ("alteration");
			int alter = scm_is_number (salter) ? scm_to_int (salter) : 0;
			m->set_property ("alteration",
				scm_from_int (alter + (yyvsp[0].i)));
		} else {
			m->set_property ("alteration", scm_from_int (0));
		}
	;}
    break;

  case 291:
#line 2233 "parser.yy"
    {
		Music *m = unsmob_music ((yyvsp[-1].scm));
		if ((yyvsp[0].scm) == ly_symbol2scm ("plus"))
			{
			m->set_property ("augmented", SCM_BOOL_T);
			}
		else if ((yyvsp[0].scm) == ly_symbol2scm ("slash"))
			{
			m->set_property ("diminished", SCM_BOOL_T);
			}
		else if ((yyvsp[0].scm) == ly_symbol2scm ("exclamation"))
			{
			m->set_property ("no-continuation", SCM_BOOL_T);
			}
	;}
    break;

  case 292:
#line 2252 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("plus");
	;}
    break;

  case 293:
#line 2255 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("exclamation");
	;}
    break;

  case 294:
#line 2258 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("slash");
	;}
    break;

  case 295:
#line 2264 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 296:
#line 2267 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		unsmob_music ((yyval.scm))->set_property ("bracket-start", SCM_BOOL_T);
	;}
    break;

  case 297:
#line 2274 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;
	;}
    break;

  case 298:
#line 2277 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 299:
#line 2283 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("EventChord");
		(yyvsp[-1].scm) = scm_reverse_x ((yyvsp[-1].scm), SCM_EOL);
		m->set_property ("elements", (yyvsp[-1].scm));
		(yyval.scm) = m->self_scm ();
	;}
    break;

  case 300:
#line 2293 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 301:
#line 2294 "parser.yy"
    { (yyval.i) = 1; ;}
    break;

  case 302:
#line 2298 "parser.yy"
    {
		if (!THIS->lexer_->is_note_state ())
			THIS->parser_error ((yylsp[-5]), _ ("have to be in Note mode for notes"));

		Music *n = 0;
		if ((yyvsp[0].i))
			n = MY_MAKE_MUSIC ("RestEvent");
		else
			n = MY_MAKE_MUSIC ("NoteEvent");
		
		n->set_property ("pitch", (yyvsp[-5].scm));
		n->set_property ("duration", (yyvsp[-1].scm));

		if (scm_is_number ((yyvsp[-2].scm)))
		{
			int q = scm_to_int ((yyvsp[-2].scm));
			n->set_property ("absolute-octave", scm_from_int (q-1));
		}

		if ((yyvsp[-3].i) % 2)
			n->set_property ("cautionary", SCM_BOOL_T);
		if ((yyvsp[-4].i) % 2 || (yyvsp[-3].i) % 2)
			n->set_property ("force-accidental", SCM_BOOL_T);

		Music *v = MY_MAKE_MUSIC ("EventChord");
		v->set_property ("elements", scm_list_1 (n->self_scm ()));
		n->unprotect ();

		v->set_spot ((yyloc));
		n->set_spot ((yyloc));
		(yyval.music) = v;
	;}
    break;

  case 303:
#line 2330 "parser.yy"
    {
		Music *n = MY_MAKE_MUSIC ("NoteEvent");
		n->set_property ("duration", (yyvsp[0].scm));
		n->set_property ("drum-type", (yyvsp[-1].scm));

		Music *v = MY_MAKE_MUSIC ("EventChord");
		v->set_property ("elements", scm_list_1 (n->self_scm ()));
		n->unprotect ();
		v->set_spot ((yyloc));
		n->set_spot ((yyloc));
		(yyval.music) = v;
		
	;}
    break;

  case 304:
#line 2343 "parser.yy"
    {
		Music *m = unsmob_music ((yyvsp[-1].scm));
		m->set_spot ((yyloc));
		for (SCM s = m->get_property ("elements"); scm_is_pair (s); s = scm_cdr (s))
		{
			unsmob_music (scm_car (s))->set_property ("duration", (yyvsp[0].scm));
		}
		(yyval.music) = m;
	;}
    break;

  case 305:
#line 2352 "parser.yy"
    {
		Music *ev = 0;
 		if (ly_scm2string ((yyvsp[-1].scm)) == "s") {
			/* Space */
			ev = MY_MAKE_MUSIC ("SkipEvent");
		  }
		else {
			ev = MY_MAKE_MUSIC ("RestEvent");
		
		    }
		ev->set_property ("duration", (yyvsp[0].scm));
		ev->set_spot ((yyloc));
 		Music *velt = MY_MAKE_MUSIC ("EventChord");
		velt->set_property ("elements", scm_list_1 (ev->self_scm ()));
		velt->set_spot ((yyloc));

		ev->unprotect();

 		(yyval.music) = velt;
	;}
    break;

  case 306:
#line 2372 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-multi-measure-rest");
		SCM mus = scm_call_2 (proc, (yyvsp[0].scm), make_input ((yyloc)));
		(yyval.music) = unsmob_music (mus);
		(yyval.music)->protect ();
	;}
    break;

  case 307:
#line 2379 "parser.yy"
    {
		if (!THIS->lexer_->is_lyric_state ())
			THIS->parser_error ((yylsp[-1]), _ ("have to be in Lyric mode for lyrics"));

		Music *levent = MY_MAKE_MUSIC ("LyricEvent");
		levent->set_property ("text", (yyvsp[-1].scm));
		levent->set_property ("duration",(yyvsp[0].scm));
		levent->set_spot ((yyloc));
		Music *velt = MY_MAKE_MUSIC ("EventChord");
		velt->set_property ("elements", scm_list_1 (levent->self_scm ()));

		(yyval.music)= velt;
	;}
    break;

  case 308:
#line 2392 "parser.yy"
    {
                if (!THIS->lexer_->is_chord_state ())
                        THIS->parser_error ((yylsp[0]), _ ("have to be in Chord mode for chords"));
                (yyval.music) = unsmob_music ((yyvsp[0].scm));
	;}
    break;

  case 309:
#line 2400 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 310:
#line 2403 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 311:
#line 2409 "parser.yy"
    {
		(yyval.scm) = make_chord ((yyvsp[-1].scm), (yyvsp[0].scm), SCM_EOL);
	;}
    break;

  case 312:
#line 2412 "parser.yy"
    {
		SCM its = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);
		(yyval.scm) = make_chord ((yyvsp[-3].scm), (yyvsp[-2].scm), scm_cons ((yyvsp[-1].scm), its));
	;}
    break;

  case 313:
#line 2419 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;		
	;}
    break;

  case 314:
#line 2422 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyval.scm));
	;}
    break;

  case 315:
#line 2428 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("chord-colon");
	;}
    break;

  case 316:
#line 2431 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("chord-caret");
	;}
    break;

  case 317:
#line 2434 "parser.yy"
    {
 		(yyval.scm) = scm_list_2 (ly_symbol2scm ("chord-slash"), (yyvsp[0].scm));
	;}
    break;

  case 318:
#line 2437 "parser.yy"
    {
		(yyval.scm) = scm_list_2 (ly_symbol2scm ("chord-bass"), (yyvsp[0].scm));
	;}
    break;

  case 319:
#line 2443 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 320:
#line 2446 "parser.yy"
    {
		(yyval.scm) = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);
	;}
    break;

  case 321:
#line 2449 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 322:
#line 2455 "parser.yy"
    { (yyval.scm) = scm_cons ((yyvsp[0].scm), SCM_EOL); ;}
    break;

  case 323:
#line 2456 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyval.scm));
	;}
    break;

  case 324:
#line 2462 "parser.yy"
    {
		(yyval.scm) = make_chord_step ((yyvsp[0].i), 0);
        ;}
    break;

  case 325:
#line 2465 "parser.yy"
    {
		(yyval.scm) = make_chord_step ((yyvsp[-1].i), SHARP);
	;}
    break;

  case 326:
#line 2468 "parser.yy"
    {
		(yyval.scm) = make_chord_step ((yyvsp[-1].i), FLAT);
	;}
    break;

  case 327:
#line 2480 "parser.yy"
    {
		(yyval.scm) = scm_sum ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 328:
#line 2483 "parser.yy"
    {
		(yyval.scm) = scm_difference ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 330:
#line 2490 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 331:
#line 2493 "parser.yy"
    {
		(yyval.scm) = scm_product ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 332:
#line 2496 "parser.yy"
    {
		(yyval.scm) = scm_divide ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 333:
#line 2502 "parser.yy"
    { /* %prec UNARY_MINUS */
		(yyval.scm) = scm_difference ((yyvsp[0].scm), SCM_UNDEFINED);
	;}
    break;

  case 335:
#line 2510 "parser.yy"
    {
		(yyval.scm) = scm_from_int ((yyvsp[0].i));
	;}
    break;

  case 336:
#line 2513 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 337:
#line 2516 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 338:
#line 2519 "parser.yy"
    {
		(yyval.scm) = scm_from_double (scm_to_double ((yyvsp[-1].scm)) *scm_to_double ((yyvsp[0].scm)));
	;}
    break;

  case 339:
#line 2522 "parser.yy"
    {
		(yyval.scm) = scm_from_double ((yyvsp[-1].i) *scm_to_double ((yyvsp[0].scm)));
	;}
    break;

  case 340:
#line 2529 "parser.yy"
    {
			(yyval.i) = (yyvsp[0].i);
	;}
    break;

  case 341:
#line 2532 "parser.yy"
    {
		(yyval.i) = (yyvsp[0].i);
	;}
    break;

  case 342:
#line 2538 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 343:
#line 2539 "parser.yy"
    { (yyval.i) ++; ;}
    break;

  case 344:
#line 2543 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 345:
#line 2544 "parser.yy"
    { (yyval.i) ++; ;}
    break;

  case 346:
#line 2552 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 347:
#line 2556 "parser.yy"
    { THIS->lexer_->push_markup_state (); ;}
    break;

  case 348:
#line 2557 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		THIS->lexer_->pop_state ();
	;}
    break;

  case 349:
#line 2564 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 350:
#line 2568 "parser.yy"
    { THIS->lexer_->push_markup_state (); ;}
    break;

  case 351:
#line 2569 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		THIS->lexer_->pop_state ();
	;}
    break;

  case 352:
#line 2576 "parser.yy"
    { 
		(yyval.scm) = scm_list_2 (ly_lily_module_constant ("line-markup"),  (yyvsp[0].scm)); 
	;}
    break;

  case 353:
#line 2579 "parser.yy"
    {
		(yyval.scm) = scm_car (scm_call_2 (ly_lily_module_constant ("map-markup-command-list"), (yyvsp[-1].scm), scm_list_1 ((yyvsp[0].scm))));
	;}
    break;

  case 354:
#line 2582 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 355:
#line 2588 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 356:
#line 2591 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 357:
#line 2597 "parser.yy"
    {
		(yyval.scm) = scm_call_2 (ly_lily_module_constant ("map-markup-command-list"), (yyvsp[-1].scm), (yyvsp[0].scm));
		
	;}
    break;

  case 358:
#line 2604 "parser.yy"
    {
		(yyval.scm) = scm_reverse_x ((yyvsp[-1].scm), SCM_EOL);
	;}
    break;

  case 359:
#line 2610 "parser.yy"
    {  (yyval.scm) = SCM_EOL; ;}
    break;

  case 360:
#line 2611 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 361:
#line 2614 "parser.yy"
    {
		(yyval.scm) = scm_append_x (scm_list_2 (scm_reverse_x ((yyvsp[0].scm), SCM_EOL), (yyvsp[-1].scm)));
	;}
    break;

  case 362:
#line 2620 "parser.yy"
    {
		(yyval.scm) = scm_list_1 ((yyvsp[0].scm));
	;}
    break;

  case 363:
#line 2623 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 364:
#line 2626 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 365:
#line 2632 "parser.yy"
    {
		(yyval.scm) = scm_list_1 ((yyvsp[0].scm));
	;}
    break;

  case 366:
#line 2635 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 367:
#line 2641 "parser.yy"
    {
		(yyval.scm) = make_simple_markup ((yyvsp[0].scm));
	;}
    break;

  case 368:
#line 2644 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 369:
#line 2647 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 370:
#line 2650 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 371:
#line 2653 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));
	;}
    break;

  case 372:
#line 2656 "parser.yy"
    {
		Score * sc = (yyvsp[-1].score);
		(yyval.scm) = scm_list_2 (ly_lily_module_constant ("score-markup"), sc->self_scm ());
		sc->unprotect ();
		THIS->lexer_->pop_state ();
	;}
    break;

  case 373:
#line 2662 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 374:
#line 2665 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-3].scm), (yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 375:
#line 2668 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 376:
#line 2671 "parser.yy"
    {
		(yyval.scm) = scm_list_1 ((yyvsp[0].scm));
	;}
    break;

  case 377:
#line 2674 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm),(yyvsp[0].scm));
	;}
    break;

  case 378:
#line 2677 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 379:
#line 2683 "parser.yy"
    {
		SCM mapper = ly_lily_module_constant ("map-markup-command-list");
		(yyval.scm) = scm_car (scm_call_2 (mapper, (yyvsp[-1].scm), scm_list_1 ((yyvsp[0].scm))));
	;}
    break;

  case 380:
#line 2687 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;


      default: break;
    }

/* Line 1052 of yacc.c.  */
#line 5629 "out/parser.cc"

  yyvsp -= yylen;
  yyssp -= yylen;
  yylsp -= yylen;

  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  int yytype = YYTRANSLATE (yychar);
	  YYSIZE_T yysize0 = yystrlen (yytname[yytype]);
	  YYSIZE_T yysize = yysize0;
	  YYSIZE_T yysize1;
	  int yysize_overflow = 0;
	  char *yymsg = 0;
#	  define YYERROR_VERBOSE_ARGS_MAXIMUM 5
	  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
	  int yyx;

#if 0
	  /* This is so xgettext sees the translatable formats that are
	     constructed on the fly.  */
	  _("syntax error, unexpected %s");
	  _("syntax error, unexpected %s, expecting %s");
	  _("syntax error, unexpected %s, expecting %s or %s");
	  _("syntax error, unexpected %s, expecting %s or %s or %s");
	  _("syntax error, unexpected %s, expecting %s or %s or %s or %s");
#endif
	  char *yyfmt;
	  char const *yyf;
	  static char const yyunexpected[] = "syntax error, unexpected %s";
	  static char const yyexpecting[] = ", expecting %s";
	  static char const yyor[] = " or %s";
	  char yyformat[sizeof yyunexpected
			+ sizeof yyexpecting - 1
			+ ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
			   * (sizeof yyor - 1))];
	  char const *yyprefix = yyexpecting;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 1;

	  yyarg[0] = yytname[yytype];
	  yyfmt = yystpcpy (yyformat, yyunexpected);

	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
		  {
		    yycount = 1;
		    yysize = yysize0;
		    yyformat[sizeof yyunexpected - 1] = '\0';
		    break;
		  }
		yyarg[yycount++] = yytname[yyx];
		yysize1 = yysize + yystrlen (yytname[yyx]);
		yysize_overflow |= yysize1 < yysize;
		yysize = yysize1;
		yyfmt = yystpcpy (yyfmt, yyprefix);
		yyprefix = yyor;
	      }

	  yyf = _(yyformat);
	  yysize1 = yysize + strlen (yyf);
	  yysize_overflow |= yysize1 < yysize;
	  yysize = yysize1;

	  if (!yysize_overflow && yysize <= YYSTACK_ALLOC_MAXIMUM)
	    yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg)
	    {
	      /* Avoid sprintf, as that infringes on the user's name space.
		 Don't have undefined behavior even if the translation
		 produced a string with the wrong number of "%s"s.  */
	      char *yyp = yymsg;
	      int yyi = 0;
	      while ((*yyp = *yyf))
		{
		  if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		    {
		      yyp = yystpcpy (yyp, yyarg[yyi++]);
		      yyf += 2;
		    }
		  else
		    {
		      yyp++;
		      yyf++;
		    }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror (_("syntax error; also memory exhausted"));
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror (_("syntax error"));
    }

  yyerror_range[0] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
                 yyerror_range[0] = *yylsp;
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 yydestruct (_("Error: popping"),
                             yystos[*yyssp], yyvsp, yylsp);
	       }
        }
      else
	{
	  yydestruct (_("Error: discarding"), yytoken, &yylval, &yylloc);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (0)
     goto yyerrorlab;

  yyerror_range[0] = yylsp[1-yylen];
  yylsp -= yylen;
  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      yyerror_range[0] = *yylsp;
      yydestruct (_("Error: popping"), yystos[yystate], yyvsp, yylsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;

  yyerror_range[1] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the look-ahead.  YYLOC is available though. */
  YYLLOC_DEFAULT (yyloc, yyerror_range - 1, 2);
  *++yylsp = yyloc;

  /* Shift the error token. */
  YY_SYMBOL_PRINT (_("Shifting"), yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yydestruct (_("Error: discarding lookahead"),
              yytoken, &yylval, &yylloc);
  yychar = YYEMPTY;
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror (_("parser stack overflow"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 2692 "parser.yy"


void
Lily_parser::set_yydebug (bool )
{
#if 0
	yydebug = 1;
#endif
}

void
Lily_parser::do_yyparse ()
{
	yyparse ((void*)this);
}





/*

It is a little strange to have this function in this file, but
otherwise, we have to import music classes into the lexer.

*/
int
Lily_lexer::try_special_identifiers (SCM *destination, SCM sid)
{
	if (scm_is_string (sid)) {
		*destination = sid;
		return STRING_IDENTIFIER;
	} else if (unsmob_book (sid)) {
		*destination = unsmob_book (sid)->clone ()->self_scm ();
		return BOOK_IDENTIFIER;
	} else if (scm_is_number (sid)) {
		*destination = sid;
		return NUMBER_IDENTIFIER;
	} else if (unsmob_context_def (sid)) {
		*destination = unsmob_context_def (sid)->clone_scm ();
		return CONTEXT_DEF_IDENTIFIER;
	} else if (unsmob_score (sid)) {
		Score *score = new Score (*unsmob_score (sid));
		*destination = score->self_scm ();
		return SCORE_IDENTIFIER;
	} else if (Music *mus = unsmob_music (sid)) {
		mus = mus->clone ();
		*destination = mus->self_scm ();
		unsmob_music (*destination)->
			set_property ("origin", make_input (last_input_));

		bool is_event = scm_memq (ly_symbol2scm ("event"), mus->get_property ("types"))
			!= SCM_BOOL_F;

		return is_event ? EVENT_IDENTIFIER : MUSIC_IDENTIFIER;
	} else if (unsmob_duration (sid)) {
		*destination = unsmob_duration (sid)->smobbed_copy ();
		return DURATION_IDENTIFIER;
	} else if (unsmob_output_def (sid)) {
		Output_def *p = unsmob_output_def (sid);
		p = p->clone ();

		*destination = p->self_scm ();
		return OUTPUT_DEF_IDENTIFIER;
	} else if (Text_interface::is_markup (sid)) {
		*destination = sid;
		if (is_lyric_state ())
			return LYRIC_MARKUP_IDENTIFIER;
		return MARKUP_IDENTIFIER;
	}

	return -1;	
}

Music *
property_op_to_music (SCM op)
{
	Music *m = 0;
	SCM tag = scm_car (op);
	SCM symbol = scm_cadr (op);
	SCM args = scm_cddr (op);
	SCM grob_val = SCM_UNDEFINED;
	SCM grob_path = SCM_UNDEFINED;
	SCM val = SCM_UNDEFINED;
	
	if (tag == ly_symbol2scm ("assign"))
		{
		m = MY_MAKE_MUSIC ("PropertySet");
		val = scm_car (args);
		}
	else if (tag == ly_symbol2scm ("unset"))
		m = MY_MAKE_MUSIC ("PropertyUnset");
	else if (tag == ly_symbol2scm ("push"))
		{
		m = MY_MAKE_MUSIC ("OverrideProperty");
		grob_val = scm_car (args);
		grob_path = scm_cdr (args);
		m->set_property ("pop-first", SCM_BOOL_T);
		}
	else if (tag == ly_symbol2scm ("pop")) {
		m = MY_MAKE_MUSIC ("RevertProperty");
		grob_path = args;
		}

	m->set_property ("symbol", symbol);

	if (val != SCM_UNDEFINED)
		m->set_property ("value", val);
	if (grob_val != SCM_UNDEFINED)
		m->set_property ("grob-value", grob_val);
	if (grob_path != SCM_UNDEFINED)
		m->set_property ("grob-property-path", grob_path);

	return m;
}

Music*
context_spec_music (SCM type, SCM id, Music *m, SCM ops)
{
	Music *csm = MY_MAKE_MUSIC ("ContextSpeccedMusic");

	csm->set_property ("element", m->self_scm ());
	m->unprotect ();

	csm->set_property ("context-type",
		scm_is_symbol (type) ? type : scm_string_to_symbol (type));
	csm->set_property ("property-operations", ops);

	if (scm_is_string (id))
		csm->set_property ("context-id", id);
	return csm;
}

SCM
get_next_unique_context_id ()
{
	return scm_makfrom0str ("$uniqueContextId");
}


SCM
get_next_unique_lyrics_context_id ()
{
	static int new_context_count;
	char s[128];
	snprintf (s, 1024, "uniqueContext%d", new_context_count++);
	return scm_makfrom0str (s);
}


