/* A Bison parser, made by GNU Bison 2.0a.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 1



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     PREC_TOP = 258,
     ADDLYRICS = 259,
     PREC_BOT = 260,
     ACCEPTS = 261,
     ADDQUOTE = 262,
     ALIAS = 263,
     ALTERNATIVE = 264,
     BAR = 265,
     BOOK = 266,
     CHANGE = 267,
     CHORDMODE = 268,
     CHORDS = 269,
     CLEF = 270,
     CONSISTS = 271,
     CONTEXT = 272,
     DEFAULT = 273,
     DEFAULTCHILD = 274,
     DENIES = 275,
     DESCRIPTION = 276,
     DRUMMODE = 277,
     DRUMS = 278,
     FIGUREMODE = 279,
     FIGURES = 280,
     GROBDESCRIPTIONS = 281,
     HEADER = 282,
     INVALID = 283,
     KEY = 284,
     LAYOUT = 285,
     LYRICMODE = 286,
     LYRICS = 287,
     LYRICSTO = 288,
     MARK = 289,
     MARKUP = 290,
     MIDI = 291,
     NAME = 292,
     NOTEMODE = 293,
     OBJECTID = 294,
     OCTAVE = 295,
     ONCE = 296,
     OVERRIDE = 297,
     PAPER = 298,
     PARTIAL = 299,
     RELATIVE = 300,
     REMOVE = 301,
     REPEAT = 302,
     REST = 303,
     REVERT = 304,
     SCORE = 305,
     SEQUENTIAL = 306,
     SET = 307,
     SIMULTANEOUS = 308,
     SKIP = 309,
     TAG = 310,
     TEMPO = 311,
     TIMES = 312,
     TRANSPOSE = 313,
     TRANSPOSITION = 314,
     TYPE = 315,
     UNSET = 316,
     WITH = 317,
     TIME_T = 318,
     NEWCONTEXT = 319,
     CHORD_BASS = 320,
     CHORD_CARET = 321,
     CHORD_COLON = 322,
     CHORD_MINUS = 323,
     CHORD_SLASH = 324,
     DOUBLE_ANGLE_CLOSE = 325,
     DOUBLE_ANGLE_OPEN = 326,
     E_BACKSLASH = 327,
     E_ANGLE_CLOSE = 328,
     E_CHAR = 329,
     E_CLOSE = 330,
     E_EXCLAMATION = 331,
     E_BRACKET_OPEN = 332,
     E_OPEN = 333,
     E_BRACKET_CLOSE = 334,
     E_ANGLE_OPEN = 335,
     E_TILDE = 336,
     EXTENDER = 337,
     FIGURE_CLOSE = 338,
     FIGURE_OPEN = 339,
     FIGURE_SPACE = 340,
     HYPHEN = 341,
     CHORDMODIFIERS = 342,
     LYRIC_MARKUP = 343,
     MULTI_MEASURE_REST = 344,
     SCM_T = 345,
     DIGIT = 346,
     E_UNSIGNED = 347,
     UNSIGNED = 348,
     IDENTIFIER = 349,
     CHORDMODIFIER_PITCH = 350,
     CHORD_MODIFIER = 351,
     CONTEXT_DEF_IDENTIFIER = 352,
     DRUM_PITCH = 353,
     DURATION_IDENTIFIER = 354,
     EVENT_IDENTIFIER = 355,
     FRACTION = 356,
     LYRICS_STRING = 357,
     LYRIC_MARKUP_IDENTIFIER = 358,
     MARKUP_HEAD_EMPTY = 359,
     MARKUP_HEAD_LIST0 = 360,
     MARKUP_HEAD_MARKUP0 = 361,
     MARKUP_HEAD_MARKUP0_MARKUP1 = 362,
     MARKUP_HEAD_SCM0 = 363,
     MARKUP_HEAD_SCM0_MARKUP1 = 364,
     MARKUP_HEAD_SCM0_SCM1 = 365,
     MARKUP_HEAD_SCM0_SCM1_MARKUP2 = 366,
     MARKUP_HEAD_SCM0_SCM1_SCM2 = 367,
     MARKUP_IDENTIFIER = 368,
     MUSIC_FUNCTION = 369,
     MUSIC_FUNCTION_MARKUP = 370,
     MUSIC_FUNCTION_MARKUP_MARKUP = 371,
     MUSIC_FUNCTION_MARKUP_MARKUP_MUSIC = 372,
     MUSIC_FUNCTION_MARKUP_MUSIC = 373,
     MUSIC_FUNCTION_MARKUP_MUSIC_MUSIC = 374,
     MUSIC_FUNCTION_MUSIC = 375,
     MUSIC_FUNCTION_MUSIC_MUSIC = 376,
     MUSIC_FUNCTION_SCM = 377,
     MUSIC_FUNCTION_SCM_MUSIC = 378,
     MUSIC_FUNCTION_SCM_MUSIC_MUSIC = 379,
     MUSIC_FUNCTION_SCM_SCM = 380,
     MUSIC_FUNCTION_SCM_SCM_MUSIC = 381,
     MUSIC_FUNCTION_SCM_SCM_SCM = 382,
     MUSIC_IDENTIFIER = 383,
     NOTENAME_PITCH = 384,
     NUMBER_IDENTIFIER = 385,
     OUTPUT_DEF_IDENTIFIER = 386,
     REAL = 387,
     RESTNAME = 388,
     SCM_IDENTIFIER = 389,
     SCORE_IDENTIFIER = 390,
     STRING = 391,
     STRING_IDENTIFIER = 392,
     TONICNAME_PITCH = 393,
     UNARY_MINUS = 394
   };
#endif
#define PREC_TOP 258
#define ADDLYRICS 259
#define PREC_BOT 260
#define ACCEPTS 261
#define ADDQUOTE 262
#define ALIAS 263
#define ALTERNATIVE 264
#define BAR 265
#define BOOK 266
#define CHANGE 267
#define CHORDMODE 268
#define CHORDS 269
#define CLEF 270
#define CONSISTS 271
#define CONTEXT 272
#define DEFAULT 273
#define DEFAULTCHILD 274
#define DENIES 275
#define DESCRIPTION 276
#define DRUMMODE 277
#define DRUMS 278
#define FIGUREMODE 279
#define FIGURES 280
#define GROBDESCRIPTIONS 281
#define HEADER 282
#define INVALID 283
#define KEY 284
#define LAYOUT 285
#define LYRICMODE 286
#define LYRICS 287
#define LYRICSTO 288
#define MARK 289
#define MARKUP 290
#define MIDI 291
#define NAME 292
#define NOTEMODE 293
#define OBJECTID 294
#define OCTAVE 295
#define ONCE 296
#define OVERRIDE 297
#define PAPER 298
#define PARTIAL 299
#define RELATIVE 300
#define REMOVE 301
#define REPEAT 302
#define REST 303
#define REVERT 304
#define SCORE 305
#define SEQUENTIAL 306
#define SET 307
#define SIMULTANEOUS 308
#define SKIP 309
#define TAG 310
#define TEMPO 311
#define TIMES 312
#define TRANSPOSE 313
#define TRANSPOSITION 314
#define TYPE 315
#define UNSET 316
#define WITH 317
#define TIME_T 318
#define NEWCONTEXT 319
#define CHORD_BASS 320
#define CHORD_CARET 321
#define CHORD_COLON 322
#define CHORD_MINUS 323
#define CHORD_SLASH 324
#define DOUBLE_ANGLE_CLOSE 325
#define DOUBLE_ANGLE_OPEN 326
#define E_BACKSLASH 327
#define E_ANGLE_CLOSE 328
#define E_CHAR 329
#define E_CLOSE 330
#define E_EXCLAMATION 331
#define E_BRACKET_OPEN 332
#define E_OPEN 333
#define E_BRACKET_CLOSE 334
#define E_ANGLE_OPEN 335
#define E_TILDE 336
#define EXTENDER 337
#define FIGURE_CLOSE 338
#define FIGURE_OPEN 339
#define FIGURE_SPACE 340
#define HYPHEN 341
#define CHORDMODIFIERS 342
#define LYRIC_MARKUP 343
#define MULTI_MEASURE_REST 344
#define SCM_T 345
#define DIGIT 346
#define E_UNSIGNED 347
#define UNSIGNED 348
#define IDENTIFIER 349
#define CHORDMODIFIER_PITCH 350
#define CHORD_MODIFIER 351
#define CONTEXT_DEF_IDENTIFIER 352
#define DRUM_PITCH 353
#define DURATION_IDENTIFIER 354
#define EVENT_IDENTIFIER 355
#define FRACTION 356
#define LYRICS_STRING 357
#define LYRIC_MARKUP_IDENTIFIER 358
#define MARKUP_HEAD_EMPTY 359
#define MARKUP_HEAD_LIST0 360
#define MARKUP_HEAD_MARKUP0 361
#define MARKUP_HEAD_MARKUP0_MARKUP1 362
#define MARKUP_HEAD_SCM0 363
#define MARKUP_HEAD_SCM0_MARKUP1 364
#define MARKUP_HEAD_SCM0_SCM1 365
#define MARKUP_HEAD_SCM0_SCM1_MARKUP2 366
#define MARKUP_HEAD_SCM0_SCM1_SCM2 367
#define MARKUP_IDENTIFIER 368
#define MUSIC_FUNCTION 369
#define MUSIC_FUNCTION_MARKUP 370
#define MUSIC_FUNCTION_MARKUP_MARKUP 371
#define MUSIC_FUNCTION_MARKUP_MARKUP_MUSIC 372
#define MUSIC_FUNCTION_MARKUP_MUSIC 373
#define MUSIC_FUNCTION_MARKUP_MUSIC_MUSIC 374
#define MUSIC_FUNCTION_MUSIC 375
#define MUSIC_FUNCTION_MUSIC_MUSIC 376
#define MUSIC_FUNCTION_SCM 377
#define MUSIC_FUNCTION_SCM_MUSIC 378
#define MUSIC_FUNCTION_SCM_MUSIC_MUSIC 379
#define MUSIC_FUNCTION_SCM_SCM 380
#define MUSIC_FUNCTION_SCM_SCM_MUSIC 381
#define MUSIC_FUNCTION_SCM_SCM_SCM 382
#define MUSIC_IDENTIFIER 383
#define NOTENAME_PITCH 384
#define NUMBER_IDENTIFIER 385
#define OUTPUT_DEF_IDENTIFIER 386
#define REAL 387
#define RESTNAME 388
#define SCM_IDENTIFIER 389
#define SCORE_IDENTIFIER 390
#define STRING 391
#define STRING_IDENTIFIER 392
#define TONICNAME_PITCH 393
#define UNARY_MINUS 394




/* Copy the first part of user declarations.  */
#line 1 "parser.yy"
 // -*-Fundamental-*-

/*
  parser.yy -- Bison/C++ parser for LilyPond

  source file of the GNU LilyPond music typesetter

  (c) 1997--2005 Han-Wen Nienhuys <hanwen@cs.uu.nl>
                 Jan Nieuwenhuizen <janneke@gnu.org>
*/

/*
FIXME:

   * The rules for who is protecting what are very shady.  Uniformise
     this.

   * There are too many lexical modes?
*/

#include "config.hh"

#include <cctype>
#include <cstdlib>
#include <cstdio>
using namespace std;

#include "book.hh"
#include "context-def.hh"
#include "dimensions.hh"
#include "music.hh"
#include "file-path.hh"
#include "input-smob.hh"
#include "input.hh"
#include "lily-guile.hh"
#include "lilypond-input-version.hh"
#include "main.hh"
#include "misc.hh"
#include "lily-lexer.hh"
#include "lily-parser.hh"
#include "paper-book.hh"
#include "output-def.hh"
#include "scm-hash.hh"
#include "program-option.hh"
#include "score.hh"
#include "text-interface.hh"
#include "warn.hh"
#include "music.hh"

#define MY_MAKE_MUSIC(x)  make_music_by_name (ly_symbol2scm (x))

Music *property_op_to_music (SCM op);
Music *context_spec_music (SCM type, SCM id, Music *m, SCM ops);
SCM get_next_unique_context_id ();
SCM get_next_unique_lyrics_context_id ();

#undef _
#if !HAVE_GETTEXT
#define _(x) x
#else
#include <libintl.h>
#define _(x) gettext (x)
#endif

#define YYERROR_VERBOSE 1

#define YYPARSE_PARAM my_lily_parser
#define YYLEX_PARAM my_lily_parser
#define THIS\
	((Lily_parser *) my_lily_parser)

#define yyerror THIS->parser_error

/* We use custom location type: Input objects */
#define YYLTYPE Input
#define YYLLOC_DEFAULT(Current,Rhs,N) \
	((Current).set_location ((Rhs)[1], (Rhs)[N]))


/* Add symbols to the TAGS field of a music object.  */

void
tag_music (Music *m, SCM tag, Input ip)
{
	SCM tags = m->get_property ("tags");
	if (scm_is_symbol (tag))
		tags = scm_cons (tag, tags);
	else if (ly_is_list (tag))
		tags = ly_append2 (tag, tags);
	else
		ip.warning (_ ("tag must be symbol or list of symbols"));

	m->set_property ("tags", tags);
}

bool
is_regular_identifier (SCM id)
{
  String str = ly_scm2string (id);
  char const *s = str.to_str0 ();

  bool v = true;
#if 0
  isalpha (*s);
  s++;
#endif
  while (*s && v)
   {
        v = v && isalnum (*s);
        s++;
   }
  return v;
}


SCM
get_first_context_id (SCM type, Music *m)
{
	SCM id = m->get_property ("context-id");
	if (SCM_BOOL_T == scm_equal_p (m->get_property ("context-type"), type)
	    && scm_is_string (m->get_property ("context-id"))
	    && scm_c_string_length (id) > 0)
	{
		return id;
	}
	return SCM_EOL;
}

SCM
make_simple_markup (SCM a)
{
	return a;
}

bool
is_duration (int t)
{
  return t && t == 1 << intlog2 (t);
}

void
set_music_properties (Music *p, SCM a)
{
  for (SCM k = a; scm_is_pair (k); k = scm_cdr (k))
 	p->internal_set_property (scm_caar (k), scm_cdar (k));
}

SCM
make_chord_step (int step, int alter)
{
	if (step == 7)
		alter += FLAT;

	while (step < 0)
		step += 7;
	Pitch m ((step -1) / 7, (step - 1) % 7, alter);
	return m.smobbed_copy ();
}


SCM
make_chord (SCM pitch, SCM dur, SCM modification_list)
{
	SCM chord_ctor = ly_lily_module_constant ("construct-chord");
	SCM ch = scm_call_3 (chord_ctor, pitch, dur, modification_list);

	unsmob_music (ch)->protect();	
	return ch;
}

/* Todo: actually also use apply iso. call too ...  */
bool
ly_input_procedure_p (SCM x)
{
	return ly_is_procedure (x)
		|| (scm_is_pair (x) && ly_is_procedure (scm_car (x)));
}

Music*
set_property_music (SCM sym, SCM value)
{
	Music *p = MY_MAKE_MUSIC ("PropertySet");
	p->set_property ("symbol", sym);
	p->set_property ("value", value);
	return p;
}

Music*
make_music_relative (Pitch start, Music *music)
{
	Music *relative = MY_MAKE_MUSIC ("RelativeOctaveMusic");
 	relative->set_property ("element", music->self_scm ());
	
 	Pitch last = music->to_relative_octave (start);
 	if (lily_1_8_relative)
 		music->set_property ("last-pitch", last.smobbed_copy ());
	return relative;
}

Music*
make_lyric_combine_music (SCM name, Music *music)
{
	Music *combine = MY_MAKE_MUSIC ("LyricCombineMusic");
	combine->set_property ("element", music->self_scm ());
 	combine->set_property ("associated-context", name);
	return combine;
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 219 "parser.yy"
typedef union YYSTYPE {
	Book *book;
	Output_def *outputdef;
	SCM scm;
	String *string;
 	Music *music;
 	Score *score;
 	int i;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 574 "out/parser.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */
#line 228 "parser.yy"


int
yylex (YYSTYPE *s, YYLTYPE *loc, void *v)
{
	Lily_parser *pars = (Lily_parser*) v;
	Lily_lexer *lex = pars->lexer_;

	lex->lexval = (void*) s;
	lex->lexloc = loc;
	lex->prepare_for_next_token ();
	return lex->yylex ();
}




/* Line 214 of yacc.c.  */
#line 614 "out/parser.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2005 */
#  endif
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  else
#   define YYSIZE_T unsigned long int
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM ((YYSIZE_T) -1)
#  endif
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYLTYPE_IS_TRIVIAL) && YYLTYPE_IS_TRIVIAL \
             && defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2106

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  163
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  128
/* YYNRULES -- Number of rules. */
#define YYNRULES  372
/* YYNRULES -- Number of states. */
#define YYNSTATES  551

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   394

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   161,     2,     2,     2,     2,     2,   154,
     152,   153,   158,   140,   155,   139,   145,   159,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   160,     2,
     146,   144,   147,   162,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   149,     2,   150,   156,   157,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   142,   148,   143,   151,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   141
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     4,     7,    10,    13,    16,    19,    21,
      23,    25,    27,    29,    31,    33,    35,    37,    39,    40,
      43,    48,    50,    52,    56,    58,    60,    62,    64,    66,
      68,    70,    72,    74,    76,    78,    83,    84,    86,    90,
      93,    98,    99,   102,   105,   108,   111,   114,   117,   122,
     124,   126,   129,   132,   135,   138,   140,   143,   145,   147,
     149,   152,   156,   159,   162,   165,   168,   173,   174,   177,
     180,   183,   185,   187,   188,   193,   199,   204,   208,   213,
     217,   219,   221,   223,   225,   226,   227,   233,   234,   237,
     239,   241,   243,   245,   247,   250,   253,   256,   260,   264,
     269,   274,   278,   282,   286,   291,   296,   298,   300,   307,
     312,   317,   321,   323,   328,   331,   335,   337,   339,   343,
     345,   347,   349,   351,   353,   355,   357,   359,   361,   365,
     368,   369,   373,   374,   379,   382,   383,   388,   393,   397,
     400,   406,   410,   412,   414,   416,   418,   420,   422,   424,
     426,   428,   430,   433,   435,   439,   445,   449,   454,   457,
     460,   462,   464,   468,   470,   472,   474,   476,   478,   480,
     482,   484,   486,   487,   491,   493,   495,   499,   501,   503,
     505,   507,   511,   512,   515,   521,   524,   528,   530,   533,
     536,   538,   540,   542,   544,   547,   550,   553,   556,   559,
     562,   564,   567,   569,   572,   576,   577,   580,   583,   588,
     590,   592,   594,   597,   600,   602,   604,   606,   608,   610,
     612,   614,   616,   618,   620,   622,   624,   626,   628,   630,
     632,   634,   635,   637,   640,   643,   645,   648,   650,   653,
     655,   658,   661,   663,   666,   669,   671,   673,   675,   677,
     679,   681,   683,   685,   687,   689,   691,   693,   695,   697,
     699,   701,   703,   705,   706,   708,   711,   714,   716,   720,
     724,   726,   730,   731,   734,   736,   739,   741,   743,   745,
     747,   749,   751,   753,   755,   757,   760,   763,   765,   768,
     769,   772,   776,   777,   779,   786,   789,   792,   795,   798,
     801,   803,   805,   807,   810,   815,   816,   819,   821,   823,
     826,   829,   831,   833,   835,   837,   841,   843,   846,   849,
     853,   857,   859,   861,   865,   869,   872,   874,   876,   878,
     880,   883,   886,   888,   890,   891,   894,   895,   898,   900,
     901,   905,   907,   908,   912,   914,   917,   919,   921,   923,
     926,   930,   931,   934,   937,   939,   942,   946,   948,   951,
     953,   955,   957,   959,   960,   966,   969,   974,   978,   980,
     983,   987,   990
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     164,     0,    -1,    -1,   164,   166,    -1,   164,   172,    -1,
     164,     1,    -1,   164,    28,    -1,    39,   136,    -1,   170,
      -1,   227,    -1,   176,    -1,   178,    -1,   167,    -1,   279,
      -1,   181,    -1,   195,    -1,    90,    -1,   134,    -1,    -1,
     169,   172,    -1,    27,   142,   169,   143,    -1,   136,    -1,
     102,    -1,   171,   144,   173,    -1,   168,    -1,   178,    -1,
     181,    -1,   174,    -1,   186,    -1,   232,    -1,   270,    -1,
     214,    -1,   168,    -1,   279,    -1,    91,    -1,    17,   142,
     175,   143,    -1,    -1,    97,    -1,   175,    26,   168,    -1,
     175,   211,    -1,    11,   142,   177,   143,    -1,    -1,   177,
     180,    -1,   177,   178,    -1,   177,   279,    -1,   177,   170,
      -1,   177,     1,    -1,   177,   165,    -1,    50,   142,   179,
     143,    -1,   186,    -1,   135,    -1,   179,   165,    -1,   179,
     170,    -1,   179,   181,    -1,   179,     1,    -1,   181,    -1,
     183,   143,    -1,    43,    -1,    36,    -1,    30,    -1,   182,
     142,    -1,   182,   142,   131,    -1,   183,   172,    -1,   183,
     174,    -1,   183,   184,    -1,   183,     1,    -1,    56,   250,
     144,   274,    -1,    -1,   185,   186,    -1,   185,   168,    -1,
     185,     1,    -1,   191,    -1,   195,    -1,    -1,     9,   142,
     185,   143,    -1,    47,   215,   274,   186,   187,    -1,    51,
     142,   185,   143,    -1,   142,   185,   143,    -1,    53,   142,
     185,   143,    -1,   222,   185,   223,    -1,   218,    -1,   128,
      -1,   213,    -1,   208,    -1,    -1,    -1,    62,   193,   142,
     194,   143,    -1,    -1,   194,   211,    -1,   199,    -1,   196,
      -1,   190,    -1,   189,    -1,   114,    -1,   122,   168,    -1,
     115,   279,    -1,   120,   186,    -1,   123,   168,   186,    -1,
     125,   168,   168,    -1,   127,   168,   168,   168,    -1,   126,
     168,   168,   186,    -1,   118,   279,   186,    -1,   116,   279,
     279,    -1,   121,   186,   186,    -1,   124,   168,   186,   186,
      -1,   119,   279,   186,   186,    -1,   197,    -1,   198,    -1,
      17,   215,   144,   215,   192,   186,    -1,    17,   215,   192,
     186,    -1,    64,   215,   192,   186,    -1,    57,   252,   186,
      -1,   188,    -1,    58,   243,   243,   186,    -1,   200,   196,
      -1,   201,   192,   196,    -1,   202,    -1,   206,    -1,    55,
     168,   186,    -1,    38,    -1,    22,    -1,    24,    -1,    13,
      -1,    31,    -1,    23,    -1,    25,    -1,    14,    -1,    32,
      -1,    45,   247,   186,    -1,    45,   195,    -1,    -1,     4,
     204,   196,    -1,    -1,   203,     4,   205,   196,    -1,   196,
     203,    -1,    -1,    33,   215,   207,   186,    -1,    12,   136,
     144,   136,    -1,   136,   144,   216,    -1,    61,   215,    -1,
      42,   215,   168,   144,   168,    -1,    49,   215,   168,    -1,
      16,    -1,    46,    -1,     6,    -1,    19,    -1,    20,    -1,
       8,    -1,    60,    -1,    21,    -1,    37,    -1,   209,    -1,
     210,   136,    -1,   215,    -1,   215,   145,   215,    -1,    42,
     212,   168,   144,   216,    -1,    49,   212,   168,    -1,    52,
     212,   144,   216,    -1,    61,   212,    -1,    41,   213,    -1,
     136,    -1,   137,    -1,   214,   140,   214,    -1,   136,    -1,
     102,    -1,   137,    -1,   214,    -1,   102,    -1,   273,    -1,
     168,    -1,   279,    -1,    91,    -1,    -1,   217,   262,   230,
      -1,   228,    -1,   219,    -1,   224,   249,   230,    -1,   146,
      -1,   147,    -1,    71,    -1,    70,    -1,   220,   225,   221,
      -1,    -1,   225,   226,    -1,   242,   275,   276,   237,   230,
      -1,    98,   230,    -1,     7,   214,   186,    -1,   229,    -1,
      54,   248,    -1,    40,   242,    -1,    77,    -1,    79,    -1,
      72,    -1,   148,    -1,    59,   242,    -1,    10,   136,    -1,
      44,   248,    -1,    15,   136,    -1,    63,   252,    -1,    34,
     216,    -1,    81,    -1,    34,    18,    -1,   184,    -1,    29,
      18,    -1,    29,   129,   134,    -1,    -1,   230,   232,    -1,
     230,   231,    -1,   139,    55,   168,   232,    -1,   235,    -1,
      86,    -1,    82,    -1,   246,   236,    -1,   246,   235,    -1,
     233,    -1,    92,    -1,   149,    -1,   150,    -1,   151,    -1,
     152,    -1,   153,    -1,    76,    -1,    78,    -1,    75,    -1,
      73,    -1,    80,    -1,   234,    -1,   100,    -1,   254,    -1,
     244,    -1,   245,    -1,    -1,   144,    -1,   144,   239,    -1,
     144,   238,    -1,   154,    -1,   238,   154,    -1,   155,    -1,
     239,   155,    -1,   129,    -1,   129,   238,    -1,   129,   239,
      -1,   138,    -1,   138,   238,    -1,   138,   239,    -1,   240,
      -1,   242,    -1,   241,    -1,   279,    -1,   214,    -1,    91,
      -1,   156,    -1,   140,    -1,   139,    -1,   148,    -1,   147,
      -1,   145,    -1,   157,    -1,   157,    -1,   156,    -1,   139,
      -1,   240,    -1,   251,    -1,    -1,   251,    -1,   274,   253,
      -1,    99,   253,    -1,   250,    -1,   251,   158,   274,    -1,
     251,   158,   101,    -1,   101,    -1,    93,   159,    93,    -1,
      -1,   253,   145,    -1,   160,    -1,   160,   274,    -1,    91,
      -1,    93,    -1,   136,    -1,   279,    -1,   139,    -1,   140,
      -1,   161,    -1,    85,    -1,   255,    -1,   257,   150,    -1,
     257,   256,    -1,   257,    -1,   149,   257,    -1,    -1,   259,
     258,    -1,    84,   259,    83,    -1,    -1,    48,    -1,   242,
     275,   276,   237,   249,   261,    -1,    98,   249,    -1,   260,
     249,    -1,   133,   249,    -1,    89,   249,    -1,   263,   249,
      -1,   264,    -1,   277,    -1,   102,    -1,   241,   249,    -1,
     241,   249,   266,   265,    -1,    -1,   265,   267,    -1,    67,
      -1,    66,    -1,    69,   241,    -1,    65,   241,    -1,   266,
      -1,   268,    -1,    96,    -1,   269,    -1,   268,   145,   269,
      -1,   274,    -1,   274,   140,    -1,   274,    68,    -1,   270,
     140,   271,    -1,   270,   139,   271,    -1,   271,    -1,   272,
      -1,   272,   158,   272,    -1,   272,   159,   272,    -1,   139,
     272,    -1,   273,    -1,    93,    -1,   132,    -1,   130,    -1,
     132,   130,    -1,    93,   130,    -1,    93,    -1,    91,    -1,
      -1,   275,   161,    -1,    -1,   276,   162,    -1,   103,    -1,
      -1,    88,   278,   281,    -1,   113,    -1,    -1,    35,   280,
     281,    -1,   282,    -1,   287,   288,    -1,   288,    -1,   283,
      -1,   284,    -1,   287,   284,    -1,   142,   285,   143,    -1,
      -1,   285,   290,    -1,   285,   282,    -1,   106,    -1,   109,
     168,    -1,   111,   168,   168,    -1,   286,    -1,   287,   286,
      -1,   136,    -1,   113,    -1,   103,    -1,   137,    -1,    -1,
      50,   289,   142,   179,   143,    -1,   108,   168,    -1,   112,
     168,   168,   168,    -1,   110,   168,   168,    -1,   104,    -1,
     105,   282,    -1,   107,   290,   290,    -1,   287,   288,    -1,
     288,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   554,   554,   555,   557,   559,   562,   569,   573,   576,
     579,   585,   592,   598,   602,   619,   624,   625,   630,   634,
     640,   649,   650,   654,   670,   675,   679,   683,   686,   690,
     694,   697,   700,   703,   706,   712,   719,   723,   727,   738,
     746,   755,   762,   766,   771,   774,   777,   781,   787,   793,
     804,   808,   811,   814,   826,   837,   849,   858,   863,   868,
     878,   883,   892,   895,   898,   908,   914,   929,   932,   943,
     946,   963,   964,   968,   971,   978,  1037,  1042,  1050,  1056,
    1064,  1065,  1068,  1069,  1074,  1075,  1075,  1084,  1085,  1092,
    1093,  1097,  1098,  1102,  1105,  1108,  1111,  1115,  1119,  1122,
    1125,  1128,  1132,  1135,  1140,  1145,  1153,  1190,  1193,  1197,
    1200,  1205,  1221,  1222,  1232,  1246,  1258,  1259,  1260,  1267,
    1273,  1280,  1285,  1293,  1300,  1306,  1311,  1318,  1326,  1332,
    1342,  1342,  1351,  1351,  1360,  1388,  1388,  1400,  1411,  1415,
    1419,  1423,  1430,  1431,  1433,  1434,  1435,  1437,  1438,  1439,
    1440,  1444,  1445,  1451,  1460,  1467,  1474,  1482,  1489,  1495,
    1505,  1508,  1511,  1516,  1519,  1522,  1527,  1530,  1533,  1536,
    1539,  1542,  1566,  1570,  1583,  1584,  1589,  1605,  1608,  1611,
    1614,  1618,  1628,  1629,  1636,  1664,  1679,  1688,  1696,  1702,
    1708,  1718,  1728,  1732,  1742,  1751,  1760,  1770,  1777,  1784,
    1794,  1797,  1801,  1804,  1808,  1826,  1829,  1834,  1843,  1851,
    1854,  1859,  1864,  1869,  1874,  1878,  1887,  1890,  1893,  1896,
    1899,  1902,  1905,  1908,  1911,  1914,  1920,  1934,  1937,  1946,
    1949,  1960,  1961,  1962,  1963,  1967,  1970,  1976,  1979,  1985,
    1988,  1993,  2005,  2008,  2013,  2022,  2028,  2029,  2033,  2039,
    2047,  2056,  2059,  2062,  2065,  2068,  2071,  2074,  2080,  2081,
    2082,  2087,  2093,  2099,  2103,  2110,  2119,  2128,  2131,  2134,
    2142,  2143,  2149,  2152,  2158,  2161,  2169,  2172,  2175,  2176,
    2180,  2181,  2182,  2186,  2191,  2202,  2206,  2221,  2224,  2231,
    2234,  2240,  2250,  2251,  2255,  2287,  2300,  2309,  2329,  2336,
    2349,  2357,  2360,  2366,  2369,  2376,  2379,  2385,  2388,  2391,
    2394,  2400,  2403,  2406,  2412,  2413,  2419,  2422,  2425,  2437,
    2440,  2443,  2447,  2450,  2453,  2459,  2462,  2467,  2470,  2473,
    2476,  2479,  2486,  2489,  2495,  2496,  2500,  2501,  2509,  2513,
    2512,  2521,  2525,  2524,  2533,  2536,  2539,  2545,  2548,  2554,
    2561,  2567,  2568,  2571,  2577,  2580,  2583,  2589,  2592,  2598,
    2601,  2604,  2607,  2610,  2610,  2619,  2622,  2625,  2628,  2631,
    2634,  2640,  2644
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "PREC_TOP", "\\addlyrics", "PREC_BOT",
  "\\accepts", "\\addquote", "\\alias", "\\alternative", "\\bar", "\book",
  "\\change", "\\chordmode", "\\chords", "\\clef", "\\consists",
  "\\context", "\\default", "\\defaultchild", "\\denies", "\\description",
  "\\drummode", "\\drums", "\\figuremode", "\\figures",
  "\\grobdescriptions", "\\header", "\\invalid", "\\key", "\\layout",
  "\\lyricmode", "\\lyrics", "\\lyricsto", "\\mark", "\\markup", "\\midi",
  "\\name", "\\notemode", "\\objectid", "\\octave", "\\once", "\\override",
  "\\paper", "\\partial", "\\relative", "\\remove", "\\repeat", "\\rest",
  "\\revert", "\\score", "\\sequential", "\\set", "\\simultaneous",
  "\\skip", "\\tag", "\\tempo", "\\times", "\\transpose",
  "\\transposition", "\\type", "\\unset", "\\with", "\\time", "\\new",
  "/+", "^", ":", "-", "/", ">>", "<<", "\\", "\\>", "\\C[haracter]",
  "\\)", "\\!", "\\[", "\\(", "\\]", "\\<", "\\~", "__", "FIGURE_CLOSE",
  "FIGURE_OPEN", "_", "--", "CHORDMODIFIERS", "LYRIC_MARKUP",
  "MULTI_MEASURE_REST", "SCM_T", "DIGIT", "E_UNSIGNED", "UNSIGNED",
  "IDENTIFIER", "CHORDMODIFIER_PITCH", "CHORD_MODIFIER",
  "CONTEXT_DEF_IDENTIFIER", "DRUM_PITCH", "DURATION_IDENTIFIER",
  "EVENT_IDENTIFIER", "FRACTION", "LYRICS_STRING",
  "LYRIC_MARKUP_IDENTIFIER", "MARKUP_HEAD_EMPTY", "MARKUP_HEAD_LIST0",
  "MARKUP_HEAD_MARKUP0", "MARKUP_HEAD_MARKUP0_MARKUP1", "MARKUP_HEAD_SCM0",
  "MARKUP_HEAD_SCM0_MARKUP1", "MARKUP_HEAD_SCM0_SCM1",
  "MARKUP_HEAD_SCM0_SCM1_MARKUP2", "MARKUP_HEAD_SCM0_SCM1_SCM2",
  "MARKUP_IDENTIFIER", "MUSIC_FUNCTION", "MUSIC_FUNCTION_MARKUP",
  "MUSIC_FUNCTION_MARKUP_MARKUP", "MUSIC_FUNCTION_MARKUP_MARKUP_MUSIC",
  "MUSIC_FUNCTION_MARKUP_MUSIC", "MUSIC_FUNCTION_MARKUP_MUSIC_MUSIC",
  "MUSIC_FUNCTION_MUSIC", "MUSIC_FUNCTION_MUSIC_MUSIC",
  "MUSIC_FUNCTION_SCM", "MUSIC_FUNCTION_SCM_MUSIC",
  "MUSIC_FUNCTION_SCM_MUSIC_MUSIC", "MUSIC_FUNCTION_SCM_SCM",
  "MUSIC_FUNCTION_SCM_SCM_MUSIC", "MUSIC_FUNCTION_SCM_SCM_SCM",
  "MUSIC_IDENTIFIER", "NOTENAME_PITCH", "NUMBER_IDENTIFIER",
  "OUTPUT_DEF_IDENTIFIER", "REAL", "RESTNAME", "SCM_IDENTIFIER",
  "SCORE_IDENTIFIER", "STRING", "STRING_IDENTIFIER", "TONICNAME_PITCH",
  "'-'", "'+'", "UNARY_MINUS", "'{'", "'}'", "'='", "'.'", "'<'", "'>'",
  "'|'", "'['", "']'", "'~'", "'('", "')'", "'''", "','", "'^'", "'_'",
  "'*'", "'/'", "':'", "'!'", "'?'", "$accept", "lilypond",
  "object_id_setting", "toplevel_expression", "toplevel_music",
  "embedded_scm", "lilypond_header_body", "lilypond_header",
  "assignment_id", "assignment", "identifier_init",
  "context_def_spec_block", "context_def_spec_body", "book_block",
  "book_body", "score_block", "score_body", "paper_block", "output_def",
  "output_def_head", "output_def_body", "tempo_event", "Music_list",
  "Music", "Alternative_music", "Repeated_music", "Sequential_music",
  "Simultaneous_music", "Simple_music", "optional_context_mod", "@1",
  "context_mod_list", "Composite_music", "Grouped_music_list",
  "Generic_prefix_music_scm", "Generic_prefix_music",
  "Prefix_composite_music", "mode_changing_head",
  "mode_changing_head_with_context", "relative_music", "new_lyrics", "@2",
  "@3", "re_rhythmed_music", "@4", "context_change", "property_operation",
  "context_def_mod", "context_mod", "context_prop_spec",
  "music_property_def", "string", "simple_string", "scalar", "pre_events",
  "event_chord", "note_chord_element", "chord_open", "chord_close",
  "simul_open", "simul_close", "chord_body", "chord_body_elements",
  "chord_body_element", "add_quote", "command_element", "command_event",
  "post_events", "tagged_post_event", "post_event", "string_number_event",
  "direction_less_char", "direction_less_event", "direction_reqd_event",
  "octave_check", "sup_quotes", "sub_quotes", "steno_pitch",
  "steno_tonic_pitch", "pitch", "pitch_also_in_chords", "gen_text_def",
  "script_abbreviation", "script_dir", "absolute_pitch", "duration_length",
  "optional_notemode_duration", "steno_duration", "multiplied_duration",
  "fraction", "dots", "tremolo_type", "bass_number", "bass_mod",
  "bass_figure", "br_bass_figure", "figure_list", "figure_spec",
  "optional_rest", "simple_element", "lyric_element", "new_chord",
  "chord_items", "chord_separator", "chord_item", "step_numbers",
  "step_number", "number_expression", "number_term", "number_factor",
  "bare_number", "bare_unsigned", "exclamations", "questions",
  "lyric_markup", "@5", "full_markup", "@6", "markup_top", "markup_list",
  "markup_composed_list", "markup_braced_list", "markup_braced_list_body",
  "markup_head_1_item", "markup_head_1_list", "simple_markup", "@7",
  "markup", 0
};
#endif

/* INFRINGES ON USER NAME SPACE */
#ifndef _
# define _(msgid) msgid
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,    45,
      43,   394,   123,   125,    61,    46,    60,    62,   124,    91,
      93,   126,    40,    41,    39,    44,    94,    95,    42,    47,
      58,    33,    63
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   163,   164,   164,   164,   164,   164,   165,   166,   166,
     166,   166,   166,   166,   166,   167,   168,   168,   169,   169,
     170,   171,   171,   172,   172,   173,   173,   173,   173,   173,
     173,   173,   173,   173,   173,   174,   175,   175,   175,   175,
     176,   177,   177,   177,   177,   177,   177,   177,   178,   179,
     179,   179,   179,   179,   179,   180,   181,   182,   182,   182,
     183,   183,   183,   183,   183,   183,   184,   185,   185,   185,
     185,   186,   186,   187,   187,   188,   189,   189,   190,   190,
     191,   191,   191,   191,   192,   193,   192,   194,   194,   195,
     195,   196,   196,   197,   197,   197,   197,   197,   197,   197,
     197,   197,   197,   197,   197,   197,   198,   199,   199,   199,
     199,   199,   199,   199,   199,   199,   199,   199,   199,   200,
     200,   200,   200,   200,   201,   201,   201,   201,   202,   202,
     204,   203,   205,   203,   206,   207,   206,   208,   209,   209,
     209,   209,   210,   210,   210,   210,   210,   210,   210,   210,
     210,   211,   211,   212,   212,   213,   213,   213,   213,   213,
     214,   214,   214,   215,   215,   215,   216,   216,   216,   216,
     216,   216,   217,   218,   218,   218,   219,   220,   221,   222,
     223,   224,   225,   225,   226,   226,   227,   228,   228,   228,
     228,   228,   228,   228,   228,   228,   228,   228,   228,   228,
     229,   229,   229,   229,   229,   230,   230,   230,   231,   232,
     232,   232,   232,   232,   232,   233,   234,   234,   234,   234,
     234,   234,   234,   234,   234,   234,   235,   235,   235,   236,
     236,   237,   237,   237,   237,   238,   238,   239,   239,   240,
     240,   240,   241,   241,   241,   242,   243,   243,   244,   244,
     244,   245,   245,   245,   245,   245,   245,   245,   246,   246,
     246,   247,   248,   249,   249,   250,   250,   251,   251,   251,
     252,   252,   253,   253,   254,   254,   255,   255,   255,   255,
     256,   256,   256,   257,   257,   257,   257,   258,   258,   259,
     259,   260,   261,   261,   262,   262,   262,   262,   262,   262,
     262,   263,   263,   264,   264,   265,   265,   266,   266,   266,
     266,   267,   267,   267,   268,   268,   269,   269,   269,   270,
     270,   270,   271,   271,   271,   272,   272,   273,   273,   273,
     273,   273,   274,   274,   275,   275,   276,   276,   277,   278,
     277,   279,   280,   279,   281,   281,   281,   282,   282,   283,
     284,   285,   285,   285,   286,   286,   286,   287,   287,   288,
     288,   288,   288,   289,   288,   288,   288,   288,   288,   288,
     288,   290,   290
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     2,     2,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     2,
       4,     1,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     0,     1,     3,     2,
       4,     0,     2,     2,     2,     2,     2,     2,     4,     1,
       1,     2,     2,     2,     2,     1,     2,     1,     1,     1,
       2,     3,     2,     2,     2,     2,     4,     0,     2,     2,
       2,     1,     1,     0,     4,     5,     4,     3,     4,     3,
       1,     1,     1,     1,     0,     0,     5,     0,     2,     1,
       1,     1,     1,     1,     2,     2,     2,     3,     3,     4,
       4,     3,     3,     3,     4,     4,     1,     1,     6,     4,
       4,     3,     1,     4,     2,     3,     1,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     2,
       0,     3,     0,     4,     2,     0,     4,     4,     3,     2,
       5,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     3,     5,     3,     4,     2,     2,
       1,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     3,     1,     1,     3,     1,     1,     1,
       1,     3,     0,     2,     5,     2,     3,     1,     2,     2,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     2,
       1,     2,     1,     2,     3,     0,     2,     2,     4,     1,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     2,     2,     1,     2,     1,     2,     1,
       2,     2,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     2,     2,     1,     3,     3,
       1,     3,     0,     2,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     2,     0,
       2,     3,     0,     1,     6,     2,     2,     2,     2,     2,
       1,     1,     1,     2,     4,     0,     2,     1,     1,     2,
       2,     1,     1,     1,     1,     3,     1,     2,     2,     3,
       3,     1,     1,     3,     3,     2,     1,     1,     1,     1,
       2,     2,     1,     1,     0,     2,     0,     2,     1,     0,
       3,     1,     0,     3,     1,     2,     1,     1,     1,     2,
       3,     0,     2,     2,     1,     2,     3,     1,     2,     1,
       1,     1,     1,     0,     5,     2,     4,     3,     1,     2,
       3,     2,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       2,     0,     1,     5,     0,     0,   122,   126,     0,   120,
     124,   121,   125,     0,     6,    59,   123,   127,     0,   342,
      58,   119,    57,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   179,    16,    22,   341,    93,     0,     0,     0,
       0,   172,   172,     0,     0,     0,     0,     0,     0,    17,
      21,    67,     3,    12,    24,     8,     0,     4,    10,    11,
      14,     0,     0,   112,    92,    91,    15,    90,   106,   107,
      89,     0,    84,   116,   117,    67,     9,    13,   160,   161,
     172,    41,   164,   163,   165,    84,    18,   135,     0,   239,
     129,   261,   172,     0,   172,    67,    67,   172,     0,   270,
     172,   242,   245,   247,   246,     0,    84,    95,     0,   172,
     172,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   192,   190,   191,
     200,    81,   177,   193,   202,    96,    71,    72,    83,    82,
       0,    80,   175,   182,   263,   174,   187,   172,    94,   172,
     172,     0,     0,     0,     0,   172,    60,    65,     0,    56,
      62,    63,    64,   130,   134,   114,    85,     0,     0,     0,
     186,     0,     0,   172,     0,   172,   363,   361,   368,     0,
     354,     0,     0,     0,     0,     0,     0,   360,   359,   362,
     351,   343,   344,   347,   348,   357,     0,   346,   235,   237,
     240,   241,   128,   333,   332,   172,    50,     0,    49,     0,
       0,   118,     0,   111,   243,   244,   172,   172,   102,   101,
     172,   195,     0,   197,   203,     0,   201,   171,   327,   167,
     329,   328,   169,   166,   199,   168,   170,   189,   159,     0,
     153,   272,   196,   267,   262,   272,     0,     0,   188,     0,
     194,   158,   198,   289,   339,   263,   263,   302,   338,   263,
     263,   334,   263,   205,   263,   300,   301,     0,   205,   264,
     103,    97,   172,    98,   172,     0,    70,    77,    69,    68,
       0,   224,   223,   221,   222,   225,   211,   210,    34,   215,
     227,   260,   216,   217,   218,   219,   220,   259,   258,   274,
      32,    23,    27,    25,    26,    28,    31,    29,   214,   226,
     209,     0,   228,    30,   321,   322,   326,    33,    61,    36,
       0,   132,     0,   115,   180,    79,   162,    46,     0,    40,
      47,    45,    43,    42,    55,    44,    84,   109,    20,    19,
     136,     0,   369,     0,     0,   372,     0,   365,   355,     0,
       0,     0,     0,   349,   358,   345,   236,   238,    73,    54,
      48,    51,    52,    53,    76,    78,   271,   113,   110,   105,
       0,   204,   331,   330,     0,     0,   266,     0,   265,   156,
       0,     0,     0,     0,   298,   295,   297,   303,   336,   296,
     173,   299,   205,   178,   181,   183,   334,   176,   104,   100,
      99,     0,   325,   275,   250,   253,   252,   256,   255,   254,
     251,   257,   249,   213,   212,   229,   230,   248,     0,     0,
       0,     0,    37,     0,   131,     0,    87,     7,   172,   172,
     371,   370,   367,   356,     0,   350,   353,     0,   352,     0,
      75,   137,     0,   154,   273,   269,   268,   157,    66,   291,
     283,   276,   277,   278,     0,   284,   287,   290,   279,   340,
       0,   308,   307,     0,   305,   335,   231,   260,   207,   206,
     185,   336,   320,   319,   323,   324,   144,   147,   142,   145,
     146,   149,     0,   150,     0,   143,     0,   148,     0,     0,
      35,   151,     0,    39,   133,     0,   108,     0,   366,    67,
     155,   288,   280,   281,   285,   282,   286,   310,   309,   304,
     232,   337,   263,     0,   231,    38,     0,     0,   139,     0,
     152,    86,    88,   364,     0,   313,   311,   306,   312,   314,
     316,   234,   233,   292,     0,   205,     0,   141,   138,    74,
       0,   318,   317,   293,   294,   260,   208,   184,     0,   315,
     140
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,     1,   361,    52,    53,   278,   174,   362,    56,    57,
     301,   161,   423,    58,   171,    59,   207,   333,   363,    61,
      62,   134,   154,   279,   440,    63,    64,    65,   136,   167,
     322,   495,   137,    67,    68,    69,    70,    71,    72,    73,
     164,   320,   425,    74,   175,   138,   491,   492,   493,   239,
     139,   233,   240,   234,   140,   141,   142,   143,   394,    75,
     325,   144,   267,   395,    76,   145,   146,   390,   468,   469,
     308,   309,   310,   414,   512,   200,   201,   102,   103,   104,
     105,   415,   416,   311,    92,   242,   268,   243,   269,   100,
     376,   312,   455,   506,   456,   457,   382,   262,   544,   263,
     264,   265,   509,   464,   527,   528,   529,   313,   314,   315,
     316,   245,   388,   466,   266,   383,   236,    88,   191,   192,
     193,   194,   352,   195,   196,   345,   341,   346
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -328
static const short int yypact[] =
{
    -328,  1359,  -328,  -328,  -101,   -64,  -328,  -328,    60,  -328,
    -328,  -328,  -328,   -49,  -328,  -328,  -328,  -328,    60,  -328,
    -328,  -328,  -328,  1891,    60,   -43,   -26,   -11,   -57,   -18,
     -48,    60,  -328,  -328,  -328,  -328,  -328,    -3,    -3,    -3,
      -3,  1764,  1764,   -57,   -57,   -57,   -57,   -57,   -57,  -328,
    -328,  -328,  -328,  -328,  -328,  -328,     5,  -328,  -328,  -328,
    -328,    11,    67,  -328,  -328,  -328,  -328,   103,  -328,  -328,
    -328,    21,    79,  -328,  -328,  -328,  -328,  -328,  -328,  -328,
    1490,  -328,  -328,  -328,  -328,    -8,  -328,  -328,   366,     6,
    -328,  -328,  1764,    87,  1627,  -328,  -328,  1764,    15,  -328,
    1764,     6,  -328,  -328,  -328,   -48,    79,  -328,    -3,  1764,
    1764,    20,    22,    28,    30,   194,    48,   319,    60,    35,
      60,    60,    35,    35,    48,    60,   -18,  -328,  -328,  -328,
    -328,  -328,  -328,  -328,  -328,  -328,  -328,  -328,  -328,  -328,
     666,  -328,  -328,  -328,    35,  -328,  -328,  1764,  -328,  1764,
    1764,   -57,   -57,   -57,   663,   510,    58,  -328,    52,  -328,
    -328,  -328,  -328,  -328,   202,  -328,  -328,    21,   802,  -101,
    -328,    94,    60,  1764,   179,  1764,  -328,  -328,  -328,   -20,
    -328,  1328,   -57,   -57,   -57,   -57,   -57,  -328,  -328,  -328,
    -328,  -328,  -328,  -328,  -328,  -328,   366,  -328,  -328,  -328,
      44,    54,  -328,  -328,  -328,  1764,  -328,    70,  -328,   941,
    1080,  -328,   124,  -328,    44,    54,  1764,  1764,  -328,  -328,
    1764,  -328,    96,  -328,  -328,   105,  -328,  -328,   113,  -328,
    -328,   116,  -328,   115,  -328,  -328,  -328,  -328,  -328,   -57,
     111,  -328,  -328,  -328,   107,  -328,   -57,   119,  -328,   123,
    -328,  -328,  -328,  -328,  -328,    35,    35,  -328,  -328,    35,
      35,  -328,    35,  -328,    35,  -328,  -328,   -35,  -328,   107,
    -328,  -328,  1764,  -328,  1764,   -57,  -328,  -328,  -328,  -328,
     117,  -328,  -328,  -328,  -328,  -328,  -328,  -328,  -328,  -328,
    -328,   -34,  -328,  -328,  -328,  -328,  -328,  -328,  -328,    87,
    -328,  -328,  -328,  -328,  -328,  -328,   115,  -328,  -328,  -328,
    -328,  1820,  -328,    85,  -328,    68,  -328,  -328,  -328,   171,
      21,  -328,   128,  -328,  -328,  -328,  -328,  -328,   141,  -328,
    -328,  -328,  -328,  -328,  -328,  -328,    79,  -328,  -328,  -328,
    -328,   138,  -328,   -20,  1328,  -328,  1328,  -328,  -328,   -57,
     -57,   -57,   352,  -328,  -328,  -328,  -328,  -328,   270,  -328,
    -328,  -328,  -328,  -328,  -328,  -328,  -328,  -328,  -328,  -328,
     147,  -328,  -328,  -328,   144,    60,   148,    47,   148,  -328,
     302,    87,   271,   366,  -328,  -328,  -328,   182,   131,  -328,
    1908,  -328,  -328,  -328,  -328,  -328,  -328,  1908,  -328,  -328,
    -328,   -28,  -328,  -328,  -328,  -328,  -328,  -328,  -328,  -328,
    -328,  -328,   115,  -328,  -328,  -328,  -328,  -328,   -28,   -28,
     -28,   -28,  -328,   215,  -328,    21,  -328,  -328,  1764,  1627,
    -328,  -328,  -328,  -328,   -57,  -328,  -328,   366,  -328,   152,
    -328,  -328,   302,  -328,  -328,  -328,  -328,  -328,  -328,  -328,
    -328,  -328,  -328,  -328,   137,  -328,   177,  -328,  -328,  -328,
     157,  -328,  -328,   157,  -328,  -328,   -75,   242,  -328,  -328,
    1908,   131,  -328,  -328,  -328,  -328,  -328,  -328,  -328,  -328,
    -328,  -328,   -57,  -328,    60,  -328,    60,  -328,    60,   154,
    -328,  -328,   164,  -328,  -328,   283,  -328,   175,  -328,  -328,
    -328,   177,  -328,  -328,  -328,  -328,  -328,  -328,  -328,   552,
       6,  -328,    35,   -57,   -75,  -328,   -57,   -57,  -328,   302,
    -328,  -328,  -328,  -328,  1219,  -328,  -328,  -328,   156,  -328,
     -37,    44,    54,   261,  1946,  -328,   166,  -328,  -328,  -328,
      87,  -328,  -328,  -328,  -328,  -328,  -328,  1908,   -57,  -328,
    -328
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -328,  -328,   143,  -328,  -328,    -1,  -328,    24,  -328,   -32,
    -328,   168,  -328,  -328,  -328,   -70,  -117,  -328,    33,  -328,
    -328,   257,   -72,   -30,  -328,  -328,  -328,  -328,  -328,   -65,
    -328,  -328,    65,   -62,  -328,  -328,  -328,  -328,  -328,  -328,
    -328,  -328,  -328,  -328,  -328,  -328,  -328,  -328,  -160,    95,
     222,    10,    -2,  -327,  -328,  -328,  -328,  -328,  -328,  -328,
    -328,  -328,  -328,  -328,  -328,  -328,  -328,  -253,  -328,  -147,
    -328,  -328,    29,  -328,  -173,   -97,   -96,   322,  -127,   -67,
     237,  -328,  -328,  -328,  -328,   224,  -204,   229,    13,   221,
     108,  -328,  -328,  -328,   -99,  -328,  -328,  -328,  -328,  -328,
    -328,  -328,  -328,  -152,  -328,  -328,  -174,  -328,  -186,  -274,
    -108,   -91,   -31,  -104,  -328,  -328,     0,  -328,   -14,  -161,
    -328,  -175,  -328,  -177,  -153,   -78,  -328,  -270
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -173
static const short int yytable[] =
{
      54,    77,   205,   168,   214,   215,    85,   235,   307,   165,
     197,   135,   147,   260,    80,   397,    87,   402,   342,   354,
     173,   353,    93,   209,   210,    55,   343,    97,   344,   106,
     160,   541,    19,    33,    60,    78,    79,   107,   108,   109,
     110,   217,   148,   149,   150,   151,   152,   153,   224,   237,
     170,   384,   385,   447,   166,   386,   387,   250,   389,   228,
     391,    54,   202,   392,   208,   228,    66,   211,   157,   510,
     213,   359,    26,   261,    27,    98,   431,    49,    81,   219,
     220,    89,   438,    99,   158,   303,   180,   511,    90,   183,
     101,   185,    32,    86,    89,   327,   230,    13,   231,    94,
      15,   332,   230,   542,   231,   323,    20,   163,   218,   328,
      35,   401,   393,    22,   232,   500,    95,   270,   355,   271,
     272,    13,   190,   123,    15,   305,   203,   402,   204,    19,
      20,    96,   244,   328,   241,   244,   172,    22,   203,   470,
     204,   166,   339,   337,    25,   340,   474,   475,   445,   155,
     273,   274,   275,   156,   300,   317,   221,    33,   222,   225,
     198,   199,    82,    51,   223,   306,   354,   354,   353,    34,
     336,   335,    19,    54,   212,   358,   359,    89,   203,   326,
     204,   347,   348,   349,   350,   351,   367,   368,   304,   318,
     369,   436,   538,   344,   319,   331,    83,    84,   356,   437,
     396,    49,    13,    50,   334,    15,   321,    35,   403,   357,
     159,    20,   226,   360,   328,   246,   247,   366,    22,    82,
     251,   476,   450,   477,   418,   419,   420,   421,   451,    19,
     452,   478,   472,   473,   479,   480,   481,   329,   374,   371,
     370,   482,   398,   372,   399,   379,   373,   460,   461,   462,
      35,   463,   483,    83,    84,   169,   375,   484,   424,   319,
     354,   485,   353,   380,   486,   377,   430,   381,   422,    33,
     426,   428,   235,   453,   400,   487,   488,   427,    85,   439,
     429,    34,   547,   441,    33,   227,   446,   228,   442,   476,
     448,   477,   465,   444,   499,   101,   229,   513,   519,   478,
     520,   540,   479,   480,   481,   197,    19,    35,   533,   543,
     548,   417,   497,    49,   330,    50,   502,   503,   523,   162,
     483,   412,   338,   302,   230,   484,   231,   504,    49,   485,
      78,    79,   486,   507,   235,   522,   508,    19,   505,   238,
     413,   535,   216,   487,   488,    91,   248,   252,   432,   433,
     434,   489,   249,   378,   449,   501,   450,   526,   490,   430,
     117,   118,   451,   494,   452,   471,   549,   514,   120,   459,
       0,   121,     0,   443,     0,     0,     0,     0,     0,   232,
     125,     0,   458,     0,    35,     0,     0,   546,     0,     0,
       0,     0,    33,   227,     0,   228,     0,     0,   496,   208,
       0,     0,   176,     0,   229,     0,     0,   453,     0,     0,
       0,   235,     0,   531,   532,    35,   176,     0,   530,   489,
     454,     0,     0,     0,     0,     0,   521,   524,     0,     0,
       0,     0,   230,   498,   231,     0,    49,     0,    78,    79,
       0,   232,     0,     0,     0,     0,     0,     0,     0,   530,
       0,     0,     0,     0,   458,   177,   178,   179,   180,   181,
     182,   183,   184,   185,   186,   187,     0,     0,     0,   177,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
       0,   515,   516,     0,   517,     0,   518,     0,   188,   189,
       0,     0,     0,     0,   190,   435,     0,     0,     0,     0,
       0,     0,   188,   189,     0,     0,     0,     0,   190,     0,
       0,     0,   534,     0,     0,   536,   537,     0,   232,     0,
     111,     0,   112,     6,     7,   113,     0,   280,     0,     0,
       0,     0,     9,    10,    11,    12,     0,     0,     0,   114,
      15,    16,    17,    18,   115,    19,    20,   550,    21,     0,
     116,   117,   118,    22,   119,    23,     0,    24,     0,   120,
      25,    26,   121,    27,   122,    28,   123,    29,    30,   124,
       0,   125,     0,   126,    31,     0,     0,     0,     0,     0,
       0,    32,   127,   281,     0,   282,   283,   128,   284,   129,
     285,   130,   286,     0,     0,     0,   287,     0,     0,     0,
      33,   288,   289,   228,     0,     0,     0,     0,     0,     0,
     290,     0,     0,     0,     0,     0,     0,   460,   461,   462,
       0,   463,     0,    35,    36,    37,    38,     0,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,   131,     0,
     230,     0,   231,   203,    49,   204,    78,    79,   525,   291,
       0,     0,    51,     0,     0,     0,   132,     0,   133,   292,
     293,   294,   295,   296,   276,     0,   297,   298,     0,     0,
     299,     0,     0,   111,     0,   112,     6,     7,   113,     0,
       8,     0,     0,     0,     0,     9,    10,    11,    12,     0,
       0,     0,   114,     0,    16,    17,    18,   115,     0,     0,
       0,    21,     0,   116,   117,   118,     0,   119,    23,     0,
      24,     0,   120,     0,    26,   121,    27,   122,    28,   123,
      29,    30,   124,     0,   125,     0,   126,    31,     0,     0,
       0,     0,     0,     0,    32,   127,     0,     0,     0,     0,
     128,     0,   129,     0,   130,     0,     0,  -172,     0,     0,
     253,  -172,  -172,    33,   254,   255,     0,     0,     0,     0,
       0,  -172,     0,     0,   256,  -172,  -172,     0,   257,   258,
       0,     0,     0,     0,     0,     0,     0,    36,    37,    38,
       0,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,   131,  -172,     0,     0,    89,  -172,    49,     0,   259,
       0,  -172,     0,   276,   101,    51,   277,     0,     0,   132,
       0,   133,   111,     0,   112,     6,     7,   113,     0,     8,
       0,     0,     0,     0,     9,    10,    11,    12,     0,     0,
       0,   114,     0,    16,    17,    18,   115,     0,     0,     0,
      21,     0,   116,   117,   118,     0,   119,    23,     0,    24,
       0,   120,     0,    26,   121,    27,   122,    28,   123,    29,
      30,   124,     0,   125,     0,   126,    31,     0,     0,     0,
       0,     0,   324,    32,   127,     0,     0,     0,     0,   128,
       0,   129,     0,   130,     0,     0,  -172,     0,     0,     0,
    -172,  -172,    33,     0,     0,     0,     0,     0,     0,     0,
    -172,     0,     0,     0,  -172,  -172,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    36,    37,    38,     0,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
     131,  -172,     0,     0,     0,  -172,    49,     0,     0,     0,
    -172,     0,   276,     0,    51,     0,     0,     0,   132,     0,
     133,   111,     0,   112,     6,     7,   113,     0,     8,     0,
       0,     0,     0,     9,    10,    11,    12,     0,     0,     0,
     114,     0,    16,    17,    18,   115,     0,     0,     0,    21,
       0,   116,   117,   118,     0,   119,    23,     0,    24,     0,
     120,     0,    26,   121,    27,   122,    28,   123,    29,    30,
     124,     0,   125,     0,   126,    31,     0,     0,     0,     0,
       0,     0,    32,   127,     0,     0,     0,     0,   128,     0,
     129,     0,   130,     0,     0,  -172,     0,     0,     0,  -172,
    -172,    33,     0,     0,     0,     0,     0,     0,     0,  -172,
       0,     0,     0,  -172,  -172,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,    37,    38,     0,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,   131,
    -172,     0,     0,     0,  -172,    49,     0,     0,     0,  -172,
       0,   276,     0,    51,   364,     0,     0,   132,     0,   133,
     111,     0,   112,     6,     7,   113,     0,     8,     0,     0,
       0,     0,     9,    10,    11,    12,     0,     0,     0,   114,
       0,    16,    17,    18,   115,     0,     0,     0,    21,     0,
     116,   117,   118,     0,   119,    23,     0,    24,     0,   120,
       0,    26,   121,    27,   122,    28,   123,    29,    30,   124,
       0,   125,     0,   126,    31,     0,     0,     0,     0,     0,
       0,    32,   127,     0,     0,     0,     0,   128,     0,   129,
       0,   130,     0,     0,  -172,     0,     0,     0,  -172,  -172,
      33,     0,     0,     0,     0,     0,     0,     0,  -172,     0,
       0,     0,  -172,  -172,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    36,    37,    38,     0,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,   131,  -172,
       0,     0,     0,  -172,    49,     0,     0,     0,  -172,     0,
     276,     0,    51,   365,     0,     0,   132,     0,   133,   111,
       0,   112,     6,     7,   113,     0,     8,     0,     0,     0,
       0,     9,    10,    11,    12,     0,     0,     0,   114,     0,
      16,    17,    18,   115,     0,     0,     0,    21,     0,   116,
     117,   118,     0,   119,    23,     0,    24,     0,   120,     0,
      26,   121,    27,   122,    28,   123,    29,    30,   124,     0,
     125,     0,   126,    31,     0,     0,     0,     0,     0,     0,
      32,   127,     0,     0,     0,     0,   128,     0,   129,     0,
     130,     0,     0,  -172,     0,     0,     0,  -172,  -172,    33,
       0,     0,     0,     0,     0,     0,     0,  -172,     0,     0,
       0,  -172,  -172,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    36,    37,    38,     0,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,   131,  -172,     0,
       0,     0,  -172,    49,     0,     0,     0,  -172,     0,     2,
       3,    51,   539,     0,     0,   132,     4,   133,     0,     0,
       5,     0,     6,     7,     0,     0,     8,     0,   176,     0,
       0,     9,    10,    11,    12,     0,    13,    14,     0,    15,
      16,    17,    18,     0,    19,    20,     0,    21,     0,     0,
       0,     0,    22,     0,    23,     0,    24,     0,     0,    25,
      26,     0,    27,     0,    28,     0,    29,    30,     0,     0,
       0,     0,     0,    31,     0,     0,     0,     0,     0,     0,
      32,   177,   178,   179,   180,   181,   182,   183,   184,   185,
     186,   187,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    34,     0,     0,   188,   189,     0,     0,     0,     0,
       0,     0,    35,    36,    37,    38,     0,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,     0,     0,     0,
       0,     0,     0,    49,     0,    50,     0,     0,     0,     0,
     111,    51,   112,     6,     7,   113,     0,     8,     0,     0,
       0,     0,     9,    10,    11,    12,     0,     0,     0,   114,
       0,    16,    17,    18,   115,     0,     0,     0,    21,     0,
     116,   117,   118,     0,   119,    23,     0,    24,     0,   120,
       0,    26,   121,    27,   122,    28,   123,    29,    30,   124,
       0,   125,     0,   126,    31,     0,     0,     0,     0,     0,
       0,    32,   127,     0,     0,     0,     0,   128,     0,   129,
       0,   130,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    36,    37,    38,     0,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,   131,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     169,     0,    51,     0,     0,     0,   132,   111,   133,   112,
       6,     7,   113,     0,     8,     0,     0,     0,     0,     9,
      10,    11,    12,     0,     0,     0,   114,     0,    16,    17,
      18,   115,     0,     0,     0,    21,     0,   116,   117,   118,
       0,   119,    23,     0,    24,     0,   120,     0,    26,   121,
      27,   122,    28,   123,    29,    30,   124,     0,   125,     0,
     126,    31,     0,     0,     0,     0,     0,     0,    32,   127,
       0,     0,     0,     0,   128,     0,   129,     0,   130,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    36,    37,    38,     0,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,   131,     0,     0,     0,     0,
       0,     0,   206,     0,     0,     0,     0,     0,     0,    51,
       0,     0,     0,   132,   111,   133,   112,     6,     7,   113,
       0,     8,     0,     0,     0,     0,     9,    10,    11,    12,
       0,     0,     0,   114,     0,    16,    17,    18,   115,     0,
       0,     0,    21,     0,   116,   117,   118,     0,   119,    23,
       0,    24,     0,   120,     0,    26,   121,    27,   122,    28,
     123,    29,    30,   124,     0,   125,     0,   126,    31,     0,
       0,     0,     0,     0,     0,    32,   127,     0,     0,     0,
       0,   128,     0,   129,     0,   130,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    19,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,    37,
      38,     0,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,   131,   281,     0,   282,   283,     0,   284,     0,
     285,     0,     0,     0,     6,     7,    51,     0,     8,     0,
     132,   404,   133,     9,    10,    11,    12,     0,     0,     0,
     290,     0,    16,    17,    18,     0,     0,     0,     0,    21,
       0,     0,     0,    35,     0,     0,    23,     0,    24,     0,
       0,     0,    26,     0,    27,     0,    28,     0,    29,    30,
       0,     0,     0,     0,     0,    31,    78,    79,     0,   405,
     406,     0,    32,     0,     0,   407,     0,   408,   409,   292,
     293,   294,   295,   296,     0,     0,   410,   411,     0,     0,
     299,   281,     0,   282,   283,     0,   284,     0,   285,     0,
     286,     0,     0,     0,   287,     0,     0,     0,     0,     0,
     289,     0,     0,     0,     0,    36,    37,    38,   290,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,   281,
      89,   282,   283,     0,   284,     0,   285,     0,   286,     0,
       0,     0,   287,    51,     0,     0,     0,     0,   289,     0,
       0,     0,     0,     0,     0,     0,   290,   467,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   292,   293,   294,
     295,   296,     0,     0,   297,   298,     0,     0,   299,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   545,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   292,   293,   294,   295,   296,
       0,     0,   297,   298,     0,     0,   299
};

static const short int yycheck[] =
{
       1,     1,    93,    75,   101,   101,     8,   115,   155,    71,
      88,    41,    42,   140,     4,   268,    18,   291,   179,   196,
      85,   196,    24,    95,    96,     1,   179,    28,   181,    31,
      62,    68,    35,    90,     1,   136,   137,    37,    38,    39,
      40,   106,    43,    44,    45,    46,    47,    48,    18,   116,
      80,   255,   256,   380,    62,   259,   260,   124,   262,    93,
     264,    62,    92,    98,    94,    93,     1,    97,     1,   144,
     100,     1,    51,   140,    53,    93,   346,   134,   142,   109,
     110,   129,   352,   101,    17,   155,   106,   162,    23,   109,
     138,   111,    71,   142,   129,     1,   130,    27,   132,   142,
      30,   171,   130,   140,   132,   167,    36,     4,   108,    39,
     113,   139,   147,    43,   115,   442,   142,   147,   196,   149,
     150,    27,   142,    56,    30,   155,    91,   401,    93,    35,
      36,   142,   119,    39,    99,   122,   144,    43,    91,   392,
      93,    62,   174,   173,    50,   175,   420,   421,   101,   144,
     151,   152,   153,   142,   155,   155,   136,    90,   136,   129,
     154,   155,   102,   142,   136,   155,   343,   344,   343,   102,
     172,   171,    35,   174,   159,   205,     1,   129,    91,   169,
      93,   182,   183,   184,   185,   186,   216,   217,   155,   131,
     220,   352,   519,   346,   142,   171,   136,   137,   154,   352,
     267,   134,    27,   136,   171,    30,     4,   113,   299,   155,
     143,    36,    18,   143,    39,   120,   121,    93,    43,   102,
     125,     6,    85,     8,   139,   140,   158,   159,    91,    35,
      93,    16,   418,   419,    19,    20,    21,   143,   239,   134,
     144,    26,   272,   130,   274,   246,   130,    65,    66,    67,
     113,    69,    37,   136,   137,   140,   145,    42,   320,   142,
     437,    46,   437,   144,    49,   158,   344,   144,    97,    90,
     142,   336,   380,   136,   275,    60,    61,   136,   280,     9,
     142,   102,   535,   136,    90,    91,   377,    93,   144,     6,
     381,     8,   161,   145,   142,   138,   102,    55,   144,    16,
     136,   145,    19,    20,    21,   383,    35,   113,   512,    48,
     144,   311,   429,   134,   171,   136,   139,   140,   143,    62,
      37,   311,   143,   155,   130,    42,   132,   150,   134,    46,
     136,   137,    49,   460,   442,   495,   463,    35,   161,   117,
     311,   514,   105,    60,    61,    23,   122,   126,   349,   350,
     351,   136,   123,   245,    83,   454,    85,   509,   143,   437,
      41,    42,    91,   425,    93,   396,   540,   471,    49,   383,
      -1,    52,    -1,   375,    -1,    -1,    -1,    -1,    -1,   380,
      61,    -1,   382,    -1,   113,    -1,    -1,   534,    -1,    -1,
      -1,    -1,    90,    91,    -1,    93,    -1,    -1,   428,   429,
      -1,    -1,    50,    -1,   102,    -1,    -1,   136,    -1,    -1,
      -1,   519,    -1,   510,   510,   113,    50,    -1,   509,   136,
     149,    -1,    -1,    -1,    -1,    -1,   143,   499,    -1,    -1,
      -1,    -1,   130,   434,   132,    -1,   134,    -1,   136,   137,
      -1,   442,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   540,
      -1,    -1,    -1,    -1,   454,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,    -1,    -1,    -1,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
      -1,   482,   484,    -1,   486,    -1,   488,    -1,   136,   137,
      -1,    -1,    -1,    -1,   142,   143,    -1,    -1,    -1,    -1,
      -1,    -1,   136,   137,    -1,    -1,    -1,    -1,   142,    -1,
      -1,    -1,   513,    -1,    -1,   516,   517,    -1,   519,    -1,
      10,    -1,    12,    13,    14,    15,    -1,    17,    -1,    -1,
      -1,    -1,    22,    23,    24,    25,    -1,    -1,    -1,    29,
      30,    31,    32,    33,    34,    35,    36,   548,    38,    -1,
      40,    41,    42,    43,    44,    45,    -1,    47,    -1,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    61,    -1,    63,    64,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    72,    73,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      90,    91,    92,    93,    -1,    -1,    -1,    -1,    -1,    -1,
     100,    -1,    -1,    -1,    -1,    -1,    -1,    65,    66,    67,
      -1,    69,    -1,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,    -1,
     130,    -1,   132,    91,   134,    93,   136,   137,    96,   139,
      -1,    -1,   142,    -1,    -1,    -1,   146,    -1,   148,   149,
     150,   151,   152,   153,     1,    -1,   156,   157,    -1,    -1,
     160,    -1,    -1,    10,    -1,    12,    13,    14,    15,    -1,
      17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,    -1,
      -1,    -1,    29,    -1,    31,    32,    33,    34,    -1,    -1,
      -1,    38,    -1,    40,    41,    42,    -1,    44,    45,    -1,
      47,    -1,    49,    -1,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    -1,    61,    -1,    63,    64,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    72,    -1,    -1,    -1,    -1,
      77,    -1,    79,    -1,    81,    -1,    -1,    84,    -1,    -1,
      84,    88,    89,    90,    88,    89,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,    98,   102,   103,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   114,   115,   116,
      -1,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,    -1,    -1,   129,   133,   134,    -1,   133,
      -1,   138,    -1,     1,   138,   142,   143,    -1,    -1,   146,
      -1,   148,    10,    -1,    12,    13,    14,    15,    -1,    17,
      -1,    -1,    -1,    -1,    22,    23,    24,    25,    -1,    -1,
      -1,    29,    -1,    31,    32,    33,    34,    -1,    -1,    -1,
      38,    -1,    40,    41,    42,    -1,    44,    45,    -1,    47,
      -1,    49,    -1,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    61,    -1,    63,    64,    -1,    -1,    -1,
      -1,    -1,    70,    71,    72,    -1,    -1,    -1,    -1,    77,
      -1,    79,    -1,    81,    -1,    -1,    84,    -1,    -1,    -1,
      88,    89,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,    -1,    -1,    -1,   133,   134,    -1,    -1,    -1,
     138,    -1,     1,    -1,   142,    -1,    -1,    -1,   146,    -1,
     148,    10,    -1,    12,    13,    14,    15,    -1,    17,    -1,
      -1,    -1,    -1,    22,    23,    24,    25,    -1,    -1,    -1,
      29,    -1,    31,    32,    33,    34,    -1,    -1,    -1,    38,
      -1,    40,    41,    42,    -1,    44,    45,    -1,    47,    -1,
      49,    -1,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    61,    -1,    63,    64,    -1,    -1,    -1,    -1,
      -1,    -1,    71,    72,    -1,    -1,    -1,    -1,    77,    -1,
      79,    -1,    81,    -1,    -1,    84,    -1,    -1,    -1,    88,
      89,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,    -1,    -1,    -1,   133,   134,    -1,    -1,    -1,   138,
      -1,     1,    -1,   142,   143,    -1,    -1,   146,    -1,   148,
      10,    -1,    12,    13,    14,    15,    -1,    17,    -1,    -1,
      -1,    -1,    22,    23,    24,    25,    -1,    -1,    -1,    29,
      -1,    31,    32,    33,    34,    -1,    -1,    -1,    38,    -1,
      40,    41,    42,    -1,    44,    45,    -1,    47,    -1,    49,
      -1,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    61,    -1,    63,    64,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    72,    -1,    -1,    -1,    -1,    77,    -1,    79,
      -1,    81,    -1,    -1,    84,    -1,    -1,    -1,    88,    89,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
      -1,    -1,    -1,   133,   134,    -1,    -1,    -1,   138,    -1,
       1,    -1,   142,   143,    -1,    -1,   146,    -1,   148,    10,
      -1,    12,    13,    14,    15,    -1,    17,    -1,    -1,    -1,
      -1,    22,    23,    24,    25,    -1,    -1,    -1,    29,    -1,
      31,    32,    33,    34,    -1,    -1,    -1,    38,    -1,    40,
      41,    42,    -1,    44,    45,    -1,    47,    -1,    49,    -1,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      61,    -1,    63,    64,    -1,    -1,    -1,    -1,    -1,    -1,
      71,    72,    -1,    -1,    -1,    -1,    77,    -1,    79,    -1,
      81,    -1,    -1,    84,    -1,    -1,    -1,    88,    89,    90,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,    -1,
      -1,    -1,   133,   134,    -1,    -1,    -1,   138,    -1,     0,
       1,   142,   143,    -1,    -1,   146,     7,   148,    -1,    -1,
      11,    -1,    13,    14,    -1,    -1,    17,    -1,    50,    -1,
      -1,    22,    23,    24,    25,    -1,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    36,    -1,    38,    -1,    -1,
      -1,    -1,    43,    -1,    45,    -1,    47,    -1,    -1,    50,
      51,    -1,    53,    -1,    55,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    64,    -1,    -1,    -1,    -1,    -1,    -1,
      71,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   102,    -1,    -1,   136,   137,    -1,    -1,    -1,    -1,
      -1,    -1,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,    -1,    -1,    -1,
      -1,    -1,    -1,   134,    -1,   136,    -1,    -1,    -1,    -1,
      10,   142,    12,    13,    14,    15,    -1,    17,    -1,    -1,
      -1,    -1,    22,    23,    24,    25,    -1,    -1,    -1,    29,
      -1,    31,    32,    33,    34,    -1,    -1,    -1,    38,    -1,
      40,    41,    42,    -1,    44,    45,    -1,    47,    -1,    49,
      -1,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    61,    -1,    63,    64,    -1,    -1,    -1,    -1,    -1,
      -1,    71,    72,    -1,    -1,    -1,    -1,    77,    -1,    79,
      -1,    81,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     140,    -1,   142,    -1,    -1,    -1,   146,    10,   148,    12,
      13,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,    22,
      23,    24,    25,    -1,    -1,    -1,    29,    -1,    31,    32,
      33,    34,    -1,    -1,    -1,    38,    -1,    40,    41,    42,
      -1,    44,    45,    -1,    47,    -1,    49,    -1,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    61,    -1,
      63,    64,    -1,    -1,    -1,    -1,    -1,    -1,    71,    72,
      -1,    -1,    -1,    -1,    77,    -1,    79,    -1,    81,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   114,   115,   116,    -1,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,    -1,    -1,    -1,    -1,
      -1,    -1,   135,    -1,    -1,    -1,    -1,    -1,    -1,   142,
      -1,    -1,    -1,   146,    10,   148,    12,    13,    14,    15,
      -1,    17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,
      -1,    -1,    -1,    29,    -1,    31,    32,    33,    34,    -1,
      -1,    -1,    38,    -1,    40,    41,    42,    -1,    44,    45,
      -1,    47,    -1,    49,    -1,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    61,    -1,    63,    64,    -1,
      -1,    -1,    -1,    -1,    -1,    71,    72,    -1,    -1,    -1,
      -1,    77,    -1,    79,    -1,    81,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   114,   115,
     116,    -1,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,    73,    -1,    75,    76,    -1,    78,    -1,
      80,    -1,    -1,    -1,    13,    14,   142,    -1,    17,    -1,
     146,    91,   148,    22,    23,    24,    25,    -1,    -1,    -1,
     100,    -1,    31,    32,    33,    -1,    -1,    -1,    -1,    38,
      -1,    -1,    -1,   113,    -1,    -1,    45,    -1,    47,    -1,
      -1,    -1,    51,    -1,    53,    -1,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    64,   136,   137,    -1,   139,
     140,    -1,    71,    -1,    -1,   145,    -1,   147,   148,   149,
     150,   151,   152,   153,    -1,    -1,   156,   157,    -1,    -1,
     160,    73,    -1,    75,    76,    -1,    78,    -1,    80,    -1,
      82,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    -1,    -1,   114,   115,   116,   100,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,    73,
     129,    75,    76,    -1,    78,    -1,    80,    -1,    82,    -1,
      -1,    -1,    86,   142,    -1,    -1,    -1,    -1,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   100,   139,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,    -1,    -1,   156,   157,    -1,    -1,   160,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,
      -1,    -1,   156,   157,    -1,    -1,   160
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,   164,     0,     1,     7,    11,    13,    14,    17,    22,
      23,    24,    25,    27,    28,    30,    31,    32,    33,    35,
      36,    38,    43,    45,    47,    50,    51,    53,    55,    57,
      58,    64,    71,    90,   102,   113,   114,   115,   116,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   134,
     136,   142,   166,   167,   168,   170,   171,   172,   176,   178,
     181,   182,   183,   188,   189,   190,   195,   196,   197,   198,
     199,   200,   201,   202,   206,   222,   227,   279,   136,   137,
     214,   142,   102,   136,   137,   215,   142,   215,   280,   129,
     195,   240,   247,   215,   142,   142,   142,   168,    93,   101,
     252,   138,   240,   241,   242,   243,   215,   279,   279,   279,
     279,    10,    12,    15,    29,    34,    40,    41,    42,    44,
      49,    52,    54,    56,    59,    61,    63,    72,    77,    79,
      81,   128,   146,   148,   184,   186,   191,   195,   208,   213,
     217,   218,   219,   220,   224,   228,   229,   186,   168,   168,
     168,   168,   168,   168,   185,   144,   142,     1,    17,   143,
     172,   174,   184,     4,   203,   196,    62,   192,   185,   140,
     186,   177,   144,   192,   169,   207,    50,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   136,   137,
     142,   281,   282,   283,   284,   286,   287,   288,   154,   155,
     238,   239,   186,    91,    93,   274,   135,   179,   186,   185,
     185,   186,   159,   186,   238,   239,   243,   192,   279,   186,
     186,   136,   136,   136,    18,   129,    18,    91,    93,   102,
     130,   132,   168,   214,   216,   273,   279,   242,   213,   212,
     215,    99,   248,   250,   251,   274,   212,   212,   248,   250,
     242,   212,   252,    84,    88,    89,    98,   102,   103,   133,
     241,   242,   260,   262,   263,   264,   277,   225,   249,   251,
     186,   186,   186,   168,   168,   168,     1,   143,   168,   186,
      17,    73,    75,    76,    78,    80,    82,    86,    91,    92,
     100,   139,   149,   150,   151,   152,   153,   156,   157,   160,
     168,   173,   174,   178,   181,   186,   214,   232,   233,   234,
     235,   246,   254,   270,   271,   272,   273,   279,   131,   142,
     204,     4,   193,   196,    70,   223,   214,     1,    39,   143,
     165,   170,   178,   180,   181,   279,   215,   186,   143,   172,
     186,   289,   282,   287,   287,   288,   290,   168,   168,   168,
     168,   168,   285,   284,   286,   288,   154,   155,   186,     1,
     143,   165,   170,   181,   143,   143,    93,   186,   186,   186,
     144,   134,   130,   130,   168,   145,   253,   158,   253,   168,
     144,   144,   259,   278,   249,   249,   249,   249,   275,   249,
     230,   249,    98,   147,   221,   226,   242,   230,   186,   186,
     168,   139,   272,   274,    91,   139,   140,   145,   147,   148,
     156,   157,   214,   235,   236,   244,   245,   279,   139,   140,
     158,   159,    97,   175,   196,   205,   142,   136,   192,   142,
     288,   290,   168,   168,   168,   143,   282,   287,   290,     9,
     187,   136,   144,   215,   145,   101,   274,   216,   274,    83,
      85,    91,    93,   136,   149,   255,   257,   258,   279,   281,
      65,    66,    67,    69,   266,   161,   276,   139,   231,   232,
     230,   275,   271,   271,   272,   272,     6,     8,    16,    19,
      20,    21,    26,    37,    42,    46,    49,    60,    61,   136,
     143,   209,   210,   211,   196,   194,   186,   179,   168,   142,
     216,   257,   139,   140,   150,   161,   256,   241,   241,   265,
     144,   162,   237,    55,   276,   168,   215,   215,   215,   144,
     136,   143,   211,   143,   185,    96,   266,   267,   268,   269,
     274,   238,   239,   249,   168,   237,   168,   168,   216,   143,
     145,    68,   140,    48,   261,   139,   232,   230,   144,   269,
     168
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror (_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, &yylloc, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, &yylloc)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value, Location);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, _("Stack now"));
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, _("Reducing stack by rule %d (line %u), "),
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep, yylocationp)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;
  (void) yylocationp;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  fprintf (yyoutput, ": ");

# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, yylocationp)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;
  (void) yylocationp;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;
/* Location data for the look-ahead symbol.  */
YYLTYPE yylloc;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;

  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
  /* The locations where the error started and ended. */
  YYLTYPE yyerror_range[2];

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
  yylsp = yyls;
#if YYLTYPE_IS_TRIVIAL
  /* Initialize the default location before parsing starts.  */
  yylloc.first_line   = yylloc.last_line   = 1;
  yylloc.first_column = yylloc.last_column = 0;
#endif


  yyvsp[0] = yylval;
    yylsp[0] = yylloc;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;
	YYLTYPE *yyls1 = yyls;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (_("parser stack overflow"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
	YYSTACK_RELOCATE (yyls);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, _("Stack size increased to %lu\n"),
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, _("Entering state %d\n"), yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, _("Reading a token: ")));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, _("Now at end of input.\n")));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT (_("Next token is"), yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT (_("Shifting"), yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
  *++yylsp = yylloc;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, yylsp - yylen, yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:
#line 555 "parser.yy"
    {
	;}
    break;

  case 4:
#line 557 "parser.yy"
    {
	;}
    break;

  case 5:
#line 559 "parser.yy"
    {
		THIS->error_level_ = 1;
	;}
    break;

  case 6:
#line 562 "parser.yy"
    {
		THIS->error_level_ = 1;
	;}
    break;

  case 7:
#line 569 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 8:
#line 573 "parser.yy"
    {
		THIS->lexer_->set_identifier (ly_symbol2scm ("$defaultheader"), (yyvsp[0].scm));
	;}
    break;

  case 9:
#line 576 "parser.yy"
    {
	
	;}
    break;

  case 10:
#line 579 "parser.yy"
    {
		Book *book = (yyvsp[0].book);
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-book-handler");
		scm_call_2 (proc, THIS->self_scm (), book->self_scm ());
		book->unprotect ();
	;}
    break;

  case 11:
#line 585 "parser.yy"
    {
		Score *score = (yyvsp[0].score);
		
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-score-handler");
		scm_call_2 (proc, THIS->self_scm (), score->self_scm ());
		score->unprotect ();
	;}
    break;

  case 12:
#line 592 "parser.yy"
    {
		Music *music = (yyvsp[0].music);
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-music-handler");
		scm_call_2 (proc, THIS->self_scm (), music->self_scm ());
		music->unprotect (); 
	;}
    break;

  case 13:
#line 598 "parser.yy"
    {
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-text-handler");
		scm_call_2 (proc, THIS->self_scm (), (yyvsp[0].scm));
	;}
    break;

  case 14:
#line 602 "parser.yy"
    {
		SCM id = SCM_EOL;
		Output_def * od = (yyvsp[0].outputdef);

		if ((yyvsp[0].outputdef)->c_variable ("is-paper") == SCM_BOOL_T)
			id = ly_symbol2scm ("$defaultpaper");
		else if ((yyvsp[0].outputdef)->c_variable ("is-midi") == SCM_BOOL_T)
			id = ly_symbol2scm ("$defaultmidi");
		else if ((yyvsp[0].outputdef)->c_variable ("is-layout") == SCM_BOOL_T)
			id = ly_symbol2scm ("$defaultlayout");

		THIS->lexer_->set_identifier (id, od->self_scm ());
		od->unprotect();
	;}
    break;

  case 15:
#line 619 "parser.yy"
    {
	;}
    break;

  case 18:
#line 630 "parser.yy"
    {
		(yyval.scm) = get_header(THIS);
		THIS->lexer_->add_scope ((yyval.scm));
	;}
    break;

  case 19:
#line 634 "parser.yy"
    {
		
	;}
    break;

  case 20:
#line 640 "parser.yy"
    {
		(yyval.scm) = THIS->lexer_->remove_scope ();
	;}
    break;

  case 21:
#line 649 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 22:
#line 650 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 23:
#line 654 "parser.yy"
    {
		if (! is_regular_identifier ((yyvsp[-2].scm)))
		{
			(yylsp[-2]).warning (_ ("identifier should have alphabetic characters only"));
		}

	        THIS->lexer_->set_identifier ((yyvsp[-2].scm), (yyvsp[0].scm));

/*
 TODO: devise standard for protection in parser.

  The parser stack lives on the C-stack, which means that
all objects can be unprotected as soon as they're here.

*/
	;}
    break;

  case 24:
#line 670 "parser.yy"
    { ;}
    break;

  case 25:
#line 675 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].score)->self_scm ();
		(yyvsp[0].score)->unprotect ();
	;}
    break;

  case 26:
#line 679 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].outputdef)->self_scm ();
		(yyvsp[0].outputdef)->unprotect ();
	;}
    break;

  case 27:
#line 683 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 28:
#line 686 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].music)->self_scm ();
		(yyvsp[0].music)->unprotect();
	;}
    break;

  case 29:
#line 690 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].music)->self_scm ();
		(yyvsp[0].music)->unprotect();
	;}
    break;

  case 30:
#line 694 "parser.yy"
    {
 		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 31:
#line 697 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 32:
#line 700 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 33:
#line 703 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 34:
#line 706 "parser.yy"
    {
		(yyval.scm) = scm_from_int ((yyvsp[0].i));
	;}
    break;

  case 35:
#line 713 "parser.yy"
    {
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 36:
#line 719 "parser.yy"
    {
		(yyval.scm) = Context_def::make_scm ();
		unsmob_context_def ((yyval.scm))->set_spot ((yyloc));
	;}
    break;

  case 37:
#line 723 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		unsmob_context_def ((yyval.scm))->set_spot ((yyloc));
	;}
    break;

  case 38:
#line 727 "parser.yy"
    {
		Context_def*td = unsmob_context_def ((yyval.scm));

		for (SCM p = (yyvsp[0].scm); scm_is_pair (p); p = scm_cdr (p)) {
			SCM tag = scm_caar (p);

			/* TODO: should make new tag "grob-definition" ? */
			td->add_context_mod (scm_list_3 (ly_symbol2scm ("assign"),
							tag, scm_cons (scm_cdar (p), SCM_EOL)));
		}
	;}
    break;

  case 39:
#line 738 "parser.yy"
    {
		unsmob_context_def ((yyval.scm))->add_context_mod ((yyvsp[0].scm));		
	;}
    break;

  case 40:
#line 746 "parser.yy"
    {
		(yyval.book) = (yyvsp[-1].book);
	;}
    break;

  case 41:
#line 755 "parser.yy"
    {
		(yyval.book) = new Book;
		(yyval.book)->set_spot ((yyloc));
		(yyval.book)->paper_ = dynamic_cast<Output_def*> (unsmob_output_def (THIS->lexer_->lookup_identifier ("$defaultpaper"))->clone ());
		(yyval.book)->paper_->unprotect ();
		(yyval.book)->header_ = THIS->lexer_->lookup_identifier ("$defaultheader"); 
	;}
    break;

  case 42:
#line 762 "parser.yy"
    {
		(yyval.book)->paper_ = (yyvsp[0].outputdef);
		(yyvsp[0].outputdef)->unprotect ();
	;}
    break;

  case 43:
#line 766 "parser.yy"
    {
		SCM s = (yyvsp[0].score)->self_scm ();
		(yyval.book)->add_score (s);
		(yyvsp[0].score)->unprotect();
	;}
    break;

  case 44:
#line 771 "parser.yy"
    {
		(yyval.book)->add_score ((yyvsp[0].scm));
	;}
    break;

  case 45:
#line 774 "parser.yy"
    {
		(yyval.book)->header_ = (yyvsp[0].scm);
	;}
    break;

  case 46:
#line 777 "parser.yy"
    {
		(yyval.book)->paper_ = 0;
		(yyval.book)->scores_ = SCM_EOL;
	;}
    break;

  case 47:
#line 781 "parser.yy"
    {
		(yyval.book)->user_key_ = ly_scm2string ((yyvsp[0].scm));
	;}
    break;

  case 48:
#line 787 "parser.yy"
    {
		(yyval.score) = (yyvsp[-1].score);
	;}
    break;

  case 49:
#line 793 "parser.yy"
    {
		SCM m = (yyvsp[0].music)->self_scm ();
		(yyvsp[0].music)->unprotect();
		SCM scorify = ly_lily_module_constant ("scorify-music");
		SCM score = scm_call_2 (scorify, m, THIS->self_scm ());

		// pass ownernship to C++ again.
		(yyval.score) = unsmob_score (score);
		(yyval.score)->protect ();
		(yyval.score)->set_spot ((yyloc));
	;}
    break;

  case 50:
#line 804 "parser.yy"
    {
		(yyval.score) = unsmob_score ((yyvsp[0].scm));
		(yyval.score)->set_spot ((yyloc));
	;}
    break;

  case 51:
#line 808 "parser.yy"
    {
		(yyval.score)->user_key_ = ly_scm2string ((yyvsp[0].scm));
	;}
    break;

  case 52:
#line 811 "parser.yy"
    {
		(yyval.score)->header_ = (yyvsp[0].scm);
	;}
    break;

  case 53:
#line 814 "parser.yy"
    {
		if ((yyvsp[0].outputdef)->lookup_variable (ly_symbol2scm ("is-paper")) == SCM_BOOL_T)
		{
			THIS->parser_error ((yylsp[0]), _("\\paper cannot be used in \\score, use \\layout instead"));
		
		}
		else
		{
			(yyval.score)->defs_.push ((yyvsp[0].outputdef));
		}
		(yyvsp[0].outputdef)->unprotect ();
	;}
    break;

  case 54:
#line 826 "parser.yy"
    {
		(yyval.score)->error_found_ = true;
	;}
    break;

  case 55:
#line 837 "parser.yy"
    {
		(yyval.outputdef) = (yyvsp[0].outputdef);
		if ((yyval.outputdef)->lookup_variable (ly_symbol2scm ("is-paper")) != SCM_BOOL_T)
		{
			THIS->parser_error ((yylsp[0]), _ ("need \\paper for paper block"));
			(yyval.outputdef) = get_paper (THIS);
		}
	;}
    break;

  case 56:
#line 849 "parser.yy"
    {
		(yyval.outputdef) = (yyvsp[-1].outputdef);

		THIS->lexer_->remove_scope ();
		THIS->lexer_->pop_state ();
	;}
    break;

  case 57:
#line 858 "parser.yy"
    {
		(yyval.outputdef) = get_paper (THIS);
		(yyval.outputdef)->input_origin_ = (yyloc);
		THIS->lexer_->add_scope ((yyval.outputdef)->scope_);
	;}
    break;

  case 58:
#line 863 "parser.yy"
    {
		Output_def *p = get_midi (THIS);
		(yyval.outputdef) = p;
		THIS->lexer_->add_scope (p->scope_);
	;}
    break;

  case 59:
#line 868 "parser.yy"
    {
		Output_def *p = get_layout (THIS);

		THIS->lexer_->add_scope (p->scope_);
		(yyval.outputdef) = p;
	;}
    break;

  case 60:
#line 878 "parser.yy"
    {
		(yyval.outputdef) = (yyvsp[-1].outputdef);
		(yyval.outputdef)->input_origin_.set_spot ((yyloc));
		THIS->lexer_->push_initial_state ();
	;}
    break;

  case 61:
#line 883 "parser.yy"
    {
		(yyvsp[-2].outputdef)->unprotect ();
		Output_def *o = unsmob_output_def ((yyvsp[0].scm));
		o->input_origin_.set_spot ((yyloc));
		(yyval.outputdef) = o;
		THIS->lexer_->remove_scope ();
		THIS->lexer_->add_scope (o->scope_);
		THIS->lexer_->push_initial_state ();
	;}
    break;

  case 62:
#line 892 "parser.yy"
    {

	;}
    break;

  case 63:
#line 895 "parser.yy"
    {
		assign_context_def ((yyval.outputdef), (yyvsp[0].scm));
	;}
    break;

  case 64:
#line 898 "parser.yy"
    {
		/*
			junk this ? there already is tempo stuff in
			music.
		*/
		int m = scm_to_int ((yyvsp[0].music)->get_property ("metronome-count"));
		Duration *d = unsmob_duration ((yyvsp[0].music)->get_property ("tempo-unit"));
		set_tempo ((yyval.outputdef), d->get_length (), m);
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 65:
#line 908 "parser.yy"
    {

	;}
    break;

  case 66:
#line 914 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("MetronomeChangeEvent");
		(yyval.music)->set_property ("tempo-unit", (yyvsp[-2].scm));
		(yyval.music)->set_property ("metronome-count", scm_from_int ( (yyvsp[0].i)));
	;}
    break;

  case 67:
#line 929 "parser.yy"
    {
		(yyval.scm) = scm_cons (SCM_EOL, SCM_EOL);
	;}
    break;

  case 68:
#line 932 "parser.yy"
    {
		SCM s = (yyval.scm);
 		SCM c = scm_cons ((yyvsp[0].music)->self_scm (), SCM_EOL);
		(yyvsp[0].music)->unprotect (); /* UGH */

		if (scm_is_pair (scm_cdr (s)))
			scm_set_cdr_x (scm_cdr (s), c); /* append */
		else
			scm_set_car_x (s, c); /* set first cons */
		scm_set_cdr_x (s, c);  /* remember last cell */
	;}
    break;

  case 69:
#line 943 "parser.yy"
    {

	;}
    break;

  case 70:
#line 946 "parser.yy"
    {
		Music * m = MY_MAKE_MUSIC("Music");
		// ugh. code dup 
		m->set_property ("error-found", SCM_BOOL_T);
		SCM s = (yyval.scm);
 		SCM c = scm_cons (m->self_scm (), SCM_EOL);
		m->unprotect (); /* UGH */

		if (scm_is_pair (scm_cdr (s)))
			scm_set_cdr_x (scm_cdr (s), c); /* append */
		else
			scm_set_car_x (s, c); /* set first cons */
		scm_set_cdr_x (s, c);  /* remember last cell */
	;}
    break;

  case 73:
#line 968 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;
	;}
    break;

  case 74:
#line 971 "parser.yy"
    {
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 75:
#line 979 "parser.yy"
    {
		Music *beg = (yyvsp[-1].music);
		int times = (yyvsp[-2].i);
		SCM alts = scm_is_pair ((yyvsp[0].scm)) ? scm_car ((yyvsp[0].scm)) : SCM_EOL;
		if (times < scm_ilength (alts)) {
		  unsmob_music (scm_car (alts))
		    ->origin ()->warning (
		    _ ("more alternatives than repeats"));
		    warning ("junking excess alternatives");
		  alts = ly_truncate_list (times, alts);
		}


		SCM proc = ly_lily_module_constant ("make-repeated-music");

		SCM mus = scm_call_1 (proc, (yyvsp[-3].scm));
		Music *r = unsmob_music (mus);
		r->protect ();
		if (beg)
			{
			r-> set_property ("element", beg->self_scm ());
			beg->unprotect ();
			}
		r->set_property ("repeat-count", scm_from_int (max (times, 1)));

		r-> set_property ("elements",alts);
		if (ly_is_equal ((yyvsp[-3].scm), scm_makfrom0str ("tremolo"))) {
			/*
			TODO: move this code to Scheme.
			*/

			/* we cannot get durations and other stuff
			   correct down the line,
			   so we have to add to the duration log here. */
			SCM func = ly_lily_module_constant ("shift-duration-log");

			int dots = ((yyvsp[-2].i) % 3) ? 0 : 1;
			int shift = -intlog2 ((dots) ? ((yyvsp[-2].i)*2/3) : (yyvsp[-2].i));

			
			if ((yyvsp[-1].music)->is_mus_type ("sequential-music"))
			{
				int list_len = scm_ilength ((yyvsp[-1].music)->get_property ("elements"));
				if (list_len != 2)
					(yyvsp[-1].music)->origin ()->warning (_f ("expect 2 elements for Chord tremolo, found %d", list_len));
				shift -= 1;
				r->compress (Moment (Rational (1, list_len)));
			}
			scm_call_3 (func, r->self_scm (), scm_from_int (shift), scm_from_int (dots));

		}
		r->set_spot (*(yyvsp[-1].music)->origin ());

		(yyval.music) = r;
	;}
    break;

  case 76:
#line 1037 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SequentialMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 77:
#line 1042 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SequentialMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 78:
#line 1050 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SimultaneousMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));

	;}
    break;

  case 79:
#line 1056 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SimultaneousMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 80:
#line 1064 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 81:
#line 1065 "parser.yy"
    {
		(yyval.music) = unsmob_music ((yyvsp[0].scm));
	;}
    break;

  case 84:
#line 1074 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 85:
#line 1075 "parser.yy"
    { THIS->lexer_->push_initial_state (); ;}
    break;

  case 86:
#line 1077 "parser.yy"
    {
		THIS->lexer_->pop_state ();
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 87:
#line 1084 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 88:
#line 1085 "parser.yy"
    {
		 (yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 89:
#line 1092 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 90:
#line 1093 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 91:
#line 1097 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 92:
#line 1098 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 93:
#line 1102 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[0].scm), make_input ((yyloc)));
	;}
    break;

  case 94:
#line 1105 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-1].scm), make_input ((yyloc)), (yyvsp[0].scm));
	;}
    break;

  case 95:
#line 1108 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-1].scm), make_input ((yyloc)), (yyvsp[0].scm));
	;}
    break;

  case 96:
#line 1111 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-1].scm), make_input ((yyloc)), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 97:
#line 1115 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 98:
#line 1119 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 99:
#line 1122 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 100:
#line 1125 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
	;}
    break;

  case 101:
#line 1128 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 102:
#line 1132 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 103:
#line 1135 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].music)->self_scm (), (yyvsp[0].music)->self_scm ());
		(yyvsp[-1].music)->unprotect ();
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 104:
#line 1140 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].music)->self_scm (), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect ();
		(yyvsp[-1].music)->unprotect ();
	;}
    break;

  case 105:
#line 1145 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].music)->self_scm (), (yyvsp[0].music)->self_scm ());
		(yyvsp[-1].music)->unprotect ();
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 106:
#line 1153 "parser.yy"
    {
		SCM func = scm_car ((yyvsp[0].scm));
		Input *loc = unsmob_input (scm_cadr ((yyvsp[0].scm)));
		SCM args = scm_cddr ((yyvsp[0].scm));
		SCM sig = scm_object_property (func, ly_symbol2scm ("music-function-signature"));

		SCM type_check_proc = ly_lily_module_constant ("type-check-list");
		bool ok  = true;

		if (!to_boolean (scm_call_3  (type_check_proc, scm_cadr ((yyvsp[0].scm)), sig, args)))
		{
			THIS->error_level_ = 1;
			ok = false;
		}

		SCM m = SCM_EOL;
  		if (ok)
			m = scm_apply_0 (func, scm_cons (THIS->self_scm(),
							 scm_cdr ((yyvsp[0].scm))));

		if (unsmob_music (m))
			{
			(yyval.music) = unsmob_music (m);
			(yyval.music)->protect ();
			}
		else
			{
			if (ok)
 				loc->error (_ ("music head function must return Music object")); 
			(yyval.music) = MY_MAKE_MUSIC ("Music");
			}
		(yyval.music)->set_spot (*loc);
	;}
    break;

  case 107:
#line 1190 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 108:
#line 1193 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-4].scm), (yyvsp[-2].scm), (yyvsp[0].music), (yyvsp[-1].scm));

	;}
    break;

  case 109:
#line 1197 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-2].scm), SCM_UNDEFINED, (yyvsp[0].music), (yyvsp[-1].scm));
	;}
    break;

  case 110:
#line 1200 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-2].scm), get_next_unique_context_id (), (yyvsp[0].music),
			(yyvsp[-1].scm));
	;}
    break;

  case 111:
#line 1207 "parser.yy"
    {
		int n = scm_to_int (scm_car ((yyvsp[-1].scm))); int d = scm_to_int (scm_cdr ((yyvsp[-1].scm)));
		Music *mp = (yyvsp[0].music);

		(yyval.music)= MY_MAKE_MUSIC ("TimeScaledMusic");
		(yyval.music)->set_spot ((yyloc));

		(yyval.music)->set_property ("element", mp->self_scm ());
		mp->unprotect();
		(yyval.music)->set_property ("numerator", scm_from_int (n));
		(yyval.music)->set_property ("denominator", scm_from_int (d));
		(yyval.music)->compress (Moment (Rational (n,d)));

	;}
    break;

  case 112:
#line 1221 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 113:
#line 1222 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("TransposedMusic");
		Music *p = (yyvsp[0].music);
		Pitch from = *unsmob_pitch ((yyvsp[-2].scm));
		Pitch to = *unsmob_pitch ((yyvsp[-1].scm));

		p->transpose (pitch_interval (from, to));
		(yyval.music)->set_property ("element", p->self_scm ());
		p->unprotect();
	;}
    break;

  case 114:
#line 1232 "parser.yy"
    {
		if ((yyvsp[-1].scm) == ly_symbol2scm ("chords"))
		{
		  Music *chm = MY_MAKE_MUSIC ("UnrelativableMusic");
		  chm->set_property ("element", (yyvsp[0].music)->self_scm ());
		  (yyval.music) = chm;
		  (yyvsp[0].music)->unprotect();
		}
		else
		{
		  (yyval.music) = (yyvsp[0].music);
		}
		THIS->lexer_->pop_state ();
	;}
    break;

  case 115:
#line 1246 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-2].scm), get_next_unique_context_id (),
					 (yyvsp[0].music), (yyvsp[-1].scm));
		if ((yyvsp[-2].scm) == ly_symbol2scm ("ChordNames"))
		{
		  Music *chm = MY_MAKE_MUSIC ("UnrelativableMusic");
		  chm->set_property ("element", (yyval.music)->self_scm ());
		  (yyval.music)->unprotect();
		  (yyval.music) = chm;
		}
		THIS->lexer_->pop_state ();
	;}
    break;

  case 116:
#line 1258 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 117:
#line 1259 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 118:
#line 1260 "parser.yy"
    {
		tag_music ((yyvsp[0].music), (yyvsp[-1].scm), (yyloc));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 119:
#line 1267 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));

		(yyval.scm) = ly_symbol2scm ("notes");
	;}
    break;

  case 120:
#line 1274 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("drumPitchNames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));

		(yyval.scm) = ly_symbol2scm ("drums");
	;}
    break;

  case 121:
#line 1280 "parser.yy"
    {
		THIS->lexer_->push_figuredbass_state ();

		(yyval.scm) = ly_symbol2scm ("figures");
	;}
    break;

  case 122:
#line 1285 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("chordmodifiers");
		THIS->lexer_->chordmodifier_tab_ = alist_to_hashq (nn);
		nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_chord_state (alist_to_hashq (nn));
		(yyval.scm) = ly_symbol2scm ("chords");

	;}
    break;

  case 123:
#line 1294 "parser.yy"
    { THIS->lexer_->push_lyric_state ();
		(yyval.scm) = ly_symbol2scm ("lyrics");
	;}
    break;

  case 124:
#line 1300 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("drumPitchNames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));

		(yyval.scm) = ly_symbol2scm ("DrumStaff");
	;}
    break;

  case 125:
#line 1306 "parser.yy"
    {
		THIS->lexer_->push_figuredbass_state ();

		(yyval.scm) = ly_symbol2scm ("FiguredBass");
	;}
    break;

  case 126:
#line 1311 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("chordmodifiers");
		THIS->lexer_->chordmodifier_tab_ = alist_to_hashq (nn);
		nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_chord_state (alist_to_hashq (nn));
		(yyval.scm) = ly_symbol2scm ("ChordNames");
	;}
    break;

  case 127:
#line 1319 "parser.yy"
    { THIS->lexer_->push_lyric_state ();
		(yyval.scm) = ly_symbol2scm ("Lyrics");
	;}
    break;

  case 128:
#line 1326 "parser.yy"
    {
		Music *m = (yyvsp[0].music);
		Pitch start = *unsmob_pitch ((yyvsp[-1].scm));
		(yyval.music) = make_music_relative (start, m);
		m->unprotect();
	;}
    break;

  case 129:
#line 1332 "parser.yy"
    {
		Music *m = (yyvsp[0].music);

		Pitch middle_c (0, 0, 0);
		(yyval.music) = make_music_relative (middle_c, m);
		m->unprotect();
	;}
    break;

  case 130:
#line 1342 "parser.yy"
    { THIS->lexer_->push_lyric_state (); ;}
    break;

  case 131:
#line 1344 "parser.yy"
    {
	/* Can also use Music at the expensive of two S/Rs similar to
           \repeat \alternative */
		THIS->lexer_->pop_state ();

		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), SCM_EOL);
	;}
    break;

  case 132:
#line 1351 "parser.yy"
    {
		THIS->lexer_->push_lyric_state ();
	;}
    break;

  case 133:
#line 1353 "parser.yy"
    {
		THIS->lexer_->pop_state ();
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyvsp[-3].scm));
	;}
    break;

  case 134:
#line 1360 "parser.yy"
    {
		Music * voice = (yyvsp[-1].music);
		SCM name = get_first_context_id (scm_makfrom0str ("Voice"), voice); 
		if (!scm_is_string (name))
		{
			name = get_next_unique_lyrics_context_id ();
			voice = context_spec_music (scm_makfrom0str ("Voice"),
						    name,
						    voice, SCM_EOL);
		}

		SCM context = scm_makfrom0str ("Lyrics");
		Music *all = MY_MAKE_MUSIC ("SimultaneousMusic");

		SCM lst = SCM_EOL;
		for (SCM s = (yyvsp[0].scm); scm_is_pair (s); s = scm_cdr (s))
		{
			Music *music = unsmob_music (scm_car (s));
			Music *com = make_lyric_combine_music (name, music);
			Music *csm = context_spec_music (context,
				get_next_unique_context_id (), com, SCM_EOL);
			lst = scm_cons (csm->self_scm (), lst);
		}
		all->set_property ("elements", scm_cons (voice->self_scm (),
			lst));
		(yyval.music) = all;
		voice->unprotect ();
	;}
    break;

  case 135:
#line 1388 "parser.yy"
    {
		THIS->lexer_->push_lyric_state ();
	;}
    break;

  case 136:
#line 1390 "parser.yy"
    {
		THIS->lexer_->pop_state ();
		Music *music = (yyvsp[0].music);
		SCM name = (yyvsp[-2].scm);
		(yyval.music) = make_lyric_combine_music (name, music);
		music->unprotect();
	;}
    break;

  case 137:
#line 1400 "parser.yy"
    {
		Music*t = MY_MAKE_MUSIC ("ContextChange");
		t-> set_property ("change-to-type", scm_string_to_symbol ((yyvsp[-2].scm)));
		t-> set_property ("change-to-id", (yyvsp[0].scm));

		(yyval.music) = t;
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 138:
#line 1411 "parser.yy"
    {
		(yyval.scm) = scm_list_3 (ly_symbol2scm ("assign"),
			scm_string_to_symbol ((yyvsp[-2].scm)), (yyvsp[0].scm));
	;}
    break;

  case 139:
#line 1415 "parser.yy"
    {
		(yyval.scm) = scm_list_2 (ly_symbol2scm ("unset"),
			scm_string_to_symbol ((yyvsp[0].scm)));
	;}
    break;

  case 140:
#line 1419 "parser.yy"
    {
		(yyval.scm) = scm_list_4 (ly_symbol2scm ("push"),
			scm_string_to_symbol ((yyvsp[-3].scm)), (yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 141:
#line 1423 "parser.yy"
    {
		(yyval.scm) = scm_list_3 (ly_symbol2scm ("pop"),
			scm_string_to_symbol ((yyvsp[-1].scm)), (yyvsp[0].scm));
	;}
    break;

  case 142:
#line 1430 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("consists"); ;}
    break;

  case 143:
#line 1431 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("remove"); ;}
    break;

  case 144:
#line 1433 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("accepts"); ;}
    break;

  case 145:
#line 1434 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("default-child"); ;}
    break;

  case 146:
#line 1435 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("denies"); ;}
    break;

  case 147:
#line 1437 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("alias"); ;}
    break;

  case 148:
#line 1438 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("translator-type"); ;}
    break;

  case 149:
#line 1439 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("description"); ;}
    break;

  case 150:
#line 1440 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("context-name"); ;}
    break;

  case 151:
#line 1444 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 152:
#line 1445 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 153:
#line 1451 "parser.yy"
    {
		if (!is_regular_identifier ((yyvsp[0].scm)))
		{
			(yyloc).error (_("Grob name should be alphanumeric"));
		}

		(yyval.scm) = scm_list_2 (ly_symbol2scm ("Bottom"),
			scm_string_to_symbol ((yyvsp[0].scm)));
	;}
    break;

  case 154:
#line 1460 "parser.yy"
    {
		(yyval.scm) = scm_list_2 (scm_string_to_symbol ((yyvsp[-2].scm)),
			scm_string_to_symbol ((yyvsp[0].scm)));
	;}
    break;

  case 155:
#line 1467 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_4 (
			ly_symbol2scm ("poppush"),
			scm_cadr ((yyvsp[-3].scm)),
			(yyvsp[-2].scm), (yyvsp[0].scm)));
		(yyval.music)= context_spec_music (scm_car ((yyvsp[-3].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 156:
#line 1474 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_3 (
			ly_symbol2scm ("pop"),
			scm_cadr ((yyvsp[-1].scm)),
			(yyvsp[0].scm)));

		(yyval.music)= context_spec_music (scm_car ((yyvsp[-1].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 157:
#line 1482 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_3 (
			ly_symbol2scm ("assign"),
			scm_cadr ((yyvsp[-2].scm)),
			(yyvsp[0].scm)));
		(yyval.music)= context_spec_music (scm_car ((yyvsp[-2].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 158:
#line 1489 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_2 (
			ly_symbol2scm ("unset"),
			scm_cadr ((yyvsp[0].scm))));
		(yyval.music)= context_spec_music (scm_car ((yyvsp[0].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 159:
#line 1495 "parser.yy"
    {
		SCM e = (yyvsp[0].music)->get_property ("element");
                unsmob_music (e)->set_property ("once", SCM_BOOL_T);
		(yyval.music) = (yyvsp[0].music);

	;}
    break;

  case 160:
#line 1505 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 161:
#line 1508 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 162:
#line 1511 "parser.yy"
    {
		(yyval.scm) = scm_string_append (scm_list_2 ((yyvsp[-2].scm), (yyvsp[0].scm)));
	;}
    break;

  case 163:
#line 1516 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 164:
#line 1519 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 165:
#line 1522 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 166:
#line 1527 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 167:
#line 1530 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 168:
#line 1533 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 169:
#line 1536 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 170:
#line 1539 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 171:
#line 1542 "parser.yy"
    {
		(yyval.scm) = scm_from_int ((yyvsp[0].i));
	;}
    break;

  case 173:
#line 1570 "parser.yy"
    {
		SCM elts = (yyvsp[-1].music)-> get_property ("elements");

		elts = ly_append2 (elts, scm_reverse_x ((yyvsp[0].scm), SCM_EOL));

		(yyvsp[-1].music)->set_property ("elements", elts);
		/* why is this giving wrong start location? -ns
		 * $2->set_spot (@$); */
		Input i;
		i.set_location ((yylsp[-1]), (yylsp[0]));
		(yyvsp[-1].music)->set_spot (i);
		(yyval.music) = (yyvsp[-1].music);
	;}
    break;

  case 176:
#line 1590 "parser.yy"
    {
		SCM dur = unsmob_duration ((yyvsp[-1].scm))->smobbed_copy ();
		SCM es = (yyvsp[-2].music)->get_property ("elements");
		SCM postevs = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);

		for (SCM s = es; scm_is_pair (s); s = scm_cdr (s))
		  unsmob_music (scm_car (s))->set_property ("duration", dur);
		es = ly_append2 (es, postevs);

		(yyvsp[-2].music)-> set_property ("elements", es);
		(yyvsp[-2].music)->set_spot ((yyloc));
		(yyval.music) = (yyvsp[-2].music);
	;}
    break;

  case 181:
#line 1619 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_spot ((yyloc));
		(yyval.music)->set_property ("elements",
			scm_reverse_x ((yyvsp[-1].scm), SCM_EOL));
	;}
    break;

  case 182:
#line 1628 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 183:
#line 1629 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyvsp[-1].scm));
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 184:
#line 1637 "parser.yy"
    {
		int q = (yyvsp[-2].i);
		int ex = (yyvsp[-3].i);
		SCM check = (yyvsp[-1].scm);
		SCM post = (yyvsp[0].scm);

		Music *n = MY_MAKE_MUSIC ("NoteEvent");
		n->set_property ("pitch", (yyvsp[-4].scm));
		n->set_spot ((yyloc));
		if (q % 2)
			n->set_property ("cautionary", SCM_BOOL_T);
		if (ex % 2 || q % 2)
			n->set_property ("force-accidental", SCM_BOOL_T);

		if (scm_is_pair (post)) {
			SCM arts = scm_reverse_x (post, SCM_EOL);
			n->set_property ("articulations", arts);
		}
		if (scm_is_number (check))
		{
			int q = scm_to_int (check);
			n->set_property ("absolute-octave", scm_from_int (q-1));
		}

		
		(yyval.music) = n;
	;}
    break;

  case 185:
#line 1664 "parser.yy"
    {
		Music *n = MY_MAKE_MUSIC ("NoteEvent");
		n->set_property ("duration", (yyvsp[0].scm));
		n->set_property ("drum-type", (yyvsp[-1].scm));
		n->set_spot ((yyloc));

		if (scm_is_pair ((yyvsp[0].scm))) {
			SCM arts = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);
			n->set_property ("articulations", arts);
		}
		(yyval.music) = n;
	;}
    break;

  case 186:
#line 1679 "parser.yy"
    {
		SCM adder = ly_lily_module_constant ("add-quotable");
		
		scm_call_2 (adder, (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
		(yyvsp[0].music)->unprotect();
	;}
    break;

  case 187:
#line 1688 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_property ("elements", scm_cons ((yyvsp[0].music)->self_scm (), SCM_EOL));
		(yyvsp[0].music)->unprotect();

		(yyval.music)-> set_spot ((yyloc));
		(yyvsp[0].music)-> set_spot ((yyloc));
	;}
    break;

  case 188:
#line 1696 "parser.yy"
    {
		Music *skip = MY_MAKE_MUSIC ("SkipMusic");
		skip->set_property ("duration", (yyvsp[0].scm));
		skip->set_spot ((yyloc));
		(yyval.music) = skip;
	;}
    break;

  case 189:
#line 1702 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("RelativeOctaveCheck");
		(yyval.music) = m;
		(yyval.music)->set_spot ((yyloc));
		(yyval.music)->set_property ("pitch", (yyvsp[0].scm));
	;}
    break;

  case 190:
#line 1708 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("LigatureEvent");
		m->set_property ("span-direction", scm_from_int (START));
		m->set_spot ((yyloc));

		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_property ("elements", scm_cons (m->self_scm (), SCM_EOL));
		m->unprotect();
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 191:
#line 1718 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("LigatureEvent");
		m->set_property ("span-direction", scm_from_int (STOP));
		m->set_spot ((yyloc));

		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_property ("elements", scm_cons (m->self_scm (), SCM_EOL));
		(yyval.music)->set_spot ((yyloc));
		m->unprotect ();
	;}
    break;

  case 192:
#line 1728 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("VoiceSeparator");
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 193:
#line 1732 "parser.yy"
    {
		SCM pipe = THIS->lexer_->lookup_identifier ("pipeSymbol");

		if (Music * m = unsmob_music (pipe))
			(yyval.music) = m->clone ();
		else
			(yyval.music) = MY_MAKE_MUSIC ("BarCheck");

		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 194:
#line 1742 "parser.yy"
    {
		Pitch middle_c;
		Pitch sounds_as_c = pitch_interval (*unsmob_pitch ((yyvsp[0].scm)), middle_c);
		(yyval.music) = set_property_music (ly_symbol2scm ("instrumentTransposition"),
					 sounds_as_c.smobbed_copy());
		(yyval.music)->set_spot ((yyloc));
		(yyval.music) = context_spec_music (ly_symbol2scm ("Staff"), SCM_UNDEFINED,
			(yyval.music), SCM_EOL);
	;}
    break;

  case 195:
#line 1751 "parser.yy"
    {
		Music *t = set_property_music (ly_symbol2scm ("whichBar"), (yyvsp[0].scm));

		Music *csm = context_spec_music (ly_symbol2scm ("Timing"), SCM_UNDEFINED,
					t, SCM_EOL);
		(yyval.music) = context_spec_music (ly_symbol2scm ("Score"), SCM_UNDEFINED, csm, SCM_EOL);
		(yyval.music)->set_spot ((yyloc));
		t->set_spot ((yyloc));
	;}
    break;

  case 196:
#line 1760 "parser.yy"
    {
		Moment m = - unsmob_duration ((yyvsp[0].scm))->get_length ();
		Music *p = set_property_music (ly_symbol2scm ( "measurePosition"),m.smobbed_copy ());
		p->set_spot ((yyloc));
		p = context_spec_music (ly_symbol2scm ("Timing"), SCM_UNDEFINED,
					p, SCM_EOL);
		p = context_spec_music (ly_symbol2scm ("Score"), SCM_UNDEFINED,
					p, SCM_EOL);
		(yyval.music) = p;
	;}
    break;

  case 197:
#line 1770 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-clef-set");

		SCM result = scm_call_1 (proc, (yyvsp[0].scm));
		(yyval.music) = unsmob_music (result);
		(yyval.music)->protect ();
	;}
    break;

  case 198:
#line 1777 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-time-signature-set");

		SCM result = scm_apply_2   (proc, scm_car ((yyvsp[0].scm)), scm_cdr ((yyvsp[0].scm)), SCM_EOL);
		(yyval.music) = unsmob_music (result);
		(yyval.music)->protect ();
	;}
    break;

  case 199:
#line 1784 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-mark-set");

		SCM result = scm_call_1 (proc, (yyvsp[0].scm));
		(yyval.music) = unsmob_music (result);
		(yyval.music)->protect ();
	;}
    break;

  case 200:
#line 1794 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("PesOrFlexaEvent");
	;}
    break;

  case 201:
#line 1797 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("MarkEvent");
		(yyval.music) = m;
	;}
    break;

  case 202:
#line 1801 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 203:
#line 1804 "parser.yy"
    {
		Music *key = MY_MAKE_MUSIC ("KeyChangeEvent");
		(yyval.music) = key;
	;}
    break;

  case 204:
#line 1808 "parser.yy"
    {

		Music *key = MY_MAKE_MUSIC ("KeyChangeEvent");
		if (scm_ilength ((yyvsp[0].scm)) > 0)
		{		
			key->set_property ("pitch-alist", (yyvsp[0].scm));
			key->set_property ("tonic", Pitch (0, 0, 0).smobbed_copy ());
			key->transpose (* unsmob_pitch ((yyvsp[-1].scm)));
		} else {
			THIS->parser_error ((yylsp[0]), _ ("second argument must be pitch list"));
		}

		(yyval.music) = key;
	;}
    break;

  case 205:
#line 1826 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;
	;}
    break;

  case 206:
#line 1829 "parser.yy"
    {
		(yyvsp[0].music)->set_spot ((yylsp[0]));
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyval.scm));
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 207:
#line 1834 "parser.yy"
    {
		(yyvsp[0].music) -> set_spot ((yylsp[0]));
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyval.scm));
		(yyvsp[0].music)->unprotect ();
	;}
    break;

  case 208:
#line 1843 "parser.yy"
    {
		tag_music ((yyvsp[0].music), (yyvsp[-1].scm), (yyloc));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 209:
#line 1851 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 210:
#line 1854 "parser.yy"
    {
		if (!THIS->lexer_->is_lyric_state ())
			THIS->parser_error ((yylsp[0]), _ ("have to be in Lyric mode for lyrics"));
		(yyval.music) = MY_MAKE_MUSIC ("HyphenEvent");
	;}
    break;

  case 211:
#line 1859 "parser.yy"
    {
		if (!THIS->lexer_->is_lyric_state ())
			THIS->parser_error ((yylsp[0]), _ ("have to be in Lyric mode for lyrics"));
		(yyval.music) = MY_MAKE_MUSIC ("ExtenderEvent");
	;}
    break;

  case 212:
#line 1864 "parser.yy"
    {
		if ((yyvsp[-1].i))
			(yyvsp[0].music)->set_property ("direction", scm_from_int ((yyvsp[-1].i)));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 213:
#line 1869 "parser.yy"
    {
		if ((yyvsp[-1].i))
			(yyvsp[0].music)->set_property ("direction", scm_from_int ((yyvsp[-1].i)));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 215:
#line 1878 "parser.yy"
    {
		Music *s = MY_MAKE_MUSIC ("StringNumberEvent");
		s->set_property ("string-number", scm_from_int ((yyvsp[0].i)));
		s->set_spot ((yyloc));
		(yyval.music) = s;
	;}
    break;

  case 216:
#line 1887 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("bracketOpenSymbol");
	;}
    break;

  case 217:
#line 1890 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("bracketCloseSymbol"); 
	;}
    break;

  case 218:
#line 1893 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("tildeSymbol");
	;}
    break;

  case 219:
#line 1896 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("parenthesisOpenSymbol");
	;}
    break;

  case 220:
#line 1899 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("parenthesisCloseSymbol");
	;}
    break;

  case 221:
#line 1902 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedExclamationSymbol");
	;}
    break;

  case 222:
#line 1905 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedParenthesisOpenSymbol");
	;}
    break;

  case 223:
#line 1908 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedParenthesisCloseSymbol");
	;}
    break;

  case 224:
#line 1911 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedBiggerSymbol");
	;}
    break;

  case 225:
#line 1914 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedSmallerSymbol");
	;}
    break;

  case 226:
#line 1920 "parser.yy"
    {
		SCM predefd = THIS->lexer_->lookup_identifier_symbol ((yyvsp[0].scm));
		Music * m = 0;
		if (unsmob_music (predefd))
		{
			m = unsmob_music (predefd)->clone ();
		}
		else
		{
			m = MY_MAKE_MUSIC ("Music");
		}
		m->set_spot ((yyloc));
		(yyval.music) = m;		
	;}
    break;

  case 227:
#line 1934 "parser.yy"
    {
		(yyval.music) = unsmob_music ((yyvsp[0].scm));
	;}
    break;

  case 228:
#line 1937 "parser.yy"
    {
               Music *a = MY_MAKE_MUSIC ("TremoloEvent");
               a->set_spot ((yyloc));
               a->set_property ("tremolo-type", scm_from_int ((yyvsp[0].i)));
               (yyval.music) = a;
        ;}
    break;

  case 229:
#line 1946 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 230:
#line 1949 "parser.yy"
    {
		SCM s = THIS->lexer_->lookup_identifier ("dash" + ly_scm2string ((yyvsp[0].scm)));
		Music *a = MY_MAKE_MUSIC ("ArticulationEvent");
		if (scm_is_string (s))
			a->set_property ("articulation-type", s);
		else THIS->parser_error ((yylsp[0]), _ ("expecting string as script definition"));
		(yyval.music) = a;
	;}
    break;

  case 231:
#line 1960 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 232:
#line 1961 "parser.yy"
    { (yyval.scm) = scm_from_int (0); ;}
    break;

  case 233:
#line 1962 "parser.yy"
    { (yyval.scm) = scm_from_int ((yyvsp[0].i)); ;}
    break;

  case 234:
#line 1963 "parser.yy"
    { (yyval.scm) = scm_from_int ((yyvsp[0].i)); ;}
    break;

  case 235:
#line 1967 "parser.yy"
    {
		(yyval.i) = 1;
	;}
    break;

  case 236:
#line 1970 "parser.yy"
    {
		(yyval.i) ++;
	;}
    break;

  case 237:
#line 1976 "parser.yy"
    {
		(yyval.i) = 1;
	;}
    break;

  case 238:
#line 1979 "parser.yy"
    {
		(yyval.i)++;
	;}
    break;

  case 239:
#line 1985 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 240:
#line 1988 "parser.yy"
    {
		Pitch p = *unsmob_pitch ((yyvsp[-1].scm));
		p = p.transposed (Pitch ((yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 241:
#line 1993 "parser.yy"
    {
		Pitch p =* unsmob_pitch ((yyvsp[-1].scm));
		p = p.transposed (Pitch (-(yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 242:
#line 2005 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 243:
#line 2008 "parser.yy"
    {
		Pitch p = *unsmob_pitch ((yyvsp[-1].scm));
		p = p.transposed (Pitch ((yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 244:
#line 2013 "parser.yy"
    {
		Pitch p =* unsmob_pitch ((yyvsp[-1].scm));

		p = p.transposed (Pitch (-(yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 245:
#line 2022 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 248:
#line 2033 "parser.yy"
    {
		Music *t = MY_MAKE_MUSIC ("TextScriptEvent");
		t->set_property ("text", (yyvsp[0].scm));
		t->set_spot ((yyloc));
		(yyval.music) = t;	
	;}
    break;

  case 249:
#line 2039 "parser.yy"
    {
		Music *t = MY_MAKE_MUSIC ("TextScriptEvent");
		t->set_property ("text",
			make_simple_markup ((yyvsp[0].scm)));
		t->set_spot ((yyloc));
		(yyval.music) = t;
	
	;}
    break;

  case 250:
#line 2047 "parser.yy"
    {
		Music *t = MY_MAKE_MUSIC ("FingerEvent");
		t->set_property ("digit", scm_from_int ((yyvsp[0].i)));
		t->set_spot ((yyloc));
		(yyval.music) = t;
	;}
    break;

  case 251:
#line 2056 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Hat");
	;}
    break;

  case 252:
#line 2059 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Plus");
	;}
    break;

  case 253:
#line 2062 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Dash");
	;}
    break;

  case 254:
#line 2065 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Bar");
	;}
    break;

  case 255:
#line 2068 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Larger");
	;}
    break;

  case 256:
#line 2071 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Dot");
	;}
    break;

  case 257:
#line 2074 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Underscore");
	;}
    break;

  case 258:
#line 2080 "parser.yy"
    { (yyval.i) = DOWN; ;}
    break;

  case 259:
#line 2081 "parser.yy"
    { (yyval.i) = UP; ;}
    break;

  case 260:
#line 2082 "parser.yy"
    { (yyval.i) = CENTER; ;}
    break;

  case 261:
#line 2087 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 262:
#line 2093 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 263:
#line 2099 "parser.yy"
    {
		Duration dd = THIS->default_duration_;
		(yyval.scm) = dd.smobbed_copy ();
	;}
    break;

  case 264:
#line 2103 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		THIS->default_duration_ = *unsmob_duration ((yyval.scm));
	;}
    break;

  case 265:
#line 2110 "parser.yy"
    {
		int len = 0;
		if (!is_duration ((yyvsp[-1].i)))
			THIS->parser_error ((yylsp[-1]), _f ("not a duration: %d", (yyvsp[-1].i)));
		else
			len = intlog2 ((yyvsp[-1].i));

		(yyval.scm) = Duration (len, (yyvsp[0].i)).smobbed_copy ();
	;}
    break;

  case 266:
#line 2119 "parser.yy"
    {
		Duration *d = unsmob_duration ((yyvsp[-1].scm));
		Duration k (d->duration_log (), d->dot_count () + (yyvsp[0].i));
		*d = k;
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 267:
#line 2128 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 268:
#line 2131 "parser.yy"
    {
		(yyval.scm) = unsmob_duration ((yyval.scm))->compressed ( (yyvsp[0].i)) .smobbed_copy ();
	;}
    break;

  case 269:
#line 2134 "parser.yy"
    {
		Rational  m (scm_to_int (scm_car ((yyvsp[0].scm))), scm_to_int (scm_cdr ((yyvsp[0].scm))));

		(yyval.scm) = unsmob_duration ((yyval.scm))->compressed (m).smobbed_copy ();
	;}
    break;

  case 270:
#line 2142 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 271:
#line 2143 "parser.yy"
    {
		(yyval.scm) = scm_cons (scm_from_int ((yyvsp[-2].i)), scm_from_int ((yyvsp[0].i)));
	;}
    break;

  case 272:
#line 2149 "parser.yy"
    {
		(yyval.i) = 0;
	;}
    break;

  case 273:
#line 2152 "parser.yy"
    {
		(yyval.i) ++;
	;}
    break;

  case 274:
#line 2158 "parser.yy"
    {
		(yyval.i) = 0;
	;}
    break;

  case 275:
#line 2161 "parser.yy"
    {
		if (!is_duration ((yyvsp[0].i)))
			THIS->parser_error ((yylsp[0]), _f ("not a duration: %d", (yyvsp[0].i)));
		(yyval.i) = (yyvsp[0].i);
	;}
    break;

  case 276:
#line 2169 "parser.yy"
    {
		(yyval.scm) = scm_from_int ((yyvsp[0].i));
	;}
    break;

  case 277:
#line 2172 "parser.yy"
    {
		(yyval.scm) = scm_from_int ((yyvsp[0].i));
	;}
    break;

  case 278:
#line 2175 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 279:
#line 2176 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 280:
#line 2180 "parser.yy"
    { (yyval.i) = -2; ;}
    break;

  case 281:
#line 2181 "parser.yy"
    { (yyval.i) = 2; ;}
    break;

  case 282:
#line 2182 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 283:
#line 2186 "parser.yy"
    {
		Music *bfr = MY_MAKE_MUSIC ("BassFigureEvent");
		(yyval.scm) = bfr->self_scm ();
		bfr->unprotect ();
	;}
    break;

  case 284:
#line 2191 "parser.yy"
    {
		Music *bfr = MY_MAKE_MUSIC ("BassFigureEvent");
		(yyval.scm) = bfr->self_scm ();

		if (scm_is_number ((yyvsp[0].scm)))
			bfr->set_property ("figure", (yyvsp[0].scm));
		else if (Text_interface::is_markup ((yyvsp[0].scm)))
			bfr->set_property ("text", (yyvsp[0].scm));

		bfr->unprotect ();
	;}
    break;

  case 285:
#line 2202 "parser.yy"
    {
		(yyval.scm) = (yyvsp[-1].scm);
		unsmob_music ((yyvsp[-1].scm))->set_property ("bracket-stop", SCM_BOOL_T);
	;}
    break;

  case 286:
#line 2206 "parser.yy"
    {
		Music *m = unsmob_music ((yyvsp[-1].scm));
		if ((yyvsp[0].i)) {
			SCM salter = m->get_property ("alteration");
			int alter = scm_is_number (salter) ? scm_to_int (salter) : 0;
			m->set_property ("alteration",
				scm_from_int (alter + (yyvsp[0].i)));
		} else {
			m->set_property ("alteration", scm_from_int (0));
		}
	;}
    break;

  case 287:
#line 2221 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 288:
#line 2224 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		unsmob_music ((yyval.scm))->set_property ("bracket-start", SCM_BOOL_T);
	;}
    break;

  case 289:
#line 2231 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;
	;}
    break;

  case 290:
#line 2234 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 291:
#line 2240 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("EventChord");
		(yyvsp[-1].scm) = scm_reverse_x ((yyvsp[-1].scm), SCM_EOL);
		m->set_property ("elements", (yyvsp[-1].scm));
		(yyval.scm) = m->self_scm ();
	;}
    break;

  case 292:
#line 2250 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 293:
#line 2251 "parser.yy"
    { (yyval.i) = 1; ;}
    break;

  case 294:
#line 2255 "parser.yy"
    {
		if (!THIS->lexer_->is_note_state ())
			THIS->parser_error ((yylsp[-5]), _ ("have to be in Note mode for notes"));

		Music *n = 0;
		if ((yyvsp[0].i))
			n = MY_MAKE_MUSIC ("RestEvent");
		else
			n = MY_MAKE_MUSIC ("NoteEvent");
		
		n->set_property ("pitch", (yyvsp[-5].scm));
		n->set_property ("duration", (yyvsp[-1].scm));

		if (scm_is_number ((yyvsp[-2].scm)))
		{
			int q = scm_to_int ((yyvsp[-2].scm));
			n->set_property ("absolute-octave", scm_from_int (q-1));
		}

		if ((yyvsp[-3].i) % 2)
			n->set_property ("cautionary", SCM_BOOL_T);
		if ((yyvsp[-4].i) % 2 || (yyvsp[-3].i) % 2)
			n->set_property ("force-accidental", SCM_BOOL_T);

		Music *v = MY_MAKE_MUSIC ("EventChord");
		v->set_property ("elements", scm_list_1 (n->self_scm ()));
		n->unprotect ();

		v->set_spot ((yyloc));
		n->set_spot ((yyloc));
		(yyval.music) = v;
	;}
    break;

  case 295:
#line 2287 "parser.yy"
    {
		Music *n = MY_MAKE_MUSIC ("NoteEvent");
		n->set_property ("duration", (yyvsp[0].scm));
		n->set_property ("drum-type", (yyvsp[-1].scm));

		Music *v = MY_MAKE_MUSIC ("EventChord");
		v->set_property ("elements", scm_list_1 (n->self_scm ()));
		n->unprotect ();
		v->set_spot ((yyloc));
		n->set_spot ((yyloc));
		(yyval.music) = v;
		
	;}
    break;

  case 296:
#line 2300 "parser.yy"
    {
		Music *m = unsmob_music ((yyvsp[-1].scm));
		m->set_spot ((yyloc));
		for (SCM s = m->get_property ("elements"); scm_is_pair (s); s = scm_cdr (s))
		{
			unsmob_music (scm_car (s))->set_property ("duration", (yyvsp[0].scm));
		}
		(yyval.music) = m;
	;}
    break;

  case 297:
#line 2309 "parser.yy"
    {
		Music *ev = 0;
 		if (ly_scm2string ((yyvsp[-1].scm)) == "s") {
			/* Space */
			ev = MY_MAKE_MUSIC ("SkipEvent");
		  }
		else {
			ev = MY_MAKE_MUSIC ("RestEvent");
		
		    }
		ev->set_property ("duration", (yyvsp[0].scm));
		ev->set_spot ((yyloc));
 		Music *velt = MY_MAKE_MUSIC ("EventChord");
		velt->set_property ("elements", scm_list_1 (ev->self_scm ()));
		velt->set_spot ((yyloc));

		ev->unprotect();

 		(yyval.music) = velt;
	;}
    break;

  case 298:
#line 2329 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-multi-measure-rest");
		SCM mus = scm_call_2 (proc, (yyvsp[0].scm), make_input ((yyloc)));
		(yyval.music) = unsmob_music (mus);
		(yyval.music)->protect ();
	;}
    break;

  case 299:
#line 2336 "parser.yy"
    {
		if (!THIS->lexer_->is_lyric_state ())
			THIS->parser_error ((yylsp[-1]), _ ("have to be in Lyric mode for lyrics"));

		Music *levent = MY_MAKE_MUSIC ("LyricEvent");
		levent->set_property ("text", (yyvsp[-1].scm));
		levent->set_property ("duration",(yyvsp[0].scm));
		levent->set_spot ((yyloc));
		Music *velt = MY_MAKE_MUSIC ("EventChord");
		velt->set_property ("elements", scm_list_1 (levent->self_scm ()));

		(yyval.music)= velt;
	;}
    break;

  case 300:
#line 2349 "parser.yy"
    {
                if (!THIS->lexer_->is_chord_state ())
                        THIS->parser_error ((yylsp[0]), _ ("have to be in Chord mode for chords"));
                (yyval.music) = unsmob_music ((yyvsp[0].scm));
	;}
    break;

  case 301:
#line 2357 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 302:
#line 2360 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 303:
#line 2366 "parser.yy"
    {
		(yyval.scm) = make_chord ((yyvsp[-1].scm), (yyvsp[0].scm), SCM_EOL);
	;}
    break;

  case 304:
#line 2369 "parser.yy"
    {
		SCM its = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);
		(yyval.scm) = make_chord ((yyvsp[-3].scm), (yyvsp[-2].scm), scm_cons ((yyvsp[-1].scm), its));
	;}
    break;

  case 305:
#line 2376 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;		
	;}
    break;

  case 306:
#line 2379 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyval.scm));
	;}
    break;

  case 307:
#line 2385 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("chord-colon");
	;}
    break;

  case 308:
#line 2388 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("chord-caret");
	;}
    break;

  case 309:
#line 2391 "parser.yy"
    {
 		(yyval.scm) = scm_list_2 (ly_symbol2scm ("chord-slash"), (yyvsp[0].scm));
	;}
    break;

  case 310:
#line 2394 "parser.yy"
    {
		(yyval.scm) = scm_list_2 (ly_symbol2scm ("chord-bass"), (yyvsp[0].scm));
	;}
    break;

  case 311:
#line 2400 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 312:
#line 2403 "parser.yy"
    {
		(yyval.scm) = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);
	;}
    break;

  case 313:
#line 2406 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 314:
#line 2412 "parser.yy"
    { (yyval.scm) = scm_cons ((yyvsp[0].scm), SCM_EOL); ;}
    break;

  case 315:
#line 2413 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyval.scm));
	;}
    break;

  case 316:
#line 2419 "parser.yy"
    {
		(yyval.scm) = make_chord_step ((yyvsp[0].i), 0);
        ;}
    break;

  case 317:
#line 2422 "parser.yy"
    {
		(yyval.scm) = make_chord_step ((yyvsp[-1].i), SHARP);
	;}
    break;

  case 318:
#line 2425 "parser.yy"
    {
		(yyval.scm) = make_chord_step ((yyvsp[-1].i), FLAT);
	;}
    break;

  case 319:
#line 2437 "parser.yy"
    {
		(yyval.scm) = scm_sum ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 320:
#line 2440 "parser.yy"
    {
		(yyval.scm) = scm_difference ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 322:
#line 2447 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 323:
#line 2450 "parser.yy"
    {
		(yyval.scm) = scm_product ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 324:
#line 2453 "parser.yy"
    {
		(yyval.scm) = scm_divide ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 325:
#line 2459 "parser.yy"
    { /* %prec UNARY_MINUS */
		(yyval.scm) = scm_difference ((yyvsp[0].scm), SCM_UNDEFINED);
	;}
    break;

  case 327:
#line 2467 "parser.yy"
    {
		(yyval.scm) = scm_from_int ((yyvsp[0].i));
	;}
    break;

  case 328:
#line 2470 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 329:
#line 2473 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 330:
#line 2476 "parser.yy"
    {
		(yyval.scm) = scm_from_double (scm_to_double ((yyvsp[-1].scm)) *scm_to_double ((yyvsp[0].scm)));
	;}
    break;

  case 331:
#line 2479 "parser.yy"
    {
		(yyval.scm) = scm_from_double ((yyvsp[-1].i) *scm_to_double ((yyvsp[0].scm)));
	;}
    break;

  case 332:
#line 2486 "parser.yy"
    {
			(yyval.i) = (yyvsp[0].i);
	;}
    break;

  case 333:
#line 2489 "parser.yy"
    {
		(yyval.i) = (yyvsp[0].i);
	;}
    break;

  case 334:
#line 2495 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 335:
#line 2496 "parser.yy"
    { (yyval.i) ++; ;}
    break;

  case 336:
#line 2500 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 337:
#line 2501 "parser.yy"
    { (yyval.i) ++; ;}
    break;

  case 338:
#line 2509 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 339:
#line 2513 "parser.yy"
    { THIS->lexer_->push_markup_state (); ;}
    break;

  case 340:
#line 2514 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		THIS->lexer_->pop_state ();
	;}
    break;

  case 341:
#line 2521 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 342:
#line 2525 "parser.yy"
    { THIS->lexer_->push_markup_state (); ;}
    break;

  case 343:
#line 2526 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		THIS->lexer_->pop_state ();
	;}
    break;

  case 344:
#line 2533 "parser.yy"
    { 
		(yyval.scm) = scm_list_2 (ly_lily_module_constant ("line-markup"),  (yyvsp[0].scm)); 
	;}
    break;

  case 345:
#line 2536 "parser.yy"
    {
		(yyval.scm) = scm_car (scm_call_2 (ly_lily_module_constant ("map-markup-command-list"), (yyvsp[-1].scm), scm_list_1 ((yyvsp[0].scm))));
	;}
    break;

  case 346:
#line 2539 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 347:
#line 2545 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 348:
#line 2548 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 349:
#line 2554 "parser.yy"
    {
		(yyval.scm) = scm_call_2 (ly_lily_module_constant ("map-markup-command-list"), (yyvsp[-1].scm), (yyvsp[0].scm));
		
	;}
    break;

  case 350:
#line 2561 "parser.yy"
    {
		(yyval.scm) = scm_reverse_x ((yyvsp[-1].scm), SCM_EOL);
	;}
    break;

  case 351:
#line 2567 "parser.yy"
    {  (yyval.scm) = SCM_EOL; ;}
    break;

  case 352:
#line 2568 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 353:
#line 2571 "parser.yy"
    {
		(yyval.scm) = scm_append_x (scm_list_2 (scm_reverse_x ((yyvsp[0].scm), SCM_EOL), (yyvsp[-1].scm)));
	;}
    break;

  case 354:
#line 2577 "parser.yy"
    {
		(yyval.scm) = scm_list_1 ((yyvsp[0].scm));
	;}
    break;

  case 355:
#line 2580 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 356:
#line 2583 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 357:
#line 2589 "parser.yy"
    {
		(yyval.scm) = scm_list_1 ((yyvsp[0].scm));
	;}
    break;

  case 358:
#line 2592 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 359:
#line 2598 "parser.yy"
    {
		(yyval.scm) = make_simple_markup ((yyvsp[0].scm));
	;}
    break;

  case 360:
#line 2601 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 361:
#line 2604 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 362:
#line 2607 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 363:
#line 2610 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));
	;}
    break;

  case 364:
#line 2613 "parser.yy"
    {
		Score * sc = (yyvsp[-1].score);
		(yyval.scm) = scm_list_2 (ly_lily_module_constant ("score-markup"), sc->self_scm ());
		sc->unprotect ();
		THIS->lexer_->pop_state ();
	;}
    break;

  case 365:
#line 2619 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 366:
#line 2622 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-3].scm), (yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 367:
#line 2625 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 368:
#line 2628 "parser.yy"
    {
		(yyval.scm) = scm_list_1 ((yyvsp[0].scm));
	;}
    break;

  case 369:
#line 2631 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm),(yyvsp[0].scm));
	;}
    break;

  case 370:
#line 2634 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 371:
#line 2640 "parser.yy"
    {
		SCM mapper = ly_lily_module_constant ("map-markup-command-list");
		(yyval.scm) = scm_car (scm_call_2 (mapper, (yyvsp[-1].scm), scm_list_1 ((yyvsp[0].scm))));
	;}
    break;

  case 372:
#line 2644 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;


      default: break;
    }

/* Line 1052 of yacc.c.  */
#line 5543 "out/parser.cc"

  yyvsp -= yylen;
  yyssp -= yylen;
  yylsp -= yylen;

  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  int yytype = YYTRANSLATE (yychar);
	  YYSIZE_T yysize0 = yystrlen (yytname[yytype]);
	  YYSIZE_T yysize = yysize0;
	  YYSIZE_T yysize1;
	  int yysize_overflow = 0;
	  char *yymsg = 0;
#	  define YYERROR_VERBOSE_ARGS_MAXIMUM 5
	  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
	  int yyx;

#if 0
	  /* This is so xgettext sees the translatable formats that are
	     constructed on the fly.  */
	  _("syntax error, unexpected %s");
	  _("syntax error, unexpected %s, expecting %s");
	  _("syntax error, unexpected %s, expecting %s or %s");
	  _("syntax error, unexpected %s, expecting %s or %s or %s");
	  _("syntax error, unexpected %s, expecting %s or %s or %s or %s");
#endif
	  char *yyfmt;
	  char const *yyf;
	  static char const yyunexpected[] = "syntax error, unexpected %s";
	  static char const yyexpecting[] = ", expecting %s";
	  static char const yyor[] = " or %s";
	  char yyformat[sizeof yyunexpected
			+ sizeof yyexpecting - 1
			+ ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
			   * (sizeof yyor - 1))];
	  char const *yyprefix = yyexpecting;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 1;

	  yyarg[0] = yytname[yytype];
	  yyfmt = yystpcpy (yyformat, yyunexpected);

	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
		  {
		    yycount = 1;
		    yysize = yysize0;
		    yyformat[sizeof yyunexpected - 1] = '\0';
		    break;
		  }
		yyarg[yycount++] = yytname[yyx];
		yysize1 = yysize + yystrlen (yytname[yyx]);
		yysize_overflow |= yysize1 < yysize;
		yysize = yysize1;
		yyfmt = yystpcpy (yyfmt, yyprefix);
		yyprefix = yyor;
	      }

	  yyf = _(yyformat);
	  yysize1 = yysize + strlen (yyf);
	  yysize_overflow |= yysize1 < yysize;
	  yysize = yysize1;

	  if (!yysize_overflow && yysize <= YYSTACK_ALLOC_MAXIMUM)
	    yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg)
	    {
	      /* Avoid sprintf, as that infringes on the user's name space.
		 Don't have undefined behavior even if the translation
		 produced a string with the wrong number of "%s"s.  */
	      char *yyp = yymsg;
	      int yyi = 0;
	      while ((*yyp = *yyf))
		{
		  if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		    {
		      yyp = yystpcpy (yyp, yyarg[yyi++]);
		      yyf += 2;
		    }
		  else
		    {
		      yyp++;
		      yyf++;
		    }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror (_("syntax error; also memory exhausted"));
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror (_("syntax error"));
    }

  yyerror_range[0] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
                 yyerror_range[0] = *yylsp;
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 yydestruct (_("Error: popping"),
                             yystos[*yyssp], yyvsp, yylsp);
	       }
        }
      else
	{
	  yydestruct (_("Error: discarding"), yytoken, &yylval, &yylloc);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (0)
     goto yyerrorlab;

  yyerror_range[0] = yylsp[1-yylen];
  yylsp -= yylen;
  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      yyerror_range[0] = *yylsp;
      yydestruct (_("Error: popping"), yystos[yystate], yyvsp, yylsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;

  yyerror_range[1] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the look-ahead.  YYLOC is available though. */
  YYLLOC_DEFAULT (yyloc, yyerror_range - 1, 2);
  *++yylsp = yyloc;

  /* Shift the error token. */
  YY_SYMBOL_PRINT (_("Shifting"), yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yydestruct (_("Error: discarding lookahead"),
              yytoken, &yylval, &yylloc);
  yychar = YYEMPTY;
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror (_("parser stack overflow"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 2649 "parser.yy"


void
Lily_parser::set_yydebug (bool )
{
#if 0
	yydebug = 1;
#endif
}

void
Lily_parser::do_yyparse ()
{
	yyparse ((void*)this);
}





/*

It is a little strange to have this function in this file, but
otherwise, we have to import music classes into the lexer.

*/
int
Lily_lexer::try_special_identifiers (SCM *destination, SCM sid)
{
	if (scm_is_string (sid)) {
		*destination = sid;
		return STRING_IDENTIFIER;
	} else if (scm_is_number (sid)) {
		*destination = sid;
		return NUMBER_IDENTIFIER;
	} else if (unsmob_context_def (sid)) {
		*destination = unsmob_context_def (sid)->clone_scm ();
		return CONTEXT_DEF_IDENTIFIER;
	} else if (unsmob_score (sid)) {
		Score *score = new Score (*unsmob_score (sid));
		*destination = score->self_scm ();
		return SCORE_IDENTIFIER;
	} else if (Music *mus = unsmob_music (sid)) {
		mus = mus->clone ();
		*destination = mus->self_scm ();
		unsmob_music (*destination)->
			set_property ("origin", make_input (last_input_));

		bool is_event = scm_memq (ly_symbol2scm ("event"), mus->get_property ("types"))
			!= SCM_BOOL_F;

		return is_event ? EVENT_IDENTIFIER : MUSIC_IDENTIFIER;
	} else if (unsmob_duration (sid)) {
		*destination = unsmob_duration (sid)->smobbed_copy ();
		return DURATION_IDENTIFIER;
	} else if (unsmob_output_def (sid)) {
		Output_def *p = unsmob_output_def (sid);
		p = p->clone ();

		*destination = p->self_scm ();
		return OUTPUT_DEF_IDENTIFIER;
	} else if (Text_interface::is_markup (sid)) {
		*destination = sid;
		if (is_lyric_state ())
			return LYRIC_MARKUP_IDENTIFIER;
		return MARKUP_IDENTIFIER;
	}

	return -1;	
}

Music *
property_op_to_music (SCM op)
{
	Music *m = 0;
	SCM tag = scm_car (op);
	SCM symbol = scm_cadr (op);
	SCM args = scm_cddr (op);
	SCM grob_val = SCM_UNDEFINED;
	SCM grob_sym = SCM_UNDEFINED;
	SCM val = SCM_UNDEFINED;
	
	if (tag == ly_symbol2scm ("assign"))
		{
		m = MY_MAKE_MUSIC ("PropertySet");
		val = scm_car (args);
		}
	else if (tag == ly_symbol2scm ("unset"))
		m = MY_MAKE_MUSIC ("PropertyUnset");
	else if (tag == ly_symbol2scm ("poppush")
		 || tag == ly_symbol2scm ("push"))
		{
		m = MY_MAKE_MUSIC ("OverrideProperty");
		grob_sym = scm_car (args);
		grob_val = scm_cadr (args);
		}
	else if (tag == ly_symbol2scm ("pop")) {
		m = MY_MAKE_MUSIC ("RevertProperty");
		grob_sym = scm_car (args);
		}

	m->set_property ("symbol", symbol);

	if (val != SCM_UNDEFINED)
		m->set_property ("value", val);
	if (grob_val != SCM_UNDEFINED)
		m->set_property ("grob-value", grob_val);

	if (grob_sym != SCM_UNDEFINED)
		{
		bool itc = do_internal_type_checking_global;
		/* UGH.
		*/
		bool autobeam = ly_is_equal (symbol, ly_symbol2scm ("autoBeamSettings"));
		if (autobeam)
			do_internal_type_checking_global = false;
		m->set_property ("grob-property", grob_sym);
		if (autobeam)
			do_internal_type_checking_global = itc;
		}

	if (tag == ly_symbol2scm ("poppush"))
		m->set_property ("pop-first", SCM_BOOL_T);


	return m;
}

Music*
context_spec_music (SCM type, SCM id, Music *m, SCM ops)
{
	Music *csm = MY_MAKE_MUSIC ("ContextSpeccedMusic");

	csm->set_property ("element", m->self_scm ());
	m->unprotect ();

	csm->set_property ("context-type",
		scm_is_symbol (type) ? type : scm_string_to_symbol (type));
	csm->set_property ("property-operations", ops);

	if (scm_is_string (id))
		csm->set_property ("context-id", id);
	return csm;
}

SCM
get_next_unique_context_id ()
{
	return scm_makfrom0str ("$uniqueContextId");
}


SCM
get_next_unique_lyrics_context_id ()
{
	static int new_context_count;
	char s[128];
	snprintf (s, 1024, "uniqueContext%d", new_context_count++);
	return scm_makfrom0str (s);
}


