/*   
  font-metric.hh -- declare Font_metric
  
  source file of the GNU LilyPond music typesetter
  
  (c) 1999--2004 Han-Wen Nienhuys <hanwen@cs.uu.nl>
  
 */

#ifndef FONT_METRIC_HH
#define FONT_METRIC_HH

#include "box.hh"
#include "smobs.hh"
#include "lily-proto.hh"

struct Font_metric
{
public:
  SCM description_;
  String file_name_;
  
  virtual int count () const;
  virtual Offset attachment_point (String) const;
  virtual Offset get_indexed_wxwy (int) const;
  virtual Box get_indexed_char (int index) const;
  virtual Box get_ascii_char (int ascii) const;
  virtual int name_to_index (String) const;
  virtual unsigned index_to_charcode (int) const;
  virtual int index_to_ascii (int) const;
  virtual Real design_size () const;
  virtual Stencil find_by_name (String) const;
  virtual Stencil get_indexed_char_stencil (int k) const;
  virtual Stencil get_ascii_char_stencil (int k) const;
  virtual String coding_scheme () const;
  virtual SCM sub_fonts () const;
  
  DECLARE_SMOBS (Font_metric,);

private:
  /* No copying, no implicit copy constructor.  */
  Font_metric (Font_metric const&);

protected:
  virtual void derived_mark () const;

  Font_metric ();
};

int get_encoded_index (Font_metric *m, String input_coding, int code);

struct Simple_font_metric : public Font_metric
{
public:
  
};
  

DECLARE_UNSMOB(Font_metric, metrics);

#endif /* FONT_METRIC_HH */
