%define info yes

%define name lilypond
%define version 2.5.23
%define release 4mdk

Summary:	A program for printing sheet music.
Name:		%{name}
Version:	%{version}
Release:	%{release}
License:	GPL
Group:		Publishing
URL:		http://www.lilypond.org/
Source0:	ftp.lilypond.org:/pub/LilyPond/development/lilypond-%{version}.tar.bz2
BuildRoot:	%{_tmppath}/%{name}-buildroot
BuildRequires:	t1utils bison texinfo t1lib1-devel libstdc++5-devel libguile12-devel >= 1.6.4
BuildRequires:	gcc-c++ glibc-devel flex >= 2.5.4a-22mdk groff netpbm autotrace
BuildRequires:  ImageMagick >= 5.5.4.4 libMagick5.5.4-devel >= 5.5.4.4
BuildRequires:	ghostscript >= 7.05-53.2mdk mftrace >= 1.0.19 pfaedit >= 030822
Requires:	tetex tetex-latex chkfontpath XFree86 info-install
PreReq:		chkfontpath
 

%description
LilyPond is a music typesetter.  It produces beautiful sheet music using a
high level description file as input.  LilyPond is part of the GNU project.
 
LilyPond is split into two packages.  The package "lilypond" provides the
core package, containing the utilities for converting the music source
(.ly) files into printable output.  The package "lilypond-documentation" 
provides the full documentation, example .ly files for various features and 
the Mutopia project files (musical equivalent of the Gutenberg project - see
http://www.mutopiaproject.org for details).
 
If you are new to lilypond, you will almost certainly want to install the
"lilypond-documentation" package in addition to the "lilypond" package.

%package -n liblilypond
Summary: LilyPond libraries.
License: GPL
Group: System/Libraries
Requires: lilypond >= %{version}

%description -n liblilypond
LilyPond libs
 
%package documentation
Summary: LilyPond documentation, examples and Mutopia files.
Group: Publishing
Requires: %{name}

%description documentation
The documentation of LilyPond, both in HTML and PostScript, along with
example input files and the files from the Mutopia project.

%prep
rm -rf $RPM_BUILD_ROOT

%setup

%build
# DO NOT use % { configure } , it hardcodes all paths, runs libtool,
# so we can't do make prefix=/tmp/ install.
# -- not sure what this comment means; it's a relic from the PPC spec file -- mbrown@fensystems.co.uk
##./configure --disable-checking --disable-debugging --enable-printing --prefix=%{_prefix} --disable-optimising --enable-shared
## Add options if needed

#Fix conflicting php variable out=/dev/vc/
unset out

./configure --disable-checking --prefix=%{_prefix} --libdir=%{_libdir} --enable-optimising

%make  all

# make info
make -C Documentation

# make  html
make web
make -C Documentation/user omf

%install

#Fix conflicting php variable out=/dev/vc/
unset out

# Create installation root folders
rm -rf $RPM_BUILD_ROOT
RPM_DOC_ROOT=$RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
rm -rf $RPM_DOC_ROOT
mkdir -p $RPM_DOC_ROOT

strip lily/out/lilypond 
%makeinstall 
local_lilypond_libdir=$RPM_BUILD_ROOT/%{_libdir}/%{name}/%{version}

%if %{info}
  rm -f $RPM_BUILD_ROOT/%{_infodir}/dir
  bzip2 $RPM_BUILD_ROOT%{_infodir}/*
%endif

mkdir -p $RPM_BUILD_ROOT%{_datadir}/emacs/site-lisp/site-start.d
install -m 644 elisp/lilypond-init.el $RPM_BUILD_ROOT%{_datadir}/emacs/site-lisp/site-start.d

bzip2 $RPM_BUILD_ROOT%{_mandir}/man1/*

mkdir -p $RPM_BUILD_ROOT%{_prefix}/../etc/profile.d
cp buildscripts/out/lilypond-profile $RPM_BUILD_ROOT%{_prefix}/../etc/profile.d/lilypond.sh
cp buildscripts/out/lilypond-login $RPM_BUILD_ROOT%{_prefix}/../etc/profile.d/lilypond.csh

make prefix="$RPM_BUILD_ROOT%{_prefix}" webdir="$RPM_BUILD_ROOT%{_prefix}/share/doc/%{name}-documentation-%{version}/" out=www web-install

# Menu
# Every entry must be changed according package specifications
# Pay attention to "section" "command" and "longtitle"

mkdir -p $RPM_BUILD_ROOT%{_menudir}
cat >$RPM_BUILD_ROOT%{_menudir}/%{name} <<EOF
?package(%name):\
  command="info %{name}"\
  needs="text"\
  icon="%{name}.png"\
  section="Documentation"\
  title="%{name}-info"\
  longtitle="%{name} Info"
EOF
  
cat >$RPM_BUILD_ROOT%{_menudir}/%{name}-documentation <<EOF
?package(%name):\
  command="\$BROWSER %{_docdir}/%{name}-documentation-%{version}/index.html"\
  needs="X11"\
  icon="%{name}.png"\
  section="Documentation"\
  title="%{name}-documentation"\
  longtitle="%{name} Documentation"
EOF

# icon
install -d $RPM_BUILD_ROOT/%{_iconsdir}
install -m 644 Documentation/pictures/out-www/lelie-logo.png $RPM_BUILD_ROOT/%{_iconsdir}/%{name}.png

%{find_lang} %{name}

%post
%{update_menus}

touch /tmp/.lilypond-install
rm `find /var/lib/texmf -name 'feta*pk' -or -name 'feta*tfm' -or -name 'parmesan*pk' -or -name 'parmesan*tfm' -print` /tmp/.lilypond-install

%if %{info}
  /sbin/install-info --quiet %{_infodir}/lilypond.info.bz2 %{_infodir}/dir 
%endif

/usr/X11R6/bin/mkfontdir %{_datadir}/lilypond/%{version}/fonts/type1/
chkfontpath --add=%{_datadir}/lilypond/%{version}/fonts/type1/

%post documentation
%{update_menus}
scrollkeeper-update

%preun

%if %{info}
  if [ $1 = 0 ]; then
    /sbin/install-info --quiet --delete %{_infodir}/lilypond.info.bz2 %{_infodir}/dir 
  fi
%endif

rm -f %{_datadir}/lilypond/%{version}/fonts/type1/fonts.dir
chkfontpath --remove=%{_datadir}/lilypond/%{version}/fonts/type1/

%postun
%{clean_menus}

%postun documentation
%{clean_menus}
scrollkeeper-update

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-, root, root)
%doc COPYING README.txt INSTALL.txt DEDICATION NEWS.txt AUTHORS.txt THANKS

%{_datadir}/emacs/site-lisp/site-start.d/lilypond-*
%{_datadir}/emacs/site-lisp/lilypond*

%if %{info}
  %{_infodir}/*
%endif

%{_datadir}/%{name}/%{version}/
%{_datadir}/locale/*/LC_MESSAGES/lilypond.mo
%{_prefix}/../etc/profile.d/lilypond.*
%_bindir/*
%_mandir/*
%_menudir/*
%_iconsdir/%{name}.*

%files -n liblilypond
%defattr(-,root,root)
%{_libdir}/%{name}/%{version}/python/*.so

%files documentation
%defattr(-, root, root)

%{_docdir}/*
%{_datadir}/omf/lilypond/%{version}
%{_menudir}/%{name}-documentation

%changelog
* Thu Sep 01 2003 Heikki Johannes Junes <hjunes@cc.hut.fi> 1.8.4-4mdk
- add target lilypond.words.

* Sun Aug 25 2003 Torbjorn Turpeinen <tobbe@nyvalls.se> 1.8.1-3mdk
- Fixed doc-path in menu.

* Thu Aug 23 2003 Heikki Johannes Junes <hjunes@cc.hut.fi> 1.8.1-1mdk
* Sun Aug 24 2003 Torbjorn Turpeinen <tobbe@nyvalls.se> 1.8.1-2mdk
- Added Heikki Johannes Junes fix for confilcting PHP variable
  out=/dev/vc/ by adding unset out before compiling
- Compiled with recent guile = 1.6.4 and mftrace = 1.0.19
- Changed icon to lilypond.png
- Added menu and icons again

* Thu Aug 07 2003 Heikki Johannes Junes <hjunes@cc.hut.fi> 1.8.0-1mdk
- removed menu and icons, sync with redhat-spec

* Thu Jun 12 2003 Heikki Johannes Junes <hjunes@cc.hut.fi> 1.7.23-1mdk
- refreshed dependencies and file list.

* Sat Feb 01 2003 Torbjorn Turpeinen <tobbe@nyvalls.se> 1.7.12-1mdk
- Built for Mandrake 9.1

* Fri Dec 01 2002 Heikki Johannes Junes <hjunes@cc.hut.fi> 1.7.9-1mdk
- set menu-items to lilypond-info and lilypond-documentation.

* Fri Nov 30 2002 Heikki Johannes Junes <hjunes@cc.hut.fi> 1.7.8-4mdk
- add pre/post-dependencies and menus with icon from source.

* Fri Oct 28 2002 Heikki Johannes Junes <hjunes@cc.hut.fi> 1.7.4-1mdk
- info, commented menu

* Fri Aug 30 2002 Heikki Johannes Junes <hjunes@cc.hut.fi> 1.6.0-1mdk
- Adapted from lilypond.redhat.skel and skeleton found in Mandrake's RPM-docs.
- TODO: info (?) and dependencies.

* Fri Jun 01 2001 Lenny Cartier <lenny@mandrakesoft.com> 1.4.2-1mdk
- updated by Michael Brown <mbrown@linux-mandrake.com> :
	- Upgraded to 1.4.2
	- Changed URL
	- Removed /etc/profile.d scripts: all TeX bits are now located properly
	- Rearranged documentation
	- Tidied spec file
	- Updated README.first

* Mon Feb 26 2001 Lenny Cartier <lenny@mandrakesoft.com> 1.3.129-1mdk
- added in contribs by Michael Brown <mbrown@fensystems.co.uk> :
	- Removed info files completely (couldn't get info reader to read them)
	- TODO: Get this to work at some point (in the meantime, use documentation in lilypond-extras)

* Sat Feb 17 2001 Michael Brown <mbrown@fensystems.co.uk>
- Moved TeX font folders into the system TeX tree (this ensures that the /var/lib/texmf font cache is used instead of current folder)
- Added mktexlsr to post-install and post-uninstall scripts
- Patched scripts in /etc/profile.d to reflect changes to font locations
- Added QuickStart guide and Points to note sections to README.first (well worth reading)
- Fixed install-info and uninstall-info sections to use Mandrake's RPM macros :-)

* Tue Feb 13 2001 Michael Brown <mbrown@fensystems.co.uk>
- First Mandrake package
- spec file heavily adapted from PowerPC contribs.
- Note HTML documentation may contain duff links and may be incomplete.  Lots of warnings appear when building HTML docs.
- PostScript documentation is duplicated (how do you get an rpm package to contain a symlink?)
- Created README.first file
