/* A Bison parser, made by GNU Bison 2.0a.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 1



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ADDLYRICS = 258,
     ACCEPTS = 259,
     ADDQUOTE = 260,
     ALIAS = 261,
     ALTERNATIVE = 262,
     BAR = 263,
     BOOK = 264,
     CHANGE = 265,
     CHORDMODE = 266,
     CHORDS = 267,
     CLEF = 268,
     CONSISTS = 269,
     CONTEXT = 270,
     DEFAULT = 271,
     DENIES = 272,
     DESCRIPTION = 273,
     DRUMMODE = 274,
     DRUMS = 275,
     FIGUREMODE = 276,
     FIGURES = 277,
     GROBDESCRIPTIONS = 278,
     HEADER = 279,
     INVALID = 280,
     KEY = 281,
     LAYOUT = 282,
     LYRICMODE = 283,
     LYRICS = 284,
     LYRICSTO = 285,
     MARK = 286,
     MARKUP = 287,
     MIDI = 288,
     NAME = 289,
     NOTEMODE = 290,
     OBJECTID = 291,
     OCTAVE = 292,
     ONCE = 293,
     OVERRIDE = 294,
     PAPER = 295,
     PARTIAL = 296,
     RELATIVE = 297,
     REMOVE = 298,
     REPEAT = 299,
     REST = 300,
     REVERT = 301,
     SCORE = 302,
     SEQUENTIAL = 303,
     SET = 304,
     SIMULTANEOUS = 305,
     SKIP = 306,
     TAG = 307,
     TEMPO = 308,
     TIMES = 309,
     TRANSPOSE = 310,
     TRANSPOSITION = 311,
     TYPE = 312,
     UNSET = 313,
     WITH = 314,
     TIME_T = 315,
     NEWCONTEXT = 316,
     CHORD_BASS = 317,
     CHORD_CARET = 318,
     CHORD_COLON = 319,
     CHORD_MINUS = 320,
     CHORD_SLASH = 321,
     DOUBLE_ANGLE_CLOSE = 322,
     DOUBLE_ANGLE_OPEN = 323,
     E_BACKSLASH = 324,
     E_ANGLE_CLOSE = 325,
     E_CHAR = 326,
     E_CLOSE = 327,
     E_EXCLAMATION = 328,
     E_BRACKET_OPEN = 329,
     E_OPEN = 330,
     E_BRACKET_CLOSE = 331,
     E_ANGLE_OPEN = 332,
     E_TILDE = 333,
     EXTENDER = 334,
     FIGURE_CLOSE = 335,
     FIGURE_OPEN = 336,
     FIGURE_SPACE = 337,
     HYPHEN = 338,
     CHORDMODIFIERS = 339,
     COMMANDSPANREQUEST = 340,
     LYRIC_MARKUP = 341,
     MULTI_MEASURE_REST = 342,
     SCM_T = 343,
     DIGIT = 344,
     E_UNSIGNED = 345,
     UNSIGNED = 346,
     IDENTIFIER = 347,
     CHORDMODIFIER_PITCH = 348,
     CHORD_MODIFIER = 349,
     CONTEXT_DEF_IDENTIFIER = 350,
     DRUM_PITCH = 351,
     DURATION_IDENTIFIER = 352,
     EVENT_IDENTIFIER = 353,
     FRACTION = 354,
     LYRICS_STRING = 355,
     LYRIC_MARKUP_IDENTIFIER = 356,
     MARKUP_HEAD_EMPTY = 357,
     MARKUP_HEAD_LIST0 = 358,
     MARKUP_HEAD_MARKUP0 = 359,
     MARKUP_HEAD_MARKUP0_MARKUP1 = 360,
     MARKUP_HEAD_SCM0 = 361,
     MARKUP_HEAD_SCM0_MARKUP1 = 362,
     MARKUP_HEAD_SCM0_SCM1 = 363,
     MARKUP_HEAD_SCM0_SCM1_MARKUP2 = 364,
     MARKUP_HEAD_SCM0_SCM1_SCM2 = 365,
     MARKUP_IDENTIFIER = 366,
     MUSIC_FUNCTION = 367,
     MUSIC_FUNCTION_MARKUP = 368,
     MUSIC_FUNCTION_MARKUP_MARKUP = 369,
     MUSIC_FUNCTION_MARKUP_MARKUP_MUSIC = 370,
     MUSIC_FUNCTION_MARKUP_MUSIC = 371,
     MUSIC_FUNCTION_MARKUP_MUSIC_MUSIC = 372,
     MUSIC_FUNCTION_MUSIC = 373,
     MUSIC_FUNCTION_MUSIC_MUSIC = 374,
     MUSIC_FUNCTION_SCM = 375,
     MUSIC_FUNCTION_SCM_MUSIC = 376,
     MUSIC_FUNCTION_SCM_MUSIC_MUSIC = 377,
     MUSIC_FUNCTION_SCM_SCM = 378,
     MUSIC_FUNCTION_SCM_SCM_MUSIC = 379,
     MUSIC_IDENTIFIER = 380,
     NOTENAME_PITCH = 381,
     NUMBER_IDENTIFIER = 382,
     OUTPUT_DEF_IDENTIFIER = 383,
     REAL = 384,
     RESTNAME = 385,
     SCM_IDENTIFIER = 386,
     SCORE_IDENTIFIER = 387,
     STRING = 388,
     STRING_IDENTIFIER = 389,
     TONICNAME_PITCH = 390,
     UNARY_MINUS = 391
   };
#endif
#define ADDLYRICS 258
#define ACCEPTS 259
#define ADDQUOTE 260
#define ALIAS 261
#define ALTERNATIVE 262
#define BAR 263
#define BOOK 264
#define CHANGE 265
#define CHORDMODE 266
#define CHORDS 267
#define CLEF 268
#define CONSISTS 269
#define CONTEXT 270
#define DEFAULT 271
#define DENIES 272
#define DESCRIPTION 273
#define DRUMMODE 274
#define DRUMS 275
#define FIGUREMODE 276
#define FIGURES 277
#define GROBDESCRIPTIONS 278
#define HEADER 279
#define INVALID 280
#define KEY 281
#define LAYOUT 282
#define LYRICMODE 283
#define LYRICS 284
#define LYRICSTO 285
#define MARK 286
#define MARKUP 287
#define MIDI 288
#define NAME 289
#define NOTEMODE 290
#define OBJECTID 291
#define OCTAVE 292
#define ONCE 293
#define OVERRIDE 294
#define PAPER 295
#define PARTIAL 296
#define RELATIVE 297
#define REMOVE 298
#define REPEAT 299
#define REST 300
#define REVERT 301
#define SCORE 302
#define SEQUENTIAL 303
#define SET 304
#define SIMULTANEOUS 305
#define SKIP 306
#define TAG 307
#define TEMPO 308
#define TIMES 309
#define TRANSPOSE 310
#define TRANSPOSITION 311
#define TYPE 312
#define UNSET 313
#define WITH 314
#define TIME_T 315
#define NEWCONTEXT 316
#define CHORD_BASS 317
#define CHORD_CARET 318
#define CHORD_COLON 319
#define CHORD_MINUS 320
#define CHORD_SLASH 321
#define DOUBLE_ANGLE_CLOSE 322
#define DOUBLE_ANGLE_OPEN 323
#define E_BACKSLASH 324
#define E_ANGLE_CLOSE 325
#define E_CHAR 326
#define E_CLOSE 327
#define E_EXCLAMATION 328
#define E_BRACKET_OPEN 329
#define E_OPEN 330
#define E_BRACKET_CLOSE 331
#define E_ANGLE_OPEN 332
#define E_TILDE 333
#define EXTENDER 334
#define FIGURE_CLOSE 335
#define FIGURE_OPEN 336
#define FIGURE_SPACE 337
#define HYPHEN 338
#define CHORDMODIFIERS 339
#define COMMANDSPANREQUEST 340
#define LYRIC_MARKUP 341
#define MULTI_MEASURE_REST 342
#define SCM_T 343
#define DIGIT 344
#define E_UNSIGNED 345
#define UNSIGNED 346
#define IDENTIFIER 347
#define CHORDMODIFIER_PITCH 348
#define CHORD_MODIFIER 349
#define CONTEXT_DEF_IDENTIFIER 350
#define DRUM_PITCH 351
#define DURATION_IDENTIFIER 352
#define EVENT_IDENTIFIER 353
#define FRACTION 354
#define LYRICS_STRING 355
#define LYRIC_MARKUP_IDENTIFIER 356
#define MARKUP_HEAD_EMPTY 357
#define MARKUP_HEAD_LIST0 358
#define MARKUP_HEAD_MARKUP0 359
#define MARKUP_HEAD_MARKUP0_MARKUP1 360
#define MARKUP_HEAD_SCM0 361
#define MARKUP_HEAD_SCM0_MARKUP1 362
#define MARKUP_HEAD_SCM0_SCM1 363
#define MARKUP_HEAD_SCM0_SCM1_MARKUP2 364
#define MARKUP_HEAD_SCM0_SCM1_SCM2 365
#define MARKUP_IDENTIFIER 366
#define MUSIC_FUNCTION 367
#define MUSIC_FUNCTION_MARKUP 368
#define MUSIC_FUNCTION_MARKUP_MARKUP 369
#define MUSIC_FUNCTION_MARKUP_MARKUP_MUSIC 370
#define MUSIC_FUNCTION_MARKUP_MUSIC 371
#define MUSIC_FUNCTION_MARKUP_MUSIC_MUSIC 372
#define MUSIC_FUNCTION_MUSIC 373
#define MUSIC_FUNCTION_MUSIC_MUSIC 374
#define MUSIC_FUNCTION_SCM 375
#define MUSIC_FUNCTION_SCM_MUSIC 376
#define MUSIC_FUNCTION_SCM_MUSIC_MUSIC 377
#define MUSIC_FUNCTION_SCM_SCM 378
#define MUSIC_FUNCTION_SCM_SCM_MUSIC 379
#define MUSIC_IDENTIFIER 380
#define NOTENAME_PITCH 381
#define NUMBER_IDENTIFIER 382
#define OUTPUT_DEF_IDENTIFIER 383
#define REAL 384
#define RESTNAME 385
#define SCM_IDENTIFIER 386
#define SCORE_IDENTIFIER 387
#define STRING 388
#define STRING_IDENTIFIER 389
#define TONICNAME_PITCH 390
#define UNARY_MINUS 391




/* Copy the first part of user declarations.  */
#line 1 "parser.yy"
 // -*-Fundamental-*-

/*
  parser.yy -- Bison/C++ parser for LilyPond

  source file of the GNU LilyPond music typesetter

  (c) 1997--2005 Han-Wen Nienhuys <hanwen@cs.uu.nl>
                 Jan Nieuwenhuizen <janneke@gnu.org>
*/

/*
FIXME:

   * The rules for who is protecting what are very shady.  Uniformise
     this.

   * There are too many lexical modes?
*/

#include "config.hh"

#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>


#include "book.hh"
#include "context-def.hh"
#include "dimensions.hh"
#include "event.hh"
#include "file-path.hh"
#include "input-smob.hh"
#include "input.hh"
#include "lily-guile.hh"
#include "lilypond-input-version.hh"
#include "main.hh"
#include "misc.hh"
#include "lily-lexer.hh"
#include "lily-parser.hh"
#include "paper-book.hh"
#include "output-def.hh"
#include "scm-hash.hh"
#include "scm-option.hh"
#include "score.hh"
#include "text-item.hh"
#include "warn.hh"

#define MY_MAKE_MUSIC(x)  make_music_by_name (ly_symbol2scm (x))

Music *property_op_to_music (SCM op);
Music *context_spec_music (SCM type, SCM id, Music *m, SCM ops);
SCM get_next_unique_context_id ();
SCM get_next_unique_lyrics_context_id ();

#undef _
#if !HAVE_GETTEXT
#define _(x) x
#else
#include <libintl.h>
#define _(x) gettext (x)
#endif

#define YYERROR_VERBOSE 1

#define YYPARSE_PARAM my_lily_parser
#define YYLEX_PARAM my_lily_parser
#define THIS\
	((Lily_parser *) my_lily_parser)

#define yyerror THIS->parser_error

/* We use custom location type: Input objects */
#define YYLTYPE Input
#define YYLLOC_DEFAULT(Current,Rhs,N) \
	((Current).set_location ((Rhs)[1], (Rhs)[N]))


/* Add symbols to the TAGS field of a music object.  */

void
tag_music (Music *m, SCM tag, Input ip)
{
	SCM tags = m->get_property ("tags");
	if (scm_is_symbol (tag))
		tags = scm_cons (tag, tags);
	else if (ly_c_list_p (tag))
		tags = ly_append2 (tag, tags);
	else
		ip.warning (_ ("tag must be symbol or list of symbols"));

	m->set_property ("tags", tags);
}

bool
is_regular_identifier (SCM id)
{
  String str = ly_scm2string (id);
  char const *s = str.to_str0 ();

  bool v = true;
#if 0
  isalpha (*s);
  s++;
#endif
  while (*s && v)
   {
        v = v && isalnum (*s);
        s++;
   }
  return v;
}


SCM
get_first_context_id (SCM type, Music *m)
{
	SCM id = m->get_property ("context-id");
	if (SCM_BOOL_T == scm_equal_p (m->get_property ("context-type"), type)
	    && scm_is_string (m->get_property ("context-id"))
	    && scm_c_string_length (id) > 0)
	{
		return id;
	}
	return SCM_EOL;
}

SCM
make_simple_markup (SCM a)
{
	SCM simple = ly_lily_module_constant ("simple-markup");
	return scm_list_2 (simple, a);
}

bool
is_duration (int t)
{
  return t && t == 1 << intlog2 (t);
}

void
set_music_properties (Music *p, SCM a)
{
  for (SCM k = a; scm_is_pair (k); k = scm_cdr (k))
 	p->internal_set_property (scm_caar (k), scm_cdar (k));
}

SCM
make_chord_step (int step, int alter)
{
	if (step == 7)
		alter += FLAT;

	while (step < 0)
		step += 7;
	Pitch m ((step -1) / 7, (step - 1) % 7, alter);
	return m.smobbed_copy ();
}


SCM
make_chord (SCM pitch, SCM dur, SCM modification_list)
{
	SCM chord_ctor = ly_lily_module_constant ("construct-chord");
	SCM ch = scm_call_3 (chord_ctor, pitch, dur, modification_list);
	scm_gc_protect_object (ch);
	return ch;
}

/* Todo: actually also use apply iso. call too ...  */
bool
ly_input_procedure_p (SCM x)
{
	return ly_c_procedure_p (x)
		|| (scm_is_pair (x) && ly_c_procedure_p (scm_car (x)));
}

Music*
set_property_music (SCM sym, SCM value)
{
	Music *p = MY_MAKE_MUSIC ("PropertySet");
	p->set_property ("symbol", sym);
	p->set_property ("value", value);
	return p;
}

Music*
make_music_relative (Pitch start, Music *music)
{
	Music *relative = MY_MAKE_MUSIC ("RelativeOctaveMusic");
 	relative->set_property ("element", music->self_scm ());
	
 	Pitch last = music->to_relative_octave (start);
 	if (lily_1_8_relative)
 		music->set_property ("last-pitch", last.smobbed_copy ());
	return relative;
}

Music*
make_lyric_combine_music (SCM name, Music *music)
{
	Music *combine = MY_MAKE_MUSIC ("NewLyricCombineMusic");
	combine->set_property ("element", music->self_scm ());
 	combine->set_property ("associated-context", name);
	return combine;
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 216 "parser.yy"
typedef union YYSTYPE {
	Book *book;
	Output_def *outputdef;
	SCM scm;
	String *string;
 	Music *music;
 	Score *score;
 	int i;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 567 "out/parser.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */
#line 225 "parser.yy"


int
yylex (YYSTYPE *s, YYLTYPE *loc, void *v)
{
	Lily_parser *pars = (Lily_parser*) v;
	Lily_lexer *lex = pars->lexer_;

	lex->lexval = (void*) s;
	lex->lexloc = loc;
	lex->prepare_for_next_token ();
	return lex->yylex ();
}




/* Line 214 of yacc.c.  */
#line 607 "out/parser.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2005 */
#  endif
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  else
#   define YYSIZE_T unsigned long int
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM ((YYSIZE_T) -1)
#  endif
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYLTYPE_IS_TRIVIAL) && YYLTYPE_IS_TRIVIAL \
             && defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2208

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  160
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  129
/* YYNRULES -- Number of rules. */
#define YYNRULES  372
/* YYNRULES -- Number of states. */
#define YYNSTATES  548

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   391

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   158,     2,     2,     2,     2,     2,   151,
     149,   150,   155,   137,   152,   136,   142,   156,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   157,     2,
     143,   141,   144,   159,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   146,     2,   147,   153,   154,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   139,   145,   140,   148,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   138
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     4,     7,    10,    13,    16,    19,    21,
      23,    25,    27,    29,    31,    33,    35,    37,    39,    40,
      43,    48,    50,    52,    56,    58,    60,    62,    64,    66,
      68,    70,    72,    74,    76,    78,    83,    84,    86,    90,
      93,    98,    99,   102,   105,   108,   111,   114,   117,   122,
     123,   125,   128,   131,   134,   137,   140,   142,   145,   147,
     149,   151,   154,   158,   161,   164,   167,   170,   175,   176,
     179,   182,   185,   187,   189,   190,   195,   201,   206,   210,
     215,   219,   221,   223,   225,   227,   228,   229,   235,   236,
     239,   241,   243,   245,   247,   249,   252,   255,   258,   262,
     266,   271,   275,   279,   283,   288,   293,   295,   297,   304,
     309,   314,   318,   320,   325,   328,   332,   334,   336,   340,
     342,   344,   346,   348,   350,   352,   354,   356,   358,   362,
     365,   366,   370,   371,   376,   379,   380,   385,   390,   394,
     397,   403,   407,   409,   411,   413,   415,   417,   419,   421,
     423,   425,   428,   430,   434,   440,   444,   449,   452,   455,
     457,   459,   463,   465,   467,   469,   471,   473,   475,   477,
     479,   480,   484,   486,   488,   492,   494,   496,   498,   500,
     504,   505,   508,   514,   517,   521,   523,   526,   529,   531,
     533,   535,   537,   540,   543,   546,   549,   552,   555,   557,
     560,   562,   565,   569,   570,   573,   576,   581,   583,   585,
     587,   590,   593,   595,   597,   599,   601,   603,   605,   607,
     609,   611,   613,   615,   617,   619,   621,   623,   625,   627,
     628,   630,   633,   636,   638,   641,   643,   646,   648,   651,
     654,   656,   659,   662,   664,   666,   668,   670,   672,   674,
     676,   678,   680,   682,   684,   686,   688,   690,   692,   694,
     696,   698,   699,   701,   704,   707,   709,   713,   717,   719,
     723,   724,   727,   729,   732,   734,   736,   738,   740,   742,
     744,   746,   748,   750,   753,   756,   758,   761,   762,   765,
     769,   770,   772,   779,   782,   785,   788,   791,   794,   796,
     798,   800,   803,   808,   809,   812,   814,   816,   819,   822,
     824,   826,   828,   830,   834,   836,   839,   842,   846,   850,
     852,   854,   858,   862,   865,   867,   869,   871,   873,   876,
     879,   881,   883,   885,   888,   889,   892,   893,   896,   898,
     899,   903,   905,   906,   910,   912,   915,   917,   919,   921,
     924,   928,   929,   932,   935,   937,   940,   944,   946,   949,
     951,   953,   955,   957,   958,   964,   967,   972,   976,   978,
     981,   985,   988
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     161,     0,    -1,    -1,   161,   163,    -1,   161,   169,    -1,
     161,     1,    -1,   161,    25,    -1,    36,   133,    -1,   167,
      -1,   224,    -1,   173,    -1,   175,    -1,   164,    -1,   277,
      -1,   178,    -1,   192,    -1,    88,    -1,   131,    -1,    -1,
     166,   169,    -1,    24,   139,   166,   140,    -1,   133,    -1,
     100,    -1,   168,   141,   170,    -1,   165,    -1,   175,    -1,
     178,    -1,   171,    -1,   183,    -1,   229,    -1,   267,    -1,
     211,    -1,   165,    -1,   277,    -1,    89,    -1,    15,   139,
     172,   140,    -1,    -1,    95,    -1,   172,    23,   165,    -1,
     172,   208,    -1,     9,   139,   174,   140,    -1,    -1,   174,
     177,    -1,   174,   175,    -1,   174,   277,    -1,   174,   167,
      -1,   174,     1,    -1,   174,   162,    -1,    47,   139,   176,
     140,    -1,    -1,   132,    -1,   176,   162,    -1,   176,   183,
      -1,   176,   167,    -1,   176,   178,    -1,   176,     1,    -1,
     178,    -1,   180,   140,    -1,    40,    -1,    33,    -1,    27,
      -1,   179,   139,    -1,   179,   139,   128,    -1,   180,   169,
      -1,   180,   171,    -1,   180,   181,    -1,   180,     1,    -1,
      53,   247,   141,   271,    -1,    -1,   182,   183,    -1,   182,
     165,    -1,   182,     1,    -1,   188,    -1,   192,    -1,    -1,
       7,   139,   182,   140,    -1,    44,   212,   271,   183,   184,
      -1,    48,   139,   182,   140,    -1,   139,   182,   140,    -1,
      50,   139,   182,   140,    -1,   219,   182,   220,    -1,   215,
      -1,   125,    -1,   210,    -1,   205,    -1,    -1,    -1,    59,
     190,   139,   191,   140,    -1,    -1,   191,   208,    -1,   196,
      -1,   193,    -1,   187,    -1,   186,    -1,   112,    -1,   120,
     165,    -1,   113,   277,    -1,   118,   183,    -1,   121,   165,
     183,    -1,   123,   165,   165,    -1,   124,   165,   165,   183,
      -1,   116,   277,   183,    -1,   114,   277,   277,    -1,   119,
     183,   183,    -1,   122,   165,   183,   183,    -1,   117,   277,
     183,   183,    -1,   194,    -1,   195,    -1,    15,   212,   141,
     212,   189,   183,    -1,    15,   212,   189,   183,    -1,    61,
     212,   189,   183,    -1,    54,   249,   183,    -1,   185,    -1,
      55,   240,   240,   183,    -1,   197,   193,    -1,   198,   189,
     193,    -1,   199,    -1,   203,    -1,    52,   165,   183,    -1,
      35,    -1,    19,    -1,    21,    -1,    11,    -1,    28,    -1,
      20,    -1,    22,    -1,    12,    -1,    29,    -1,    42,   244,
     183,    -1,    42,   192,    -1,    -1,     3,   201,   193,    -1,
      -1,   200,     3,   202,   193,    -1,   193,   200,    -1,    -1,
      30,   212,   204,   183,    -1,    10,   133,   141,   133,    -1,
     133,   141,   213,    -1,    58,   212,    -1,    39,   212,   165,
     141,   165,    -1,    46,   212,   165,    -1,    14,    -1,    43,
      -1,     4,    -1,    17,    -1,     6,    -1,    57,    -1,    18,
      -1,    34,    -1,   206,    -1,   207,   133,    -1,   212,    -1,
     212,   142,   212,    -1,    39,   209,   165,   141,   213,    -1,
      46,   209,   165,    -1,    49,   209,   141,   213,    -1,    58,
     209,    -1,    38,   210,    -1,   133,    -1,   134,    -1,   211,
     137,   211,    -1,   133,    -1,   100,    -1,   211,    -1,   100,
      -1,   272,    -1,   165,    -1,   277,    -1,    89,    -1,    -1,
     214,   259,   227,    -1,   225,    -1,   216,    -1,   221,   246,
     227,    -1,   143,    -1,   144,    -1,    68,    -1,    67,    -1,
     217,   222,   218,    -1,    -1,   222,   223,    -1,   239,   273,
     274,   234,   227,    -1,    96,   227,    -1,     5,   211,   183,
      -1,   226,    -1,    51,   245,    -1,    37,   239,    -1,    74,
      -1,    76,    -1,    69,    -1,   145,    -1,    56,   239,    -1,
       8,   133,    -1,    41,   245,    -1,    13,   133,    -1,    60,
     249,    -1,    31,   213,    -1,    78,    -1,    31,    16,    -1,
     181,    -1,    26,    16,    -1,    26,   126,   131,    -1,    -1,
     227,   229,    -1,   227,   228,    -1,   136,    52,   165,   229,
      -1,   232,    -1,    83,    -1,    79,    -1,   243,   233,    -1,
     243,   232,    -1,   230,    -1,    90,    -1,   146,    -1,   147,
      -1,   148,    -1,   149,    -1,   150,    -1,    73,    -1,    75,
      -1,    72,    -1,    70,    -1,    77,    -1,   231,    -1,    98,
      -1,   251,    -1,   241,    -1,   242,    -1,    -1,   141,    -1,
     141,   236,    -1,   141,   235,    -1,   151,    -1,   235,   151,
      -1,   152,    -1,   236,   152,    -1,   126,    -1,   126,   235,
      -1,   126,   236,    -1,   135,    -1,   135,   235,    -1,   135,
     236,    -1,   237,    -1,   239,    -1,   238,    -1,   277,    -1,
     211,    -1,    89,    -1,   153,    -1,   137,    -1,   136,    -1,
     145,    -1,   144,    -1,   142,    -1,   154,    -1,   154,    -1,
     153,    -1,   136,    -1,   237,    -1,   248,    -1,    -1,   248,
      -1,   271,   250,    -1,    97,   250,    -1,   247,    -1,   248,
     155,   271,    -1,   248,   155,    99,    -1,    99,    -1,    91,
     156,    91,    -1,    -1,   250,   142,    -1,   157,    -1,   157,
     271,    -1,    89,    -1,    91,    -1,   133,    -1,   277,    -1,
     136,    -1,   137,    -1,   158,    -1,    82,    -1,   252,    -1,
     254,   253,    -1,   146,   254,    -1,   254,    -1,   255,   147,
      -1,    -1,   256,   255,    -1,    81,   256,    80,    -1,    -1,
      45,    -1,   239,   273,   274,   234,   246,   258,    -1,    96,
     246,    -1,   257,   246,    -1,   130,   246,    -1,    87,   246,
      -1,   260,   246,    -1,   261,    -1,   275,    -1,   100,    -1,
     238,   246,    -1,   238,   246,   263,   262,    -1,    -1,   262,
     264,    -1,    64,    -1,    63,    -1,    66,   238,    -1,    62,
     238,    -1,   263,    -1,   265,    -1,    94,    -1,   266,    -1,
     265,   142,   266,    -1,   271,    -1,   271,   137,    -1,   271,
      65,    -1,   267,   137,   268,    -1,   267,   136,   268,    -1,
     268,    -1,   269,    -1,   269,   155,   269,    -1,   269,   156,
     269,    -1,   136,   269,    -1,   270,    -1,    91,    -1,   129,
      -1,   127,    -1,   129,   127,    -1,    91,   127,    -1,    91,
      -1,    89,    -1,   270,    -1,   136,   272,    -1,    -1,   273,
     158,    -1,    -1,   274,   159,    -1,   101,    -1,    -1,    86,
     276,   279,    -1,   111,    -1,    -1,    32,   278,   279,    -1,
     280,    -1,   285,   286,    -1,   286,    -1,   281,    -1,   282,
      -1,   285,   282,    -1,   139,   283,   140,    -1,    -1,   283,
     288,    -1,   283,   280,    -1,   104,    -1,   107,   165,    -1,
     109,   165,   165,    -1,   284,    -1,   285,   284,    -1,   133,
      -1,   111,    -1,   101,    -1,   134,    -1,    -1,    47,   287,
     139,   176,   140,    -1,   106,   165,    -1,   110,   165,   165,
     165,    -1,   108,   165,   165,    -1,   102,    -1,   103,   280,
      -1,   105,   288,   288,    -1,   285,   286,    -1,   286,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   551,   551,   552,   554,   556,   559,   566,   570,   573,
     576,   582,   589,   595,   599,   616,   621,   622,   627,   631,
     637,   646,   647,   651,   667,   672,   676,   680,   683,   687,
     691,   694,   697,   700,   703,   709,   716,   720,   724,   735,
     743,   752,   759,   763,   768,   771,   774,   778,   784,   790,
     794,   798,   801,   806,   809,   821,   832,   844,   853,   858,
     863,   873,   878,   887,   890,   893,   903,   909,   924,   927,
     938,   941,   958,   959,   963,   966,   973,  1032,  1037,  1045,
    1051,  1059,  1060,  1063,  1064,  1069,  1070,  1070,  1079,  1080,
    1087,  1088,  1092,  1093,  1097,  1100,  1103,  1106,  1110,  1114,
    1117,  1120,  1124,  1127,  1132,  1137,  1145,  1182,  1185,  1189,
    1192,  1197,  1213,  1214,  1224,  1238,  1250,  1251,  1252,  1259,
    1265,  1272,  1277,  1285,  1292,  1298,  1303,  1310,  1318,  1324,
    1334,  1334,  1343,  1343,  1352,  1380,  1380,  1392,  1403,  1407,
    1411,  1415,  1422,  1423,  1425,  1426,  1428,  1429,  1430,  1431,
    1435,  1436,  1442,  1451,  1458,  1465,  1473,  1480,  1486,  1496,
    1499,  1502,  1507,  1510,  1515,  1518,  1521,  1524,  1527,  1530,
    1554,  1558,  1571,  1572,  1577,  1593,  1596,  1599,  1602,  1606,
    1616,  1617,  1624,  1652,  1667,  1676,  1684,  1690,  1696,  1706,
    1716,  1720,  1730,  1739,  1748,  1758,  1765,  1772,  1782,  1785,
    1789,  1792,  1796,  1814,  1817,  1822,  1831,  1839,  1842,  1847,
    1852,  1857,  1862,  1866,  1875,  1878,  1881,  1884,  1887,  1890,
    1893,  1896,  1899,  1902,  1908,  1922,  1925,  1934,  1937,  1948,
    1949,  1950,  1951,  1955,  1958,  1964,  1967,  1973,  1976,  1981,
    1993,  1996,  2001,  2010,  2016,  2017,  2021,  2027,  2035,  2044,
    2047,  2050,  2053,  2056,  2059,  2062,  2068,  2069,  2070,  2075,
    2081,  2087,  2093,  2102,  2111,  2120,  2123,  2126,  2134,  2135,
    2141,  2144,  2150,  2153,  2161,  2166,  2171,  2172,  2176,  2177,
    2178,  2182,  2187,  2195,  2209,  2213,  2216,  2223,  2226,  2232,
    2242,  2243,  2247,  2279,  2292,  2301,  2321,  2328,  2341,  2349,
    2352,  2358,  2361,  2368,  2371,  2377,  2380,  2383,  2386,  2392,
    2395,  2398,  2404,  2405,  2411,  2414,  2417,  2429,  2432,  2435,
    2439,  2442,  2445,  2451,  2454,  2459,  2462,  2465,  2468,  2471,
    2478,  2481,  2487,  2498,  2504,  2505,  2509,  2510,  2518,  2522,
    2521,  2530,  2534,  2533,  2542,  2545,  2548,  2554,  2557,  2563,
    2570,  2576,  2577,  2580,  2586,  2589,  2592,  2598,  2601,  2607,
    2610,  2613,  2616,  2619,  2619,  2628,  2631,  2634,  2637,  2640,
    2643,  2649,  2652
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\\addlyrics", "\\accepts", "\\addquote",
  "\\alias", "\\alternative", "\\bar", "\book", "\\change", "\\chordmode",
  "\\chords", "\\clef", "\\consists", "\\context", "\\default", "\\denies",
  "\\description", "\\drummode", "\\drums", "\\figuremode", "\\figures",
  "\\grobdescriptions", "\\header", "\\invalid", "\\key", "\\layout",
  "\\lyricmode", "\\lyrics", "\\lyricsto", "\\mark", "\\markup", "\\midi",
  "\\name", "\\notemode", "\\objectid", "\\octave", "\\once", "\\override",
  "\\paper", "\\partial", "\\relative", "\\remove", "\\repeat", "\\rest",
  "\\revert", "\\score", "\\sequential", "\\set", "\\simultaneous",
  "\\skip", "\\tag", "\\tempo", "\\times", "\\transpose",
  "\\transposition", "\\type", "\\unset", "\\with", "\\time", "\\new",
  "/+", "^", ":", "-", "/", ">>", "<<", "\\", "\\>", "\\C[haracter]",
  "\\)", "\\!", "\\[", "\\(", "\\]", "\\<", "\\~", "__", "FIGURE_CLOSE",
  "FIGURE_OPEN", "_", "--", "CHORDMODIFIERS", "COMMANDSPANREQUEST",
  "LYRIC_MARKUP", "MULTI_MEASURE_REST", "SCM_T", "DIGIT", "E_UNSIGNED",
  "UNSIGNED", "IDENTIFIER", "CHORDMODIFIER_PITCH", "CHORD_MODIFIER",
  "CONTEXT_DEF_IDENTIFIER", "DRUM_PITCH", "DURATION_IDENTIFIER",
  "EVENT_IDENTIFIER", "FRACTION", "LYRICS_STRING",
  "LYRIC_MARKUP_IDENTIFIER", "MARKUP_HEAD_EMPTY", "MARKUP_HEAD_LIST0",
  "MARKUP_HEAD_MARKUP0", "MARKUP_HEAD_MARKUP0_MARKUP1", "MARKUP_HEAD_SCM0",
  "MARKUP_HEAD_SCM0_MARKUP1", "MARKUP_HEAD_SCM0_SCM1",
  "MARKUP_HEAD_SCM0_SCM1_MARKUP2", "MARKUP_HEAD_SCM0_SCM1_SCM2",
  "MARKUP_IDENTIFIER", "MUSIC_FUNCTION", "MUSIC_FUNCTION_MARKUP",
  "MUSIC_FUNCTION_MARKUP_MARKUP", "MUSIC_FUNCTION_MARKUP_MARKUP_MUSIC",
  "MUSIC_FUNCTION_MARKUP_MUSIC", "MUSIC_FUNCTION_MARKUP_MUSIC_MUSIC",
  "MUSIC_FUNCTION_MUSIC", "MUSIC_FUNCTION_MUSIC_MUSIC",
  "MUSIC_FUNCTION_SCM", "MUSIC_FUNCTION_SCM_MUSIC",
  "MUSIC_FUNCTION_SCM_MUSIC_MUSIC", "MUSIC_FUNCTION_SCM_SCM",
  "MUSIC_FUNCTION_SCM_SCM_MUSIC", "MUSIC_IDENTIFIER", "NOTENAME_PITCH",
  "NUMBER_IDENTIFIER", "OUTPUT_DEF_IDENTIFIER", "REAL", "RESTNAME",
  "SCM_IDENTIFIER", "SCORE_IDENTIFIER", "STRING", "STRING_IDENTIFIER",
  "TONICNAME_PITCH", "'-'", "'+'", "UNARY_MINUS", "'{'", "'}'", "'='",
  "'.'", "'<'", "'>'", "'|'", "'['", "']'", "'~'", "'('", "')'", "'''",
  "','", "'^'", "'_'", "'*'", "'/'", "':'", "'!'", "'?'", "$accept",
  "lilypond", "object_id_setting", "toplevel_expression", "toplevel_music",
  "embedded_scm", "lilypond_header_body", "lilypond_header",
  "assignment_id", "assignment", "identifier_init",
  "context_def_spec_block", "context_def_spec_body", "book_block",
  "book_body", "score_block", "score_body", "paper_block", "output_def",
  "output_def_head", "output_def_body", "tempo_event", "Music_list",
  "Music", "Alternative_music", "Repeated_music", "Sequential_music",
  "Simultaneous_music", "Simple_music", "optional_context_mod", "@1",
  "context_mod_list", "Composite_music", "Grouped_music_list",
  "Generic_prefix_music_scm", "Generic_prefix_music",
  "Prefix_composite_music", "mode_changing_head",
  "mode_changing_head_with_context", "relative_music", "new_lyrics", "@2",
  "@3", "re_rhythmed_music", "@4", "context_change", "property_operation",
  "context_def_mod", "context_mod", "context_prop_spec",
  "music_property_def", "string", "simple_string", "scalar", "pre_events",
  "event_chord", "note_chord_element", "chord_open", "chord_close",
  "simul_open", "simul_close", "chord_body", "chord_body_elements",
  "chord_body_element", "add_quote", "command_element", "command_req",
  "post_events", "tagged_post_event", "post_event", "string_number_event",
  "direction_less_char", "direction_less_event", "direction_reqd_event",
  "octave_check", "sup_quotes", "sub_quotes", "steno_pitch",
  "steno_tonic_pitch", "pitch", "pitch_also_in_chords", "gen_text_def",
  "script_abbreviation", "script_dir", "absolute_pitch", "duration_length",
  "optional_notemode_duration", "steno_duration", "multiplied_duration",
  "fraction", "dots", "tremolo_type", "bass_number", "bass_mod",
  "bass_figure", "br_bass_figure", "figure_list", "figure_spec",
  "optional_rest", "simple_element", "lyric_element", "new_chord",
  "chord_items", "chord_separator", "chord_item", "step_numbers",
  "step_number", "number_expression", "number_term", "number_factor",
  "bare_number", "bare_unsigned", "bare_int", "exclamations", "questions",
  "lyric_markup", "@5", "full_markup", "@6", "markup_top", "markup_list",
  "markup_composed_list", "markup_braced_list", "markup_braced_list_body",
  "markup_head_1_item", "markup_head_1_list", "simple_markup", "@7",
  "markup", 0
};
#endif

/* INFRINGES ON USER NAME SPACE */
#ifndef _
# define _(msgid) msgid
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,    45,    43,   391,   123,
     125,    61,    46,    60,    62,   124,    91,    93,   126,    40,
      41,    39,    44,    94,    95,    42,    47,    58,    33,    63
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   160,   161,   161,   161,   161,   161,   162,   163,   163,
     163,   163,   163,   163,   163,   164,   165,   165,   166,   166,
     167,   168,   168,   169,   169,   170,   170,   170,   170,   170,
     170,   170,   170,   170,   170,   171,   172,   172,   172,   172,
     173,   174,   174,   174,   174,   174,   174,   174,   175,   176,
     176,   176,   176,   176,   176,   176,   177,   178,   179,   179,
     179,   180,   180,   180,   180,   180,   180,   181,   182,   182,
     182,   182,   183,   183,   184,   184,   185,   186,   186,   187,
     187,   188,   188,   188,   188,   189,   190,   189,   191,   191,
     192,   192,   193,   193,   194,   194,   194,   194,   194,   194,
     194,   194,   194,   194,   194,   194,   195,   196,   196,   196,
     196,   196,   196,   196,   196,   196,   196,   196,   196,   197,
     197,   197,   197,   197,   198,   198,   198,   198,   199,   199,
     201,   200,   202,   200,   203,   204,   203,   205,   206,   206,
     206,   206,   207,   207,   207,   207,   207,   207,   207,   207,
     208,   208,   209,   209,   210,   210,   210,   210,   210,   211,
     211,   211,   212,   212,   213,   213,   213,   213,   213,   213,
     214,   215,   215,   215,   216,   217,   218,   219,   220,   221,
     222,   222,   223,   223,   224,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   226,   226,
     226,   226,   226,   227,   227,   227,   228,   229,   229,   229,
     229,   229,   229,   230,   231,   231,   231,   231,   231,   231,
     231,   231,   231,   231,   232,   232,   232,   233,   233,   234,
     234,   234,   234,   235,   235,   236,   236,   237,   237,   237,
     238,   238,   238,   239,   240,   240,   241,   241,   241,   242,
     242,   242,   242,   242,   242,   242,   243,   243,   243,   244,
     245,   246,   246,   247,   247,   248,   248,   248,   249,   249,
     250,   250,   251,   251,   252,   252,   252,   252,   253,   253,
     253,   254,   254,   254,   255,   255,   255,   256,   256,   257,
     258,   258,   259,   259,   259,   259,   259,   259,   259,   260,
     260,   261,   261,   262,   262,   263,   263,   263,   263,   264,
     264,   264,   265,   265,   266,   266,   266,   267,   267,   267,
     268,   268,   268,   269,   269,   270,   270,   270,   270,   270,
     271,   271,   272,   272,   273,   273,   274,   274,   275,   276,
     275,   277,   278,   277,   279,   279,   279,   280,   280,   281,
     282,   283,   283,   283,   284,   284,   284,   285,   285,   286,
     286,   286,   286,   287,   286,   286,   286,   286,   286,   286,
     286,   288,   288
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     2,     2,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     2,
       4,     1,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     0,     1,     3,     2,
       4,     0,     2,     2,     2,     2,     2,     2,     4,     0,
       1,     2,     2,     2,     2,     2,     1,     2,     1,     1,
       1,     2,     3,     2,     2,     2,     2,     4,     0,     2,
       2,     2,     1,     1,     0,     4,     5,     4,     3,     4,
       3,     1,     1,     1,     1,     0,     0,     5,     0,     2,
       1,     1,     1,     1,     1,     2,     2,     2,     3,     3,
       4,     3,     3,     3,     4,     4,     1,     1,     6,     4,
       4,     3,     1,     4,     2,     3,     1,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     2,
       0,     3,     0,     4,     2,     0,     4,     4,     3,     2,
       5,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     3,     5,     3,     4,     2,     2,     1,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     3,     1,     1,     3,     1,     1,     1,     1,     3,
       0,     2,     5,     2,     3,     1,     2,     2,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     2,     1,     2,
       1,     2,     3,     0,     2,     2,     4,     1,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     2,     2,     1,     2,     1,     2,     1,     2,     2,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     2,     2,     1,     3,     3,     1,     3,
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     2,     0,     2,     3,
       0,     1,     6,     2,     2,     2,     2,     2,     1,     1,
       1,     2,     4,     0,     2,     1,     1,     2,     2,     1,
       1,     1,     1,     3,     1,     2,     2,     3,     3,     1,
       1,     3,     3,     2,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     2,     0,     2,     0,     2,     1,     0,
       3,     1,     0,     3,     1,     2,     1,     1,     1,     2,
       3,     0,     2,     2,     1,     2,     3,     1,     2,     1,
       1,     1,     1,     0,     5,     2,     4,     3,     1,     2,
       3,     2,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       2,     0,     1,     5,     0,     0,   122,   126,     0,   120,
     124,   121,   125,     0,     6,    60,   123,   127,     0,   342,
      59,   119,    58,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   177,    16,    22,   341,    94,     0,     0,     0,
       0,   170,   170,     0,     0,     0,     0,     0,    17,    21,
      68,     3,    12,    24,     8,     0,     4,    10,    11,    14,
       0,     0,   112,    93,    92,    15,    91,   106,   107,    90,
       0,    85,   116,   117,    68,     9,    13,   159,   160,   170,
      41,   163,   162,    85,    18,   135,     0,   237,   129,   259,
     170,     0,    49,    68,    68,   170,     0,   268,   170,   240,
     243,   245,   244,     0,    85,    96,     0,   170,   170,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   190,   188,   189,   198,    82,
     175,   191,   200,    97,    72,    73,    84,    83,     0,    81,
     173,   180,   261,   172,   185,   170,    95,   170,   170,     0,
       0,     0,   170,    61,    66,     0,    57,    63,    64,    65,
     130,   134,   114,    86,     0,     0,     0,   184,     0,     0,
     170,     0,   170,   363,   361,   368,     0,   354,     0,     0,
       0,     0,     0,     0,   360,   359,   362,   351,   343,   344,
     347,   348,   357,     0,   346,   233,   235,   238,   239,   128,
     331,   330,   170,    50,     0,     0,     0,   118,     0,   111,
     241,   242,   170,   170,   102,   101,   170,   193,     0,   195,
     201,     0,   199,   169,   325,   165,   327,   326,     0,   167,
     164,   197,   332,   166,   168,   187,   158,     0,   152,   270,
     194,   265,   260,   270,     0,     0,   186,     0,   192,   157,
     196,   287,   339,   261,   261,   300,   338,   261,   261,   334,
     261,   203,   261,   298,   299,     0,   203,   262,   103,    98,
     170,    99,   170,    71,    78,    70,    69,     0,   222,   221,
     219,   220,   223,   209,   208,    34,   213,   225,   258,   214,
     215,   216,   217,   218,   257,   256,   272,    32,    23,    27,
      25,    26,    28,    31,    29,   212,   224,   207,     0,   226,
      30,   319,   320,   324,    33,    62,    36,     0,   132,     0,
     115,   178,    80,   161,    46,     0,    40,    47,    45,    43,
      42,    56,    44,    85,   109,    20,    19,   136,     0,   369,
       0,     0,   372,     0,   365,   355,     0,     0,     0,     0,
     349,   358,   345,   234,   236,    74,    55,    48,    51,    53,
      54,    52,    77,    79,   269,   113,   110,   105,     0,   202,
     329,   328,   333,     0,     0,   264,     0,   263,   155,     0,
       0,     0,     0,   296,   293,   295,   301,   336,   294,   171,
     297,   203,   176,   179,   181,   334,   174,   104,   100,     0,
     323,   273,   248,   251,   250,   254,   253,   252,   249,   255,
     247,   211,   210,   227,   228,   246,     0,     0,     0,     0,
      37,     0,   131,     0,    88,     7,   170,    49,   371,   370,
     367,   356,     0,   350,   353,     0,   352,     0,    76,   137,
       0,   153,   271,   267,   266,   156,    67,   289,   281,   274,
     275,   276,     0,   282,   285,   288,   277,   340,     0,   306,
     305,     0,   303,   335,   229,   258,   205,   204,   183,   336,
     318,   317,   321,   322,   144,   146,   142,   145,   148,     0,
     149,     0,   143,     0,   147,     0,     0,    35,   150,     0,
      39,   133,     0,   108,     0,   366,    68,   154,   284,   278,
     279,   280,   283,   286,   308,   307,   302,   230,   337,   261,
       0,   229,    38,     0,     0,   139,     0,   151,    87,    89,
     364,     0,   311,   309,   304,   310,   312,   314,   232,   231,
     290,     0,   203,     0,   141,   138,    75,     0,   316,   315,
     291,   292,   258,   206,   182,     0,   313,   140
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,     1,   358,    51,    52,   275,   171,   359,    55,    56,
     298,   158,   421,    57,   168,    58,   204,   330,   360,    60,
      61,   132,   151,   276,   438,    62,    63,    64,   134,   164,
     319,   492,   135,    66,    67,    68,    69,    70,    71,    72,
     161,   317,   423,    73,   172,   136,   488,   489,   490,   237,
     137,   230,   238,   231,   138,   139,   140,   141,   393,    74,
     322,   142,   265,   394,    75,   143,   144,   389,   466,   467,
     305,   306,   307,   412,   509,   197,   198,   100,   101,   102,
     103,   413,   414,   308,    90,   240,   266,   241,   267,    98,
     375,   309,   453,   502,   454,   455,   381,   260,   541,   261,
     262,   263,   506,   462,   524,   525,   526,   310,   311,   312,
     313,   243,   233,   387,   464,   264,   382,   234,    86,   188,
     189,   190,   191,   349,   192,   193,   342,   338,   343
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -358
static const short int yypact[] =
{
    -358,  1611,  -358,  -358,   -58,  -108,  -358,  -358,   -34,  -358,
    -358,  -358,  -358,   -38,  -358,  -358,  -358,  -358,   -34,  -358,
    -358,  -358,  -358,  2006,   -34,   -31,   -18,   -12,   -29,    59,
       8,   -34,  -358,  -358,  -358,  -358,  -358,    24,    24,    24,
      24,  1877,  1877,   -29,   -29,   -29,   -29,   -29,  -358,  -358,
    -358,  -358,  -358,  -358,  -358,   -46,  -358,  -358,  -358,  -358,
      48,   122,  -358,  -358,  -358,  -358,   206,  -358,  -358,  -358,
      23,    66,  -358,  -358,  -358,  -358,  -358,  -358,  -358,  1741,
    -358,  -358,  -358,   -27,  -358,  -358,  1870,    39,  -358,  -358,
    1877,   115,    82,  -358,  -358,  1877,    65,  -358,  1877,    39,
    -358,  -358,  -358,     8,    66,  -358,    24,  1877,  1877,    93,
     105,   107,    20,   261,   121,   181,   -34,   183,   -34,   -34,
     183,   183,   121,   -34,    59,  -358,  -358,  -358,  -358,  -358,
    -358,  -358,  -358,  -358,  -358,  -358,  -358,  -358,   111,  -358,
    -358,  -358,   183,  -358,  -358,  1877,  -358,  1877,  1877,   -29,
     -29,   930,   508,   123,  -358,   110,  -358,  -358,  -358,  -358,
    -358,   249,  -358,  -358,    23,  1066,   -58,  -358,    60,   -34,
    1877,    -2,  1877,  -358,  -358,  -358,   109,  -358,  2074,   -29,
     -29,   -29,   -29,   -29,  -358,  -358,  -358,  -358,  -358,  -358,
    -358,  -358,  -358,  1870,  -358,  -358,  -358,   113,   124,  -358,
    -358,  -358,  1877,  -358,   658,  1202,  1338,  -358,   174,  -358,
     113,   124,  1877,  1877,  -358,  -358,  1877,  -358,   126,  -358,
    -358,   144,  -358,  -358,   151,  -358,  -358,   152,     3,  -358,
     148,  -358,  -358,  -358,  -358,  -358,  -358,   -29,   149,  -358,
    -358,  -358,   135,  -358,   -29,   153,  -358,   154,  -358,  -358,
    -358,  -358,  -358,   183,   183,  -358,  -358,   183,   183,  -358,
     183,  -358,   183,  -358,  -358,   -62,  -358,   135,  -358,  -358,
    1877,  -358,  1877,  -358,  -358,  -358,  -358,   -23,  -358,  -358,
    -358,  -358,  -358,  -358,  -358,  -358,  -358,  -358,    76,  -358,
    -358,  -358,  -358,  -358,  -358,  -358,   115,  -358,  -358,  -358,
    -358,  -358,  -358,   148,  -358,  -358,  -358,  -358,   347,  -358,
     -48,  -358,    68,  -358,  -358,  -358,   201,    23,  -358,   159,
    -358,  -358,  -358,  -358,  -358,   166,  -358,  -358,  -358,  -358,
    -358,  -358,  -358,    66,  -358,  -358,  -358,  -358,   163,  -358,
     109,  2074,  -358,  2074,  -358,  -358,   -29,   -29,   -29,  1580,
    -358,  -358,  -358,  -358,  -358,   296,  -358,  -358,  -358,  -358,
    -358,  -358,  -358,  -358,  -358,  -358,  -358,  -358,   172,  -358,
    -358,  -358,  -358,   165,   -34,   167,    37,   167,  -358,  1716,
     115,   295,  1870,  -358,  -358,  -358,   220,   155,  -358,  2000,
    -358,  -358,  -358,  -358,  -358,  -358,  2000,  -358,  -358,    18,
    -358,  -358,  -358,  -358,  -358,  -358,  -358,  -358,  -358,  -358,
     148,  -358,  -358,  -358,  -358,  -358,    18,    18,    18,    18,
    -358,   211,  -358,    23,  -358,  -358,  1877,    82,  -358,  -358,
    -358,  -358,   -29,  -358,  -358,  1870,  -358,   171,  -358,  -358,
    1716,  -358,  -358,  -358,  -358,  -358,  -358,  -358,  -358,  -358,
    -358,  -358,    22,  -358,   -68,   164,  -358,  -358,   177,  -358,
    -358,   177,  -358,  -358,   -44,   262,  -358,  -358,  2000,   155,
    -358,  -358,  -358,  -358,  -358,  -358,  -358,  -358,  -358,   -29,
    -358,   -34,  -358,   -34,  -358,   -34,   175,  -358,  -358,   182,
    -358,  -358,   283,  -358,   794,  -358,  -358,  -358,   -68,  -358,
    -358,  -358,  -358,  -358,  -358,  -358,   169,    39,  -358,   183,
     -29,   -44,  -358,   -29,   -29,  -358,  1716,  -358,  -358,  -358,
    -358,  1474,  -358,  -358,  -358,   176,  -358,   -32,   113,   124,
     274,  2016,  -358,   179,  -358,  -358,  -358,   115,  -358,  -358,
    -358,  -358,  -358,  -358,  2000,   -29,  -358,  -358
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -358,  -358,   156,  -358,  -358,    -1,  -358,    28,  -358,   -14,
    -358,   180,  -358,  -358,  -358,   -87,  -104,  -358,    34,  -358,
    -358,   260,   -70,   -28,  -358,  -358,  -358,  -358,  -358,   -63,
    -358,  -358,    62,   -61,  -358,  -358,  -358,  -358,  -358,  -358,
    -358,  -358,  -358,  -358,  -358,  -358,  -358,  -358,  -164,    54,
     216,    17,    -6,  -357,  -358,  -358,  -358,  -358,  -358,  -358,
    -358,  -358,  -358,  -358,  -358,  -358,  -358,  -251,  -358,  -144,
    -358,  -358,    27,  -358,  -175,   -94,   -93,   314,  -128,   -64,
     235,  -358,  -358,  -358,  -358,   219,  -205,   221,    36,   224,
     100,  -358,  -358,  -358,   -99,  -358,  -358,  -358,  -358,  -358,
    -358,  -358,  -358,  -152,  -358,  -358,  -182,  -358,  -222,  -258,
    -106,   -88,   128,   -37,  -112,  -358,  -358,     0,  -358,   -19,
    -160,  -358,  -174,  -358,  -176,  -150,   -75,  -358,  -271
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -171
static const short int yytable[] =
{
      53,    76,    83,   202,   165,   210,   211,   232,   304,   162,
     258,   194,    85,   133,   145,   396,   339,   351,    91,   350,
     170,    79,   445,   205,   206,   104,   340,    95,   341,    54,
     400,    80,   163,   538,   391,    59,   220,   105,   106,   107,
     108,   213,   146,   147,   148,   149,   150,   157,   383,   384,
     235,   167,   385,   386,    19,   388,    19,   390,   248,    33,
      53,   324,   199,    65,    87,   300,    81,   207,   499,   500,
     209,    26,   429,    27,   259,    77,    78,    81,   436,   215,
     216,   329,   392,   497,    13,    88,    33,    15,   416,   417,
     501,    32,    19,    20,   224,   152,   325,   507,    34,    82,
      22,    84,    48,   320,   448,   539,   214,    25,    92,   224,
      82,   449,   229,   450,   169,   508,   316,   268,   352,   269,
     270,    93,   232,   154,   302,   163,   200,    94,   201,    48,
     226,    49,   227,    35,    87,    35,   443,   155,   335,   228,
     468,   400,   334,    99,   337,   226,   221,   227,   271,   272,
      96,   297,   314,   242,   399,   451,   242,   336,    97,   535,
     472,   473,    50,   333,   351,   351,   350,   224,   332,   303,
      53,    35,   244,   245,   355,   121,   361,   249,   344,   345,
     346,   347,   348,   323,   365,   366,   301,   153,   367,   434,
     195,   196,   251,   341,   470,   471,   328,   252,   253,   435,
     326,   395,   331,   226,   200,   227,   201,   254,   401,   160,
      33,   255,   256,   177,   203,   474,   180,   475,   182,   115,
     116,   208,    34,   418,   419,   476,   217,   118,   477,   478,
     119,   458,   459,   460,   479,   461,   373,    87,   218,   123,
     219,   257,   397,   378,   398,   480,    99,    87,   187,   316,
     481,   315,   318,    48,   482,    49,   422,   483,   200,   351,
     201,   350,   156,   522,   353,   364,   428,   368,   484,   485,
     426,    83,   200,   232,   201,   369,   354,   222,   370,   371,
     239,   544,   458,   459,   460,   166,   461,   474,   444,   475,
     376,   374,   446,    19,   379,   380,   420,   476,   424,   425,
     477,   478,   427,   437,   530,   439,   440,   194,   415,   442,
     496,   503,    99,   463,   510,   517,   516,   480,   537,   540,
     545,   159,   481,   494,   327,   410,   482,    19,   519,   483,
     504,   236,   299,   505,   232,   411,   532,    89,   212,   246,
     484,   485,   247,   377,   486,   430,   431,   432,   250,    33,
     223,   487,   224,   498,   523,   546,   372,   511,   469,     0,
     428,   225,   491,   457,     0,     0,     0,     0,   441,     0,
       0,     0,    35,     0,     0,   447,     0,   448,   229,    19,
       0,   456,     0,     0,   449,     0,   450,   543,   226,     0,
     227,     0,    48,     0,    77,    78,     0,   228,   493,     0,
       0,     0,     0,     0,     0,     0,    35,     0,     0,     0,
     232,     0,     0,   528,   529,     0,   486,   278,   527,   279,
     280,     0,   281,   518,   282,     0,   521,     0,   451,     0,
       0,   495,     0,     0,     0,     0,   402,     0,     0,   229,
       0,   452,     0,     0,     0,   287,     0,     0,     0,   527,
       0,     0,   456,     0,     0,     0,     0,     0,    35,     0,
       0,     0,     0,     0,     0,     0,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   513,     0,   514,   512,   515,
      77,    78,     0,   403,   404,     0,     0,     0,     0,   405,
       0,   406,   407,   289,   290,   291,   292,   293,     0,     0,
     408,   409,     0,     0,   296,     0,     0,     0,     0,   531,
       0,     0,   533,   534,     0,   229,   109,     0,   110,     6,
       7,   111,     0,   277,     0,     0,     0,     9,    10,    11,
      12,     0,     0,     0,   112,    15,    16,    17,    18,   113,
      19,    20,     0,    21,   547,   114,   115,   116,    22,   117,
      23,     0,    24,     0,   118,    25,    26,   119,    27,   120,
      28,   121,    29,    30,   122,     0,   123,     0,   124,    31,
       0,     0,     0,     0,     0,     0,    32,   125,   278,     0,
     279,   280,   126,   281,   127,   282,   128,   283,     0,     0,
       0,   284,     0,     0,     0,     0,    33,   285,   286,   224,
       0,     0,     0,     0,     0,     0,   287,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
      36,    37,    38,     0,    39,    40,    41,    42,    43,    44,
      45,    46,    47,   129,     0,   226,     0,   227,     0,    48,
       0,    77,    78,     0,   288,     0,     0,    50,     0,     0,
       0,   130,     0,   131,   289,   290,   291,   292,   293,   356,
       0,   294,   295,     0,     0,   296,   109,     0,   110,     6,
       7,   111,     0,     8,     0,     0,     0,     9,    10,    11,
      12,     0,    13,     0,   112,    15,    16,    17,    18,   113,
       0,    20,     0,    21,   325,   114,   115,   116,    22,   117,
      23,     0,    24,     0,   118,     0,    26,   119,    27,   120,
      28,   121,    29,    30,   122,     0,   123,     0,   124,    31,
       0,     0,     0,     0,     0,     0,    32,   125,     0,     0,
       0,     0,   126,     0,   127,     0,   128,     0,     0,  -170,
       0,     0,     0,     0,  -170,  -170,     0,     0,     0,     0,
       0,     0,     0,     0,  -170,     0,     0,     0,  -170,  -170,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      36,    37,    38,     0,    39,    40,    41,    42,    43,    44,
      45,    46,    47,   129,  -170,     0,     0,     0,  -170,     0,
       0,     0,     0,  -170,     0,   356,     0,    50,   357,     0,
       0,   130,   109,   131,   110,     6,     7,   111,     0,     8,
       0,     0,     0,     9,    10,    11,    12,     0,    13,     0,
     112,    15,    16,    17,    18,   113,     0,    20,     0,    21,
     325,   114,   115,   116,    22,   117,    23,     0,    24,     0,
     118,     0,    26,   119,    27,   120,    28,   121,    29,    30,
     122,     0,   123,     0,   124,    31,     0,     0,     0,     0,
       0,     0,    32,   125,     0,     0,     0,     0,   126,     0,
     127,     0,   128,     0,     0,  -170,     0,     0,     0,     0,
    -170,  -170,     0,     0,     0,     0,     0,     0,     0,     0,
    -170,     0,     0,     0,  -170,  -170,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    36,    37,    38,     0,
      39,    40,    41,    42,    43,    44,    45,    46,    47,   129,
    -170,     0,     0,     0,  -170,     0,     0,     0,     0,  -170,
       0,   273,     0,    50,   520,     0,     0,   130,   109,   131,
     110,     6,     7,   111,     0,     8,     0,     0,     0,     9,
      10,    11,    12,     0,     0,     0,   112,     0,    16,    17,
      18,   113,     0,     0,     0,    21,     0,   114,   115,   116,
       0,   117,    23,     0,    24,     0,   118,     0,    26,   119,
      27,   120,    28,   121,    29,    30,   122,     0,   123,     0,
     124,    31,     0,     0,     0,     0,     0,     0,    32,   125,
       0,     0,     0,     0,   126,     0,   127,     0,   128,     0,
       0,  -170,     0,     0,     0,     0,  -170,  -170,    33,     0,
       0,     0,     0,     0,     0,     0,  -170,     0,     0,     0,
    -170,  -170,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,    37,    38,     0,    39,    40,    41,    42,
      43,    44,    45,    46,    47,   129,  -170,     0,     0,     0,
    -170,    48,     0,     0,     0,  -170,     0,   273,     0,    50,
     274,     0,     0,   130,   109,   131,   110,     6,     7,   111,
       0,     8,     0,     0,     0,     9,    10,    11,    12,     0,
       0,     0,   112,     0,    16,    17,    18,   113,     0,     0,
       0,    21,     0,   114,   115,   116,     0,   117,    23,     0,
      24,     0,   118,     0,    26,   119,    27,   120,    28,   121,
      29,    30,   122,     0,   123,     0,   124,    31,     0,     0,
       0,     0,     0,   321,    32,   125,     0,     0,     0,     0,
     126,     0,   127,     0,   128,     0,     0,  -170,     0,     0,
       0,     0,  -170,  -170,    33,     0,     0,     0,     0,     0,
       0,     0,  -170,     0,     0,     0,  -170,  -170,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,    37,
      38,     0,    39,    40,    41,    42,    43,    44,    45,    46,
      47,   129,  -170,     0,     0,     0,  -170,    48,     0,     0,
       0,  -170,     0,   273,     0,    50,     0,     0,     0,   130,
     109,   131,   110,     6,     7,   111,     0,     8,     0,     0,
       0,     9,    10,    11,    12,     0,     0,     0,   112,     0,
      16,    17,    18,   113,     0,     0,     0,    21,     0,   114,
     115,   116,     0,   117,    23,     0,    24,     0,   118,     0,
      26,   119,    27,   120,    28,   121,    29,    30,   122,     0,
     123,     0,   124,    31,     0,     0,     0,     0,     0,     0,
      32,   125,     0,     0,     0,     0,   126,     0,   127,     0,
     128,     0,     0,  -170,     0,     0,     0,     0,  -170,  -170,
      33,     0,     0,     0,     0,     0,     0,     0,  -170,     0,
       0,     0,  -170,  -170,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    36,    37,    38,     0,    39,    40,
      41,    42,    43,    44,    45,    46,    47,   129,  -170,     0,
       0,     0,  -170,    48,     0,     0,     0,  -170,     0,   273,
       0,    50,   362,     0,     0,   130,   109,   131,   110,     6,
       7,   111,     0,     8,     0,     0,     0,     9,    10,    11,
      12,     0,     0,     0,   112,     0,    16,    17,    18,   113,
       0,     0,     0,    21,     0,   114,   115,   116,     0,   117,
      23,     0,    24,     0,   118,     0,    26,   119,    27,   120,
      28,   121,    29,    30,   122,     0,   123,     0,   124,    31,
       0,     0,     0,     0,     0,     0,    32,   125,     0,     0,
       0,     0,   126,     0,   127,     0,   128,     0,     0,  -170,
       0,     0,     0,     0,  -170,  -170,    33,     0,     0,     0,
       0,     0,     0,     0,  -170,     0,     0,     0,  -170,  -170,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      36,    37,    38,     0,    39,    40,    41,    42,    43,    44,
      45,    46,    47,   129,  -170,     0,     0,     0,  -170,    48,
       0,     0,     0,  -170,     0,   273,     0,    50,   363,     0,
       0,   130,   109,   131,   110,     6,     7,   111,     0,     8,
       0,     0,     0,     9,    10,    11,    12,     0,     0,     0,
     112,     0,    16,    17,    18,   113,     0,     0,     0,    21,
       0,   114,   115,   116,     0,   117,    23,     0,    24,     0,
     118,     0,    26,   119,    27,   120,    28,   121,    29,    30,
     122,     0,   123,     0,   124,    31,     0,     0,     0,     0,
       0,     0,    32,   125,     0,     0,     0,     0,   126,     0,
     127,     0,   128,     0,     0,  -170,     0,     0,     0,     0,
    -170,  -170,    33,     0,     0,     0,     0,     0,     0,     0,
    -170,     0,     0,     0,  -170,  -170,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    36,    37,    38,     0,
      39,    40,    41,    42,    43,    44,    45,    46,    47,   129,
    -170,     0,     0,     0,  -170,    48,     0,     0,     0,  -170,
       0,     2,     3,    50,   536,     0,     4,   130,     0,   131,
       5,     0,     6,     7,     0,     0,     8,   173,     0,     0,
       9,    10,    11,    12,     0,    13,    14,     0,    15,    16,
      17,    18,     0,    19,    20,     0,    21,     0,     0,     0,
       0,    22,     0,    23,     0,    24,     0,     0,    25,    26,
       0,    27,     0,    28,     0,    29,    30,     0,     0,     0,
       0,     0,    31,     0,     0,     0,     0,     0,     0,    32,
       0,   174,   175,   176,   177,   178,   179,   180,   181,   182,
     183,   184,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    34,     0,   185,   186,     0,     0,     0,     0,   187,
     433,     0,    35,    36,    37,    38,     0,    39,    40,    41,
      42,    43,    44,    45,    46,    47,     0,     0,     0,     0,
       0,     0,    48,     0,    49,     0,     0,     0,    19,   109,
      50,   110,     6,     7,   111,     0,     8,     0,     0,     0,
       9,    10,    11,    12,     0,     0,     0,   112,     0,    16,
      17,    18,   113,     0,     0,     0,    21,     0,   114,   115,
     116,     0,   117,    23,     0,    24,     0,   118,     0,    26,
     119,    27,   120,    28,   121,    29,    30,   122,     0,   123,
       0,   124,    31,     0,    33,   223,     0,   224,     0,    32,
     125,     0,     0,     0,     0,   126,   225,   127,     0,   128,
       0,     0,     0,     0,     0,     0,     0,    35,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   226,     0,   227,     0,    48,     0,    77,
      78,     0,   228,    36,    37,    38,     0,    39,    40,    41,
      42,    43,    44,    45,    46,    47,   129,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   166,     0,
      50,     0,     0,     0,   130,   109,   131,   110,     6,     7,
     111,     0,     8,     0,     0,     0,     9,    10,    11,    12,
       0,     0,     0,   112,     0,    16,    17,    18,   113,     0,
       0,     0,    21,     0,   114,   115,   116,   173,   117,    23,
       0,    24,     0,   118,     0,    26,   119,    27,   120,    28,
     121,    29,    30,   122,     0,   123,     0,   124,    31,     0,
       0,     0,     0,     0,     0,    32,   125,     0,     0,     0,
       0,   126,     0,   127,     0,   128,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   174,   175,   176,   177,   178,   179,   180,   181,   182,
     183,   184,     0,     0,     0,     0,     0,     0,     0,    36,
      37,    38,     0,    39,    40,    41,    42,    43,    44,    45,
      46,    47,   129,   185,   186,     0,     0,     0,     0,   187,
       0,     0,     0,     0,     0,     0,    50,     6,     7,     0,
     130,     8,   131,     0,     0,     9,    10,    11,    12,     0,
       0,     0,     0,     0,    16,    17,    18,     0,     0,     0,
       0,    21,     0,     0,     0,     0,     0,     0,    23,     0,
      24,     0,     0,     0,    26,     0,    27,     0,    28,     0,
      29,    30,     0,     0,     0,     0,     0,    31,     0,     0,
     278,     0,   279,   280,    32,   281,     0,   282,     0,   283,
       0,     0,     0,   284,     0,     0,   278,     0,   279,   280,
     286,   281,     0,   282,     0,   283,     0,     0,   287,   284,
       0,     0,     0,     0,     0,     0,   286,     0,     0,     0,
       0,     0,     0,     0,   287,     0,     0,     0,    36,    37,
      38,   173,    39,    40,    41,    42,    43,    44,    45,    46,
      47,     0,    87,     0,     0,     0,   465,     0,     0,     0,
       0,     0,     0,     0,     0,    50,   289,   290,   291,   292,
     293,     0,   542,   294,   295,     0,     0,   296,     0,     0,
       0,     0,   289,   290,   291,   292,   293,     0,     0,   294,
     295,     0,     0,   296,     0,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   185,   186
};

static const short int yycheck[] =
{
       1,     1,     8,    91,    74,    99,    99,   113,   152,    70,
     138,    86,    18,    41,    42,   266,   176,   193,    24,   193,
      83,     4,   379,    93,    94,    31,   176,    28,   178,     1,
     288,   139,    59,    65,    96,     1,    16,    37,    38,    39,
      40,   104,    43,    44,    45,    46,    47,    61,   253,   254,
     114,    79,   257,   258,    32,   260,    32,   262,   122,    88,
      61,     1,    90,     1,   126,   152,   100,    95,   136,   137,
      98,    48,   343,    50,   138,   133,   134,   100,   349,   107,
     108,   168,   144,   440,    24,    23,    88,    27,   136,   137,
     158,    68,    32,    33,    91,   141,    36,   141,   100,   133,
      40,   139,   131,   164,    82,   137,   106,    47,   139,    91,
     133,    89,   113,    91,   141,   159,   139,   145,   193,   147,
     148,   139,   228,     1,   152,    59,    89,   139,    91,   131,
     127,   133,   129,   111,   126,   111,    99,    15,   140,   136,
     391,   399,   170,   135,   172,   127,   126,   129,   149,   150,
      91,   152,   152,   117,   136,   133,   120,   171,    99,   516,
     418,   419,   139,   169,   340,   341,   340,    91,   168,   152,
     171,   111,   118,   119,   202,    53,   204,   123,   179,   180,
     181,   182,   183,   166,   212,   213,   152,   139,   216,   349,
     151,   152,    81,   343,   416,   417,   168,    86,    87,   349,
     140,   265,   168,   127,    89,   129,    91,    96,   296,     3,
      88,   100,   101,   104,   132,     4,   107,     6,   109,    38,
      39,   156,   100,   155,   156,    14,   133,    46,    17,    18,
      49,    62,    63,    64,    23,    66,   237,   126,   133,    58,
     133,   130,   270,   244,   272,    34,   135,   126,   139,   139,
      39,   128,     3,   131,    43,   133,   317,    46,    89,   435,
      91,   435,   140,    94,   151,    91,   341,   141,    57,    58,
     333,   277,    89,   379,    91,   131,   152,    16,   127,   127,
      97,   532,    62,    63,    64,   137,    66,     4,   376,     6,
     155,   142,   380,    32,   141,   141,    95,    14,   139,   133,
      17,    18,   139,     7,   509,   133,   141,   382,   308,   142,
     139,   147,   135,   158,    52,   133,   141,    34,   142,    45,
     141,    61,    39,   427,   168,   308,    43,    32,   492,    46,
     458,   115,   152,   461,   440,   308,   511,    23,   103,   120,
      57,    58,   121,   243,   133,   346,   347,   348,   124,    88,
      89,   140,    91,   452,   506,   537,   228,   469,   395,    -1,
     435,   100,   423,   382,    -1,    -1,    -1,    -1,   374,    -1,
      -1,    -1,   111,    -1,    -1,    80,    -1,    82,   379,    32,
      -1,   381,    -1,    -1,    89,    -1,    91,   531,   127,    -1,
     129,    -1,   131,    -1,   133,   134,    -1,   136,   426,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   111,    -1,    -1,    -1,
     516,    -1,    -1,   507,   507,    -1,   133,    70,   506,    72,
      73,    -1,    75,   140,    77,    -1,   496,    -1,   133,    -1,
      -1,   432,    -1,    -1,    -1,    -1,    89,    -1,    -1,   440,
      -1,   146,    -1,    -1,    -1,    98,    -1,    -1,    -1,   537,
      -1,    -1,   452,    -1,    -1,    -1,    -1,    -1,   111,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   481,    -1,   483,   479,   485,
     133,   134,    -1,   136,   137,    -1,    -1,    -1,    -1,   142,
      -1,   144,   145,   146,   147,   148,   149,   150,    -1,    -1,
     153,   154,    -1,    -1,   157,    -1,    -1,    -1,    -1,   510,
      -1,    -1,   513,   514,    -1,   516,     8,    -1,    10,    11,
      12,    13,    -1,    15,    -1,    -1,    -1,    19,    20,    21,
      22,    -1,    -1,    -1,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    35,   545,    37,    38,    39,    40,    41,
      42,    -1,    44,    -1,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    -1,    58,    -1,    60,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    -1,    88,    89,    90,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   111,
     112,   113,   114,    -1,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,    -1,   127,    -1,   129,    -1,   131,
      -1,   133,   134,    -1,   136,    -1,    -1,   139,    -1,    -1,
      -1,   143,    -1,   145,   146,   147,   148,   149,   150,     1,
      -1,   153,   154,    -1,    -1,   157,     8,    -1,    10,    11,
      12,    13,    -1,    15,    -1,    -1,    -1,    19,    20,    21,
      22,    -1,    24,    -1,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    35,    36,    37,    38,    39,    40,    41,
      42,    -1,    44,    -1,    46,    -1,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    -1,    58,    -1,    60,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    -1,    -1,
      -1,    -1,    74,    -1,    76,    -1,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,   100,   101,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     112,   113,   114,    -1,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,    -1,    -1,    -1,   130,    -1,
      -1,    -1,    -1,   135,    -1,     1,    -1,   139,   140,    -1,
      -1,   143,     8,   145,    10,    11,    12,    13,    -1,    15,
      -1,    -1,    -1,    19,    20,    21,    22,    -1,    24,    -1,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    35,
      36,    37,    38,    39,    40,    41,    42,    -1,    44,    -1,
      46,    -1,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    -1,    60,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    69,    -1,    -1,    -1,    -1,    74,    -1,
      76,    -1,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    -1,    -1,    -1,   100,   101,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   112,   113,   114,    -1,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,    -1,    -1,    -1,   130,    -1,    -1,    -1,    -1,   135,
      -1,     1,    -1,   139,   140,    -1,    -1,   143,     8,   145,
      10,    11,    12,    13,    -1,    15,    -1,    -1,    -1,    19,
      20,    21,    22,    -1,    -1,    -1,    26,    -1,    28,    29,
      30,    31,    -1,    -1,    -1,    35,    -1,    37,    38,    39,
      -1,    41,    42,    -1,    44,    -1,    46,    -1,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    -1,    58,    -1,
      60,    61,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      -1,    -1,    -1,    -1,    74,    -1,    76,    -1,    78,    -1,
      -1,    81,    -1,    -1,    -1,    -1,    86,    87,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,
     100,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,    -1,    -1,    -1,
     130,   131,    -1,    -1,    -1,   135,    -1,     1,    -1,   139,
     140,    -1,    -1,   143,     8,   145,    10,    11,    12,    13,
      -1,    15,    -1,    -1,    -1,    19,    20,    21,    22,    -1,
      -1,    -1,    26,    -1,    28,    29,    30,    31,    -1,    -1,
      -1,    35,    -1,    37,    38,    39,    -1,    41,    42,    -1,
      44,    -1,    46,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    -1,    58,    -1,    60,    61,    -1,    -1,
      -1,    -1,    -1,    67,    68,    69,    -1,    -1,    -1,    -1,
      74,    -1,    76,    -1,    78,    -1,    -1,    81,    -1,    -1,
      -1,    -1,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    -1,    -1,    -1,   100,   101,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   112,   113,
     114,    -1,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,    -1,    -1,    -1,   130,   131,    -1,    -1,
      -1,   135,    -1,     1,    -1,   139,    -1,    -1,    -1,   143,
       8,   145,    10,    11,    12,    13,    -1,    15,    -1,    -1,
      -1,    19,    20,    21,    22,    -1,    -1,    -1,    26,    -1,
      28,    29,    30,    31,    -1,    -1,    -1,    35,    -1,    37,
      38,    39,    -1,    41,    42,    -1,    44,    -1,    46,    -1,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    -1,
      58,    -1,    60,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    69,    -1,    -1,    -1,    -1,    74,    -1,    76,    -1,
      78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    86,    87,
      88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    -1,
      -1,    -1,   100,   101,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,    -1,
      -1,    -1,   130,   131,    -1,    -1,    -1,   135,    -1,     1,
      -1,   139,   140,    -1,    -1,   143,     8,   145,    10,    11,
      12,    13,    -1,    15,    -1,    -1,    -1,    19,    20,    21,
      22,    -1,    -1,    -1,    26,    -1,    28,    29,    30,    31,
      -1,    -1,    -1,    35,    -1,    37,    38,    39,    -1,    41,
      42,    -1,    44,    -1,    46,    -1,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    -1,    58,    -1,    60,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    -1,    -1,
      -1,    -1,    74,    -1,    76,    -1,    78,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    86,    87,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,   100,   101,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     112,   113,   114,    -1,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,    -1,    -1,    -1,   130,   131,
      -1,    -1,    -1,   135,    -1,     1,    -1,   139,   140,    -1,
      -1,   143,     8,   145,    10,    11,    12,    13,    -1,    15,
      -1,    -1,    -1,    19,    20,    21,    22,    -1,    -1,    -1,
      26,    -1,    28,    29,    30,    31,    -1,    -1,    -1,    35,
      -1,    37,    38,    39,    -1,    41,    42,    -1,    44,    -1,
      46,    -1,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    -1,    60,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    69,    -1,    -1,    -1,    -1,    74,    -1,
      76,    -1,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    -1,    -1,    -1,   100,   101,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   112,   113,   114,    -1,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,    -1,    -1,    -1,   130,   131,    -1,    -1,    -1,   135,
      -1,     0,     1,   139,   140,    -1,     5,   143,    -1,   145,
       9,    -1,    11,    12,    -1,    -1,    15,    47,    -1,    -1,
      19,    20,    21,    22,    -1,    24,    25,    -1,    27,    28,
      29,    30,    -1,    32,    33,    -1,    35,    -1,    -1,    -1,
      -1,    40,    -1,    42,    -1,    44,    -1,    -1,    47,    48,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      -1,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   100,    -1,   133,   134,    -1,    -1,    -1,    -1,   139,
     140,    -1,   111,   112,   113,   114,    -1,   116,   117,   118,
     119,   120,   121,   122,   123,   124,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,   133,    -1,    -1,    -1,    32,     8,
     139,    10,    11,    12,    13,    -1,    15,    -1,    -1,    -1,
      19,    20,    21,    22,    -1,    -1,    -1,    26,    -1,    28,
      29,    30,    31,    -1,    -1,    -1,    35,    -1,    37,    38,
      39,    -1,    41,    42,    -1,    44,    -1,    46,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    -1,    58,
      -1,    60,    61,    -1,    88,    89,    -1,    91,    -1,    68,
      69,    -1,    -1,    -1,    -1,    74,   100,    76,    -1,    78,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   111,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   127,    -1,   129,    -1,   131,    -1,   133,
     134,    -1,   136,   112,   113,   114,    -1,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,
     139,    -1,    -1,    -1,   143,     8,   145,    10,    11,    12,
      13,    -1,    15,    -1,    -1,    -1,    19,    20,    21,    22,
      -1,    -1,    -1,    26,    -1,    28,    29,    30,    31,    -1,
      -1,    -1,    35,    -1,    37,    38,    39,    47,    41,    42,
      -1,    44,    -1,    46,    -1,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    -1,    58,    -1,    60,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    69,    -1,    -1,    -1,
      -1,    74,    -1,    76,    -1,    78,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   133,   134,    -1,    -1,    -1,    -1,   139,
      -1,    -1,    -1,    -1,    -1,    -1,   139,    11,    12,    -1,
     143,    15,   145,    -1,    -1,    19,    20,    21,    22,    -1,
      -1,    -1,    -1,    -1,    28,    29,    30,    -1,    -1,    -1,
      -1,    35,    -1,    -1,    -1,    -1,    -1,    -1,    42,    -1,
      44,    -1,    -1,    -1,    48,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      70,    -1,    72,    73,    68,    75,    -1,    77,    -1,    79,
      -1,    -1,    -1,    83,    -1,    -1,    70,    -1,    72,    73,
      90,    75,    -1,    77,    -1,    79,    -1,    -1,    98,    83,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   112,   113,
     114,    47,   116,   117,   118,   119,   120,   121,   122,   123,
     124,    -1,   126,    -1,    -1,    -1,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   139,   146,   147,   148,   149,
     150,    -1,   136,   153,   154,    -1,    -1,   157,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,   150,    -1,    -1,   153,
     154,    -1,    -1,   157,    -1,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   133,   134
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,   161,     0,     1,     5,     9,    11,    12,    15,    19,
      20,    21,    22,    24,    25,    27,    28,    29,    30,    32,
      33,    35,    40,    42,    44,    47,    48,    50,    52,    54,
      55,    61,    68,    88,   100,   111,   112,   113,   114,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   131,   133,
     139,   163,   164,   165,   167,   168,   169,   173,   175,   178,
     179,   180,   185,   186,   187,   192,   193,   194,   195,   196,
     197,   198,   199,   203,   219,   224,   277,   133,   134,   211,
     139,   100,   133,   212,   139,   212,   278,   126,   192,   237,
     244,   212,   139,   139,   139,   165,    91,    99,   249,   135,
     237,   238,   239,   240,   212,   277,   277,   277,   277,     8,
      10,    13,    26,    31,    37,    38,    39,    41,    46,    49,
      51,    53,    56,    58,    60,    69,    74,    76,    78,   125,
     143,   145,   181,   183,   188,   192,   205,   210,   214,   215,
     216,   217,   221,   225,   226,   183,   165,   165,   165,   165,
     165,   182,   141,   139,     1,    15,   140,   169,   171,   181,
       3,   200,   193,    59,   189,   182,   137,   183,   174,   141,
     189,   166,   204,    47,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   133,   134,   139,   279,   280,
     281,   282,   284,   285,   286,   151,   152,   235,   236,   183,
      89,    91,   271,   132,   176,   182,   182,   183,   156,   183,
     235,   236,   240,   189,   277,   183,   183,   133,   133,   133,
      16,   126,    16,    89,    91,   100,   127,   129,   136,   165,
     211,   213,   270,   272,   277,   239,   210,   209,   212,    97,
     245,   247,   248,   271,   209,   209,   245,   247,   239,   209,
     249,    81,    86,    87,    96,   100,   101,   130,   238,   239,
     257,   259,   260,   261,   275,   222,   246,   248,   183,   183,
     183,   165,   165,     1,   140,   165,   183,    15,    70,    72,
      73,    75,    77,    79,    83,    89,    90,    98,   136,   146,
     147,   148,   149,   150,   153,   154,   157,   165,   170,   171,
     175,   178,   183,   211,   229,   230,   231,   232,   243,   251,
     267,   268,   269,   270,   277,   128,   139,   201,     3,   190,
     193,    67,   220,   211,     1,    36,   140,   162,   167,   175,
     177,   178,   277,   212,   183,   140,   169,   183,   287,   280,
     285,   285,   286,   288,   165,   165,   165,   165,   165,   283,
     282,   284,   286,   151,   152,   183,     1,   140,   162,   167,
     178,   183,   140,   140,    91,   183,   183,   183,   141,   131,
     127,   127,   272,   165,   142,   250,   155,   250,   165,   141,
     141,   256,   276,   246,   246,   246,   246,   273,   246,   227,
     246,    96,   144,   218,   223,   239,   227,   183,   183,   136,
     269,   271,    89,   136,   137,   142,   144,   145,   153,   154,
     211,   232,   233,   241,   242,   277,   136,   137,   155,   156,
      95,   172,   193,   202,   139,   133,   189,   139,   286,   288,
     165,   165,   165,   140,   280,   285,   288,     7,   184,   133,
     141,   212,   142,    99,   271,   213,   271,    80,    82,    89,
      91,   133,   146,   252,   254,   255,   277,   279,    62,    63,
      64,    66,   263,   158,   274,   136,   228,   229,   227,   273,
     268,   268,   269,   269,     4,     6,    14,    17,    18,    23,
      34,    39,    43,    46,    57,    58,   133,   140,   206,   207,
     208,   193,   191,   183,   176,   165,   139,   213,   254,   136,
     137,   158,   253,   147,   238,   238,   262,   141,   159,   234,
      52,   274,   165,   212,   212,   212,   141,   133,   140,   208,
     140,   182,    94,   263,   264,   265,   266,   271,   235,   236,
     246,   165,   234,   165,   165,   213,   140,   142,    65,   137,
      45,   258,   136,   229,   227,   141,   266,   165
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror (_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, &yylloc, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, &yylloc)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value, Location);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, _("Stack now"));
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, _("Reducing stack by rule %d (line %u), "),
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep, yylocationp)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;
  (void) yylocationp;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  fprintf (yyoutput, ": ");

# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, yylocationp)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;
  (void) yylocationp;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;
/* Location data for the look-ahead symbol.  */
YYLTYPE yylloc;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;

  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
  /* The locations where the error started and ended. */
  YYLTYPE yyerror_range[2];

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
  yylsp = yyls;
#if YYLTYPE_IS_TRIVIAL
  /* Initialize the default location before parsing starts.  */
  yylloc.first_line   = yylloc.last_line   = 1;
  yylloc.first_column = yylloc.last_column = 0;
#endif


  yyvsp[0] = yylval;
    yylsp[0] = yylloc;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;
	YYLTYPE *yyls1 = yyls;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (_("parser stack overflow"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
	YYSTACK_RELOCATE (yyls);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, _("Stack size increased to %lu\n"),
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, _("Entering state %d\n"), yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, _("Reading a token: ")));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, _("Now at end of input.\n")));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT (_("Next token is"), yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT (_("Shifting"), yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
  *++yylsp = yylloc;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, yylsp - yylen, yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:
#line 552 "parser.yy"
    {
	;}
    break;

  case 4:
#line 554 "parser.yy"
    {
	;}
    break;

  case 5:
#line 556 "parser.yy"
    {
		THIS->error_level_ = 1;
	;}
    break;

  case 6:
#line 559 "parser.yy"
    {
		THIS->error_level_ = 1;
	;}
    break;

  case 7:
#line 566 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 8:
#line 570 "parser.yy"
    {
		THIS->lexer_->set_identifier (ly_symbol2scm ("$globalheader"), (yyvsp[0].scm));
	;}
    break;

  case 9:
#line 573 "parser.yy"
    {
	
	;}
    break;

  case 10:
#line 576 "parser.yy"
    {
		Book *book = (yyvsp[0].book);
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-book-handler");
		scm_call_2 (proc, THIS->self_scm (), book->self_scm ());
 		scm_gc_unprotect_object (book->self_scm ());
	;}
    break;

  case 11:
#line 582 "parser.yy"
    {
		Score *score = (yyvsp[0].score);
		
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-score-handler");
		scm_call_2 (proc, THIS->self_scm (), score->self_scm ());
 		scm_gc_unprotect_object (score->self_scm ());
	;}
    break;

  case 12:
#line 589 "parser.yy"
    {
		Music *music = (yyvsp[0].music);
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-music-handler");
		scm_call_2 (proc, THIS->self_scm (), music->self_scm ());
 		scm_gc_unprotect_object (music->self_scm ());
	;}
    break;

  case 13:
#line 595 "parser.yy"
    {
		SCM proc = THIS->lexer_->lookup_identifier ("toplevel-text-handler");
		scm_call_2 (proc, THIS->self_scm (), (yyvsp[0].scm));
	;}
    break;

  case 14:
#line 599 "parser.yy"
    {
		SCM id = SCM_EOL;
		Output_def * od = (yyvsp[0].outputdef);

		if ((yyvsp[0].outputdef)->c_variable ("is-paper") == SCM_BOOL_T)
			id = ly_symbol2scm ("$defaultpaper");
		else if ((yyvsp[0].outputdef)->c_variable ("is-midi") == SCM_BOOL_T)
			id = ly_symbol2scm ("$defaultmidi");
		else if ((yyvsp[0].outputdef)->c_variable ("is-layout") == SCM_BOOL_T)
			id = ly_symbol2scm ("$defaultlayout");

		THIS->lexer_->set_identifier (id, od->self_scm ());
		scm_gc_unprotect_object (od->self_scm ());
	;}
    break;

  case 15:
#line 616 "parser.yy"
    {
	;}
    break;

  case 18:
#line 627 "parser.yy"
    {
		(yyval.scm) = ly_make_anonymous_module (be_safe_global);
		THIS->lexer_->add_scope ((yyval.scm));
	;}
    break;

  case 19:
#line 631 "parser.yy"
    {
		
	;}
    break;

  case 20:
#line 637 "parser.yy"
    {
		(yyval.scm) = THIS->lexer_->remove_scope ();
	;}
    break;

  case 21:
#line 646 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 22:
#line 647 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 23:
#line 651 "parser.yy"
    {
		if (! is_regular_identifier ((yyvsp[-2].scm)))
		{
			(yylsp[-2]).warning (_ ("identifier should have alphabetic characters only"));
		}

	        THIS->lexer_->set_identifier ((yyvsp[-2].scm), (yyvsp[0].scm));

/*
 TODO: devise standard for protection in parser.

  The parser stack lives on the C-stack, which means that
all objects can be unprotected as soon as they're here.

*/
	;}
    break;

  case 24:
#line 667 "parser.yy"
    { ;}
    break;

  case 25:
#line 672 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].score)->self_scm ();
		scm_gc_unprotect_object ((yyval.scm));
	;}
    break;

  case 26:
#line 676 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].outputdef)->self_scm ();
		scm_gc_unprotect_object ((yyval.scm));
	;}
    break;

  case 27:
#line 680 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 28:
#line 683 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].music)->self_scm ();
		scm_gc_unprotect_object ((yyval.scm));
	;}
    break;

  case 29:
#line 687 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].music)->self_scm ();
		scm_gc_unprotect_object ((yyval.scm));
	;}
    break;

  case 30:
#line 691 "parser.yy"
    {
 		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 31:
#line 694 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 32:
#line 697 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 33:
#line 700 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 34:
#line 703 "parser.yy"
    {
		(yyval.scm) = scm_int2num ((yyvsp[0].i));
	;}
    break;

  case 35:
#line 710 "parser.yy"
    {
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 36:
#line 716 "parser.yy"
    {
		(yyval.scm) = Context_def::make_scm ();
		unsmob_context_def ((yyval.scm))->set_spot ((yyloc));
	;}
    break;

  case 37:
#line 720 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		unsmob_context_def ((yyval.scm))->set_spot ((yyloc));
	;}
    break;

  case 38:
#line 724 "parser.yy"
    {
		Context_def*td = unsmob_context_def ((yyval.scm));

		for (SCM p = (yyvsp[0].scm); scm_is_pair (p); p = scm_cdr (p)) {
			SCM tag = scm_caar (p);

			/* TODO: should make new tag "grob-definition" ? */
			td->add_context_mod (scm_list_3 (ly_symbol2scm ("assign"),
							tag, scm_cons (scm_cdar (p), SCM_EOL)));
		}
	;}
    break;

  case 39:
#line 735 "parser.yy"
    {
		unsmob_context_def ((yyval.scm))->add_context_mod ((yyvsp[0].scm));		
	;}
    break;

  case 40:
#line 743 "parser.yy"
    {
		(yyval.book) = (yyvsp[-1].book);
	;}
    break;

  case 41:
#line 752 "parser.yy"
    {
		(yyval.book) = new Book;
		(yyval.book)->set_spot ((yyloc));
		(yyval.book)->paper_ = dynamic_cast<Output_def*> (unsmob_output_def (THIS->lexer_->lookup_identifier ("$defaultpaper"))->clone ());
		scm_gc_unprotect_object ((yyval.book)->paper_->self_scm ());
		(yyval.book)->header_ = THIS->lexer_->lookup_identifier ("$globalheader"); 
	;}
    break;

  case 42:
#line 759 "parser.yy"
    {
		(yyval.book)->paper_ = (yyvsp[0].outputdef);
		scm_gc_unprotect_object ((yyvsp[0].outputdef)->self_scm ());
	;}
    break;

  case 43:
#line 763 "parser.yy"
    {
		SCM s = (yyvsp[0].score)->self_scm ();
		(yyval.book)->add_score (s);
		scm_gc_unprotect_object (s);
	;}
    break;

  case 44:
#line 768 "parser.yy"
    {
		(yyval.book)->add_score ((yyvsp[0].scm));
	;}
    break;

  case 45:
#line 771 "parser.yy"
    {
		(yyval.book)->header_ = (yyvsp[0].scm);
	;}
    break;

  case 46:
#line 774 "parser.yy"
    {
		(yyval.book)->paper_ = 0;
		(yyval.book)->scores_ = SCM_EOL;
	;}
    break;

  case 47:
#line 778 "parser.yy"
    {
		(yyval.book)->user_key_ = ly_scm2string ((yyvsp[0].scm));
	;}
    break;

  case 48:
#line 784 "parser.yy"
    {
		(yyval.score) = (yyvsp[-1].score);
	;}
    break;

  case 49:
#line 790 "parser.yy"
    {
		(yyval.score) = new Score;
		(yyval.score)->set_spot ((yyloc));
	;}
    break;

  case 50:
#line 794 "parser.yy"
    {
		(yyval.score) = new Score ( *unsmob_score ((yyvsp[0].scm)));
		(yyval.score)->set_spot ((yyloc));
	;}
    break;

  case 51:
#line 798 "parser.yy"
    {
		(yyval.score)->user_key_ = ly_scm2string ((yyvsp[0].scm));
	;}
    break;

  case 52:
#line 801 "parser.yy"
    {
		SCM m = (yyvsp[0].music)->self_scm ();
		scm_gc_unprotect_object (m);
		(yyval.score)->set_music (m, THIS->self_scm ());
	;}
    break;

  case 53:
#line 806 "parser.yy"
    {
		(yyval.score)->header_ = (yyvsp[0].scm);
	;}
    break;

  case 54:
#line 809 "parser.yy"
    {
		if ((yyvsp[0].outputdef)->lookup_variable (ly_symbol2scm ("is-paper")) == SCM_BOOL_T)
		{
			THIS->parser_error ((yylsp[0]), _("\\paper cannot be used in \\score, use \\layout instead"));
		
		}
		else
		{
			(yyval.score)->defs_.push ((yyvsp[0].outputdef));
		}
		scm_gc_unprotect_object ((yyvsp[0].outputdef)->self_scm ());
	;}
    break;

  case 55:
#line 821 "parser.yy"
    {
		(yyval.score)->error_found_ = true;
	;}
    break;

  case 56:
#line 832 "parser.yy"
    {
		(yyval.outputdef) = (yyvsp[0].outputdef);
		if ((yyval.outputdef)->lookup_variable (ly_symbol2scm ("is-paper")) != SCM_BOOL_T)
		{
			THIS->parser_error ((yylsp[0]), _ ("need \\paper for paper block"));
			(yyval.outputdef) = get_paper (THIS);
		}
	;}
    break;

  case 57:
#line 844 "parser.yy"
    {
		(yyval.outputdef) = (yyvsp[-1].outputdef);

		THIS->lexer_->remove_scope ();
		THIS->lexer_->pop_state ();
	;}
    break;

  case 58:
#line 853 "parser.yy"
    {
		(yyval.outputdef) = get_paper (THIS);
		(yyval.outputdef)->input_origin_ = (yyloc);
		THIS->lexer_->add_scope ((yyval.outputdef)->scope_);
	;}
    break;

  case 59:
#line 858 "parser.yy"
    {
		Output_def *p = get_midi (THIS);
		(yyval.outputdef) = p;
		THIS->lexer_->add_scope (p->scope_);
	;}
    break;

  case 60:
#line 863 "parser.yy"
    {
		Output_def *p = get_layout (THIS);

		THIS->lexer_->add_scope (p->scope_);
		(yyval.outputdef) = p;
	;}
    break;

  case 61:
#line 873 "parser.yy"
    {
		(yyval.outputdef) = (yyvsp[-1].outputdef);
		(yyval.outputdef)->input_origin_.set_spot ((yyloc));
		THIS->lexer_->push_initial_state ();
	;}
    break;

  case 62:
#line 878 "parser.yy"
    {
		scm_gc_unprotect_object ((yyvsp[-2].outputdef)->self_scm ());
		Output_def *o = unsmob_output_def ((yyvsp[0].scm));
		o->input_origin_.set_spot ((yyloc));
		(yyval.outputdef) = o;
		THIS->lexer_->remove_scope ();
		THIS->lexer_->add_scope (o->scope_);
		THIS->lexer_->push_initial_state ();
	;}
    break;

  case 63:
#line 887 "parser.yy"
    {

	;}
    break;

  case 64:
#line 890 "parser.yy"
    {
		assign_context_def ((yyval.outputdef), (yyvsp[0].scm));
	;}
    break;

  case 65:
#line 893 "parser.yy"
    {
		/*
			junk this ? there already is tempo stuff in
			music.
		*/
		int m = scm_to_int ((yyvsp[0].music)->get_property ("metronome-count"));
		Duration *d = unsmob_duration ((yyvsp[0].music)->get_property ("tempo-unit"));
		set_tempo ((yyval.outputdef), d->get_length (), m);
		scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ());
	;}
    break;

  case 66:
#line 903 "parser.yy"
    {

	;}
    break;

  case 67:
#line 909 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("MetronomeChangeEvent");
		(yyval.music)->set_property ("tempo-unit", (yyvsp[-2].scm));
		(yyval.music)->set_property ("metronome-count", scm_int2num ( (yyvsp[0].i)));
	;}
    break;

  case 68:
#line 924 "parser.yy"
    {
		(yyval.scm) = scm_cons (SCM_EOL, SCM_EOL);
	;}
    break;

  case 69:
#line 927 "parser.yy"
    {
		SCM s = (yyval.scm);
 		SCM c = scm_cons ((yyvsp[0].music)->self_scm (), SCM_EOL);
		scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ()); /* UGH */

		if (scm_is_pair (scm_cdr (s)))
			scm_set_cdr_x (scm_cdr (s), c); /* append */
		else
			scm_set_car_x (s, c); /* set first cons */
		scm_set_cdr_x (s, c);  /* remember last cell */
	;}
    break;

  case 70:
#line 938 "parser.yy"
    {

	;}
    break;

  case 71:
#line 941 "parser.yy"
    {
		Music * m = MY_MAKE_MUSIC("Music");
		// ugh. code dup 
		m->set_property ("error-found", SCM_BOOL_T);
		SCM s = (yyval.scm);
 		SCM c = scm_cons (m->self_scm (), SCM_EOL);
		scm_gc_unprotect_object (m->self_scm ()); /* UGH */

		if (scm_is_pair (scm_cdr (s)))
			scm_set_cdr_x (scm_cdr (s), c); /* append */
		else
			scm_set_car_x (s, c); /* set first cons */
		scm_set_cdr_x (s, c);  /* remember last cell */
	;}
    break;

  case 74:
#line 963 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;
	;}
    break;

  case 75:
#line 966 "parser.yy"
    {
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 76:
#line 974 "parser.yy"
    {
		Music *beg = (yyvsp[-1].music);
		int times = (yyvsp[-2].i);
		SCM alts = scm_is_pair ((yyvsp[0].scm)) ? scm_car ((yyvsp[0].scm)) : SCM_EOL;
		if (times < scm_ilength (alts)) {
		  unsmob_music (scm_car (alts))
		    ->origin ()->warning (
		    _ ("more alternatives than repeats"));
		    warning ("junking excess alternatives");
		  alts = ly_truncate_list (times, alts);
		}


		SCM proc = ly_lily_module_constant ("make-repeated-music");

		SCM mus = scm_call_1 (proc, (yyvsp[-3].scm));
		scm_gc_protect_object (mus); // UGH.
		Music *r = unsmob_music (mus);
		if (beg)
			{
			r-> set_property ("element", beg->self_scm ());
			scm_gc_unprotect_object (beg->self_scm ());
			}
		r->set_property ("repeat-count", scm_int2num (times >? 1));

		r-> set_property ("elements",alts);
		if (ly_c_equal_p ((yyvsp[-3].scm), scm_makfrom0str ("tremolo"))) {
			/*
			TODO: move this code to Scheme.
			*/

			/* we cannot get durations and other stuff
			   correct down the line,
			   so we have to add to the duration log here. */
			SCM func = ly_lily_module_constant ("shift-duration-log");

			int dots = ((yyvsp[-2].i) % 3) ? 0 : 1;
			int shift = -intlog2 ((dots) ? ((yyvsp[-2].i)*2/3) : (yyvsp[-2].i));

			
			if ((yyvsp[-1].music)->is_mus_type ("sequential-music"))
			{
				int list_len = scm_ilength ((yyvsp[-1].music)->get_property ("elements"));
				if (list_len != 2)
					(yyvsp[-1].music)->origin ()->warning (_f ("expect 2 elements for Chord tremolo, found %d", list_len));
				shift -= 1;
				r->compress (Moment (Rational (1, list_len)));
			}
			scm_call_3 (func, r->self_scm (), scm_int2num (shift), scm_int2num (dots));

		}
		r->set_spot (*(yyvsp[-1].music)->origin ());

		(yyval.music) = r;
	;}
    break;

  case 77:
#line 1032 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SequentialMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 78:
#line 1037 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SequentialMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 79:
#line 1045 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SimultaneousMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));

	;}
    break;

  case 80:
#line 1051 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("SimultaneousMusic");
		(yyval.music)->set_property ("elements", scm_car ((yyvsp[-1].scm)));
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 81:
#line 1059 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 82:
#line 1060 "parser.yy"
    {
		(yyval.music) = unsmob_music ((yyvsp[0].scm));
	;}
    break;

  case 85:
#line 1069 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 86:
#line 1070 "parser.yy"
    { THIS->lexer_->push_initial_state (); ;}
    break;

  case 87:
#line 1072 "parser.yy"
    {
		THIS->lexer_->pop_state ();
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 88:
#line 1079 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 89:
#line 1080 "parser.yy"
    {
		 (yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 90:
#line 1087 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 91:
#line 1088 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 92:
#line 1092 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 93:
#line 1093 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 94:
#line 1097 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[0].scm), make_input ((yyloc)));
	;}
    break;

  case 95:
#line 1100 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-1].scm), make_input ((yyloc)), (yyvsp[0].scm));
	;}
    break;

  case 96:
#line 1103 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-1].scm), make_input ((yyloc)), (yyvsp[0].scm));
	;}
    break;

  case 97:
#line 1106 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-1].scm), make_input ((yyloc)), (yyvsp[0].music)->self_scm ());
		scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ());
	;}
    break;

  case 98:
#line 1110 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
		scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ());
	;}
    break;

  case 99:
#line 1114 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 100:
#line 1117 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
	;}
    break;

  case 101:
#line 1120 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
		scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ());
	;}
    break;

  case 102:
#line 1124 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 103:
#line 1127 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-2].scm), make_input ((yyloc)), (yyvsp[-1].music)->self_scm (), (yyvsp[0].music)->self_scm ());
		scm_gc_unprotect_object ((yyvsp[-1].music)->self_scm ());
		scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ());
	;}
    break;

  case 104:
#line 1132 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].music)->self_scm (), (yyvsp[0].music)->self_scm ());
		scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ());
		scm_gc_unprotect_object ((yyvsp[-1].music)->self_scm ());
	;}
    break;

  case 105:
#line 1137 "parser.yy"
    {
		(yyval.scm) = scm_list_5 ((yyvsp[-3].scm), make_input ((yyloc)), (yyvsp[-2].scm), (yyvsp[-1].music)->self_scm (), (yyvsp[0].music)->self_scm ());
		scm_gc_unprotect_object ((yyvsp[-1].music)->self_scm ());
		scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ());
	;}
    break;

  case 106:
#line 1145 "parser.yy"
    {
		SCM func = scm_car ((yyvsp[0].scm));
		Input *loc = unsmob_input (scm_cadr ((yyvsp[0].scm)));
		SCM args = scm_cddr ((yyvsp[0].scm));
		SCM sig = scm_object_property (func, ly_symbol2scm ("music-function-signature"));

		SCM type_check_proc = ly_lily_module_constant ("type-check-list");
		bool ok  = true;

		if (!to_boolean (scm_call_3  (type_check_proc, scm_cadr ((yyvsp[0].scm)), sig, args)))
		{
			THIS->error_level_ = 1;
			ok = false;
		}

		SCM m = SCM_EOL;
  		if (ok)
			m = scm_apply_0 (func, scm_cons (THIS->self_scm(),
							 scm_cdr ((yyvsp[0].scm))));

		if (unsmob_music (m))
			{
			(yyval.music) = unsmob_music (m);
			scm_gc_protect_object (m);
			}
		else
			{
			if (ok)
 				loc->error (_ ("music head function must return Music object")); 
			(yyval.music) = MY_MAKE_MUSIC ("Music");
			}
		(yyval.music)->set_spot (*loc);
	;}
    break;

  case 107:
#line 1182 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 108:
#line 1185 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-4].scm), (yyvsp[-2].scm), (yyvsp[0].music), (yyvsp[-1].scm));

	;}
    break;

  case 109:
#line 1189 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-2].scm), SCM_UNDEFINED, (yyvsp[0].music), (yyvsp[-1].scm));
	;}
    break;

  case 110:
#line 1192 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-2].scm), get_next_unique_context_id (), (yyvsp[0].music),
			(yyvsp[-1].scm));
	;}
    break;

  case 111:
#line 1199 "parser.yy"
    {
		int n = scm_to_int (scm_car ((yyvsp[-1].scm))); int d = scm_to_int (scm_cdr ((yyvsp[-1].scm)));
		Music *mp = (yyvsp[0].music);

		(yyval.music)= MY_MAKE_MUSIC ("TimeScaledMusic");
		(yyval.music)->set_spot ((yyloc));

		(yyval.music)->set_property ("element", mp->self_scm ());
		scm_gc_unprotect_object (mp->self_scm ());
		(yyval.music)->set_property ("numerator", scm_int2num (n));
		(yyval.music)->set_property ("denominator", scm_int2num (d));
		(yyval.music)->compress (Moment (Rational (n,d)));

	;}
    break;

  case 112:
#line 1213 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 113:
#line 1214 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("TransposedMusic");
		Music *p = (yyvsp[0].music);
		Pitch from = *unsmob_pitch ((yyvsp[-2].scm));
		Pitch to = *unsmob_pitch ((yyvsp[-1].scm));

		p->transpose (pitch_interval (from, to));
		(yyval.music)->set_property ("element", p->self_scm ());
		scm_gc_unprotect_object (p->self_scm ());
	;}
    break;

  case 114:
#line 1224 "parser.yy"
    {
		if ((yyvsp[-1].scm) == ly_symbol2scm ("chords"))
		{
		  Music *chm = MY_MAKE_MUSIC ("UnrelativableMusic");
		  chm->set_property ("element", (yyvsp[0].music)->self_scm ());
		  (yyval.music) = chm;
		  scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ());
		}
		else
		{
		  (yyval.music) = (yyvsp[0].music);
		}
		THIS->lexer_->pop_state ();
	;}
    break;

  case 115:
#line 1238 "parser.yy"
    {
		(yyval.music) = context_spec_music ((yyvsp[-2].scm), get_next_unique_context_id (),
					 (yyvsp[0].music), (yyvsp[-1].scm));
		if ((yyvsp[-2].scm) == ly_symbol2scm ("ChordNames"))
		{
		  Music *chm = MY_MAKE_MUSIC ("UnrelativableMusic");
		  chm->set_property ("element", (yyval.music)->self_scm ());
		  scm_gc_unprotect_object ((yyval.music)->self_scm ());
		  (yyval.music) = chm;
		}
		THIS->lexer_->pop_state ();
	;}
    break;

  case 116:
#line 1250 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 117:
#line 1251 "parser.yy"
    { (yyval.music) = (yyvsp[0].music); ;}
    break;

  case 118:
#line 1252 "parser.yy"
    {
		tag_music ((yyvsp[0].music), (yyvsp[-1].scm), (yyloc));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 119:
#line 1259 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));

		(yyval.scm) = ly_symbol2scm ("notes");
	;}
    break;

  case 120:
#line 1266 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("drumPitchNames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));

		(yyval.scm) = ly_symbol2scm ("drums");
	;}
    break;

  case 121:
#line 1272 "parser.yy"
    {
		THIS->lexer_->push_figuredbass_state ();

		(yyval.scm) = ly_symbol2scm ("figures");
	;}
    break;

  case 122:
#line 1277 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("chordmodifiers");
		THIS->lexer_->chordmodifier_tab_ = alist_to_hashq (nn);
		nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_chord_state (alist_to_hashq (nn));
		(yyval.scm) = ly_symbol2scm ("chords");

	;}
    break;

  case 123:
#line 1286 "parser.yy"
    { THIS->lexer_->push_lyric_state ();
		(yyval.scm) = ly_symbol2scm ("lyrics");
	;}
    break;

  case 124:
#line 1292 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("drumPitchNames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));

		(yyval.scm) = ly_symbol2scm ("DrumStaff");
	;}
    break;

  case 125:
#line 1298 "parser.yy"
    {
		THIS->lexer_->push_figuredbass_state ();

		(yyval.scm) = ly_symbol2scm ("FiguredBass");
	;}
    break;

  case 126:
#line 1303 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("chordmodifiers");
		THIS->lexer_->chordmodifier_tab_ = alist_to_hashq (nn);
		nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_chord_state (alist_to_hashq (nn));
		(yyval.scm) = ly_symbol2scm ("ChordNames");
	;}
    break;

  case 127:
#line 1311 "parser.yy"
    { THIS->lexer_->push_lyric_state ();
		(yyval.scm) = ly_symbol2scm ("Lyrics");
	;}
    break;

  case 128:
#line 1318 "parser.yy"
    {
		Music *m = (yyvsp[0].music);
		Pitch start = *unsmob_pitch ((yyvsp[-1].scm));
		(yyval.music) = make_music_relative (start, m);
		scm_gc_unprotect_object (m->self_scm ());
	;}
    break;

  case 129:
#line 1324 "parser.yy"
    {
		Music *m = (yyvsp[0].music);

		Pitch middle_c (0, 0, 0);
		(yyval.music) = make_music_relative (middle_c, m);
		scm_gc_unprotect_object (m->self_scm ());
	;}
    break;

  case 130:
#line 1334 "parser.yy"
    { THIS->lexer_->push_lyric_state (); ;}
    break;

  case 131:
#line 1336 "parser.yy"
    {
	/* Can also use Music at the expensive of two S/Rs similar to
           \repeat \alternative */
		THIS->lexer_->pop_state ();

		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), SCM_EOL);
	;}
    break;

  case 132:
#line 1343 "parser.yy"
    {
		THIS->lexer_->push_lyric_state ();
	;}
    break;

  case 133:
#line 1345 "parser.yy"
    {
		THIS->lexer_->pop_state ();
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyvsp[-3].scm));
	;}
    break;

  case 134:
#line 1352 "parser.yy"
    {
		Music * voice = (yyvsp[-1].music);
		SCM name = get_first_context_id (scm_makfrom0str ("Voice"), voice); 
		if (!scm_is_string (name))
		{
			name = get_next_unique_lyrics_context_id ();
			voice = context_spec_music (scm_makfrom0str ("Voice"),
						    name,
						    voice, SCM_EOL);
		}

		SCM context = scm_makfrom0str ("Lyrics");
		Music *all = MY_MAKE_MUSIC ("SimultaneousMusic");

		SCM lst = SCM_EOL;
		for (SCM s = (yyvsp[0].scm); scm_is_pair (s); s = scm_cdr (s))
		{
			Music *music = unsmob_music (scm_car (s));
			Music *com = make_lyric_combine_music (name, music);
			Music *csm = context_spec_music (context,
				get_next_unique_context_id (), com, SCM_EOL);
			lst = scm_cons (csm->self_scm (), lst);
		}
		all->set_property ("elements", scm_cons (voice->self_scm (),
			lst));
		(yyval.music) = all;
		scm_gc_unprotect_object (voice->self_scm ());
	;}
    break;

  case 135:
#line 1380 "parser.yy"
    {
		THIS->lexer_->push_lyric_state ();
	;}
    break;

  case 136:
#line 1382 "parser.yy"
    {
		THIS->lexer_->pop_state ();
		Music *music = (yyvsp[0].music);
		SCM name = (yyvsp[-2].scm);
		(yyval.music) = make_lyric_combine_music (name, music);
		scm_gc_unprotect_object (music->self_scm ());
	;}
    break;

  case 137:
#line 1392 "parser.yy"
    {
		Music*t = MY_MAKE_MUSIC ("ContextChange");
		t-> set_property ("change-to-type", scm_string_to_symbol ((yyvsp[-2].scm)));
		t-> set_property ("change-to-id", (yyvsp[0].scm));

		(yyval.music) = t;
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 138:
#line 1403 "parser.yy"
    {
		(yyval.scm) = scm_list_3 (ly_symbol2scm ("assign"),
			scm_string_to_symbol ((yyvsp[-2].scm)), (yyvsp[0].scm));
	;}
    break;

  case 139:
#line 1407 "parser.yy"
    {
		(yyval.scm) = scm_list_2 (ly_symbol2scm ("unset"),
			scm_string_to_symbol ((yyvsp[0].scm)));
	;}
    break;

  case 140:
#line 1411 "parser.yy"
    {
		(yyval.scm) = scm_list_4 (ly_symbol2scm ("push"),
			scm_string_to_symbol ((yyvsp[-3].scm)), (yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 141:
#line 1415 "parser.yy"
    {
		(yyval.scm) = scm_list_3 (ly_symbol2scm ("pop"),
			scm_string_to_symbol ((yyvsp[-1].scm)), (yyvsp[0].scm));
	;}
    break;

  case 142:
#line 1422 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("consists"); ;}
    break;

  case 143:
#line 1423 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("remove"); ;}
    break;

  case 144:
#line 1425 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("accepts"); ;}
    break;

  case 145:
#line 1426 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("denies"); ;}
    break;

  case 146:
#line 1428 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("alias"); ;}
    break;

  case 147:
#line 1429 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("translator-type"); ;}
    break;

  case 148:
#line 1430 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("description"); ;}
    break;

  case 149:
#line 1431 "parser.yy"
    { (yyval.scm) = ly_symbol2scm ("context-name"); ;}
    break;

  case 150:
#line 1435 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 151:
#line 1436 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 152:
#line 1442 "parser.yy"
    {
		if (!is_regular_identifier ((yyvsp[0].scm)))
		{
			(yyloc).error (_("Grob name should be alphanumeric"));
		}

		(yyval.scm) = scm_list_2 (ly_symbol2scm ("Bottom"),
			scm_string_to_symbol ((yyvsp[0].scm)));
	;}
    break;

  case 153:
#line 1451 "parser.yy"
    {
		(yyval.scm) = scm_list_2 (scm_string_to_symbol ((yyvsp[-2].scm)),
			scm_string_to_symbol ((yyvsp[0].scm)));
	;}
    break;

  case 154:
#line 1458 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_4 (
			ly_symbol2scm ("poppush"),
			scm_cadr ((yyvsp[-3].scm)),
			(yyvsp[-2].scm), (yyvsp[0].scm)));
		(yyval.music)= context_spec_music (scm_car ((yyvsp[-3].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 155:
#line 1465 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_3 (
			ly_symbol2scm ("pop"),
			scm_cadr ((yyvsp[-1].scm)),
			(yyvsp[0].scm)));

		(yyval.music)= context_spec_music (scm_car ((yyvsp[-1].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 156:
#line 1473 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_3 (
			ly_symbol2scm ("assign"),
			scm_cadr ((yyvsp[-2].scm)),
			(yyvsp[0].scm)));
		(yyval.music)= context_spec_music (scm_car ((yyvsp[-2].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 157:
#line 1480 "parser.yy"
    {
		(yyval.music) = property_op_to_music (scm_list_2 (
			ly_symbol2scm ("unset"),
			scm_cadr ((yyvsp[0].scm))));
		(yyval.music)= context_spec_music (scm_car ((yyvsp[0].scm)), SCM_UNDEFINED, (yyval.music), SCM_EOL);
	;}
    break;

  case 158:
#line 1486 "parser.yy"
    {
		SCM e = (yyvsp[0].music)->get_property ("element");
                unsmob_music (e)->set_property ("once", SCM_BOOL_T);
		(yyval.music) = (yyvsp[0].music);

	;}
    break;

  case 159:
#line 1496 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 160:
#line 1499 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 161:
#line 1502 "parser.yy"
    {
		(yyval.scm) = scm_string_append (scm_list_2 ((yyvsp[-2].scm), (yyvsp[0].scm)));
	;}
    break;

  case 162:
#line 1507 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 163:
#line 1510 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 164:
#line 1515 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 165:
#line 1518 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 166:
#line 1521 "parser.yy"
    {
		(yyval.scm) = scm_int2num ((yyvsp[0].i));
	;}
    break;

  case 167:
#line 1524 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 168:
#line 1527 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 169:
#line 1530 "parser.yy"
    {
		(yyval.scm) = scm_int2num ((yyvsp[0].i));
	;}
    break;

  case 171:
#line 1558 "parser.yy"
    {
		SCM elts = (yyvsp[-1].music)-> get_property ("elements");

		elts = ly_append2 (elts, scm_reverse_x ((yyvsp[0].scm), SCM_EOL));

		(yyvsp[-1].music)->set_property ("elements", elts);
		/* why is this giving wrong start location? -ns
		 * $2->set_spot (@$); */
		Input i;
		i.set_location ((yylsp[-1]), (yylsp[0]));
		(yyvsp[-1].music)->set_spot (i);
		(yyval.music) = (yyvsp[-1].music);
	;}
    break;

  case 174:
#line 1578 "parser.yy"
    {
		SCM dur = unsmob_duration ((yyvsp[-1].scm))->smobbed_copy ();
		SCM es = (yyvsp[-2].music)->get_property ("elements");
		SCM postevs = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);

		for (SCM s = es; scm_is_pair (s); s = scm_cdr (s))
		  unsmob_music (scm_car (s))->set_property ("duration", dur);
		es = ly_append2 (es, postevs);

		(yyvsp[-2].music)-> set_property ("elements", es);
		(yyvsp[-2].music)->set_spot ((yyloc));
		(yyval.music) = (yyvsp[-2].music);
	;}
    break;

  case 179:
#line 1607 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_spot ((yyloc));
		(yyval.music)->set_property ("elements",
			scm_reverse_x ((yyvsp[-1].scm), SCM_EOL));
	;}
    break;

  case 180:
#line 1616 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 181:
#line 1617 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyvsp[-1].scm));
		scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ());
	;}
    break;

  case 182:
#line 1625 "parser.yy"
    {
		int q = (yyvsp[-2].i);
		int ex = (yyvsp[-3].i);
		SCM check = (yyvsp[-1].scm);
		SCM post = (yyvsp[0].scm);

		Music *n = MY_MAKE_MUSIC ("NoteEvent");
		n->set_property ("pitch", (yyvsp[-4].scm));
		n->set_spot ((yyloc));
		if (q % 2)
			n->set_property ("cautionary", SCM_BOOL_T);
		if (ex % 2 || q % 2)
			n->set_property ("force-accidental", SCM_BOOL_T);

		if (scm_is_pair (post)) {
			SCM arts = scm_reverse_x (post, SCM_EOL);
			n->set_property ("articulations", arts);
		}
		if (scm_is_number (check))
		{
			int q = scm_to_int (check);
			n->set_property ("absolute-octave", scm_int2num (q-1));
		}

		
		(yyval.music) = n;
	;}
    break;

  case 183:
#line 1652 "parser.yy"
    {
		Music *n = MY_MAKE_MUSIC ("NoteEvent");
		n->set_property ("duration", (yyvsp[0].scm));
		n->set_property ("drum-type", (yyvsp[-1].scm));
		n->set_spot ((yyloc));

		if (scm_is_pair ((yyvsp[0].scm))) {
			SCM arts = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);
			n->set_property ("articulations", arts);
		}
		(yyval.music) = n;
	;}
    break;

  case 184:
#line 1667 "parser.yy"
    {
		SCM adder = ly_lily_module_constant ("add-quotable");
		
		scm_call_2 (adder, (yyvsp[-1].scm), (yyvsp[0].music)->self_scm ());
		scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ());
	;}
    break;

  case 185:
#line 1676 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_property ("elements", scm_cons ((yyvsp[0].music)->self_scm (), SCM_EOL));
		scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ());

		(yyval.music)-> set_spot ((yyloc));
		(yyvsp[0].music)-> set_spot ((yyloc));
	;}
    break;

  case 186:
#line 1684 "parser.yy"
    {
		Music *skip = MY_MAKE_MUSIC ("SkipMusic");
		skip->set_property ("duration", (yyvsp[0].scm));
		skip->set_spot ((yyloc));
		(yyval.music) = skip;
	;}
    break;

  case 187:
#line 1690 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("RelativeOctaveCheck");
		(yyval.music) = m;
		(yyval.music)->set_spot ((yyloc));
		(yyval.music)->set_property ("pitch", (yyvsp[0].scm));
	;}
    break;

  case 188:
#line 1696 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("LigatureEvent");
		m->set_property ("span-direction", scm_int2num (START));
		m->set_spot ((yyloc));

		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_property ("elements", scm_cons (m->self_scm (), SCM_EOL));
		scm_gc_unprotect_object (m->self_scm ());
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 189:
#line 1706 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("LigatureEvent");
		m->set_property ("span-direction", scm_int2num (STOP));
		m->set_spot ((yyloc));

		(yyval.music) = MY_MAKE_MUSIC ("EventChord");
		(yyval.music)->set_property ("elements", scm_cons (m->self_scm (), SCM_EOL));
		(yyval.music)->set_spot ((yyloc));
		scm_gc_unprotect_object (m->self_scm ());
	;}
    break;

  case 190:
#line 1716 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("VoiceSeparator");
		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 191:
#line 1720 "parser.yy"
    {
		SCM pipe = THIS->lexer_->lookup_identifier ("pipeSymbol");

		if (Music * m = unsmob_music (pipe))
			(yyval.music) = m->clone ();
		else
			(yyval.music) = MY_MAKE_MUSIC ("BarCheck");

		(yyval.music)->set_spot ((yyloc));
	;}
    break;

  case 192:
#line 1730 "parser.yy"
    {
		Pitch middle_c;
		Pitch sounds_as_c = pitch_interval (*unsmob_pitch ((yyvsp[0].scm)), middle_c);
		(yyval.music) = set_property_music (ly_symbol2scm ("instrumentTransposition"),
					 sounds_as_c.smobbed_copy());
		(yyval.music)->set_spot ((yyloc));
		(yyval.music) = context_spec_music (ly_symbol2scm ("Staff"), SCM_UNDEFINED,
			(yyval.music), SCM_EOL);
	;}
    break;

  case 193:
#line 1739 "parser.yy"
    {
		Music *t = set_property_music (ly_symbol2scm ("whichBar"), (yyvsp[0].scm));

		Music *csm = context_spec_music (ly_symbol2scm ("Timing"), SCM_UNDEFINED,
					t, SCM_EOL);
		(yyval.music) = context_spec_music (ly_symbol2scm ("Score"), SCM_UNDEFINED, csm, SCM_EOL);
		(yyval.music)->set_spot ((yyloc));
		t->set_spot ((yyloc));
	;}
    break;

  case 194:
#line 1748 "parser.yy"
    {
		Moment m = - unsmob_duration ((yyvsp[0].scm))->get_length ();
		Music *p = set_property_music (ly_symbol2scm ( "measurePosition"),m.smobbed_copy ());
		p->set_spot ((yyloc));
		p = context_spec_music (ly_symbol2scm ("Timing"), SCM_UNDEFINED,
					p, SCM_EOL);
		p = context_spec_music (ly_symbol2scm ("Score"), SCM_UNDEFINED,
					p, SCM_EOL);
		(yyval.music) = p;
	;}
    break;

  case 195:
#line 1758 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-clef-set");

		SCM result = scm_call_1 (proc, (yyvsp[0].scm));
		scm_gc_protect_object (result);
		(yyval.music) = unsmob_music (result);
	;}
    break;

  case 196:
#line 1765 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-time-signature-set");

		SCM result = scm_apply_2   (proc, scm_car ((yyvsp[0].scm)), scm_cdr ((yyvsp[0].scm)), SCM_EOL);
		scm_gc_protect_object (result);
		(yyval.music) = unsmob_music (result);
	;}
    break;

  case 197:
#line 1772 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-mark-set");

		SCM result = scm_call_1 (proc, (yyvsp[0].scm));
		scm_gc_protect_object (result);
		(yyval.music) = unsmob_music (result);
	;}
    break;

  case 198:
#line 1782 "parser.yy"
    {
		(yyval.music) = MY_MAKE_MUSIC ("PesOrFlexaEvent");
	;}
    break;

  case 199:
#line 1785 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("MarkEvent");
		(yyval.music) = m;
	;}
    break;

  case 200:
#line 1789 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 201:
#line 1792 "parser.yy"
    {
		Music *key = MY_MAKE_MUSIC ("KeyChangeEvent");
		(yyval.music) = key;
	;}
    break;

  case 202:
#line 1796 "parser.yy"
    {

		Music *key = MY_MAKE_MUSIC ("KeyChangeEvent");
		if (scm_ilength ((yyvsp[0].scm)) > 0)
		{		
			key->set_property ("pitch-alist", (yyvsp[0].scm));
			key->set_property ("tonic", Pitch (0, 0, 0).smobbed_copy ());
			key->transpose (* unsmob_pitch ((yyvsp[-1].scm)));
		} else {
			THIS->parser_error ((yylsp[0]), _ ("second argument must be pitch list"));
		}

		(yyval.music) = key;
	;}
    break;

  case 203:
#line 1814 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;
	;}
    break;

  case 204:
#line 1817 "parser.yy"
    {
		(yyvsp[0].music)->set_spot ((yylsp[0]));
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyval.scm));
		scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ());
	;}
    break;

  case 205:
#line 1822 "parser.yy"
    {
		(yyvsp[0].music) -> set_spot ((yylsp[0]));
		(yyval.scm) = scm_cons ((yyvsp[0].music)->self_scm (), (yyval.scm));
		scm_gc_unprotect_object ((yyvsp[0].music)->self_scm ());
	;}
    break;

  case 206:
#line 1831 "parser.yy"
    {
		tag_music ((yyvsp[0].music), (yyvsp[-1].scm), (yyloc));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 207:
#line 1839 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 208:
#line 1842 "parser.yy"
    {
		if (!THIS->lexer_->is_lyric_state ())
			THIS->parser_error ((yylsp[0]), _ ("have to be in Lyric mode for lyrics"));
		(yyval.music) = MY_MAKE_MUSIC ("HyphenEvent");
	;}
    break;

  case 209:
#line 1847 "parser.yy"
    {
		if (!THIS->lexer_->is_lyric_state ())
			THIS->parser_error ((yylsp[0]), _ ("have to be in Lyric mode for lyrics"));
		(yyval.music) = MY_MAKE_MUSIC ("ExtenderEvent");
	;}
    break;

  case 210:
#line 1852 "parser.yy"
    {
		if ((yyvsp[-1].i))
			(yyvsp[0].music)->set_property ("direction", scm_int2num ((yyvsp[-1].i)));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 211:
#line 1857 "parser.yy"
    {
		if ((yyvsp[-1].i))
			(yyvsp[0].music)->set_property ("direction", scm_int2num ((yyvsp[-1].i)));
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 213:
#line 1866 "parser.yy"
    {
		Music *s = MY_MAKE_MUSIC ("StringNumberEvent");
		s->set_property ("string-number", scm_int2num ((yyvsp[0].i)));
		s->set_spot ((yyloc));
		(yyval.music) = s;
	;}
    break;

  case 214:
#line 1875 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("bracketOpenSymbol");
	;}
    break;

  case 215:
#line 1878 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("bracketCloseSymbol"); 
	;}
    break;

  case 216:
#line 1881 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("tildeSymbol");
	;}
    break;

  case 217:
#line 1884 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("parenthesisOpenSymbol");
	;}
    break;

  case 218:
#line 1887 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("parenthesisCloseSymbol");
	;}
    break;

  case 219:
#line 1890 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedExclamationSymbol");
	;}
    break;

  case 220:
#line 1893 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedParenthesisOpenSymbol");
	;}
    break;

  case 221:
#line 1896 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedParenthesisCloseSymbol");
	;}
    break;

  case 222:
#line 1899 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedBiggerSymbol");
	;}
    break;

  case 223:
#line 1902 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("escapedSmallerSymbol");
	;}
    break;

  case 224:
#line 1908 "parser.yy"
    {
		SCM predefd = THIS->lexer_->lookup_identifier_symbol ((yyvsp[0].scm));
		Music * m = 0;
		if (unsmob_music (predefd))
		{
			m = unsmob_music (predefd)->clone ();
		}
		else
		{
			m = MY_MAKE_MUSIC ("Music");
		}
		m->set_spot ((yyloc));
		(yyval.music) = m;		
	;}
    break;

  case 225:
#line 1922 "parser.yy"
    {
		(yyval.music) = unsmob_music ((yyvsp[0].scm));
	;}
    break;

  case 226:
#line 1925 "parser.yy"
    {
               Music *a = MY_MAKE_MUSIC ("TremoloEvent");
               a->set_spot ((yyloc));
               a->set_property ("tremolo-type", scm_int2num ((yyvsp[0].i)));
               (yyval.music) = a;
        ;}
    break;

  case 227:
#line 1934 "parser.yy"
    {
		(yyval.music) = (yyvsp[0].music);
	;}
    break;

  case 228:
#line 1937 "parser.yy"
    {
		SCM s = THIS->lexer_->lookup_identifier ("dash" + ly_scm2string ((yyvsp[0].scm)));
		Music *a = MY_MAKE_MUSIC ("ArticulationEvent");
		if (scm_is_string (s))
			a->set_property ("articulation-type", s);
		else THIS->parser_error ((yylsp[0]), _ ("expecting string as script definition"));
		(yyval.music) = a;
	;}
    break;

  case 229:
#line 1948 "parser.yy"
    { (yyval.scm) = SCM_EOL; ;}
    break;

  case 230:
#line 1949 "parser.yy"
    { (yyval.scm) = scm_int2num (0); ;}
    break;

  case 231:
#line 1950 "parser.yy"
    { (yyval.scm) = scm_int2num ((yyvsp[0].i)); ;}
    break;

  case 232:
#line 1951 "parser.yy"
    { (yyval.scm) = scm_int2num ((yyvsp[0].i)); ;}
    break;

  case 233:
#line 1955 "parser.yy"
    {
		(yyval.i) = 1;
	;}
    break;

  case 234:
#line 1958 "parser.yy"
    {
		(yyval.i) ++;
	;}
    break;

  case 235:
#line 1964 "parser.yy"
    {
		(yyval.i) = 1;
	;}
    break;

  case 236:
#line 1967 "parser.yy"
    {
		(yyval.i)++;
	;}
    break;

  case 237:
#line 1973 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 238:
#line 1976 "parser.yy"
    {
		Pitch p = *unsmob_pitch ((yyvsp[-1].scm));
		p = p.transposed (Pitch ((yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 239:
#line 1981 "parser.yy"
    {
		Pitch p =* unsmob_pitch ((yyvsp[-1].scm));
		p = p.transposed (Pitch (-(yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 240:
#line 1993 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 241:
#line 1996 "parser.yy"
    {
		Pitch p = *unsmob_pitch ((yyvsp[-1].scm));
		p = p.transposed (Pitch ((yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 242:
#line 2001 "parser.yy"
    {
		Pitch p =* unsmob_pitch ((yyvsp[-1].scm));

		p = p.transposed (Pitch (-(yyvsp[0].i),0,0));
		(yyval.scm) = p.smobbed_copy ();
	;}
    break;

  case 243:
#line 2010 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 246:
#line 2021 "parser.yy"
    {
		Music *t = MY_MAKE_MUSIC ("TextScriptEvent");
		t->set_property ("text", (yyvsp[0].scm));
		t->set_spot ((yyloc));
		(yyval.music) = t;	
	;}
    break;

  case 247:
#line 2027 "parser.yy"
    {
		Music *t = MY_MAKE_MUSIC ("TextScriptEvent");
		t->set_property ("text",
			make_simple_markup ((yyvsp[0].scm)));
		t->set_spot ((yyloc));
		(yyval.music) = t;
	
	;}
    break;

  case 248:
#line 2035 "parser.yy"
    {
		Music *t = MY_MAKE_MUSIC ("FingerEvent");
		t->set_property ("digit", scm_int2num ((yyvsp[0].i)));
		t->set_spot ((yyloc));
		(yyval.music) = t;
	;}
    break;

  case 249:
#line 2044 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Hat");
	;}
    break;

  case 250:
#line 2047 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Plus");
	;}
    break;

  case 251:
#line 2050 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Dash");
	;}
    break;

  case 252:
#line 2053 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Bar");
	;}
    break;

  case 253:
#line 2056 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Larger");
	;}
    break;

  case 254:
#line 2059 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Dot");
	;}
    break;

  case 255:
#line 2062 "parser.yy"
    {
		(yyval.scm) = scm_makfrom0str ("Underscore");
	;}
    break;

  case 256:
#line 2068 "parser.yy"
    { (yyval.i) = DOWN; ;}
    break;

  case 257:
#line 2069 "parser.yy"
    { (yyval.i) = UP; ;}
    break;

  case 258:
#line 2070 "parser.yy"
    { (yyval.i) = CENTER; ;}
    break;

  case 259:
#line 2075 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 260:
#line 2081 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 261:
#line 2087 "parser.yy"
    {
		Duration dd = THIS->default_duration_;
		(yyval.scm) = dd.smobbed_copy ();

		THIS->beam_check ((yyval.scm));
	;}
    break;

  case 262:
#line 2093 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		THIS->default_duration_ = *unsmob_duration ((yyval.scm));

		THIS->beam_check ((yyval.scm));
	;}
    break;

  case 263:
#line 2102 "parser.yy"
    {
		int len = 0;
		if (!is_duration ((yyvsp[-1].i)))
			THIS->parser_error ((yylsp[-1]), _f ("not a duration: %d", (yyvsp[-1].i)));
		else
			len = intlog2 ((yyvsp[-1].i));

		(yyval.scm) = Duration (len, (yyvsp[0].i)).smobbed_copy ();
	;}
    break;

  case 264:
#line 2111 "parser.yy"
    {
		Duration *d = unsmob_duration ((yyvsp[-1].scm));
		Duration k (d->duration_log (), d->dot_count () + (yyvsp[0].i));
		*d = k;
		(yyval.scm) = (yyvsp[-1].scm);
	;}
    break;

  case 265:
#line 2120 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 266:
#line 2123 "parser.yy"
    {
		(yyval.scm) = unsmob_duration ((yyval.scm))->compressed ( (yyvsp[0].i)) .smobbed_copy ();
	;}
    break;

  case 267:
#line 2126 "parser.yy"
    {
		Rational  m (scm_to_int (scm_car ((yyvsp[0].scm))), scm_to_int (scm_cdr ((yyvsp[0].scm))));

		(yyval.scm) = unsmob_duration ((yyval.scm))->compressed (m).smobbed_copy ();
	;}
    break;

  case 268:
#line 2134 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 269:
#line 2135 "parser.yy"
    {
		(yyval.scm) = scm_cons (scm_int2num ((yyvsp[-2].i)), scm_int2num ((yyvsp[0].i)));
	;}
    break;

  case 270:
#line 2141 "parser.yy"
    {
		(yyval.i) = 0;
	;}
    break;

  case 271:
#line 2144 "parser.yy"
    {
		(yyval.i) ++;
	;}
    break;

  case 272:
#line 2150 "parser.yy"
    {
		(yyval.i) = 0;
	;}
    break;

  case 273:
#line 2153 "parser.yy"
    {
		if (!is_duration ((yyvsp[0].i)))
			THIS->parser_error ((yylsp[0]), _f ("not a duration: %d", (yyvsp[0].i)));
		(yyval.i) = (yyvsp[0].i);
	;}
    break;

  case 274:
#line 2161 "parser.yy"
    {
		(yyval.scm) = scm_number_to_string (scm_int2num ((yyvsp[0].i)), scm_int2num (10));
		(yyval.scm) = scm_list_2 (ly_lily_module_constant ("number-markup"),
				(yyval.scm));
	;}
    break;

  case 275:
#line 2166 "parser.yy"
    {
		(yyval.scm) = scm_number_to_string (scm_int2num ((yyvsp[0].i)), scm_int2num (10));
		(yyval.scm) = scm_list_2 (ly_lily_module_constant ("number-markup"),
				(yyval.scm));
	;}
    break;

  case 276:
#line 2171 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 277:
#line 2172 "parser.yy"
    { (yyval.scm) = (yyvsp[0].scm); ;}
    break;

  case 278:
#line 2176 "parser.yy"
    { (yyval.i) = -2; ;}
    break;

  case 279:
#line 2177 "parser.yy"
    { (yyval.i) = 2; ;}
    break;

  case 280:
#line 2178 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 281:
#line 2182 "parser.yy"
    {
		Music *bfr = MY_MAKE_MUSIC ("BassFigureEvent");
		(yyval.scm) = bfr->self_scm ();
		scm_gc_unprotect_object ((yyval.scm));
	;}
    break;

  case 282:
#line 2187 "parser.yy"
    {
		Music *bfr = MY_MAKE_MUSIC ("BassFigureEvent");
		(yyval.scm) = bfr->self_scm ();

		bfr->set_property ("figure", (yyvsp[0].scm));

		scm_gc_unprotect_object ((yyval.scm));
	;}
    break;

  case 283:
#line 2195 "parser.yy"
    {
		Music *m = unsmob_music ((yyvsp[-1].scm));
		if ((yyvsp[0].i)) {
			SCM salter = m->get_property ("alteration");
			int alter = scm_is_number (salter) ? scm_to_int (salter) : 0;
			m->set_property ("alteration",
				scm_int2num (alter + (yyvsp[0].i)));
		} else {
			m->set_property ("alteration", scm_int2num (0));
		}
	;}
    break;

  case 284:
#line 2209 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		unsmob_music ((yyval.scm))->set_property ("bracket-start", SCM_BOOL_T);
	;}
    break;

  case 285:
#line 2213 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 286:
#line 2216 "parser.yy"
    {
		(yyval.scm) = (yyvsp[-1].scm);
		unsmob_music ((yyvsp[-1].scm))->set_property ("bracket-stop", SCM_BOOL_T);
	;}
    break;

  case 287:
#line 2223 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;
	;}
    break;

  case 288:
#line 2226 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 289:
#line 2232 "parser.yy"
    {
		Music *m = MY_MAKE_MUSIC ("EventChord");
		(yyvsp[-1].scm) = scm_reverse_x ((yyvsp[-1].scm), SCM_EOL);
		m->set_property ("elements", (yyvsp[-1].scm));
		(yyval.scm) = m->self_scm ();
	;}
    break;

  case 290:
#line 2242 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 291:
#line 2243 "parser.yy"
    { (yyval.i) = 1; ;}
    break;

  case 292:
#line 2247 "parser.yy"
    {
		if (!THIS->lexer_->is_note_state ())
			THIS->parser_error ((yylsp[-5]), _ ("have to be in Note mode for notes"));

		Music *n = 0;
		if ((yyvsp[0].i))
			n = MY_MAKE_MUSIC ("RestEvent");
		else
			n = MY_MAKE_MUSIC ("NoteEvent");
		
		n->set_property ("pitch", (yyvsp[-5].scm));
		n->set_property ("duration", (yyvsp[-1].scm));

		if (scm_is_number ((yyvsp[-2].scm)))
		{
			int q = scm_to_int ((yyvsp[-2].scm));
			n->set_property ("absolute-octave", scm_int2num (q-1));
		}

		if ((yyvsp[-3].i) % 2)
			n->set_property ("cautionary", SCM_BOOL_T);
		if ((yyvsp[-4].i) % 2 || (yyvsp[-3].i) % 2)
			n->set_property ("force-accidental", SCM_BOOL_T);

		Music *v = MY_MAKE_MUSIC ("EventChord");
		v->set_property ("elements", scm_list_1 (n->self_scm ()));
		scm_gc_unprotect_object (n->self_scm ());

		v->set_spot ((yyloc));
		n->set_spot ((yyloc));
		(yyval.music) = v;
	;}
    break;

  case 293:
#line 2279 "parser.yy"
    {
		Music *n = MY_MAKE_MUSIC ("NoteEvent");
		n->set_property ("duration", (yyvsp[0].scm));
		n->set_property ("drum-type", (yyvsp[-1].scm));

		Music *v = MY_MAKE_MUSIC ("EventChord");
		v->set_property ("elements", scm_list_1 (n->self_scm ()));
		scm_gc_unprotect_object (n->self_scm ());
		v->set_spot ((yyloc));
		n->set_spot ((yyloc));
		(yyval.music) = v;
		
	;}
    break;

  case 294:
#line 2292 "parser.yy"
    {
		Music *m = unsmob_music ((yyvsp[-1].scm));
		m->set_spot ((yyloc));
		for (SCM s = m->get_property ("elements"); scm_is_pair (s); s = scm_cdr (s))
		{
			unsmob_music (scm_car (s))->set_property ("duration", (yyvsp[0].scm));
		}
		(yyval.music) = m;
	;}
    break;

  case 295:
#line 2301 "parser.yy"
    {
		Music *ev = 0;
 		if (ly_scm2string ((yyvsp[-1].scm)) == "s") {
			/* Space */
			ev = MY_MAKE_MUSIC ("SkipEvent");
		  }
		else {
			ev = MY_MAKE_MUSIC ("RestEvent");
		
		    }
		ev->set_property ("duration", (yyvsp[0].scm));
		ev->set_spot ((yyloc));
 		Music *velt = MY_MAKE_MUSIC ("EventChord");
		velt->set_property ("elements", scm_list_1 (ev->self_scm ()));
		velt->set_spot ((yyloc));

		scm_gc_unprotect_object (ev->self_scm ());

 		(yyval.music) = velt;
	;}
    break;

  case 296:
#line 2321 "parser.yy"
    {
		SCM proc = ly_lily_module_constant ("make-multi-measure-rest");
		SCM mus = scm_call_2 (proc, (yyvsp[0].scm), make_input ((yyloc)));
		scm_gc_protect_object (mus);
		(yyval.music) = unsmob_music (mus);
	;}
    break;

  case 297:
#line 2328 "parser.yy"
    {
		if (!THIS->lexer_->is_lyric_state ())
			THIS->parser_error ((yylsp[-1]), _ ("have to be in Lyric mode for lyrics"));

		Music *lreq = MY_MAKE_MUSIC ("LyricEvent");
		lreq->set_property ("text", (yyvsp[-1].scm));
		lreq->set_property ("duration",(yyvsp[0].scm));
		lreq->set_spot ((yyloc));
		Music *velt = MY_MAKE_MUSIC ("EventChord");
		velt->set_property ("elements", scm_list_1 (lreq->self_scm ()));

		(yyval.music)= velt;
	;}
    break;

  case 298:
#line 2341 "parser.yy"
    {
                if (!THIS->lexer_->is_chord_state ())
                        THIS->parser_error ((yylsp[0]), _ ("have to be in Chord mode for chords"));
                (yyval.music) = unsmob_music ((yyvsp[0].scm));
	;}
    break;

  case 299:
#line 2349 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 300:
#line 2352 "parser.yy"
    {
		(yyval.scm) = make_simple_markup ((yyvsp[0].scm));
	;}
    break;

  case 301:
#line 2358 "parser.yy"
    {
		(yyval.scm) = make_chord ((yyvsp[-1].scm), (yyvsp[0].scm), SCM_EOL);
	;}
    break;

  case 302:
#line 2361 "parser.yy"
    {
		SCM its = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);
		(yyval.scm) = make_chord ((yyvsp[-3].scm), (yyvsp[-2].scm), scm_cons ((yyvsp[-1].scm), its));
	;}
    break;

  case 303:
#line 2368 "parser.yy"
    {
		(yyval.scm) = SCM_EOL;		
	;}
    break;

  case 304:
#line 2371 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyval.scm));
	;}
    break;

  case 305:
#line 2377 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("chord-colon");
	;}
    break;

  case 306:
#line 2380 "parser.yy"
    {
		(yyval.scm) = ly_symbol2scm ("chord-caret");
	;}
    break;

  case 307:
#line 2383 "parser.yy"
    {
 		(yyval.scm) = scm_list_2 (ly_symbol2scm ("chord-slash"), (yyvsp[0].scm));
	;}
    break;

  case 308:
#line 2386 "parser.yy"
    {
		(yyval.scm) = scm_list_2 (ly_symbol2scm ("chord-bass"), (yyvsp[0].scm));
	;}
    break;

  case 309:
#line 2392 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 310:
#line 2395 "parser.yy"
    {
		(yyval.scm) = scm_reverse_x ((yyvsp[0].scm), SCM_EOL);
	;}
    break;

  case 311:
#line 2398 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 312:
#line 2404 "parser.yy"
    { (yyval.scm) = scm_cons ((yyvsp[0].scm), SCM_EOL); ;}
    break;

  case 313:
#line 2405 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyval.scm));
	;}
    break;

  case 314:
#line 2411 "parser.yy"
    {
		(yyval.scm) = make_chord_step ((yyvsp[0].i), 0);
        ;}
    break;

  case 315:
#line 2414 "parser.yy"
    {
		(yyval.scm) = make_chord_step ((yyvsp[-1].i), SHARP);
	;}
    break;

  case 316:
#line 2417 "parser.yy"
    {
		(yyval.scm) = make_chord_step ((yyvsp[-1].i), FLAT);
	;}
    break;

  case 317:
#line 2429 "parser.yy"
    {
		(yyval.scm) = scm_sum ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 318:
#line 2432 "parser.yy"
    {
		(yyval.scm) = scm_difference ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 320:
#line 2439 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 321:
#line 2442 "parser.yy"
    {
		(yyval.scm) = scm_product ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 322:
#line 2445 "parser.yy"
    {
		(yyval.scm) = scm_divide ((yyvsp[-2].scm), (yyvsp[0].scm));
	;}
    break;

  case 323:
#line 2451 "parser.yy"
    { /* %prec UNARY_MINUS */
		(yyval.scm) = scm_difference ((yyvsp[0].scm), SCM_UNDEFINED);
	;}
    break;

  case 325:
#line 2459 "parser.yy"
    {
		(yyval.scm) = scm_int2num ((yyvsp[0].i));
	;}
    break;

  case 326:
#line 2462 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 327:
#line 2465 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 328:
#line 2468 "parser.yy"
    {
		(yyval.scm) = scm_make_real (scm_to_double ((yyvsp[-1].scm)) *scm_to_double ((yyvsp[0].scm)));
	;}
    break;

  case 329:
#line 2471 "parser.yy"
    {
		(yyval.scm) = scm_make_real ((yyvsp[-1].i) *scm_to_double ((yyvsp[0].scm)));
	;}
    break;

  case 330:
#line 2478 "parser.yy"
    {
			(yyval.i) = (yyvsp[0].i);
	;}
    break;

  case 331:
#line 2481 "parser.yy"
    {
		(yyval.i) = (yyvsp[0].i);
	;}
    break;

  case 332:
#line 2487 "parser.yy"
    {
		if (scm_integer_p ((yyvsp[0].scm)) == SCM_BOOL_T)
		{
			int k = scm_to_int ((yyvsp[0].scm));
			(yyval.i) = k;
		} else
		{
			THIS->parser_error ((yylsp[0]), _ ("need integer number arg"));
			(yyval.i) = 0;
		}
	;}
    break;

  case 333:
#line 2498 "parser.yy"
    {
		(yyval.i) = -(yyvsp[0].i);
	;}
    break;

  case 334:
#line 2504 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 335:
#line 2505 "parser.yy"
    { (yyval.i) ++; ;}
    break;

  case 336:
#line 2509 "parser.yy"
    { (yyval.i) = 0; ;}
    break;

  case 337:
#line 2510 "parser.yy"
    { (yyval.i) ++; ;}
    break;

  case 338:
#line 2518 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 339:
#line 2522 "parser.yy"
    { THIS->lexer_->push_markup_state (); ;}
    break;

  case 340:
#line 2523 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		THIS->lexer_->pop_state ();
	;}
    break;

  case 341:
#line 2530 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 342:
#line 2534 "parser.yy"
    { THIS->lexer_->push_markup_state (); ;}
    break;

  case 343:
#line 2535 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
		THIS->lexer_->pop_state ();
	;}
    break;

  case 344:
#line 2542 "parser.yy"
    { 
		(yyval.scm) = scm_list_2 (ly_lily_module_constant ("line-markup"),  (yyvsp[0].scm)); 
	;}
    break;

  case 345:
#line 2545 "parser.yy"
    {
		(yyval.scm) = scm_car (scm_call_2 (ly_lily_module_constant ("map-markup-command-list"), (yyvsp[-1].scm), scm_list_1 ((yyvsp[0].scm))));
	;}
    break;

  case 346:
#line 2548 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 347:
#line 2554 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 348:
#line 2557 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 349:
#line 2563 "parser.yy"
    {
		(yyval.scm) = scm_call_2 (ly_lily_module_constant ("map-markup-command-list"), (yyvsp[-1].scm), (yyvsp[0].scm));
		
	;}
    break;

  case 350:
#line 2570 "parser.yy"
    {
		(yyval.scm) = scm_reverse_x ((yyvsp[-1].scm), SCM_EOL);
	;}
    break;

  case 351:
#line 2576 "parser.yy"
    {  (yyval.scm) = scm_list (SCM_EOL); ;}
    break;

  case 352:
#line 2577 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 353:
#line 2580 "parser.yy"
    {
		(yyval.scm) = scm_append_x (scm_list_2 (scm_reverse_x ((yyvsp[0].scm), SCM_EOL), (yyvsp[-1].scm)));
	;}
    break;

  case 354:
#line 2586 "parser.yy"
    {
		(yyval.scm) = scm_list_1 ((yyvsp[0].scm));
	;}
    break;

  case 355:
#line 2589 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 356:
#line 2592 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 357:
#line 2598 "parser.yy"
    {
		(yyval.scm) = scm_list_1 ((yyvsp[0].scm));
	;}
    break;

  case 358:
#line 2601 "parser.yy"
    {
		(yyval.scm) = scm_cons ((yyvsp[0].scm), (yyvsp[-1].scm));
	;}
    break;

  case 359:
#line 2607 "parser.yy"
    {
		(yyval.scm) = make_simple_markup ((yyvsp[0].scm));
	;}
    break;

  case 360:
#line 2610 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 361:
#line 2613 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 362:
#line 2616 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;

  case 363:
#line 2619 "parser.yy"
    {
		SCM nn = THIS->lexer_->lookup_identifier ("pitchnames");
		THIS->lexer_->push_note_state (alist_to_hashq (nn));
	;}
    break;

  case 364:
#line 2622 "parser.yy"
    {
		Score * sc = (yyvsp[-1].score);
		(yyval.scm) = scm_list_2 (ly_lily_module_constant ("score-markup"), sc->self_scm ());
		scm_gc_unprotect_object (sc->self_scm ());
		THIS->lexer_->pop_state ();
	;}
    break;

  case 365:
#line 2628 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 366:
#line 2631 "parser.yy"
    {
		(yyval.scm) = scm_list_4 ((yyvsp[-3].scm), (yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 367:
#line 2634 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 368:
#line 2637 "parser.yy"
    {
		(yyval.scm) = scm_list_1 ((yyvsp[0].scm));
	;}
    break;

  case 369:
#line 2640 "parser.yy"
    {
		(yyval.scm) = scm_list_2 ((yyvsp[-1].scm),(yyvsp[0].scm));
	;}
    break;

  case 370:
#line 2643 "parser.yy"
    {
		(yyval.scm) = scm_list_3 ((yyvsp[-2].scm), (yyvsp[-1].scm), (yyvsp[0].scm));
	;}
    break;

  case 371:
#line 2649 "parser.yy"
    {
		(yyval.scm) = scm_car (scm_call_2 (ly_lily_module_constant ("map-markup-command-list"), (yyvsp[-1].scm), scm_list_1 ((yyvsp[0].scm))));
	;}
    break;

  case 372:
#line 2652 "parser.yy"
    {
		(yyval.scm) = (yyvsp[0].scm);
	;}
    break;


      default: break;
    }

/* Line 1052 of yacc.c.  */
#line 5558 "out/parser.cc"

  yyvsp -= yylen;
  yyssp -= yylen;
  yylsp -= yylen;

  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  int yytype = YYTRANSLATE (yychar);
	  YYSIZE_T yysize0 = yystrlen (yytname[yytype]);
	  YYSIZE_T yysize = yysize0;
	  YYSIZE_T yysize1;
	  int yysize_overflow = 0;
	  char *yymsg = 0;
#	  define YYERROR_VERBOSE_ARGS_MAXIMUM 5
	  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
	  int yyx;

#if 0
	  /* This is so xgettext sees the translatable formats that are
	     constructed on the fly.  */
	  _("syntax error, unexpected %s");
	  _("syntax error, unexpected %s, expecting %s");
	  _("syntax error, unexpected %s, expecting %s or %s");
	  _("syntax error, unexpected %s, expecting %s or %s or %s");
	  _("syntax error, unexpected %s, expecting %s or %s or %s or %s");
#endif
	  char *yyfmt;
	  char const *yyf;
	  static char const yyunexpected[] = "syntax error, unexpected %s";
	  static char const yyexpecting[] = ", expecting %s";
	  static char const yyor[] = " or %s";
	  char yyformat[sizeof yyunexpected
			+ sizeof yyexpecting - 1
			+ ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
			   * (sizeof yyor - 1))];
	  char const *yyprefix = yyexpecting;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 1;

	  yyarg[0] = yytname[yytype];
	  yyfmt = yystpcpy (yyformat, yyunexpected);

	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
		  {
		    yycount = 1;
		    yysize = yysize0;
		    yyformat[sizeof yyunexpected - 1] = '\0';
		    break;
		  }
		yyarg[yycount++] = yytname[yyx];
		yysize1 = yysize + yystrlen (yytname[yyx]);
		yysize_overflow |= yysize1 < yysize;
		yysize = yysize1;
		yyfmt = yystpcpy (yyfmt, yyprefix);
		yyprefix = yyor;
	      }

	  yyf = _(yyformat);
	  yysize1 = yysize + strlen (yyf);
	  yysize_overflow |= yysize1 < yysize;
	  yysize = yysize1;

	  if (!yysize_overflow && yysize <= YYSTACK_ALLOC_MAXIMUM)
	    yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg)
	    {
	      /* Avoid sprintf, as that infringes on the user's name space.
		 Don't have undefined behavior even if the translation
		 produced a string with the wrong number of "%s"s.  */
	      char *yyp = yymsg;
	      int yyi = 0;
	      while ((*yyp = *yyf))
		{
		  if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		    {
		      yyp = yystpcpy (yyp, yyarg[yyi++]);
		      yyf += 2;
		    }
		  else
		    {
		      yyp++;
		      yyf++;
		    }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror (_("syntax error; also memory exhausted"));
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror (_("syntax error"));
    }

  yyerror_range[0] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
                 yyerror_range[0] = *yylsp;
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 yydestruct (_("Error: popping"),
                             yystos[*yyssp], yyvsp, yylsp);
	       }
        }
      else
	{
	  yydestruct (_("Error: discarding"), yytoken, &yylval, &yylloc);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (0)
     goto yyerrorlab;

  yyerror_range[0] = yylsp[1-yylen];
  yylsp -= yylen;
  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      yyerror_range[0] = *yylsp;
      yydestruct (_("Error: popping"), yystos[yystate], yyvsp, yylsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;

  yyerror_range[1] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the look-ahead.  YYLOC is available though. */
  YYLLOC_DEFAULT (yyloc, yyerror_range - 1, 2);
  *++yylsp = yyloc;

  /* Shift the error token. */
  YY_SYMBOL_PRINT (_("Shifting"), yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yydestruct (_("Error: discarding lookahead"),
              yytoken, &yylval, &yylloc);
  yychar = YYEMPTY;
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror (_("parser stack overflow"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 2657 "parser.yy"


void
Lily_parser::set_yydebug (bool )
{
#if 0
	yydebug = 1;
#endif
}

void
Lily_parser::do_yyparse ()
{
	yyparse ((void*)this);
}


/* FIXME: Should make this optional?  It will also complain at

	[s4]

which is entirely legitimate.

Or we can scrap it.  Barchecks should detect wrong durations, and
skipTypesetting speeds it up a lot.  */

void
Lily_parser::beam_check (SCM dur)
{
  Duration *d = unsmob_duration (dur);
  if (unsmob_music (last_beam_start_) && d->duration_log () <= 2)
    {
      Music *m = unsmob_music (last_beam_start_);
      m->origin ()->warning (_f ("suspect duration in beam: %s",
      d->to_string ()));
    }
  last_beam_start_ = SCM_EOL;
}




/*

It is a little strange to have this function in this file, but
otherwise, we have to import music classes into the lexer.

*/
int
Lily_lexer::try_special_identifiers (SCM *destination, SCM sid)
{
	if (scm_is_string (sid)) {
		*destination = sid;
		return STRING_IDENTIFIER;
	} else if (scm_is_number (sid)) {
		*destination = sid;
		return NUMBER_IDENTIFIER;
	} else if (unsmob_context_def (sid)) {
		*destination = unsmob_context_def (sid)->clone_scm ();
		return CONTEXT_DEF_IDENTIFIER;
	} else if (unsmob_score (sid)) {
		Score *score = new Score (*unsmob_score (sid));
		*destination = score->self_scm ();
		return SCORE_IDENTIFIER;
	} else if (Music *mus = unsmob_music (sid)) {
		mus = mus->clone ();
		*destination = mus->self_scm ();
		unsmob_music (*destination)->
			set_property ("origin", make_input (last_input_));
		return dynamic_cast<Event*> (mus)
			? EVENT_IDENTIFIER : MUSIC_IDENTIFIER;
	} else if (unsmob_duration (sid)) {
		*destination = unsmob_duration (sid)->smobbed_copy ();
		return DURATION_IDENTIFIER;
	} else if (unsmob_output_def (sid)) {
		Output_def *p = unsmob_output_def (sid);
		p = p->clone ();

		*destination = p->self_scm ();
		return OUTPUT_DEF_IDENTIFIER;
	} else if (Text_interface::markup_p (sid)) {
		*destination = sid;
		if (is_lyric_state ())
			return LYRIC_MARKUP_IDENTIFIER;
		return MARKUP_IDENTIFIER;
	}

	return -1;	
}

Music *
property_op_to_music (SCM op)
{
	Music *m = 0;
	SCM tag = scm_car (op);
	SCM symbol = scm_cadr (op);
	SCM args = scm_cddr (op);
	SCM grob_val = SCM_UNDEFINED;
	SCM grob_sym = SCM_UNDEFINED;
	SCM val = SCM_UNDEFINED;
	
	if (tag == ly_symbol2scm ("assign"))
		{
		m = MY_MAKE_MUSIC ("PropertySet");
		val = scm_car (args);
		}
	else if (tag == ly_symbol2scm ("unset"))
		m = MY_MAKE_MUSIC ("PropertyUnset");
	else if (tag == ly_symbol2scm ("poppush")
		 || tag == ly_symbol2scm ("push"))
		{
		m = MY_MAKE_MUSIC ("OverrideProperty");
		grob_sym = scm_car (args);
		grob_val = scm_cadr (args);
		}
	else if (tag == ly_symbol2scm ("pop")) {
		m = MY_MAKE_MUSIC ("RevertProperty");
		grob_sym = scm_car (args);
		}

	m->set_property ("symbol", symbol);

	if (val != SCM_UNDEFINED)
		m->set_property ("value", val);
	if (grob_val != SCM_UNDEFINED)
		m->set_property ("grob-value", grob_val);

	if (grob_sym != SCM_UNDEFINED)
		{
		bool itc = do_internal_type_checking_global;
		/* UGH.
		*/
		bool autobeam = ly_c_equal_p (symbol, ly_symbol2scm ("autoBeamSettings"));
		if (autobeam)
			do_internal_type_checking_global = false;
		m->set_property ("grob-property", grob_sym);
		if (autobeam)
			do_internal_type_checking_global = itc;
		}

	if (tag == ly_symbol2scm ("poppush"))
		m->set_property ("pop-first", SCM_BOOL_T);


	return m;
}

Music*
context_spec_music (SCM type, SCM id, Music *m, SCM ops)
{
	Music *csm = MY_MAKE_MUSIC ("ContextSpeccedMusic");

	csm->set_property ("element", m->self_scm ());
	scm_gc_unprotect_object (m->self_scm ());

	csm->set_property ("context-type",
		scm_is_symbol (type) ? type : scm_string_to_symbol (type));
	csm->set_property ("property-operations", ops);

	if (scm_is_string (id))
		csm->set_property ("context-id", id);
	return csm;
}

SCM
get_next_unique_context_id ()
{
	return scm_makfrom0str ("$uniqueContextId");
}


SCM
get_next_unique_lyrics_context_id ()
{
	static int new_context_count;
	char s[128];
	snprintf (s, 1024, "uniqueContext%d", new_context_count++);
	return scm_makfrom0str (s);
}


