/*
  object-key-dumper.hh -- declare Object_key_dumper

  source file of the GNU LilyPond music typesetter

  (c) 2004 Han-Wen Nienhuys <hanwen@xs4all.nl>

*/

#ifndef OBJECT_KEY_DUMPER_HH
#define OBJECT_KEY_DUMPER_HH

#include <map>

#include "lily-guile.hh"
#include "smobs.hh"

typedef  std::map<Object_key const*, Object_key const*, Object_key_less> Key_to_key_map ;
typedef  std::map<Object_key const*, int> Pointer_to_int_map ;

class Object_key_dumper
{
  SCM file_contents_;
  Key_to_key_map serialized_keys_;
  Key_to_int_map key_serial_numbers_;
  int next_available_;
  
  
  SCM key_serial (int);
  void serialize_key (Object_key const *);
  DECLARE_SMOBS (Object_key_dumper,);
public:
  Object_key_dumper ();
  SCM get_file_contents ();
  SCM dump_key (Object_key const *);
};

#endif /* OBJECT_KEY_DUMPER_HH */

