/*
  paper-system.cc -- implement Paper_system

  source file of the GNU LilyPond music typesetter

  (c) 2004 Jan Nieuwenhuizen <janneke@gnu.org>
*/

#include "paper-system.hh"
#include "stencil.hh"
#include "string.hh"
#include "virtual-methods.hh"

#include "ly-smobs.icc"

IMPLEMENT_SMOBS (Paper_system);
IMPLEMENT_TYPE_P (Paper_system, "ly:paper-system?");
IMPLEMENT_DEFAULT_EQUAL_P (Paper_system);



Paper_system::Paper_system (Stencil s, bool is_title)
{
  is_title_ = is_title;
  number_ = 0;
  penalty_ = 0;
  smobify_self ();
  stencil_ = s;
}

Paper_system::~Paper_system ()
{
}

SCM
Paper_system::mark_smob (SCM smob)
{
  Paper_system *line = (Paper_system*) ly_cdr (smob);
  return line-> stencil_.expr ();
}

int
Paper_system::print_smob (SCM smob, SCM port, scm_print_state*)
{
  Paper_system *p = (Paper_system*) ly_cdr (smob);
  scm_puts ("#<", port);
  scm_puts (classname (p), port);
  scm_puts (" ", port);
  scm_puts (to_string (p->number_).to_str0 (), port);
  scm_puts ("p ", port);
  scm_puts (to_string (p->penalty_).to_str0 (), port);
  if (p->is_title ())
    scm_puts (" t", port);
  scm_puts (" >", port);
  return 1;
}

bool
Paper_system::is_title () const
{
  return is_title_;
}

Real
Paper_system::penalty () const
{
  return penalty_;
}

Offset
Paper_system::dim () const
{
  return Offset (stencil_.extent (X_AXIS).length (),
		 stencil_.extent (Y_AXIS).length ());
}

Stencil
Paper_system::to_stencil () const
{
  return stencil_;
}

LY_DEFINE (ly_paper_line_height, "ly:paper-system-extent",
	   2, 0, 0, (SCM line, SCM axis),
	   "Return the extent of @var{line}.")
{
  Paper_system *pl = unsmob_paper_line (line);
  SCM_ASSERT_TYPE (pl, line, SCM_ARG1, __FUNCTION__, "paper-system");
  SCM_ASSERT_TYPE (is_axis (axis), axis, SCM_ARG2, __FUNCTION__, "axis");
  Axis ax = (Axis)ly_scm2int (axis);
  return scm_make_real (pl->dim ()[ax]);
}



LY_DEFINE (ly_paper_line_title_p, "ly:paper-system-title?",
	   1, 0, 0, (SCM line),
	   "Is  @var{line} a title line?")
{
  Paper_system *pl = unsmob_paper_line (line);
  SCM_ASSERT_TYPE (pl, line, SCM_ARG1, __FUNCTION__, "paper-system");
  return SCM_BOOL (pl->is_title ());
}

LY_DEFINE (ly_paper_line_number, "ly:paper-system-number",
	   1, 0, 0, (SCM line),
	   "Return the number of @var{line}.")
{
  Paper_system *pl = unsmob_paper_line (line);
  SCM_ASSERT_TYPE (pl, line, SCM_ARG1, __FUNCTION__, "paper-system");
  return scm_int2num (pl->number_);
}

LY_DEFINE (ly_paper_line_break_score, "ly:paper-system-break-penalty",
	   1, 0, 0, (SCM line),
	   "Return the score for page break after @var{line}.")
{
  Paper_system *pl = unsmob_paper_line (line);
  SCM_ASSERT_TYPE (pl, line, SCM_ARG1, __FUNCTION__, "paper-system");
  return scm_int2num (int (pl->penalty ()));
}

LY_DEFINE (ly_paper_line_stencil, "ly:paper-system-stencil",
	   1, 0, 0, (SCM line),
	   "Return the height of @var{line}.")
{
  Paper_system *pl = unsmob_paper_line (line);
  SCM_ASSERT_TYPE (pl, line, SCM_ARG1, __FUNCTION__, "paper-system");
  return pl->to_stencil ().smobbed_copy ();
}

