/*
  paper-system.hh -- declare Paper_system

  source file of the GNU LilyPond music typesetter

  (c) 2004  Jan Nieuwenhuizen <janneke@gnu.org>
*/
#ifndef PAPER_LINE_HH
#define PAPER_LINE_HH

#include "lily-proto.hh"
#include "smobs.hh"
#include "offset.hh"
#include "stencil.hh"

/*
  A formatted "system" (A block of titling also is a Paper_system)

  To save memory, we don't keep around the System grobs, but put the
  formatted content of the grob is put into a Paper_system. Page-breaking handles
  Paper_system objects.
  
 */
class Paper_system
{
  DECLARE_SMOBS (Paper_system, );
  Stencil stencil_;
  bool is_title_;
  
public:
  Real penalty_;
  int number_;

  Paper_system (Stencil, bool);

  Offset dim () const;
  Stencil to_stencil () const;
  SCM stencils () const;
  bool is_title () const;
  Real penalty () const;
};

DECLARE_UNSMOB (Paper_system, paper_line);

#endif /* PAPER_LINE_HH */
