;;;; This file is part of LilyPond, the GNU music typesetter.
;;;;
;;;; Copyright (C) 1998--2012  Han-Wen Nienhuys <hanwen@xs4all.nl>
;;;;                 Jan Nieuwenhuizen <janneke@gnu.org>
;;;;
;;;; LilyPond is free software: you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or
;;;; (at your option) any later version.
;;;;
;;;; LilyPond is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with LilyPond.  If not, see <http://www.gnu.org/licenses/>.


;; The interfaces defined here generally have no code (e.g.,
;; dynamic-interface), or have callbacks defined entirely in
;; scheme.  Others interfaces are defined in lily/*.cc with the
;; ADD_INTERFACE function.

;; should include default value?


(ly:add-interface
 'accidental-suggestion-interface
 "An accidental, printed as a suggestion (typically: vertically over a
note)."
 '())

(ly:add-interface
 'ambitus-interface
 "The line between note heads for a pitch range."
 '(gap note-heads thickness))

(ly:add-interface
 'bar-line-interface
 "Print a special bar symbol.  It replaces the regular bar
symbol with a special symbol.  The argument @var{bartype}
is a string which specifies the kind of bar line to print.
Options are @code{|}, @code{:|}, @code{|:}, @code{:|:}, @code{:|.|:},
@code{:|.:}, @code{.}, @code{||}, @code{|.}, @code{.|}, @code{.|.},
@code{|.|}, @code{:}, @code{dashed}, @code{'} and @code{S}.

These produce, respectively, a normal bar line, a right repeat, a left repeat,
a thick double repeat, a thin-thick-thin double repeat,
a thin-thick double repeat, a thick bar, a double bar, a start bar,
an end bar, a thick double bar, a thin-thick-thin bar,
a dotted bar, a dashed bar, a tick as bar line and a segno bar.

In addition, there is an option
@code{||:} which is equivalent to @code{|:} except at line
breaks, where it produces a double bar (@code{||}) at the
end of the line and a repeat sign (@code{|:}) at the
beginning of the new line.

For segno, @code{S} produces a segno sign except at line breaks,
where it produces a double bar (@code{||}) at the
end of the line and a segno sign at the beginning of the new line.
@code{|S} is equivalent to @code{S} but produces a simple bar line
(@code{|}) instead of a double bar line (@code{||}) at line breaks.
@code{S|} produces the segno sign at line breaks and starts the following
line without special bar lines.

@code{S|:} and @code{:|S} are used for repeat/segno combinations that are
separated at line breaks.  Alternatively, @code{.S|:} and @code{:|S.}
may be used which combine repeat signs and segno at the same line in
case of a line break.  @code{:|S|:} is a combination of a left repeat
(@code{:|}), a segno (@code{S}) and a right repeat @code{|:} which
splits before the segno at line breaks; @code{:|S.|:} splits after
the segno sign.

If @var{bartype} is set to @code{empty} then nothing is
printed, but a line break is allowed at that spot.

@code{gap} is used for the gaps in dashed bar lines."
 '(allow-span-bar bar-extent gap glyph glyph-name has-span-bar
   hair-thickness kern thin-kern thick-thickness))

(ly:add-interface
 'bass-figure-interface
 "A bass figure text."
 '(implicit))

(ly:add-interface
 'bass-figure-alignment-interface
 "Align a bass figure."
 '())

(ly:add-interface
 'bend-after-interface
 "A doit or drop."
 '(thickness delta-position))

(ly:add-interface
 'dynamic-interface
 "Any kind of loudness sign."
 '())

(ly:add-interface
 'dynamic-line-spanner-interface
 "Dynamic line spanner."
 '(avoid-slur))

(ly:add-interface
 'dynamic-text-interface
 "An absolute text dynamic."
 '(right-padding))

(ly:add-interface
 'dynamic-text-spanner-interface
 "Dynamic text spanner."
 '(text))

(ly:add-interface
 'episema-interface
 "An episema line."
 '())

(ly:add-interface
 'finger-interface
 "A fingering instruction."
 '())

(ly:add-interface
 'footnote-interface
 "Make a footnote."
 '(automatically-numbered
   footnote
   footnote-text
   numbering-assertion-function))

(ly:add-interface
 'footnote-spanner-interface
 "Make a footnote spanner."
 '(footnote-text spanner-placement))

(ly:add-interface
 'fret-diagram-interface
 "A fret diagram"
 '(align-dir fret-diagram-details size dot-placement-list
   thickness))

(ly:add-interface
  'glissando-interface
  "A glissando."
  '(glissando-index))

(ly:add-interface
 'grace-spacing-interface
 "Keep track of durations in a run of grace notes."
 '(columns common-shortest-duration))

(ly:add-interface
 'inline-accidental-interface
 "An inlined accidental (i.e. normal accidentals, cautionary
accidentals)."
 '())

(ly:add-interface
 'instrument-specific-markup-interface
 "Instrument-specific markup (like fret boards or harp pedal diagrams)."
 '(fret-diagram-details graphical harp-pedal-details size thickness))

(ly:add-interface
 'key-cancellation-interface
 "A key cancellation."
 '())

(ly:add-interface
 'ligature-head-interface
 "A note head that can become part of a ligature."
 '())

(ly:add-interface
 'ligature-bracket-interface
 "A bracket indicating a ligature in the original edition."
 '(width thickness height))

(ly:add-interface
 'ligature-interface
 "A ligature."
 '())

(ly:add-interface
 'lyric-interface
 "Any object that is related to lyrics."
 '())

(ly:add-interface
 'lyric-syllable-interface
 "A single piece of lyrics."
 '())

(ly:add-interface
 'mark-interface
 "A rehearsal mark."
 '())

(ly:add-interface
 'metronome-mark-interface
 "A metronome mark."
 '())

(ly:add-interface
 'multi-measure-interface
 "Multi measure rest, and the text or number that is printed over it."
 '(bound-padding))

(ly:add-interface
 'note-name-interface
 "Note names."
 '())

(ly:add-interface
 'octavate-eight-interface
  "Interface that permits the nominal identification of the octavian
annotation that multiplies by two the freqency of the pitches present
in a given staff were they played on a clef that lacked said octavian
annotation."
  '())

(ly:add-interface
 'only-prebreak-interface
 "Kill this grob after the line breaking process."
 '())

(ly:add-interface
 'parentheses-interface
 "Parentheses for other objects."
 '(padding stencils))

(ly:add-interface
 'percent-repeat-interface
 "Beat, Double and single measure repeats."
 '(dot-negative-kern slash-negative-kern slope thickness))

(ly:add-interface
 'piano-pedal-interface
 "A piano pedal sign."
 '())

(ly:add-interface
 'piano-pedal-script-interface
 "A piano pedal sign, fixed size."
 '())

(ly:add-interface
 'pitched-trill-interface
 "A note head to indicate trill pitches."
 '(accidental-grob))

(ly:add-interface
 'rhythmic-grob-interface
 "Any object with a duration.  Used to determine which grobs are
interesting enough to maintain a hara-kiri staff."
 '())

(ly:add-interface
 'spacing-options-interface
 "Supports setting of spacing variables."
 '(spacing-increment shortest-duration-space))

(ly:add-interface
 'span-bar-interface
 "A bar line that is spanned between other barlines.
  This interface is used for bar lines that connect different
  staves."
 '(glyph-name elements pure-Y-common pure-relevant-grobs
   pure-relevant-items pure-relevant-spanners))

(ly:add-interface
 'stanza-number-interface
 "A stanza number, to be put in from of a lyrics line."
 '())

(ly:add-interface
 'string-number-interface
 "A string number instruction."
 '())

(ly:add-interface
 'stroke-finger-interface
 "A right hand finger instruction."
 '(digit-names))

(ly:add-interface
 'system-start-text-interface
 "Text in front of the system."
 '(long-text self-alignment-X self-alignment-Y text))

(ly:add-interface
 'tab-note-head-interface
 "A note head in tablature."
 '(details display-cautionary span-start))

(ly:add-interface
 'trill-spanner-interface
 "A trill spanner."
 '())

(ly:add-interface
 'trill-pitch-accidental-interface
 "An accidental for trill pitch."
 '())

(ly:add-interface
 'unbreakable-spanner-interface
 "A spanner that should not be broken across line breaks.  Override
with @code{breakable=##t}."
 '(breakable))

(ly:add-interface
 'volta-interface
 "A volta repeat."
 '())
