% Do not edit this file; it is automatically
% generated from Documentation/snippets/new
% This file is in the public domain.
%% Note: this file works from version 2.13.34
\version "2.13.36"

\header {
%% Translation of GIT committish: 5a7301fc350ffc3ab5bd3a2084c91666c9e9a549

  texidoces = "
   Este ejemplo muestra una forma de simplificar la adición de muchas
notas guía orquestales a la reducción de piano en una partitura vocal.
La función musical @code{\\cueWhile} toma cuatro argumentos: la música
de la que se toma la cita, como viene definida por @code{\\addQuote},
el nombre que insertar antes de las notas guía, y después @code{#UP} o
@code{#DOWN} para especificar @code{\\voiceOne} con el nombre encima
del pentagrama o bien @code{\\voiceTwo} con el nombre debajo del
pentagrama, y finalmente la música de piano con la que las notas guía
deben aparecer en paralelo.  El nombre del instrumento citado se
posiciona a la izquierda de las notas guía.  Se pueden citar muchos
pasajes como guía, pero no se pueden superponer en el tiempo entre
ellos.

"

 doctitlees = "Añadir notas guía orquestales a una partitura vocal"




  lsrtags="vocal-music, staff-notation"
  texidoc="
  This shows one approach to simplify adding many orchestral cues to
the piano reduction in a vocal score.  The music function
@code{\\cueWhile} takes four arguments: the music from which the cue
is to be taken, as defined by @code{\\addQuote}, the name to be
inserted before the cue notes, then either @code{#UP} or @code{#DOWN}
to specify either @code{\\voiceOne} with the name above the staff or
@code{\\voiceTwo} with the name below the staff, and finally the piano
music in parallel with which the cue notes are to appear.  The name
of the quoted instrument is positioned to the left of the cue notes.
Many passages can be cued, but they cannot overlap each other in time.
"
  doctitle = "Adding orchestral cues to a vocal score"
} % begin verbatim


cueWhile =
  #(define-music-function
    (parser location instrument name dir music)
    (string? string? ly:dir? ly:music?)
    #{
      \cueDuring $instrument #$dir {
        \once \override TextScript #'self-alignment-X = #RIGHT
        \once \override TextScript #'direction = $dir
        s1*0-\markup { \tiny $name }
        $music
      }
    #}
  )

flute = \relative c'' {
  \transposition c'
  s4 s4 e g
}
\addQuote "flute" { \flute }

clarinet = \relative c' {
  \transposition bes
  fis4 d d c
}
\addQuote "clarinet" { \clarinet }

singer = \relative c'' { c4. g8 g4 bes4 }
words = \lyricmode { here's the lyr -- ics }

pianoRH = \relative c'' {
  \transposition c'
  \cueWhile "clarinet" "Clar." #DOWN { c4. g8 }
  \cueWhile "flute" "Flute" #UP { g4 bes4 }
}
pianoLH = \relative c { c4 <c' e> e, <g c> }

\score {
  <<
    \new Staff {
      \new Voice = "singer" {
        \singer
      }
    }
    \new Lyrics {
      \lyricsto "singer"
      \words
    }
    \new PianoStaff <<
      \new Staff {
        \new Voice {
          \pianoRH
        }
      }
      \new Staff {
        \clef "bass"
        \pianoLH
      }
    >>
  >>
}