/*
  This file is part of LilyPond, the GNU music typesetter.

  Copyright (C) 2010 Jan Nieuwenhuizen <janneke@gnu.org>
  Han-Wen Nienhuys <hanwen@xs4all.nl>

  LilyPond is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  LilyPond is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with LilyPond.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "context.hh"
#include "context-mod.hh"

LY_DEFINE (ly_get_context_mods,
	   "ly:get-context-mods",
	   1, 0, 0, (SCM contextmod),
	   "Returns the list of context modifications stored in @var{contextmod}.")
{
  Context_mod *tr = unsmob_context_mod (contextmod);
  LY_ASSERT_SMOB (Context_mod, contextmod, 1);
  return tr->get_mods ();
}

LY_DEFINE (ly_add_context_mod,
	   "ly:add-context-mod",
	   2, 0, 0, (SCM contextmods, SCM modification),
	   "Adds the given context @var{modification} to the list @var{contextmods} of context modifications.")
{
  Context_mod *ctxmod = unsmob_context_mod (contextmods);
  LY_ASSERT_SMOB (Context_mod, contextmods, 1);
  ctxmod->add_context_mod (modification);
  return SCM_UNSPECIFIED;
}

