/*
  This file is part of LilyPond, the GNU music typesetter.

  Copyright (C) 2006--2010 Han-Wen Nienhuys <hanwen@lilypond.org>
  

  LilyPond is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  LilyPond is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with LilyPond.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "lily-lexer.hh"

LY_DEFINE (ly_lexer_keywords, "ly:lexer-keywords",
	  1, 0, 0, (SCM lexer),
	  "Return a list of @code{(KEY . CODE)} pairs, signifying the"
	  " LilyPond reserved words list.")
{
  LY_ASSERT_SMOB (Lily_lexer, lexer, 1);

  Lily_lexer * lex = Lily_lexer::unsmob (lexer);
  return lex->keyword_list ();
}
