%% Do not edit this file; it is automatically
%% generated from LSR http://lsr.dsi.unimi.it
%% This file is in the public domain.
\version "2.13.10"

\header {
  lsrtags = "text, tweaks-and-overrides"

  texidoc = "
For technical reasons, text scripts attached to note heads cannot
easily be centered on a note head's width, unlike articulations.

Instead of using trial-and-error offset tweaks, this snippet accesses a
note head (or rest) from the @code{TextScript} object's horizontal
parent (a paper column), using its extent to correct the positioning.



"
  doctitle = "Centering markup on note heads automatically"
} % begin verbatim

textScriptCenterOnNote = \override TextScript #'X-offset =
#(lambda (grob)
   (let* ((paper-col (ly:grob-parent grob X))
          (elts (ly:grob-object paper-col 'elements))
          (rhythmic-head grob))

     (for-each
      (lambda (idx)
        (let ((elt (ly:grob-array-ref elts idx)))
          (if (grob::has-interface elt
                                   'rhythmic-grob-interface)
              (set! rhythmic-head elt))))
      (reverse (iota (ly:grob-array-length elts))))

     (+
      (ly:self-alignment-interface::x-aligned-on-self grob)
      (interval-center
       (ly:grob-robust-relative-extent rhythmic-head rhythmic-head X)))))

\relative c' {
  \override TextScript #'self-alignment-X = #CENTER
  \textScriptCenterOnNote
  <c e g c>1-\markup \arrow-head #Y #UP ##t
  <c e g c>1-\markup \huge "^"
}

