%% Do not edit this file; it is auto-generated from input/new
%% This file is in the public domain.
\version "2.11.61"
\header {
doctitlees = "Transportar música con el menor número de alteraciones"
texidoces = "
Este ejemplo utiliza código de Scheme para forzar las
modificaciones enarmónicas de las notas, y así tener el menor
número de alteraciones accidentales. En este caso se aplican las
siguientes reglas:

@itemize
@item
Se quitan las dobles alteraciones

@item
Si sostenido -> Do

@item
Mi sistenido -> Fa

@item
Do bemol -> Si

@item
Fa bemol -> Mi

@end itemize

De esta forma se selecciona el mayor número de notas enarmónicas
naturales.

"
  lsrtags = "pitches"
  texidoc = "This example uses some Scheme code to enforce enharmonic
modifications for notes in order to have the minimum number of
accidentals.  In this case, the following rules apply:

@itemize
@item
Double accidentals should be removed

@item
B sharp -> C

@item
E sharp -> F

@item
C flat -> B

@item
F flat -> E

@end itemize

In this manner, the most natural enharmonic notes are chosen.
"
  doctitle = "Transposing music with minimum accidentals"
} % begin verbatim

#(define  (naturalize-pitch p)
  (let* ((o (ly:pitch-octave p))
         (a (* 4 (ly:pitch-alteration p)))
    ; alteration, a, in quarter tone steps, for historical reasons
         (n (ly:pitch-notename p)))
    (cond
     ((and (> a 1) (or (eq? n 6) (eq? n 2)))
      (set! a (- a 2))
      (set! n (+ n 1)))
     ((and (< a -1) (or (eq? n 0) (eq? n 3)))
      (set! a (+ a 2))
      (set! n (- n 1))))
    (cond
     ((> a 2) (set! a (- a 4)) (set! n (+ n 1)))
     ((< a -2) (set! a (+ a 4)) (set! n (- n 1))))
    (if (< n 0) (begin (set! o (- o 1)) (set! n (+ n 7))))
    (if (> n 6) (begin (set! o (+ o 1)) (set! n (- n 7))))
    (ly:make-pitch o n (/ a 4))))

#(define (naturalize music)
  (let* ((es (ly:music-property music 'elements))
         (e (ly:music-property music 'element))
         (p (ly:music-property music 'pitch)))
    (if (pair? es)
        (ly:music-set-property!
         music 'elements
         (map (lambda (x) (naturalize x)) es)))
    (if (ly:music? e)
        (ly:music-set-property!
         music 'element
         (naturalize e)))
    (if (ly:pitch? p)
        (begin
          (set! p (naturalize-pitch p))
          (ly:music-set-property! music 'pitch p)))
    music))

naturalizeMusic =
#(define-music-function (parser location m)
					(ly:music?)
			(naturalize m))

music = \relative c' { c4 d e g }

\score {
  \new Staff {
    \transpose c ais \music
    \naturalizeMusic \transpose c ais \music
    \transpose c deses \music
    \naturalizeMusic \transpose c deses \music
  }
  \layout { }
}
