%% Do not edit this file; it is auto-generated from LSR http://lsr.dsi.unimi.it
%% This file is in the public domain.
\version "2.11.38"

\header {
  lsrtags = "rhythms, text"

  texidoc = "
This function allows you to change the tempo and specify text
directions at the same time, using one single command.It takes three
arguments: the text to be printed (the string has to be introduced with
a # character), the duration (it has to be specified as a text string,
between double quotes and with a #), and the metronome tempo (as a
number). This way, the given tempo will be taken into account in MIDI
output, but the normal @code{\\tempo} command will remain unaffected. 

"
  doctitle = "Integrating text indications in metronome marks"
} % begin verbatim
#(define ((make-format-movement-markup-function text) duration count context)
 (markup #:huge #:bold text #:hspace 1
         "("
         #:general-align Y DOWN #:smaller
            #:note-by-number (ly:duration-log duration)
                             (ly:duration-dot-count duration)
                             1
         "="
         (number->string count)
         ")"))


#(define (string->duration duration-string)
 "Parse the `duration-string', e.g. ''4..'' or ''breve.'', and return a duration object."
 (let* ((length (string-length duration-string))
        (dot-index (or (string-index duration-string #\.) length))
        (len (substring duration-string 0 dot-index))
        (dots (- length dot-index)))
  (ly:make-duration (cond ((string=? len "breve") -1)
                          ((string=? len "longa") -2)
                          ((string=? len "maxima") -3)
                          (else (log2 (string->number len))))
                    dots 1 1)))

movement =
#(define-music-function (parser location text duration count music)

                       (string? string? integer? ly:music?)
 #{
   \set Score.metronomeMarkFormatter = #(make-format-movement-markup-function $text)
   \set Score.tempoWholesPerMinute = #$(ly:moment-mul (ly:make-moment count 1)
                                         (ly:duration-length
                                           (string->duration duration)))
   \set Score.tempoUnitDuration = #$(string->duration duration)
   \set Score.tempoUnitCount = #$count
   $music
   \set Score.metronomeMarkFormatter = #format-metronome-markup
 #})

\layout { ragged-right = ##f }

\relative c' {
  \time 3/4
  \movement "Allegro" "2." #96
  c2 e4
  g2.
  \movement "Moderato" "4" #104
  f4 e d
  \tempo 4 = 92
  c2.
}
