%% Do not edit this file; it is auto-generated from LSR http://lsr.dsi.unimi.it
%% This file is in the public domain.
\version "2.11.38"

\header {
  lsrtags = "pitches"

  texidoc = "
In music that contains many occurrences of the same sequence of notes
at different pitches, the following music function may prove useful. It
takes a note, of which only the pitch is used. The supporting Scheme
functions were borrowed from the \"Tips and tricks\" document in the
manual for version 2.10. This example creates the rhythm used
throughout Mars, from Gustav Holst's The Planets. 

"
  doctitle = "Creating a sequence of notes on various pitches"
} % begin verbatim
#(define (make-note-req p d)
  (make-music 'NoteEvent
   'duration d
   'pitch p))

#(define (make-note p d)
  (make-music 'EventChord
   'elements (list (make-note-req p d))))

#(define (seq-music-list elts)
  (make-music 'SequentialMusic
   'elements elts))

#(define (make-triplet elt)
  (make-music 'TimeScaledMusic
   'denominator 3
   'numerator 2
   'element elt))


rhythm = #(define-music-function (parser location note) (ly:music?)
          "Make the rhythm in Mars (the Planets) at the given note's pitch"
          (let* ((p (ly:music-property
                      (car (ly:music-property note 'elements))
                      'pitch)))
          (seq-music-list (list
            (make-triplet (seq-music-list (list
              (make-note p (ly:make-duration 3 0 2 3))
              (make-note p (ly:make-duration 3 0 2 3))
              (make-note p (ly:make-duration 3 0 2 3))
            )))
            (make-note p (ly:make-duration 2 0))
            (make-note p (ly:make-duration 2 0))
            (make-note p (ly:make-duration 3 0))
            (make-note p (ly:make-duration 3 0))
            (make-note p (ly:make-duration 2 0))
          ))))

\score {
  \new Staff {
    \time 5/4
    \rhythm c'
    \rhythm c''
    \rhythm g
  }
}
