#!/usr/bin/python

import sys
import os
import glob

USAGE = '''  Usage: makelsr.py LSR_SNIPPETS_DIR
This script must be run from top of the source tree;
it updates snippets input/lsr with snippets in input/new or LSR_SNIPPETS_DIR.
'''

LY_HEADER = '''%%%% Do not edit this file; it is auto-generated from LSR!
%%%% Tags: %s
'''

DEST = os.path.join ('input', 'lsr')
NEW_LYS = os.path.join ('input', 'new')

TAGS = []
# NR 1
TAGS.extend (['pitches', 'rhythms', 'expressive-marks',
'repeats', 'simultaneous-notes', 'staff-notation', 'editorial-and-educational-use', 'text'])
# NR 2
TAGS.extend (['vocal-music', 'chords', 'piano-music',
'percussion', 'guitar', 'strings', 'bagpipes', 'ancient-notation'])

TAGS.append ('other')

def exit_with_usage (n=0):
	sys.stderr.write (USAGE)
	sys.exit (n)

try:
	in_dir = sys.argv[1]
except:
	exit_with_usage (2)

if not (os.path.isdir (DEST) and os.path.isdir (NEW_LYS)):
	exit_with_usage (3)

unsafe = []
unconverted = []

def copy_ly (srcdir, name, tags):
	global unsafe
	global unconverted
	dest = os.path.join (DEST, name)
	f = open (dest, 'w')
	f.write (LY_HEADER % ', '.join (tags))
	f.write (open (os.path.join (srcdir, name)).read ())
	f.close ()
	e = os.system('convert-ly -e ' + dest)
	if e:
		unconverted.append (dest)
	if os.path.exists (dest + '~'):
		os.remove (dest + '~')
	# -V seems to make unsafe snippets fail nicer/sooner
	e = os.system ('nice lilypond -V -dno-print-pages -dsafe -o /tmp/lsrtest ' + dest)
	if e:
		unsafe.append (dest)

def read_source (src):
	s = {}
	l = {}
	for tag in TAGS:
		srcdir = os.path.join (src, tag)
		l[tag] = set (map (os.path.basename, glob.glob (os.path.join (srcdir, '*.ly'))))
		for f in l[tag]:
			if f in s.keys ():
				s[f][1].append (tag)
			else:
				s[f] = (srcdir, [tag])
	return s, l

def dump_file_list (file, list):
	f = open (file, 'w')
	f.write ('\n'.join (list) + '\n')

## clean out existing lys and generated files
map (os.remove, glob.glob (os.path.join (DEST, '*.ly')) +
     glob.glob (os.path.join (DEST, '*.snippet-list')))

# read LSR source
snippets, tag_lists = read_source (in_dir)
# read input/new
s, l = read_source (NEW_LYS)
snippets.update (s)
for t in TAGS:
	tag_lists[t].update (l[t])

for (name, (srcdir, tags)) in snippets.items ():
	copy_ly (srcdir, name, tags)

for (tag, file_set) in tag_lists.items ():
	dump_file_list (os.path.join (DEST, tag + '.snippet-list'), file_set)

if unconverted:
	sys.stderr.write ('These files could not be converted successfully by convert-ly:\n')
	sys.stderr.write ('\n'.join (unconverted))

dump_file_list ('lsr-unsafe.txt', unsafe)
sys.stderr.write ('''

Unsafe files printed in lsr-unsafe.txt: CHECK MANUALLY!
  xargs git-diff < lsr-unsafe.txt

''')

