%%  Do not edit this file; it is auto-generated from LSR!
\version "2.11.23"

\header { texidoc = "
A template to write score for a diatonic accordion.

- There is a horizontal staff indicating if the accordion   must be
pushed (thick line) or pulled (thin line)

- There is a small rhytmic staff with lyrics that describes the bass
buttons to press.   The bar-lines are made of gridlines ( Gridlines,
not a really satisfying solution, but the best I found)

- The tabulator staff for diatonic accordions shows the geographic
position of the buttons   and not (as for every other instrument) the
pitch of the tones.   The keys on the melody-side of the accordion are
placed in three columns and about 12 rows.   In the tabulator staff
notation the   - most outer column is described with notes between
lines   - most inner column is described with notes between lines with
a cross as accidental   - middle column is described with notes on a
line, whereby the row in the middle is represented     on the middle
line in the staff.



Some words to transpose piano note to the diatonic accordion.
------------------------------------------------------------ 1. Every
diatonic accordion is built for some keys only. For example    for the
key of C-major and F-major.    So it is important to transpose a piano
melody to match one of these keys.    Transpose the source code, not
only the output because    you need this code later on to translate it
once more to the tabulator staff.    This can be done with the command
'displayLilyMusic'.

2. You have to alternate the push and pull-direction of the accordion
regularely.    If the player has a too long part to pull the accordion
gets broken.    At the other hand some harmonies are only available in
one direction (push or pull)    Considering this decide which parts of
the melody are the push-parts and whic the  pull-parts.

3. For each pull- / or push-part translate the piano notes to the
according tabulatur representation.

This snippet comes with a useful optional macro for the jEdit text
editor.
" }

% Created on Sat Aug 17 2007 by ak

verse= \lyricmode { Wie gross bist du! Wie gross bist du! }

harmonies =  \new ChordNames \chordmode {
	\germanChords \set chordChanges = ##t
	bes8 bes8 bes8 es2 f bes1
}

NoStem = \override Stem #'transparent = ##t
NoNoteHead= \override NoteHead #'transparent = ##t
ZeroBeam = \override Beam  #'positions = #'(0 . 0)

staffTabLine = \new Staff  \with { \remove "Time_signature_engraver" \remove "Clef_engraver" } {
	\override Staff.StaffSymbol #'line-positions = #'( 0 ) 
% Shows one horizontal line. The vertical line (simulating a bar-line) is simulated with a gridline
	\set Staff.midiInstrument="choir aahs"
	\key c \major
	\relative c''
		{  
			% disable the following line to see the the noteheads while writing the song 
			\NoNoteHead  
			\override NoteHead #'no-ledgers = ##t

			% The beam between 8th-notes is used to draw the push-line
			%How to fast write the push-lines: 
			%	 1. write repeatedly 'c c c c c c c c |' for the whole length of the song 
			%	 2. uncomment the line \NoNoteHead
			%	 3. compile
			%	 4. Mark the positions on which push/pull changes. 
			%	    In the score-picture click on the position the push- or pull-part starts 
                        %           (on the noteHead, the cursor will change to a hand-icon).
			%	    The cursor in the source code will jump just at this position.
			%	  a) If a push-part starts there, replace the 'c' by an 'e['
			%	  b) If a pull-part starts there, replace the 'c' by an 's'
			%	 5. Switch into 'overwrite-mode' by pressing the 'ins' key. 
			%	 6. For the pull-parts overwrite the 'c' with 's' 
			%	 7. For every push-part replace the last 'c' with 'e]' 
			%        8. Switch into 'insert-mode' again 
			%	 9. At last it should look lik e.g. (s s e[ c | c c c c c c c c | c c c c c c e] s s)
			%	10. re-enable the line \NoNoteHead
			\autoBeamOff
			\ZeroBeam 
			 s8 s s | e[ c c c c c c e] | s s s s s 
		}
}

%{
notePush= {  	e       f	fis	g	a	 c'	c'      d'      ees'	e'	f'	fis'	g'	a'	bes'	c''	c''	d''	ees''	e''	f''	fis''	g''	a''	c'''	c'''	ees'''	e'''	f'''	g'''	a''' }
tabPush=  {  	g	f	e	b	a	 d'	c'	bisis	disis'	f'	e'	aisis'	a'	g'	fisis'	b'	c''	eisis''	cisis''	e''	d''	gisis''	g''	f''	a''	b''	bisis''	d'''	c'''	f'''	e''' }

notePull= {	g	aes	bes	b	c'	cis'	d'	ees'	e'	f'	fis'	g'	aes'	a'	bes'	b'	c''	cis''	d''	ees''	e''	f''	g''	aes''	a''	bes''	b''	c'''	cis'''	d'''	e''' }
tabPull=  {	g	e	f	b	a	disis'	d'	bisis	c'	f'	fisis'	e'	aisis'	a'	g'	c''	b'	cisis''	e''	eisis''	d''	g''	f''	gisis''	b''	a''	d'''	f'''	bisis''	c'''	e''' }
%}

% Accordion melody in tabulator score		
% 1. Place a copy of the piano melody below
% 2. Separate piano melody into pull- and push-parts according to the staffTabLine you've already made      
% 3. For each line: Double the line. Remark the 1st one (Keeps unchanged as reference) and then change the second line using the transformation paper
%    or the macros 'conv2diaton push.bsh' and 'conv2diaton pull.bsh' 
% Tips:
% - In jEdit Search & Replace mark the Option 'Keep Dialog'

AccordionTabTwoCBesDur= {	
 % pull 1
 %<f' bes'>8 <f' a'>8 <d' bes'>8 | 
<g'' a''>8 <g'' b''>8 <e'' a''>8 | 
 % push 2
 %<g' c''>4 <f' d''> <g' ees''> <f' a'> | 
<g'' a''>4 <d'' eisis''> <g'' bisis''> <d'' f''> | 
 % pull 3
% <f' bes'>2 r8 }
 <g'' a''>2 r8 }

  AccordionTab= { \dynamicUp		
% 1. Place a copy of the piano melody above
% 2. Separate piano melody into pull- and push-parts according to the staffTabLine you've already made      
% 3. For each line: Double the line. Remark the 1st one (Keeps unchanged as reference) and then 
%    change the second line using the transformation paper
% Tips:
% - In jEdit Search & Replace mark the Option 'Keep Dialog'
% - 
\AccordionTabTwoCBesDur
 }


 
 \layout {   
 \context {
   \Staff    	  
   \consists "Grid_point_engraver"

   gridInterval = #(ly:make-moment 4 4) % 4/4 - tact. How many beats per bar

   % The following line has to be adjusted O-F-T-E-N.
   \override GridPoint #'Y-extent = #'(-2 . -21)   
 }
 \context {
    \ChoirStaff
    \remove "System_start_delimiter_engraver" 
 }
}

staffVoice = \new Staff=astaffvoice  {
	\time 4/4
	\set Staff.instrumentName="Voice"
	\set Staff.midiInstrument="voice oohs"
	\key bes \major
	\partial 8*3 
	\clef treble
	{ 	
		\context Voice = "melodyVoi" 
		{ <f' bes'>8 <f' a'>8 <d' bes'>8 | <g' c''>4 <f' d''> <g' es''> <f' a'> | <f' bes'>2 r8 }
	\bar "|."
	}
}

staffAccordionMel = \new Staff  \with { \remove "Clef_engraver" } {
	#(set-accidental-style 'forget) %Set the accidentals (Vorzeichen) for each note, 
					%do not remember them for the rest of the measure.  
	\time 4/4
	\set Staff.instrumentName="Accordion"
	\set Staff.midiInstrument="voice oohs"
	\key c \major
	\clef treble
	{ \AccordionTab \bar "|." }
}

	AltOn = #(define-music-function (parser location mag) (number?)
        	#{ \override Stem #'length = #$(* 7.0 mag)
		\override NoteHead #'font-size =
		#$(inexact->exact (* (/ 6.0 (log 2.0)) (log mag))) #})
     
	AltOff = {
		\revert Stem #'length
		\revert NoteHead #'font-size
		}

BassRhytm = {s4 s8 | c2 c2 | c2 s8 }
LyricBassRhythmI=  \lyricmode { c b | c }

staffBassRhytm = \new Staff=staffbass  \with { \remove "Clef_engraver" } {
	% This is not a RhythmicStaff  because it must be possible to append lyrics.
		
	\override Score.GridLine #'extra-offset = #'( 13.0 . 0.0 ) % x.y
	\override Staff.StaffSymbol #'line-positions = #'( 0 ) 
        % Shows one horizontal line. The vertical line (simulating a bar-line) is simulated by a grid
        % Search for 'grid' in this page to find all related functions 
	\time 4/4
	{ 	
		\context Voice = "VoiceBassRhytm" 
		\stemDown \AltOn #0.6
		\relative c''
		{   
		\BassRhytm
		}
		\AltOff
	\bar "|."
	}
}

\new Score 
\with {
 \consists "Grid_line_span_engraver" %The vertical line (simulating a bar-line) in the staffBassRhytm is a gridline 
}
\new ChoirStaff 
	<<
		\harmonies 
		\staffVoice
		\context Lyrics = "lmelodyVoi" \with {alignBelowContext=astaffvoice} { \lyricsto "melodyVoi" \verse }
		\staffAccordionMel
		\staffTabLine
		\staffBassRhytm
	\context Lyrics = "lBassRhytmAboveI" \with {alignAboveContext=staffbass} \lyricsto VoiceBassRhytm \LyricBassRhythmI
	>>


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                            APPENDIX                          %
%     macro 'macro_conv2diaton_push.bsh' for jedit editor      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%{ 
// original saved in 'Handorg_Adria_Diaton_III.xls'
// Save this buffer, to the other recorded macros in the jedit editor
// and the macro should appear in the
// Macros menu.

// /ak 17.8.07 This macro from converts lilypond piano notation into 
// lilypond tabulator notation for the push-part (at the bottom the pull-part) of a diatonic accordion
// It replaces the piano notes of the line where the cursor is by the accordion notation



// Known issues: 1) A note at the end of line is not replaced

textArea.goToEndOfWhiteSpace(false);
textArea.goToStartOfWhiteSpace(true);


String firstName, lastName; 

int ReplaceTextInSelection(String sfind, String sreplace)
{
//MsgConcat = new StringBuffer(512);
//MsgConcat.append("Ha");

//Macros.message(view, "On that line replace \"" + sfind + "\" by \"" + sreplace+ "\"");
SearchAndReplace.setSearchString(sfind.toString());
SearchAndReplace.setReplaceString(sreplace.toString());
SearchAndReplace.setBeanShellReplace(false);
SearchAndReplace.setIgnoreCase(true);
SearchAndReplace.replace(view);
SearchAndReplace.setRegexp(true);
return 1;
}


String smainfind;
String smainrepl;


// Push-part tmp
smainfind="(\\s|^|<|\\{)(c,)([^\'^is^es])"; smainrepl="$1tmpd\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(cis,)([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(des,)([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(d,)([^\'^is^es])"; smainrepl="$1tmpbisis-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(dis,)([^\'^is^es])"; smainrepl="$1tmpdisis\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ees,)([^\'^is^es])"; smainrepl="$1tmpdisis\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(e,)([^\'^is^es])"; smainrepl="$1tmpg$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(f,)([^\'^is^es])"; smainrepl="$1tmpf$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(fis,)([^\'^is^es])"; smainrepl="$1tmpe$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ges,)([^\'^is^es])"; smainrepl="$1tmpe$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(g,)([^\'^is^es])"; smainrepl="$1tmpb$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(gis,)([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(aes,)([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(a,)([^\'^is^es])"; smainrepl="$1tmpa$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ais,)([^\'^is^es])"; smainrepl="$1tmpfisis\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(bes,)([^\'^is^es])"; smainrepl="$1tmpfisis\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(b,)([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(c)([^\'^is^es])"; smainrepl="$1tmpd\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(cis)([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(des)([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(d)([^\'^is^es])"; smainrepl="$1tmpbisis$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(dis)([^\'^is^es])"; smainrepl="$1tmpdisis\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ees)([^\'^is^es])"; smainrepl="$1tmpdisis\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(e)([^\'^is^es])"; smainrepl="$1tmpf\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(f)([^\'^is^es])"; smainrepl="$1tmpe\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(fis)([^\'^is^es])"; smainrepl="$1tmpaisis\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ges)([^\'^is^es])"; smainrepl="$1tmpaisis\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(g)([^\'^is^es])"; smainrepl="$1tmpa\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(gis)([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(aes)([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(a)([^\'^is^es])"; smainrepl="$1tmpg\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ais)([^\'^is^es])"; smainrepl="$1tmpfisis\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(bes)([^\'^is^es])"; smainrepl="$1tmpfisis\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(b)([^\'^is^es])"; smainrepl="$1tmpr$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(c\')([^\'^is^es])"; smainrepl="$1tmpb\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(cis\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(des\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(d\')([^\'^is^es])"; smainrepl="$1tmpeisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(dis\')([^\'^is^es])"; smainrepl="$1tmpcisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ees\')([^\'^is^es])"; smainrepl="$1tmpcisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(e\')([^\'^is^es])"; smainrepl="$1tmpe\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(f\')([^\'^is^es])"; smainrepl="$1tmpd\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(fis\')([^\'^is^es])"; smainrepl="$1tmpgisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ges\')([^\'^is^es])"; smainrepl="$1tmpgisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(g\')([^\'^is^es])"; smainrepl="$1tmpg\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(gis\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(as\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(a\')([^\'^is^es])"; smainrepl="$1tmpf\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ais\')([^\'^is^es])"; smainrepl="$1tmpfisis\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(bes\')([^\'^is^es])"; smainrepl="$1tmpfisis\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(b\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(c\'\')([^\'^is^es])"; smainrepl="$1tmpa\'\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(cis\'\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(des\'\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(d\'\')([^\'^is^es])"; smainrepl="$1tmpeisis\'\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(dis\'\')([^\'^is^es])"; smainrepl="$1tmpbisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ees\'\')([^\'^is^es])"; smainrepl="$1tmpbisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(e\'\')([^\'^is^es])"; smainrepl="$1tmpd\'\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(f\'\')([^\'^is^es])"; smainrepl="$1tmpc\'\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(fis\'\')([^\'^is^es])"; smainrepl="$1tmpgisis\'\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ges\'\')([^\'^is^es])"; smainrepl="$1tmpgisis\'\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(g\'\')([^\'^is^es])"; smainrepl="$1tmpf\'\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(gis\'\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(aes\'\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(a\'\')([^\'^is^es])"; smainrepl="$1tmpe\'\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ais\'\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(bes\'\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(b\'\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );

smainfind="(\\s|^|<|\\{)(tmp)()"; smainrepl="$1$3"; ReplaceTextInSelection( smainfind, smainrepl );
*/

/*
// Pull-part tmp
smainfind="(\\s|^|<|\\{)(c,)([^\'^is^es])"; smainrepl="$1tmpa-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(cis,)([^\'^is^es])"; smainrepl="$1tmpdisis\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(des,)([^\'^is^es])"; smainrepl="$1tmpdisis\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(d,)([^\'^is^es])"; smainrepl="$1tmpd\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(dis,)([^\'^is^es])"; smainrepl="$1tmpbisis-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ees,)([^\'^is^es])"; smainrepl="$1tmpbisis-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(e,)([^\'^is^es])"; smainrepl="$1tmpc\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(f,)([^\'^is^es])"; smainrepl="$1tmpf\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(fis,)([^\'^is^es])"; smainrepl="$1tmpfisis\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ges,)([^\'^is^es])"; smainrepl="$1tmpfisis\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(g,)([^\'^is^es])"; smainrepl="$1tmpg$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(gis,)([^\'^is^es])"; smainrepl="$1tmpe$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(aes,)([^\'^is^es])"; smainrepl="$1tmpe$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(a,)([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ais,)([^\'^is^es])"; smainrepl="$1tmpf$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(bes,)([^\'^is^es])"; smainrepl="$1tmpf$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(b,)([^\'^is^es])"; smainrepl="$1tmpb$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(c)([^\'^is^es])"; smainrepl="$1tmpa$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(cis)([^\'^is^es])"; smainrepl="$1tmpdisis\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(des)([^\'^is^es])"; smainrepl="$1tmpdisis\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(d)([^\'^is^es])"; smainrepl="$1tmpd\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(dis)([^\'^is^es])"; smainrepl="$1tmpbisis$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ees)([^\'^is^es])"; smainrepl="$1tmpbisis$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(e)([^\'^is^es])"; smainrepl="$1tmpc\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(f)([^\'^is^es])"; smainrepl="$1tmpf\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(fis)([^\'^is^es])"; smainrepl="$1tmpfisis\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ges)([^\'^is^es])"; smainrepl="$1tmpfisis\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(g)([^\'^is^es])"; smainrepl="$1tmpe\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(gis)([^\'^is^es])"; smainrepl="$1tmpaisis\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(aes)([^\'^is^es])"; smainrepl="$1tmpaisis\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(a)([^\'^is^es])"; smainrepl="$1tmpa\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ais)([^\'^is^es])"; smainrepl="$1tmpg\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(bes)([^\'^is^es])"; smainrepl="$1tmpg\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(b)([^\'^is^es])"; smainrepl="$1tmpc\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(c\')([^\'^is^es])"; smainrepl="$1tmpb\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(cis\')([^\'^is^es])"; smainrepl="$1tmpcisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(des\')([^\'^is^es])"; smainrepl="$1tmpcisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(d\')([^\'^is^es])"; smainrepl="$1tmpe\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(dis\')([^\'^is^es])"; smainrepl="$1tmpeisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ees\')([^\'^is^es])"; smainrepl="$1tmpeisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(e\')([^\'^is^es])"; smainrepl="$1tmpd\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(f\')([^\'^is^es])"; smainrepl="$1tmpg\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(fis\')([^\'^is^es])"; smainrepl="$1tmpfisis\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ges\')([^\'^is^es])"; smainrepl="$1tmpfisis\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(g\')([^\'^is^es])"; smainrepl="$1tmpf\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(gis\')([^\'^is^es])"; smainrepl="$1tmpgisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(aes\')([^\'^is^es])"; smainrepl="$1tmpgisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(a\')([^\'^is^es])"; smainrepl="$1tmpb\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ais\')([^\'^is^es])"; smainrepl="$1tmpa\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(bes\')([^\'^is^es])"; smainrepl="$1tmpa\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(b\')([^\'^is^es])"; smainrepl="$1tmpd\'\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(c\'\')([^\'^is^es])"; smainrepl="$1tmpf\'\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(cis\'\')([^\'^is^es])"; smainrepl="$1tmpbisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(des\'\')([^\'^is^es])"; smainrepl="$1tmpbisis\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(d\'\')([^\'^is^es])"; smainrepl="$1tmpc\'\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(dis\'\')([^\'^is^es])"; smainrepl="$1tmpeisis\'\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ees\'\')([^\'^is^es])"; smainrepl="$1tmpeisis\'\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(e\'\')([^\'^is^es])"; smainrepl="$1tmpe\'\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(f\'\')([^\'^is^es])"; smainrepl="$1tmpg\'\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(fis\'\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ges\'\')([^\'^is^es])"; smainrepl="$1tmpr-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(g\'\')([^\'^is^es])"; smainrepl="$1tmpf\'\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(gis\'\')([^\'^is^es])"; smainrepl="$1tmpgisis\'\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(aes\'\')([^\'^is^es])"; smainrepl="$1tmpgisis\'\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(a\'\')([^\'^is^es])"; smainrepl="$1tmpb\'\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(ais\'\')([^\'^is^es])"; smainrepl="$1tmpa\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(bes\'\')([^\'^is^es])"; smainrepl="$1tmpa\'\'$3"; ReplaceTextInSelection( smainfind, smainrepl );
smainfind="(\\s|^|<|\\{)(b\'\')([^\'^is^es])"; smainrepl="$1tmpd\'\'\'-.$3"; ReplaceTextInSelection( smainfind, smainrepl );

smainfind="(\\s|^|<|\\{)(tmp)()"; smainrepl="$1$3"; ReplaceTextInSelection( smainfind, smainrepl );
*/


%}

