/*   
  music-wrapper.cc --  implement Music_wrapper
  
  source file of the GNU LilyPond music typesetter
  
  (c) 1998--2003 Han-Wen Nienhuys <hanwen@cs.uu.nl>
  
 */


#include "music-wrapper.hh"




void
Music_wrapper::transpose (Pitch p)
{
  if (element ())
    element ()-> transpose (p);
}


Music_wrapper::Music_wrapper ()
  : Music ()
{
}

Moment
Music_wrapper::get_length () const
{
  return element ()->get_length ();
}

Pitch
Music_wrapper::to_relative_octave (Pitch p)
{
  return element ()->to_relative_octave (p);
}


Music*
Music_wrapper::element () const
{
  return unsmob_music (get_mus_property ("element"));
}

void
Music_wrapper::compress (Moment m)
{
  element ()->compress (m);
}

ADD_MUSIC (Music_wrapper);


Moment
Music_wrapper::start_mom () const
{
  return element ()->start_mom ();
}
