/*   
  spacing-spanner.hh -- declare Spacing_spanner
  
  source file of the GNU LilyPond music typesetter
  
  (c) 1999--2002 Han-Wen Nienhuys <hanwen@cs.uu.nl>
  
 */

#ifndef SPACING_SPANNER_HH
#define SPACING_SPANNER_HH

#include "spanner.hh"
#include "spring.hh"

class Spacing_spanner
{
public:
  static void set_interface (Grob*);
  static void do_measure (Grob*,Link_array<Grob> const &) ;
  static void stretch_to_regularity (Grob*, Array<Spring> *, Link_array<Grob> const &);
  DECLARE_SCHEME_CALLBACK (set_springs, (SCM ));
  static Real default_bar_spacing (Grob*,Grob*,Grob*,Moment)  ;
  static Real note_spacing (Grob*,Grob*,Grob*,Moment)  ;
  static Real get_duration_space (Grob*,Moment dur, Moment shortest) ;
};

#endif /* SPACING_SPANNER_HH */

