/*
  stem.hh -- declare Stem

  (c) 1996--2000 Han-Wen Nienhuys
*/

#ifndef STEM_HH
#define STEM_HH

#include "lily-proto.hh"
#include "lily-guile.hh"
#include "stem-info.hh"

/**the rule attached to the ball.
  takes care of:

  \begin{itemize}
  \item the rule
  \item the flag
  \item up/down position.
  \end{itemize}

  should move beam_{left, right} into Beam

  TODO.
  
  Stem size depends on flag.

  elt properties:

  beam_dir: direction of the beam (int)

  dir_force: is direction explicitely specified? (bool)

  /// how many abbrev beam don't reach stem?
  int beam_gap_i_;
  
  */
class Stem 
{
public:
  static SCM brew_molecule (SCM);

  /// log of the duration. Eg. 4 -> 16th note -> 2 flags
  static  int flag_i (Score_element*) ;
  static int beam_count (Score_element*,Direction) ;
  static void set_beaming (Score_element*,int,  Direction d);
  /** 
      don't print flag when in beam.
      our beam, for aligning abbrev flags
  */
  static Score_element * beam_l (Score_element*);
  static Score_element * first_head (Score_element*) ;
  static Drul_array<Score_element*> extremal_heads (Score_element*);
  static Score_element * support_head (Score_element*) ;
  
  /// ensure that this Stem also encompasses the Notehead #n#
  static void add_head (Score_element*me, Score_element*n);
  static Stem_info calc_stem_info (Score_element *) ;
  static Real chord_start_f (Score_element *) ;
  static Direction get_direction (Score_element*) ;
  static int type_i (Score_element *) ;
  static void set_stemend (Score_element *,Real);
  static Direction get_default_dir(Score_element *) ;
  static int get_center_distance(Score_element *,Direction) ;
  static int heads_i (Score_element *) ;
  static bool invisible_b(Score_element *) ;
 
  /// heads that the stem encompasses (positions)
  static Interval head_positions(Score_element *) ;
  static Real get_default_stem_end_position (Score_element*me) ;
  static void position_noteheads(Score_element*);
  static Real stem_end_position (Score_element*) ;
  static Real off_callback (Score_element *, Axis);
  static Molecule flag (Score_element*);
  static SCM before_line_breaking (SCM);
  static Interval dim_callback (Score_element *,Axis);
  static bool has_interface (Score_element*);
  static void set_interface (Score_element*);

  static void set_spacing_hints (Score_element*me) ;
};
#endif
