/*   
  grace-align-item.cc --  implement Grace_align_item
  
  source file of the GNU LilyPond music typesetter
  
  (c) 1999--2000 Han-Wen Nienhuys <hanwen@cs.uu.nl>
  
 */

#include "grace-align-item.hh"
#include "lookup.hh"
#include "paper-column.hh"
#include "paper-def.hh"

Grace_align_item::Grace_align_item ()
{
  set_elt_property ("stacking-dir", gh_int2scm (RIGHT));
  set_axis (X_AXIS);
}
  
void
Grace_align_item::before_line_breaking ()
{
  Real nhw = // lookup_l ()->notehead (2, "").dim_[X_AXIS].length();
    paper_l ()->get_var ("quartwidth");
  
  set_elt_property ("threshold",
		    gh_cons (gh_double2scm (nhw* 1.5),
			     gh_double2scm (infinity_f)));
  column_l ()->set_elt_property ("contains-grace", SCM_BOOL_T);

  
  Axis_align_item::before_line_breaking ();
  //  translate_axis (-0.5* nhw, X_AXIS); // ugh.
}


void
Grace_align_item::do_add_processing ()
{
}

