% params-as.ly
% generic paper parameters

#'staff-height = \staffheight;

%%paperfile = \papersize + ".ly";
%%% paperfile = "a4.ly";
%%\include \paperfile;
%hsize = 60.0\char;
%vsize = 60.0\char;  %?

%%\include "paper.ly";
linewidth = 60.0\char;
textheight = 60.0\char;
indent = 8.0\char;

staffspace = (\staffheight - 1.0 ) / 4.0;
stafflinethickness = \staffspace / 2.0;

% deprecated
interline = \staffspace;

% urg, need grace_ versions of these too?
beam_thickness = 0.52 * (\staffspace - \stafflinethickness);

#'beam-thickness = \beam_thickness;  %% UGR


interbeam = (2.0 * \staffspace + \stafflinethickness - \beam_thickness) / 2.0;
interbeam4 = (3.0 * \staffspace - \beam_thickness) / 3.0;

%{
The space taken by a note is determined by the formula 

arithmetic_multiplier * ( c + log2 (time) ))

where code(time) is the amount of time a note occupies.  The value
of code(c) is chosen such that the smallest space within a measure is
arithmetic_basicspace.  The smallest space is the one following the
shortest note in the measure.  Typically arithmetic_basicspace is set
to the width of a quarter note head.
%}
arithmetic_basicspace = 2.;
arithmetic_multiplier = 0.9 * \quartwidth ;


#'Stem_tremolo::beam-width = 1.5 * \quartwidth ; 

#'Clef_item::visibility-lambda = #postbreak-only-visibility
#'Key_item::visibility-lambda = #postbreak-only-visibility
#'Breathing_sign::visibility-lambda = #non-postbreak-visibility

% catch suspect beam slopes, set slope to zero if
% outer stem is lengthened more than
beam_lengthened = 0.2 * \staffspace;
% and slope is running away steeper than
beam_steep_slope = 0.2 / 1.0;

%{
dit(code(slur_x_gap)) Horizontal space between note and slur.  Set to
code(\staffspace / 5) by default.  

%}
% OSU: suggested gap = ss / 5;
slur_x_gap = \staffspace / 5.0;
slur_y_gap = 0.25 * \staffspace;
slur_y_free = 0.75 * \staffspace;
slur_x_minimum = 1.5 * \staffspace;

%{
Like beams, slurs often aren't as steep as the notes they encompass.
This sets the amount of damping.
%}
% slope damping: keep dy/dx < slur_slope_damping
slur_slope_damping = 0.3;
slur_interstaff_slope_damping = 0.6;
% height damping: keep h/dx < slur_height_damping
slur_height_damping = 0.4;
slur_interstaff_height_damping = 0.5;
% snap to stem if slur ends closer to stem than
slur_snap_to_stem = 1.75 * \staffspace;
slur_interstaff_snap_to_stem = 2.5 * \staffspace;
% maximum dy change allowed by snapping
slur_snap_max_slope_change = 0.5;
slur_interstaff_snap_max_slope_change = 0.5;



tie_x_minimum = \staffspace + \slur_x_minimum;
% OSU: tie gap == slur gap
tie_x_gap = \slur_x_gap;
tie_y_gap = 0.25 * \staffspace;
% length of a tie that's a staffspace high
tie_staffspace_length = 4.0 * \staffspace;

% ugh: rename to bow (in bezier.cc and fonts.doc too...)

% used to be 1.4 .
slur_thickness = 1.2 * \stafflinethickness;
tie_thickness = 1.2 * \stafflinethickness;

%{
 Specifies the maximum height of slurs.
%}
slur_height_limit = \staffheight;


%{
Specifes the ratio of slur hight to slur width
to aim for.  Default value is 0.3. 
%}

% slur_ratio = 0.3;
% try bit flatter slurs
slur_ratio = 0.25;
slur_clip_ratio = 1.2;
slur_clip_height = 3.0 * \staffheight;
slur_clip_angle = 100.0;
slur_rc_factor = 2.4;

% ugh
notewidth = 3.0\char;

gourlay_energybound = 100000.;
%{
Maximum number of measures per line to try when using Gourlay
method. 
%}
gourlay_maxmeasures = 10.;

bar_kern = 1.0\char;
bar_thinkern = 1.0\char;
barthick_thick = 2.0\char;
barthick_score = 1.0\char;
barthick_thin = 1.0\char;

bracket_arch_thick = \staffspace / 3.0;
bracket_width = 2.0 * \staffspace;
bracket_thick = 2.0 * \stafflinethickness;
bracket_arch_height = 1.5 * \staffspace;
bracket_arch_width = \bracket_arch_height;
bracket_arch_angle = 50.0;

tuplet_spanner_gap = 2.0 * \staffspace;
tuplet_thick = 1.0\char;
volta_thick = 1.0\char;
volta_spanner_height = 1.0\char;

% relative thickness of thin lines  1.6 : 1 : 0.8
stemthickness = 1.0\char;
rulethickness = 1.0\char;


extender_height = 0.8*\stafflinethickness;

hyphen_thickness = 0.05*\font_normal;
hyphen_height = 0.2*\font_normal;
hyphen_minimum_length = 0.25*\font_normal;

% Multi-measure rests
multi_measure_rest_x_minimum = 2.5*\staffheight;
multi_measure_rest_padding = 2.0 *\staffspace;
multi_measure_rest_expand_limit = 10.0;

% chop off this much when next to pp / ff sign.
crescendo_shorten = 4.0 * \staffspace;
crescendo_thickness   = \stafflinethickness;
crescendo_height = 0.666 * \staffspace;

% in internote.
restcollision_minimum_dist = 3.0;
restcollision_minimum_beamdist = 1.5;


% unit for note collision resolving
collision_note_width = \notewidth;	%ugh.

% deprecated!
postBreakPadding = 0.0;

% optical correction amount.
stemSpacingCorrection = 0.5*\staffspace;


%{
 relative strength of space following breakable columns (eg. prefatory matter)
 %}
breakable_column_space_strength = 2.0; 

% space after inline clefs and such get this much stretched
decrease_nonmus_spacing_factor = 1.0 ;

%{
 space before musical columns (eg. taken by accidentals) get this much
 stretched when they follow a musical column, in absence of grace notes.

 0.0 means no extra space (accidentals are ignored)
%}
musical_to_musical_left_spacing_factor = 0.4;

%{
 stretch space this much if there are grace notes before the column
%}
before_grace_spacing_factor = 1.2;

%{
If columns do not have spacing information set, set it to this much
%}
loose_column_distance = 2.0 * \staffspace;

%{
Relative cost of compressing (vs. stretching).  Increasing this
will cause scores to be set looser
.
%}

compression_energy_factor = 0.6;

% if stem is on middle line, choose this direction.
stem_default_neutral_direction = 1.0;

% in staffspace
articulation_script_padding_default = 1.0;

% Backward compatibility -- has no function; 
Gourlay = 0.0;
Wordwrap =0.0;

\include "engraver.ly";


#'margin-shape = #'()


% 
#'Local_key_item::left-padding = #'0.2
#'Local_key_item::right-padding = #'0.4

#'Staff_symbol::staff-space = \staffspace ;
#'Staff_symbol::line-count = #5

