#!/bin/sh

cwd=`pwd`

if [ "$1" = "" ]; then
    echo usage tar-docxx TARBALL
    exit 2
else
  TARBALL=$1
fi


# mail-address
if [ "$MAILADDRESS" != "" ]; then
	echo mail address is $MAILADDRESS
else
	echo "mail-address:6: warning: \$MAILADDRESS undefined" > /dev/stderr
	echo $USER@`hostname`
fi


if [ ! -e $TARBALL ]; then
  echo $TARBALL does not exist
  exit 2
fi

TARBALLBASE=`basename $TARBALL`

TAROUTDIR=/tmp/tar-docxx
rm -rf $TAROUTDIR
mkdir -p $TAROUTDIR
echo untarring ...
tar -C $TAROUTDIR -zxf $TARBALL '*cc' '*.c' '*.hh' '*.h'

cd $TAROUTDIR 
DATE=`date`

cat << EOF > banner.html
  This program documentation comes from $TARBALLBASE.  It was generated by
  $USERNAME &lt<a href="mail:$MAILADDRESS">$MAILADDRESS</a>&gt on $DATE
EOF

mkdir docxx;
echo doc++ ...
doc++ -pSf -B banner.html -d docxx `find -type f`
echo tarring ...
tar -czf $cwd/progdocs.tar.gz docxx/

rm -rf $TAROUTDIR
