%
% common Swedish names for notes. "ess" means flat, "iss" means sharp
%
% by Mats Bengtsson.


%
% Please note that, while these names are used to enter *notes*, they
% actually are *melodic*s, i.e. they represent a pitch solely. Notes
% have a rhythmic part too. This is the reason that we don't write 'note { .. }'
%
\notenames {
	cessess	= \musical_pitch { -1 0 -2 }
	cess 	= \musical_pitch { -1 0 -1 }
	c 	= \musical_pitch { -1 0 0 }
	ciss 	= \musical_pitch { -1 0 1 }
	cississ	= \musical_pitch { -1 0 2 }
	dessess	= \musical_pitch { -1 1 -2 }
	dess 	= \musical_pitch { -1 1 -1 }
	d 	= \musical_pitch { -1 1 0 }
	diss 	= \musical_pitch { -1 1 1 }
	dississ	= \musical_pitch { -1 1 2 }
	essess 	= \musical_pitch { -1 2 -2 }
	ess 	= \musical_pitch { -1 2 -1 }
	e 	= \musical_pitch { -1 2 0 }
	eiss 	= \musical_pitch { -1 2 1 }
	eississ	= \musical_pitch { -1 2 2 }
	fessess	= \musical_pitch { -1 3 -2 }
	fess 	= \musical_pitch { -1 3 -1 }
	f 	= \musical_pitch { -1 3 0 }
	fiss 	= \musical_pitch { -1 3 1 }
	fississ	= \musical_pitch { -1 3 2 }
	gessess	= \musical_pitch { -1 4 -2 }
	gess 	= \musical_pitch { -1 4 -1 }
	g 	= \musical_pitch { -1 4 0 }
	giss 	= \musical_pitch { -1 4 1 }
	gississ	= \musical_pitch { -1 4 2 }
	assess 	= \musical_pitch { -1 5 -2 }
	ass 	= \musical_pitch { -1 5 -1 }
	a 	= \musical_pitch { -1 5 0 }
	aiss 	= \musical_pitch { -1 5 1 }
	aississ	= \musical_pitch { -1 5 2 }
	hessess	= \musical_pitch { -1 6 -2 }
	b 	= \musical_pitch { -1 6 -1 }
	h 	= \musical_pitch { -1 6 0 }
	hiss 	= \musical_pitch { -1 6 1 }
	hississ	= \musical_pitch { -1 6 2 }


	%
	% upper case: 1 octave lower.
	%


	Cessess	= \musical_pitch { -2 0 -2 }
	Cess 	= \musical_pitch { -2 0 -1 }
	C 	= \musical_pitch { -2 0 0 }
	Ciss 	= \musical_pitch { -2 0 1 }
	Cississ	= \musical_pitch { -2 0 2 }
	Dessess	= \musical_pitch { -2 1 -2 }
	Dess 	= \musical_pitch { -2 1 -1 }
	D 	= \musical_pitch { -2 1 0 }
	Diss 	= \musical_pitch { -2 1 1 }
	Dississ	= \musical_pitch { -2 1 2 }
	Essess 	= \musical_pitch { -2 2 -2 }
	Ess 	= \musical_pitch { -2 2 -1 }
	E 	= \musical_pitch { -2 2 0 }
	Eiss 	= \musical_pitch { -2 2 1 }
	Eississ	= \musical_pitch { -2 2 2 }
	Fessess	= \musical_pitch { -2 3 -2 }
	Fess 	= \musical_pitch { -2 3 -1 }
	F 	= \musical_pitch { -2 3 0 }
	Fiss 	= \musical_pitch { -2 3 1 }
	Fississ	= \musical_pitch { -2 3 2 }
	Gessess	= \musical_pitch { -2 4 -2 }
	Gess 	= \musical_pitch { -2 4 -1 }
	G 	= \musical_pitch { -2 4 0 }
	Giss 	= \musical_pitch { -2 4 1 }
	Gississ	= \musical_pitch { -2 4 2 }
	Assess 	= \musical_pitch { -2 5 -2 }
	Ass 	= \musical_pitch { -2 5 -1 }
	A 	= \musical_pitch { -2 5 0 }
	Aiss 	= \musical_pitch { -2 5 1 }
	Aississ	= \musical_pitch { -2 5 2 }
	Hessess	= \musical_pitch { -2 6 -2 }
	B 	= \musical_pitch { -2 6 -1 }
	H 	= \musical_pitch { -2 6 0 }
	Hiss 	= \musical_pitch { -2 6 1 }
	Hississ	= \musical_pitch { -2 6 2 }


}
