# gui-config2.pl
# $Id: gui-config.pl 14978 2009-09-01 07:37:45Z preining $
#
# Copyright 2008 Tomasz Luczak
# Copyright 2008, 2009 Norbert Preining
#
# GUI for tlmgr
#

our $back_config = $back->add("config",-label => __("Configuration"));
$screens{"config"} = $back_config;

my @fileassocdesc;
$fileassocdesc[0] = __("None");
$fileassocdesc[1] = __("Only new");
$fileassocdesc[2] = __("All");

my %defaults;
for my $key (keys %TeXLive::TLConfig::TLPDBOptions) {
  if ($TeXLive::TLConfig::TLPDBOptions{$key}->[0] eq "b") {
    $defaults{$key} = ($localtlpdb->option($key) ? __("Yes") : __("No"));
  } else {
    if ($key eq "file_assocs") {
      $defaults{$key} = $fileassocdesc[$localtlpdb->option($key)];
    } else {
      $defaults{$key} = $localtlpdb->option($key);
    }
  }
}

# this will be loaded only on unix systems!
#
my @config_set_l;
my @config_set_m;
my @config_set_r;

my $back_config_set = $back_config->Labelframe(-text => __("Default settings"));
$back_config_set->pack(-fill => "both", -padx => "2m", -pady => "2m");

push @config_set_l, 
  $back_config_set->Label(-text => __("Default package repository"), -anchor => "w");
push @config_set_m,
  $back_config_set->Label(-textvariable => \$defaults{"location"});
push @config_set_r,
  $back_config_set->Button(-text => __("Change"), 
     -state => $::action_button_state,
     -command => sub { menu_default_location(); });


push @config_set_l,
  $back_config_set->Label(-text => __("Create formats on installation"), -anchor => "w");
push @config_set_m,
  $back_config_set->Label(-textvariable => \$defaults{"create_formats"});
push @config_set_r,
  $back_config_set->Button(-text => __("Toggle"),
     -state => $::action_button_state,
     -command => sub { toggle_setting("create_formats"); });

push @config_set_l,
  $back_config_set->Label(-text => __("Install macro/font sources"), -anchor => "w");
push @config_set_m,
  $back_config_set->Label(-textvariable => \$defaults{"install_srcfiles"});
push @config_set_r,
  $back_config_set->Button(-text => __("Toggle"),
     -state => $::action_button_state,
     -command => sub { toggle_setting("install_srcfiles"); });

push @config_set_l,
  $back_config_set->Label(-text => __("Install macro/font docs"), -anchor => "w");
push @config_set_m,
  $back_config_set->Label(-textvariable => \$defaults{"install_docfiles"});
push @config_set_r,
  $back_config_set->Button(-text => __("Toggle"),
     -state => $::action_button_state,
     -command => sub { toggle_setting("install_docfiles"); });

push @config_set_l,
  $back_config_set->Label(-text => __("Default backup directory"), -anchor => "w");
push @config_set_m,
  $back_config_set->Label(-textvariable => \$defaults{"backupdir"});
push @config_set_r,
  $back_config_set->Button(-text => __("Change"),
     -state => $::action_button_state,
     -command => sub { 
        my $dir = $back_config->chooseDirectory();
        if (defined($dir) && ($default_backupdir ne $dir)) {
          # see warning concerning UTF8 or other encoded dir names!!
          $localtlpdb->option("backupdir", $dir);
          $default_backupdir = $dir;
          $localtlpdb->save;
        }
      });

push @config_set_l,
  $back_config_set->Label(-text => __("Auto backup setting"), -anchor => "w");
push @config_set_m,
  $back_config_set->Label(-textvariable => \$defaults{"autobackup"});
push @config_set_r,
  $back_config_set->Button(-text => __("Change"),
     -state => $::action_button_state,
     -command => sub { select_autobackup($p); }, -anchor => "w");

if (!win32()) {
  push @config_set_l,
    $back_config_set->Label(-text => __("Link destination for programs"), -anchor => "w");
  push @config_set_m,
    $back_config_set->Label(-textvariable => \$defaults{"sys_bin"});
  push @config_set_r,
    $back_config_set->Button(-text => __("Change"),
      -state => $::action_button_state,
      -command => sub { 
        my $dir = $back_config->chooseDirectory();
        if (defined($dir) && ($defaults{"sys_bin"} ne $dir)) {
          # see warning concerning UTF8 or other encoded dir names!!
          $localtlpdb->option("sys_bin", $dir);
          $defaults{"sys_bin"} = $dir;
          $localtlpdb->save;
        }
      });

  push @config_set_l,
    $back_config_set->Label(-text => __("Link destination for info docs"), -anchor => "w");
  push @config_set_m,
    $back_config_set->Label(-textvariable => \$defaults{"sys_info"});
  push @config_set_r,
    $back_config_set->Button(-text => __("Change"),
      -state => $::action_button_state,
      -command => sub { 
        my $dir = $back_config->chooseDirectory();
        if (defined($dir) && ($defaults{"sys_info"} ne $dir)) {
          # see warning concerning UTF8 or other encoded dir names!!
          $localtlpdb->option("sys_info", $dir);
          $defaults{"sys_info"} = $dir;
          $localtlpdb->save;
        }
      });

  push @config_set_l,
    $back_config_set->Label(-text => __("Link destination for man pages"), -anchor => "w");
  push @config_set_m,
    $back_config_set->Label(-textvariable => \$defaults{"sys_man"});
  push @config_set_r,
    $back_config_set->Button(-text => __("Change"),
      -state => $::action_button_state,
      -command => sub { 
        my $dir = $back_config->chooseDirectory();
        if (defined($dir) && ($defaults{"sys_man"} ne $dir)) {
          # see warning concerning UTF8 or other encoded dir names!!
          $localtlpdb->option("sys_man", $dir);
          $defaults{"sys_man"} = $dir;
          $localtlpdb->save;
        }
      });
}

if (win32()) {
  push @config_set_l,
    $back_config_set->Label(-text => __("Create shortcuts in menu and on desktop"), -anchor => "w");
  push @config_set_m,
    $back_config_set->Label(-textvariable => \$defaults{"desktop_integration"});
  push @config_set_r,
    $back_config_set->Button(-text => __("Toggle"),
      -state => $::action_button_state,
      -command => sub { toggle_setting("desktop_integration"); });

  if (admin()) {
    push @config_set_l,
      $back_config_set->Label(-text => __("Install for all users"), -anchor => "w");
    push @config_set_m,
      $back_config_set->Label(-textvariable => \$defaults{"w32_multi_user"});
    push @config_set_r,
      $back_config_set->Button(-text => __("Toggle"),
        -state => $::action_button_state,
        -command => sub { toggle_setting("w32_multi_user"); });
  }

  push @config_set_l,
    $back_config_set->Label(-text => __("Change file associations"), -anchor => "w");
  push @config_set_m,
    $back_config_set->Label(-textvariable => \$defaults{'file_assocs'});
  push @config_set_r,
    $back_config_set->Button(-text => __("Change"),
      -state => $::action_button_state,
      -command => sub { select_file_assocs($p); }, -anchor => "w");

}

for my $i (0..$#config_set_l) {
  $config_set_l[$i]->grid( $config_set_m[$i], $config_set_r[$i],
                            -padx => "1m", -pady => "1m", -sticky => "nwe");
}

#############

my $lower = $back_config->Frame;
$lower->pack(-fill => "both");

my $back_config_pap = $lower->Labelframe(-text => __("Paper settings"));


my $back_config_pap_l1 = $back_config_pap->Label(-text => __("Default paper for all"), -anchor => "w");
my $back_config_pap_m1 = $back_config_pap->Button(-text => "A4",
      -state => $::action_button_state,
      -command => sub { change_paper("all", "a4"); });
my $back_config_pap_r1 = $back_config_pap->Button(-text => "letter",
      -state => $::action_button_state,
      -command => sub { change_paper("all", "letter"); });

$back_config_pap_l1->grid( $back_config_pap_m1, $back_config_pap_r1,
           -padx => "2m", -pady => "2m", -sticky => "nswe");

my %papers;
my %defaultpaper;

sub init_paper_xdvi {
  if (!win32()) {
    @{$papers{"xdvi"}} = TeXLive::TLPaper::get_paper_list("xdvi");
    $defaultpaper{"xdvi"} = ${$papers{"xdvi"}}[0];
  }
}
sub init_paper_pdftex {
  @{$papers{"pdftex"}} = TeXLive::TLPaper::get_paper_list("pdftex");
  $defaultpaper{"pdftex"} = ${$papers{"pdftex"}}[0];
}
sub init_paper_dvips {
  @{$papers{"dvips"}} = TeXLive::TLPaper::get_paper_list("dvips");
  $defaultpaper{"dvips"} = ${$papers{"dvips"}}[0];
}
sub init_paper_dvipdfm {
  @{$papers{"dvipdfm"}} = TeXLive::TLPaper::get_paper_list("dvipdfm");
  $defaultpaper{"dvipdfm"} = ${$papers{"dvipdfm"}}[0];
}
sub init_paper_context {
  if (defined($localtlpdb->get_package("bin-context"))) {
    @{$papers{"context"}} = TeXLive::TLPaper::get_paper_list("context");
    $defaultpaper{"context"} = ${$papers{"context"}}[0];
  }
}
sub init_paper_dvipdfmx {
  @{$papers{"dvipdfmx"}} = TeXLive::TLPaper::get_paper_list("dvipdfmx");
  $defaultpaper{"dvipdfmx"} = ${$papers{"dvipdfmx"}}[0];
}

my %init_paper_subs;
$init_paper_subs{"xdvi"} = \&init_paper_xdvi;
$init_paper_subs{"pdftex"} = \&init_paper_pdftex;
$init_paper_subs{"dvips"} = \&init_paper_dvips;
$init_paper_subs{"context"} = \&init_paper_context;
$init_paper_subs{"dvipdfm"} = \&init_paper_dvipdfm;
$init_paper_subs{"dvipdfmx"} = \&init_paper_dvipdfmx;

sub init_all_papers {
  for my $p (keys %init_paper_subs) {
    &{$init_paper_subs{$p}}();
  }
}

init_all_papers();

my (%l,%m,%r);
foreach my $p (sort keys %papers) {
  if (($p eq "context") && !defined($localtlpdb->get_package("bin-context"))) {
    next;
  }
  $l{$p} = $back_config_pap->Label(-text => __("Default paper for") . " $p", -anchor => "w");
  $m{$p} = $back_config_pap->Label(-textvariable => \$defaultpaper{$p}, -anchor => "w");
  $r{$p} = $back_config_pap->Button(-text => __("Change"),
      -state => $::action_button_state,
      -command => sub { select_paper($p); }, -anchor => "w");
  $l{$p}->grid( $m{$p}, $r{$p},
           -padx => "2m", -pady => "2m", -sticky => "nsw");
}

$back_config_pap->pack(-side => 'left', -fill => "both", -padx => "2m", -pady => "2m");


my $back_config_act = $lower->Labelframe(-text => __("Actions"));


$back_config_act->Button(-text => __("Re-initialize file database"),
  -state => $::action_button_state,
  -command => sub { 
                    $mw->Busy(-recurse => 1);
                    info("Running mktexlsr, this may take some time ...\n");
                    info(`mktexlsr 2>&1`); 
                    $mw->Unbusy;
                  })->pack(-expand => 1, -fill => "x", 
                           -padx => "2m", -pady => "2m");
$back_config_act->Button(-text => __("Re-create all formats"),
  -state => $::action_button_state,
  -command => sub { 
                    $mw->Busy(-recurse => 1);
                    info("Running fmtutil-sys --all, this may take some time ...\n");
                    info(`fmtutil-sys --all 2>&1`); 
                    $mw->Unbusy;
                  })->pack(-expand => 1, -fill => "x", 
                           -padx => "2m", -pady => "2m");
$back_config_act->Button(-text => __("Update font map database"),
  -state => $::action_button_state,
  -command => sub { 
                    $mw->Busy(-recurse => 1);
                    info("Running updmap-sys, this may take some time ...\n");
                    info(`updmap-sys 2>&1`); 
                    $mw->Unbusy;
                  })->pack(-expand => 1, -fill => "x", 
                            -padx => "2m", -pady => "2m");

if (!win32()) {
  $back_config_act->Button(-text => __("Update symbolic links"),
    -state => $::action_button_state,
    -command => sub {
                      $mw->Busy(-recurse => 1);
                      info("Updating symlinks ...\n");
                      execute_action_gui("path", "add");
                      $mw->Unbusy;
                    })->pack(-expand => 1, -fill => "x",
                              -padx => "2m", -pady => "2m");

  $back_config_act->Button(-text => __("Remove symbolic links"),
    -state => $::action_button_state,
    -command => sub {
                      $mw->Busy(-recurse => 1);
                      info("Removing symlinks ...\n");
                      execute_action_gui("path", "remove");
                      $mw->Unbusy;
                    })->pack(-expand => 1, -fill => "x",
                              -padx => "2m", -pady => "2m");
}

$back_config_act->pack(-side => 'right', -fill => "both", -padx => "2m", -pady => "2m", -expand => 1, -ipadx => "2m", -ipady => "2m");



sub menu_default_location {
  my $val = $default_location;
  my $sw = $mw->Toplevel(-title => __("Change default package repository"));
  $sw->transient($mw);
  $sw->grab();
  $sw->Label(-text => __("New default package repository"))->pack(-padx => "2m", -pady => "2m");

  my $f1 = $sw->Frame;
  my $entry = $f1->Entry(-text => $val, -width => 50);
  $entry->pack(-side => "left",-padx => "2m", -pady => "2m");

  my $f2 = $sw->Frame;
  $f2->Button(-text => __("Choose Directory"), 
    -command => sub {
                      my $var = $sw->chooseDirectory;
                      if (defined($var)) {
                        $entry->delete(0,"end");
                        $entry->insert(0,$var);
                      }
                    })->pack(-side => "left",-padx => "2m", -pady => "2m");
  $f2->Button(-text => __("Default net package repository"),
    -command => sub {
                      $entry->delete(0,"end");
                      $entry->insert(0,$TeXLiveURL);
                    })->pack(-side => "left",-padx => "2m", -pady => "2m");
  $f1->pack;
  $f2->pack;

  my $f = $sw->Frame;
  my $okbutton = $f->Button(-text => __("Ok"), 
    -command => sub { $default_location = $entry->get;
                      $localtlpdb->option("location", $default_location);
                      $localtlpdb->save;
                      $sw->destroy })->pack(-side => 'left',-padx => "2m", -pady => "2m");
  my $cancelbutton = $f->Button(-text => __("Cancel"), 
          -command => sub { $sw->destroy })->pack(-side => 'right',-padx => "2m", -pady => "2m");
  $f->pack(-expand => 'x');
  $sw->bind('<Return>', [ $okbutton, 'Invoke' ]);
  $sw->bind('<Escape>', [ $cancelbutton, 'Invoke' ]);
}

sub toggle_setting() {
  my ($key) = @_;
  my $new = ($localtlpdb->option($key) ? 0 : 1);
  $localtlpdb->option($key, $new);
  $defaults{$key} = ($new ? __("Yes") : __("No"));
  $localtlpdb->save;
}


sub change_paper {
  my ($prog, $pap) = @_;
  $mw->Busy(-recurse => 1);
  if ($prog eq "all") {
    execute_action_gui ("paper", "paper", $pap);
    init_all_papers();
  } else {
    execute_action_gui ( "paper", $prog, "paper", $pap);
    &{$init_paper_subs{$prog}}();
  }
  $mw->Unbusy;
}

sub select_paper {
  my $prog = shift;
  my $foo = $back_config->Toplevel(-title => __("Select paper format for") . " $prog");
  $foo->transient($mw);
  $foo->grab();
  my $var = $defaultpaper{$prog};
  my $opt = $foo->BrowseEntry(-label => __("Default paper for") . " $prog", -variable => \$var);
  foreach my $p (sort @{$papers{$prog}}) {
    $opt->insert("end",$p);
  }
  $opt->pack(-padx => "2m", -pady => "2m");
  my $f = $foo->Frame;
  my $okbutton = $f->Button(-text => __("Ok"), -command => sub { change_paper($prog,$var); $foo->destroy; })->pack(-side => "left", -padx => "2m", -pady => "2m");
  my $cancelbutton = $f->Button(-text => __("Cancel"), -command => sub { $foo->destroy; })->pack(-side => "left", -padx => "2m", -pady => "2m");
  $f->pack;
  $foo->bind('<Return>', [ $okbutton, 'Invoke' ]);
  $foo->bind('<Escape>', [ $cancelbutton, 'Invoke' ]);
}

sub select_autobackup {
  my $foo = $back_config->Toplevel(-title => __("Auto backup setting"));
  $foo->transient($mw);
  $foo->grab();
  my $var = $defaults{"autobackup"};
  my $opt = $foo->BrowseEntry(-label => __("Auto backup setting"), 
                              -variable => \$var);
  my @al;
  push @al, "-1 (" . __("keep arbitrarily many") . ")";
  push @al, "0  (" . __("disable") . ")";
  for my $i (1..100) {
    push @al, $i;
  }
  foreach my $p (@al) {
    $opt->insert("end",$p);
  }
  $opt->pack(-padx => "2m", -pady => "2m");
  my $f = $foo->Frame;
  my $okbutton = $f->Button(-text => __("Ok"), 
        -command => sub { 
                          $var =~ s/ .*$//;
                          $localtlpdb->option("autobackup", $var);
                          $defaults{"autobackup"} = $var;
                          $localtlpdb->save;
                          $foo->destroy;
                        }
     )->pack(-side => "left", -padx => "2m", -pady => "2m");
  my $cancelbutton = $f->Button(-text => __("Cancel"), -command => sub { $foo->destroy; })->pack(-side => "left", -padx => "2m", -pady => "2m");
  $f->pack;
  $foo->bind('<Return>', [ $okbutton, 'Invoke' ]);
  $foo->bind('<Escape>', [ $cancelbutton, 'Invoke' ]);
}


sub select_file_assocs {
  my $foo = $back_config->Toplevel(-title => __("Change file associations"));
  $foo->transient($mw);
  $foo->grab();
  my $var = $defaults{"file_assocs"};
  my $opt = $foo->BrowseEntry(-label => __("Change file associations"), 
                              -variable => \$var);
  my @al;
  push @al, "0 " . __("None");
  push @al, "1 " . __("Only new");
  push @al, "2 " . __("All");
  foreach my $p (@al) {
    $opt->insert("end",$p);
  }
  $opt->pack(-padx => "2m", -pady => "2m");
  my $f = $foo->Frame;
  my $okbutton = $f->Button(-text => __("Ok"), 
        -command => sub { 
                          $var = substr($var,0,1);
                          $localtlpdb->option("file_assocs", $var);
                          $defaults{"file_assocs"} = $fileassocdesc[$var];
                          $localtlpdb->save;
                          $foo->destroy;
                        }
     )->pack(-side => "left", -padx => "2m", -pady => "2m");
  my $cancelbutton = $f->Button(-text => __("Cancel"), -command => sub { $foo->destroy; })->pack(-side => "left", -padx => "2m", -pady => "2m");
  $f->pack;
  $foo->bind('<Return>', [ $okbutton, 'Invoke' ]);
  $foo->bind('<Escape>', [ $cancelbutton, 'Invoke' ]);
}


1;

### Local Variables:
### perl-indent-level: 2
### tab-width: 2
### indent-tabs-mode: nil
### End:
# vim:set tabstop=2 expandtab: #
