/*
  This file is part of Mingw extras
  
  Copyright (C) 2008  Vasyl Vavrychuk
  Copyright (C) 2011  Jan Nieuwenhuizen <janneke@gnu.org>
  
  Mingw-extras is free software: you can redistribute it and/or modify
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of the
  License, or (at your option) any later version.
  
  Mingw-extras is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Mingw-extras.  If not, see <http://www.gnu.org/licenses/>.

*/

#if 0
From: Vasyl Vavrychuk
Subject: [PATCH] mmap implementation for mingw.
Date: Thursday, November 20, 2008 - 7:50 pm

    Here is simple and restricted implementation of mmap using CreateFileMapping, 
    MapViewOfFile.

    ---
    compat/mingw.c    |   27 +++++++++++++++++++++++++++
    compat/mingw.h    |    6 ++++++
    git-compat-util.h |    2 ++
    3 files changed, 35 insertions(+), 0 deletions(-)

    diff --git a/compat/mingw.c b/compat/mingw.c
    index b534a8a..a6a5081 100644
    --- a/compat/mingw.c
    +++ b/compat/mingw.c
    @@ -994,3 +994,30 @@ void mingw_open_html(const char *unixpath)
    printf("Launching default browser to display HTML ...\n");
ShellExecute(NULL, "open", htmlpath, NULL, "\\", 0);
}
#endif

#include <sys/mman.h>

#include <io.h>
#include <stdio.h>
#include <errno.h>
#include <windows.h>

void *
mingw_mmap (void *start, size_t length, int prot, int flags, int fd, off_t offset)
{

  (void) prot;
  if (start != NULL || !(flags & MAP_PRIVATE))
    return errno = EINVAL, fputs ("Invalid usage of mingw_extras\n", stderr), MAP_FAILED;
  
  HANDLE handle = CreateFileMapping ((HANDLE)_get_osfhandle (fd), NULL, PAGE_WRITECOPY, 0, 0, NULL);

  if (handle == NULL)
    return MAP_FAILED;

  start = MapViewOfFile (handle, FILE_MAP_COPY, 0, offset, length);
  CloseHandle (handle);
  
  return start;
}

int
mingw_munmap (void *start, size_t length)
{

  (void) length;
  UnmapViewOfFile (start);
  return 0;
}
