/*
 * System call prototypes.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * $FreeBSD: src/sys/sys/sysproto.h,v 1.59.2.10 2002/07/12 08:23:08 alfred Exp $
 * created from FreeBSD: src/sys/kern/syscalls.master,v 1.72.2.9 2002/03/09 04:43:21 dd Exp 
 */

#ifndef _SYS_SYSPROTO_H_
#define	_SYS_SYSPROTO_H_

#include <sys/signal.h>

#include <sys/acl.h>

struct proc;

#define	PAD_(t)	(sizeof(register_t) <= sizeof(t) ? \
		0 : sizeof(register_t) - sizeof(t))

struct	nosys_args {
	register_t dummy;
};
struct	sys_exit_args {
	int	rval;	char rval_[PAD_(int)];
};
struct	fork_args {
	register_t dummy;
};
struct	read_args {
	int	fd;	char fd_[PAD_(int)];
	void *	buf;	char buf_[PAD_(void *)];
	size_t	nbyte;	char nbyte_[PAD_(size_t)];
};
struct	write_args {
	int	fd;	char fd_[PAD_(int)];
	const void *	buf;	char buf_[PAD_(const void *)];
	size_t	nbyte;	char nbyte_[PAD_(size_t)];
};
struct	open_args {
	char *	path;	char path_[PAD_(char *)];
	int	flags;	char flags_[PAD_(int)];
	int	mode;	char mode_[PAD_(int)];
};
struct	close_args {
	int	fd;	char fd_[PAD_(int)];
};
struct	wait_args {
	int	pid;	char pid_[PAD_(int)];
	int *	status;	char status_[PAD_(int *)];
	int	options;	char options_[PAD_(int)];
	struct rusage *	rusage;	char rusage_[PAD_(struct rusage *)];
};
struct	link_args {
	char *	path;	char path_[PAD_(char *)];
	char *	link;	char link_[PAD_(char *)];
};
struct	unlink_args {
	char *	path;	char path_[PAD_(char *)];
};
struct	chdir_args {
	char *	path;	char path_[PAD_(char *)];
};
struct	fchdir_args {
	int	fd;	char fd_[PAD_(int)];
};
struct	mknod_args {
	char *	path;	char path_[PAD_(char *)];
	int	mode;	char mode_[PAD_(int)];
	int	dev;	char dev_[PAD_(int)];
};
struct	chmod_args {
	char *	path;	char path_[PAD_(char *)];
	int	mode;	char mode_[PAD_(int)];
};
struct	chown_args {
	char *	path;	char path_[PAD_(char *)];
	int	uid;	char uid_[PAD_(int)];
	int	gid;	char gid_[PAD_(int)];
};
struct	obreak_args {
	char *	nsize;	char nsize_[PAD_(char *)];
};
struct	getfsstat_args {
	struct statfs *	buf;	char buf_[PAD_(struct statfs *)];
	long	bufsize;	char bufsize_[PAD_(long)];
	int	flags;	char flags_[PAD_(int)];
};
struct	getpid_args {
	register_t dummy;
};
struct	mount_args {
	char *	type;	char type_[PAD_(char *)];
	char *	path;	char path_[PAD_(char *)];
	int	flags;	char flags_[PAD_(int)];
	caddr_t	data;	char data_[PAD_(caddr_t)];
};
struct	unmount_args {
	char *	path;	char path_[PAD_(char *)];
	int	flags;	char flags_[PAD_(int)];
};
struct	setuid_args {
	uid_t	uid;	char uid_[PAD_(uid_t)];
};
struct	getuid_args {
	register_t dummy;
};
struct	geteuid_args {
	register_t dummy;
};
struct	ptrace_args {
	int	req;	char req_[PAD_(int)];
	pid_t	pid;	char pid_[PAD_(pid_t)];
	caddr_t	addr;	char addr_[PAD_(caddr_t)];
	int	data;	char data_[PAD_(int)];
};
struct	recvmsg_args {
	int	s;	char s_[PAD_(int)];
	struct msghdr *	msg;	char msg_[PAD_(struct msghdr *)];
	int	flags;	char flags_[PAD_(int)];
};
struct	sendmsg_args {
	int	s;	char s_[PAD_(int)];
	caddr_t	msg;	char msg_[PAD_(caddr_t)];
	int	flags;	char flags_[PAD_(int)];
};
struct	recvfrom_args {
	int	s;	char s_[PAD_(int)];
	caddr_t	buf;	char buf_[PAD_(caddr_t)];
	size_t	len;	char len_[PAD_(size_t)];
	int	flags;	char flags_[PAD_(int)];
	caddr_t	from;	char from_[PAD_(caddr_t)];
	int *	fromlenaddr;	char fromlenaddr_[PAD_(int *)];
};
struct	accept_args {
	int	s;	char s_[PAD_(int)];
	caddr_t	name;	char name_[PAD_(caddr_t)];
	int *	anamelen;	char anamelen_[PAD_(int *)];
};
struct	getpeername_args {
	int	fdes;	char fdes_[PAD_(int)];
	caddr_t	asa;	char asa_[PAD_(caddr_t)];
	int *	alen;	char alen_[PAD_(int *)];
};
struct	getsockname_args {
	int	fdes;	char fdes_[PAD_(int)];
	caddr_t	asa;	char asa_[PAD_(caddr_t)];
	int *	alen;	char alen_[PAD_(int *)];
};
struct	access_args {
	char *	path;	char path_[PAD_(char *)];
	int	flags;	char flags_[PAD_(int)];
};
struct	chflags_args {
	char *	path;	char path_[PAD_(char *)];
	int	flags;	char flags_[PAD_(int)];
};
struct	fchflags_args {
	int	fd;	char fd_[PAD_(int)];
	int	flags;	char flags_[PAD_(int)];
};
struct	sync_args {
	register_t dummy;
};
struct	kill_args {
	int	pid;	char pid_[PAD_(int)];
	int	signum;	char signum_[PAD_(int)];
};
struct	getppid_args {
	register_t dummy;
};
struct	dup_args {
	u_int	fd;	char fd_[PAD_(u_int)];
};
struct	pipe_args {
	register_t dummy;
};
struct	getegid_args {
	register_t dummy;
};
struct	profil_args {
	caddr_t	samples;	char samples_[PAD_(caddr_t)];
	size_t	size;	char size_[PAD_(size_t)];
	size_t	offset;	char offset_[PAD_(size_t)];
	u_int	scale;	char scale_[PAD_(u_int)];
};
struct	ktrace_args {
	const char *	fname;	char fname_[PAD_(const char *)];
	int	ops;	char ops_[PAD_(int)];
	int	facs;	char facs_[PAD_(int)];
	int	pid;	char pid_[PAD_(int)];
};
struct	getgid_args {
	register_t dummy;
};
struct	getlogin_args {
	char *	namebuf;	char namebuf_[PAD_(char *)];
	u_int	namelen;	char namelen_[PAD_(u_int)];
};
struct	setlogin_args {
	char *	namebuf;	char namebuf_[PAD_(char *)];
};
struct	acct_args {
	char *	path;	char path_[PAD_(char *)];
};
struct	osigpending_args {
	register_t dummy;
};
struct	sigaltstack_args {
	stack_t *	ss;	char ss_[PAD_(stack_t *)];
	stack_t *	oss;	char oss_[PAD_(stack_t *)];
};
struct	ioctl_args {
	int	fd;	char fd_[PAD_(int)];
	u_long	com;	char com_[PAD_(u_long)];
	caddr_t	data;	char data_[PAD_(caddr_t)];
};
struct	reboot_args {
	int	opt;	char opt_[PAD_(int)];
};
struct	revoke_args {
	char *	path;	char path_[PAD_(char *)];
};
struct	symlink_args {
	char *	path;	char path_[PAD_(char *)];
	char *	link;	char link_[PAD_(char *)];
};
struct	readlink_args {
	char *	path;	char path_[PAD_(char *)];
	char *	buf;	char buf_[PAD_(char *)];
	int	count;	char count_[PAD_(int)];
};
struct	execve_args {
	char *	fname;	char fname_[PAD_(char *)];
	char **	argv;	char argv_[PAD_(char **)];
	char **	envv;	char envv_[PAD_(char **)];
};
struct	umask_args {
	int	newmask;	char newmask_[PAD_(int)];
};
struct	chroot_args {
	char *	path;	char path_[PAD_(char *)];
};
struct	getpagesize_args {
	register_t dummy;
};
struct	msync_args {
	void *	addr;	char addr_[PAD_(void *)];
	size_t	len;	char len_[PAD_(size_t)];
	int	flags;	char flags_[PAD_(int)];
};
struct	vfork_args {
	register_t dummy;
};
struct	sbrk_args {
	int	incr;	char incr_[PAD_(int)];
};
struct	sstk_args {
	int	incr;	char incr_[PAD_(int)];
};
struct	ovadvise_args {
	int	anom;	char anom_[PAD_(int)];
};
struct	munmap_args {
	void *	addr;	char addr_[PAD_(void *)];
	size_t	len;	char len_[PAD_(size_t)];
};
struct	mprotect_args {
	const void *	addr;	char addr_[PAD_(const void *)];
	size_t	len;	char len_[PAD_(size_t)];
	int	prot;	char prot_[PAD_(int)];
};
struct	madvise_args {
	void *	addr;	char addr_[PAD_(void *)];
	size_t	len;	char len_[PAD_(size_t)];
	int	behav;	char behav_[PAD_(int)];
};
struct	mincore_args {
	const void *	addr;	char addr_[PAD_(const void *)];
	size_t	len;	char len_[PAD_(size_t)];
	char *	vec;	char vec_[PAD_(char *)];
};
struct	getgroups_args {
	u_int	gidsetsize;	char gidsetsize_[PAD_(u_int)];
	gid_t *	gidset;	char gidset_[PAD_(gid_t *)];
};
struct	setgroups_args {
	u_int	gidsetsize;	char gidsetsize_[PAD_(u_int)];
	gid_t *	gidset;	char gidset_[PAD_(gid_t *)];
};
struct	getpgrp_args {
	register_t dummy;
};
struct	setpgid_args {
	int	pid;	char pid_[PAD_(int)];
	int	pgid;	char pgid_[PAD_(int)];
};
struct	setitimer_args {
	u_int	which;	char which_[PAD_(u_int)];
	struct itimerval *	itv;	char itv_[PAD_(struct itimerval *)];
	struct itimerval *	oitv;	char oitv_[PAD_(struct itimerval *)];
};
struct	owait_args {
	register_t dummy;
};
struct	swapon_args {
	char *	name;	char name_[PAD_(char *)];
};
struct	getitimer_args {
	u_int	which;	char which_[PAD_(u_int)];
	struct itimerval *	itv;	char itv_[PAD_(struct itimerval *)];
};
struct	getdtablesize_args {
	register_t dummy;
};
struct	dup2_args {
	u_int	from;	char from_[PAD_(u_int)];
	u_int	to;	char to_[PAD_(u_int)];
};
struct	fcntl_args {
	int	fd;	char fd_[PAD_(int)];
	int	cmd;	char cmd_[PAD_(int)];
	long	arg;	char arg_[PAD_(long)];
};
struct	select_args {
	int	nd;	char nd_[PAD_(int)];
	fd_set *	in;	char in_[PAD_(fd_set *)];
	fd_set *	ou;	char ou_[PAD_(fd_set *)];
	fd_set *	ex;	char ex_[PAD_(fd_set *)];
	struct timeval *	tv;	char tv_[PAD_(struct timeval *)];
};
struct	fsync_args {
	int	fd;	char fd_[PAD_(int)];
};
struct	setpriority_args {
	int	which;	char which_[PAD_(int)];
	int	who;	char who_[PAD_(int)];
	int	prio;	char prio_[PAD_(int)];
};
struct	socket_args {
	int	domain;	char domain_[PAD_(int)];
	int	type;	char type_[PAD_(int)];
	int	protocol;	char protocol_[PAD_(int)];
};
struct	connect_args {
	int	s;	char s_[PAD_(int)];
	caddr_t	name;	char name_[PAD_(caddr_t)];
	int	namelen;	char namelen_[PAD_(int)];
};
struct	getpriority_args {
	int	which;	char which_[PAD_(int)];
	int	who;	char who_[PAD_(int)];
};
struct	bind_args {
	int	s;	char s_[PAD_(int)];
	caddr_t	name;	char name_[PAD_(caddr_t)];
	int	namelen;	char namelen_[PAD_(int)];
};
struct	setsockopt_args {
	int	s;	char s_[PAD_(int)];
	int	level;	char level_[PAD_(int)];
	int	name;	char name_[PAD_(int)];
	caddr_t	val;	char val_[PAD_(caddr_t)];
	int	valsize;	char valsize_[PAD_(int)];
};
struct	listen_args {
	int	s;	char s_[PAD_(int)];
	int	backlog;	char backlog_[PAD_(int)];
};
struct	gettimeofday_args {
	struct timeval *	tp;	char tp_[PAD_(struct timeval *)];
	struct timezone *	tzp;	char tzp_[PAD_(struct timezone *)];
};
struct	getrusage_args {
	int	who;	char who_[PAD_(int)];
	struct rusage *	rusage;	char rusage_[PAD_(struct rusage *)];
};
struct	getsockopt_args {
	int	s;	char s_[PAD_(int)];
	int	level;	char level_[PAD_(int)];
	int	name;	char name_[PAD_(int)];
	caddr_t	val;	char val_[PAD_(caddr_t)];
	int *	avalsize;	char avalsize_[PAD_(int *)];
};
struct	readv_args {
	int	fd;	char fd_[PAD_(int)];
	struct iovec *	iovp;	char iovp_[PAD_(struct iovec *)];
	u_int	iovcnt;	char iovcnt_[PAD_(u_int)];
};
struct	writev_args {
	int	fd;	char fd_[PAD_(int)];
	struct iovec *	iovp;	char iovp_[PAD_(struct iovec *)];
	u_int	iovcnt;	char iovcnt_[PAD_(u_int)];
};
struct	settimeofday_args {
	struct timeval *	tv;	char tv_[PAD_(struct timeval *)];
	struct timezone *	tzp;	char tzp_[PAD_(struct timezone *)];
};
struct	fchown_args {
	int	fd;	char fd_[PAD_(int)];
	int	uid;	char uid_[PAD_(int)];
	int	gid;	char gid_[PAD_(int)];
};
struct	fchmod_args {
	int	fd;	char fd_[PAD_(int)];
	int	mode;	char mode_[PAD_(int)];
};
struct	setreuid_args {
	int	ruid;	char ruid_[PAD_(int)];
	int	euid;	char euid_[PAD_(int)];
};
struct	setregid_args {
	int	rgid;	char rgid_[PAD_(int)];
	int	egid;	char egid_[PAD_(int)];
};
struct	rename_args {
	char *	from;	char from_[PAD_(char *)];
	char *	to;	char to_[PAD_(char *)];
};
struct	flock_args {
	int	fd;	char fd_[PAD_(int)];
	int	how;	char how_[PAD_(int)];
};
struct	mkfifo_args {
	char *	path;	char path_[PAD_(char *)];
	int	mode;	char mode_[PAD_(int)];
};
struct	sendto_args {
	int	s;	char s_[PAD_(int)];
	caddr_t	buf;	char buf_[PAD_(caddr_t)];
	size_t	len;	char len_[PAD_(size_t)];
	int	flags;	char flags_[PAD_(int)];
	caddr_t	to;	char to_[PAD_(caddr_t)];
	int	tolen;	char tolen_[PAD_(int)];
};
struct	shutdown_args {
	int	s;	char s_[PAD_(int)];
	int	how;	char how_[PAD_(int)];
};
struct	socketpair_args {
	int	domain;	char domain_[PAD_(int)];
	int	type;	char type_[PAD_(int)];
	int	protocol;	char protocol_[PAD_(int)];
	int *	rsv;	char rsv_[PAD_(int *)];
};
struct	mkdir_args {
	char *	path;	char path_[PAD_(char *)];
	int	mode;	char mode_[PAD_(int)];
};
struct	rmdir_args {
	char *	path;	char path_[PAD_(char *)];
};
struct	utimes_args {
	char *	path;	char path_[PAD_(char *)];
	struct timeval *	tptr;	char tptr_[PAD_(struct timeval *)];
};
struct	adjtime_args {
	struct timeval *	delta;	char delta_[PAD_(struct timeval *)];
	struct timeval *	olddelta;	char olddelta_[PAD_(struct timeval *)];
};
struct	ogethostid_args {
	register_t dummy;
};
struct	setsid_args {
	register_t dummy;
};
struct	quotactl_args {
	char *	path;	char path_[PAD_(char *)];
	int	cmd;	char cmd_[PAD_(int)];
	int	uid;	char uid_[PAD_(int)];
	caddr_t	arg;	char arg_[PAD_(caddr_t)];
};
struct	oquota_args {
	register_t dummy;
};
struct	nfssvc_args {
	int	flag;	char flag_[PAD_(int)];
	caddr_t	argp;	char argp_[PAD_(caddr_t)];
};
struct	statfs_args {
	char *	path;	char path_[PAD_(char *)];
	struct statfs *	buf;	char buf_[PAD_(struct statfs *)];
};
struct	fstatfs_args {
	int	fd;	char fd_[PAD_(int)];
	struct statfs *	buf;	char buf_[PAD_(struct statfs *)];
};
struct	getfh_args {
	char *	fname;	char fname_[PAD_(char *)];
	struct fhandle *	fhp;	char fhp_[PAD_(struct fhandle *)];
};
struct	getdomainname_args {
	char *	domainname;	char domainname_[PAD_(char *)];
	int	len;	char len_[PAD_(int)];
};
struct	setdomainname_args {
	char *	domainname;	char domainname_[PAD_(char *)];
	int	len;	char len_[PAD_(int)];
};
struct	uname_args {
	struct utsname *	name;	char name_[PAD_(struct utsname *)];
};
struct	sysarch_args {
	int	op;	char op_[PAD_(int)];
	char *	parms;	char parms_[PAD_(char *)];
};
struct	rtprio_args {
	int	function;	char function_[PAD_(int)];
	pid_t	pid;	char pid_[PAD_(pid_t)];
	struct rtprio *	rtp;	char rtp_[PAD_(struct rtprio *)];
};
struct	semsys_args {
	int	which;	char which_[PAD_(int)];
	int	a2;	char a2_[PAD_(int)];
	int	a3;	char a3_[PAD_(int)];
	int	a4;	char a4_[PAD_(int)];
	int	a5;	char a5_[PAD_(int)];
};
struct	msgsys_args {
	int	which;	char which_[PAD_(int)];
	int	a2;	char a2_[PAD_(int)];
	int	a3;	char a3_[PAD_(int)];
	int	a4;	char a4_[PAD_(int)];
	int	a5;	char a5_[PAD_(int)];
	int	a6;	char a6_[PAD_(int)];
};
struct	shmsys_args {
	int	which;	char which_[PAD_(int)];
	int	a2;	char a2_[PAD_(int)];
	int	a3;	char a3_[PAD_(int)];
	int	a4;	char a4_[PAD_(int)];
};
struct	pread_args {
	int	fd;	char fd_[PAD_(int)];
	void *	buf;	char buf_[PAD_(void *)];
	size_t	nbyte;	char nbyte_[PAD_(size_t)];
	int	pad;	char pad_[PAD_(int)];
	off_t	offset;	char offset_[PAD_(off_t)];
};
struct	pwrite_args {
	int	fd;	char fd_[PAD_(int)];
	const void *	buf;	char buf_[PAD_(const void *)];
	size_t	nbyte;	char nbyte_[PAD_(size_t)];
	int	pad;	char pad_[PAD_(int)];
	off_t	offset;	char offset_[PAD_(off_t)];
};
struct	ntp_adjtime_args {
	struct timex *	tp;	char tp_[PAD_(struct timex *)];
};
struct	setgid_args {
	gid_t	gid;	char gid_[PAD_(gid_t)];
};
struct	setegid_args {
	gid_t	egid;	char egid_[PAD_(gid_t)];
};
struct	seteuid_args {
	uid_t	euid;	char euid_[PAD_(uid_t)];
};
struct	stat_args {
	char *	path;	char path_[PAD_(char *)];
	struct stat *	ub;	char ub_[PAD_(struct stat *)];
};
struct	fstat_args {
	int	fd;	char fd_[PAD_(int)];
	struct stat *	sb;	char sb_[PAD_(struct stat *)];
};
struct	lstat_args {
	char *	path;	char path_[PAD_(char *)];
	struct stat *	ub;	char ub_[PAD_(struct stat *)];
};
struct	pathconf_args {
	char *	path;	char path_[PAD_(char *)];
	int	name;	char name_[PAD_(int)];
};
struct	fpathconf_args {
	int	fd;	char fd_[PAD_(int)];
	int	name;	char name_[PAD_(int)];
};
struct	__getrlimit_args {
	u_int	which;	char which_[PAD_(u_int)];
	struct rlimit *	rlp;	char rlp_[PAD_(struct rlimit *)];
};
struct	__setrlimit_args {
	u_int	which;	char which_[PAD_(u_int)];
	struct rlimit *	rlp;	char rlp_[PAD_(struct rlimit *)];
};
struct	getdirentries_args {
	int	fd;	char fd_[PAD_(int)];
	char *	buf;	char buf_[PAD_(char *)];
	u_int	count;	char count_[PAD_(u_int)];
	long *	basep;	char basep_[PAD_(long *)];
};
struct	mmap_args {
	caddr_t	addr;	char addr_[PAD_(caddr_t)];
	size_t	len;	char len_[PAD_(size_t)];
	int	prot;	char prot_[PAD_(int)];
	int	flags;	char flags_[PAD_(int)];
	int	fd;	char fd_[PAD_(int)];
	int	pad;	char pad_[PAD_(int)];
	off_t	pos;	char pos_[PAD_(off_t)];
};
struct	lseek_args {
	int	fd;	char fd_[PAD_(int)];
	int	pad;	char pad_[PAD_(int)];
	off_t	offset;	char offset_[PAD_(off_t)];
	int	whence;	char whence_[PAD_(int)];
};
struct	truncate_args {
	char *	path;	char path_[PAD_(char *)];
	int	pad;	char pad_[PAD_(int)];
	off_t	length;	char length_[PAD_(off_t)];
};
struct	ftruncate_args {
	int	fd;	char fd_[PAD_(int)];
	int	pad;	char pad_[PAD_(int)];
	off_t	length;	char length_[PAD_(off_t)];
};
struct	sysctl_args {
	int *	name;	char name_[PAD_(int *)];
	u_int	namelen;	char namelen_[PAD_(u_int)];
	void *	old;	char old_[PAD_(void *)];
	size_t *	oldlenp;	char oldlenp_[PAD_(size_t *)];
	void *	new;	char new_[PAD_(void *)];
	size_t	newlen;	char newlen_[PAD_(size_t)];
};
struct	mlock_args {
	const void *	addr;	char addr_[PAD_(const void *)];
	size_t	len;	char len_[PAD_(size_t)];
};
struct	munlock_args {
	const void *	addr;	char addr_[PAD_(const void *)];
	size_t	len;	char len_[PAD_(size_t)];
};
struct	undelete_args {
	char *	path;	char path_[PAD_(char *)];
};
struct	futimes_args {
	int	fd;	char fd_[PAD_(int)];
	struct timeval *	tptr;	char tptr_[PAD_(struct timeval *)];
};
struct	getpgid_args {
	pid_t	pid;	char pid_[PAD_(pid_t)];
};
struct	poll_args {
	struct pollfd *	fds;	char fds_[PAD_(struct pollfd *)];
	u_int	nfds;	char nfds_[PAD_(u_int)];
	int	timeout;	char timeout_[PAD_(int)];
};
struct	__semctl_args {
	int	semid;	char semid_[PAD_(int)];
	int	semnum;	char semnum_[PAD_(int)];
	int	cmd;	char cmd_[PAD_(int)];
	union semun *	arg;	char arg_[PAD_(union semun *)];
};
struct	semget_args {
	key_t	key;	char key_[PAD_(key_t)];
	int	nsems;	char nsems_[PAD_(int)];
	int	semflg;	char semflg_[PAD_(int)];
};
struct	semop_args {
	int	semid;	char semid_[PAD_(int)];
	struct sembuf *	sops;	char sops_[PAD_(struct sembuf *)];
	u_int	nsops;	char nsops_[PAD_(u_int)];
};
struct	msgctl_args {
	int	msqid;	char msqid_[PAD_(int)];
	int	cmd;	char cmd_[PAD_(int)];
	struct msqid_ds *	buf;	char buf_[PAD_(struct msqid_ds *)];
};
struct	msgget_args {
	key_t	key;	char key_[PAD_(key_t)];
	int	msgflg;	char msgflg_[PAD_(int)];
};
struct	msgsnd_args {
	int	msqid;	char msqid_[PAD_(int)];
	void *	msgp;	char msgp_[PAD_(void *)];
	size_t	msgsz;	char msgsz_[PAD_(size_t)];
	int	msgflg;	char msgflg_[PAD_(int)];
};
struct	msgrcv_args {
	int	msqid;	char msqid_[PAD_(int)];
	void *	msgp;	char msgp_[PAD_(void *)];
	size_t	msgsz;	char msgsz_[PAD_(size_t)];
	long	msgtyp;	char msgtyp_[PAD_(long)];
	int	msgflg;	char msgflg_[PAD_(int)];
};
struct	shmat_args {
	int	shmid;	char shmid_[PAD_(int)];
	void *	shmaddr;	char shmaddr_[PAD_(void *)];
	int	shmflg;	char shmflg_[PAD_(int)];
};
struct	shmctl_args {
	int	shmid;	char shmid_[PAD_(int)];
	int	cmd;	char cmd_[PAD_(int)];
	struct shmid_ds *	buf;	char buf_[PAD_(struct shmid_ds *)];
};
struct	shmdt_args {
	void *	shmaddr;	char shmaddr_[PAD_(void *)];
};
struct	shmget_args {
	key_t	key;	char key_[PAD_(key_t)];
	int	size;	char size_[PAD_(int)];
	int	shmflg;	char shmflg_[PAD_(int)];
};
struct	clock_gettime_args {
	clockid_t	clock_id;	char clock_id_[PAD_(clockid_t)];
	struct timespec *	tp;	char tp_[PAD_(struct timespec *)];
};
struct	clock_settime_args {
	clockid_t	clock_id;	char clock_id_[PAD_(clockid_t)];
	const struct timespec *	tp;	char tp_[PAD_(const struct timespec *)];
};
struct	clock_getres_args {
	clockid_t	clock_id;	char clock_id_[PAD_(clockid_t)];
	struct timespec *	tp;	char tp_[PAD_(struct timespec *)];
};
struct	nanosleep_args {
	const struct timespec *	rqtp;	char rqtp_[PAD_(const struct timespec *)];
	struct timespec *	rmtp;	char rmtp_[PAD_(struct timespec *)];
};
struct	minherit_args {
	void *	addr;	char addr_[PAD_(void *)];
	size_t	len;	char len_[PAD_(size_t)];
	int	inherit;	char inherit_[PAD_(int)];
};
struct	rfork_args {
	int	flags;	char flags_[PAD_(int)];
};
struct	openbsd_poll_args {
	struct pollfd *	fds;	char fds_[PAD_(struct pollfd *)];
	u_int	nfds;	char nfds_[PAD_(u_int)];
	int	timeout;	char timeout_[PAD_(int)];
};
struct	issetugid_args {
	register_t dummy;
};
struct	lchown_args {
	char *	path;	char path_[PAD_(char *)];
	int	uid;	char uid_[PAD_(int)];
	int	gid;	char gid_[PAD_(int)];
};
struct	getdents_args {
	int	fd;	char fd_[PAD_(int)];
	char *	buf;	char buf_[PAD_(char *)];
	size_t	count;	char count_[PAD_(size_t)];
};
struct	lchmod_args {
	char *	path;	char path_[PAD_(char *)];
	mode_t	mode;	char mode_[PAD_(mode_t)];
};
struct	lutimes_args {
	char *	path;	char path_[PAD_(char *)];
	struct timeval *	tptr;	char tptr_[PAD_(struct timeval *)];
};
struct	nstat_args {
	char *	path;	char path_[PAD_(char *)];
	struct nstat *	ub;	char ub_[PAD_(struct nstat *)];
};
struct	nfstat_args {
	int	fd;	char fd_[PAD_(int)];
	struct nstat *	sb;	char sb_[PAD_(struct nstat *)];
};
struct	nlstat_args {
	char *	path;	char path_[PAD_(char *)];
	struct nstat *	ub;	char ub_[PAD_(struct nstat *)];
};
struct	fhstatfs_args {
	const struct fhandle *	u_fhp;	char u_fhp_[PAD_(const struct fhandle *)];
	struct statfs *	buf;	char buf_[PAD_(struct statfs *)];
};
struct	fhopen_args {
	const struct fhandle *	u_fhp;	char u_fhp_[PAD_(const struct fhandle *)];
	int	flags;	char flags_[PAD_(int)];
};
struct	fhstat_args {
	const struct fhandle *	u_fhp;	char u_fhp_[PAD_(const struct fhandle *)];
	struct stat *	sb;	char sb_[PAD_(struct stat *)];
};
struct	modnext_args {
	int	modid;	char modid_[PAD_(int)];
};
struct	modstat_args {
	int	modid;	char modid_[PAD_(int)];
	struct module_stat *	stat;	char stat_[PAD_(struct module_stat *)];
};
struct	modfnext_args {
	int	modid;	char modid_[PAD_(int)];
};
struct	modfind_args {
	const char *	name;	char name_[PAD_(const char *)];
};
struct	kldload_args {
	const char *	file;	char file_[PAD_(const char *)];
};
struct	kldunload_args {
	int	fileid;	char fileid_[PAD_(int)];
};
struct	kldfind_args {
	const char *	file;	char file_[PAD_(const char *)];
};
struct	kldnext_args {
	int	fileid;	char fileid_[PAD_(int)];
};
struct	kldstat_args {
	int	fileid;	char fileid_[PAD_(int)];
	struct kld_file_stat *	stat;	char stat_[PAD_(struct kld_file_stat *)];
};
struct	kldfirstmod_args {
	int	fileid;	char fileid_[PAD_(int)];
};
struct	getsid_args {
	pid_t	pid;	char pid_[PAD_(pid_t)];
};
struct	setresuid_args {
	uid_t	ruid;	char ruid_[PAD_(uid_t)];
	uid_t	euid;	char euid_[PAD_(uid_t)];
	uid_t	suid;	char suid_[PAD_(uid_t)];
};
struct	setresgid_args {
	gid_t	rgid;	char rgid_[PAD_(gid_t)];
	gid_t	egid;	char egid_[PAD_(gid_t)];
	gid_t	sgid;	char sgid_[PAD_(gid_t)];
};
struct	aio_return_args {
	struct aiocb *	aiocbp;	char aiocbp_[PAD_(struct aiocb *)];
};
struct	aio_suspend_args {
	struct aiocb *const *	aiocbp;	char aiocbp_[PAD_(struct aiocb *const *)];
	int	nent;	char nent_[PAD_(int)];
	const struct timespec *	timeout;	char timeout_[PAD_(const struct timespec *)];
};
struct	aio_cancel_args {
	int	fd;	char fd_[PAD_(int)];
	struct aiocb *	aiocbp;	char aiocbp_[PAD_(struct aiocb *)];
};
struct	aio_error_args {
	struct aiocb *	aiocbp;	char aiocbp_[PAD_(struct aiocb *)];
};
struct	aio_read_args {
	struct aiocb *	aiocbp;	char aiocbp_[PAD_(struct aiocb *)];
};
struct	aio_write_args {
	struct aiocb *	aiocbp;	char aiocbp_[PAD_(struct aiocb *)];
};
struct	lio_listio_args {
	int	mode;	char mode_[PAD_(int)];
	struct aiocb *const *	acb_list;	char acb_list_[PAD_(struct aiocb *const *)];
	int	nent;	char nent_[PAD_(int)];
	struct sigevent *	sig;	char sig_[PAD_(struct sigevent *)];
};
struct	yield_args {
	register_t dummy;
};
struct	thr_sleep_args {
	const struct timespec *	timeout;	char timeout_[PAD_(const struct timespec *)];
};
struct	thr_wakeup_args {
	pid_t	pid;	char pid_[PAD_(pid_t)];
};
struct	mlockall_args {
	int	how;	char how_[PAD_(int)];
};
struct	munlockall_args {
	register_t dummy;
};
struct	__getcwd_args {
	u_char *	buf;	char buf_[PAD_(u_char *)];
	u_int	buflen;	char buflen_[PAD_(u_int)];
};
struct	sched_setparam_args {
	pid_t	pid;	char pid_[PAD_(pid_t)];
	const struct sched_param *	param;	char param_[PAD_(const struct sched_param *)];
};
struct	sched_getparam_args {
	pid_t	pid;	char pid_[PAD_(pid_t)];
	struct sched_param *	param;	char param_[PAD_(struct sched_param *)];
};
struct	sched_setscheduler_args {
	pid_t	pid;	char pid_[PAD_(pid_t)];
	int	policy;	char policy_[PAD_(int)];
	const struct sched_param *	param;	char param_[PAD_(const struct sched_param *)];
};
struct	sched_getscheduler_args {
	pid_t	pid;	char pid_[PAD_(pid_t)];
};
struct	sched_yield_args {
	register_t dummy;
};
struct	sched_get_priority_max_args {
	int	policy;	char policy_[PAD_(int)];
};
struct	sched_get_priority_min_args {
	int	policy;	char policy_[PAD_(int)];
};
struct	sched_rr_get_interval_args {
	pid_t	pid;	char pid_[PAD_(pid_t)];
	struct timespec *	interval;	char interval_[PAD_(struct timespec *)];
};
struct	utrace_args {
	const void *	addr;	char addr_[PAD_(const void *)];
	size_t	len;	char len_[PAD_(size_t)];
};
struct	kldsym_args {
	int	fileid;	char fileid_[PAD_(int)];
	int	cmd;	char cmd_[PAD_(int)];
	void *	data;	char data_[PAD_(void *)];
};
struct	jail_args {
	struct jail *	jail;	char jail_[PAD_(struct jail *)];
};
struct	sigprocmask_args {
	int	how;	char how_[PAD_(int)];
	const sigset_t *	set;	char set_[PAD_(const sigset_t *)];
	sigset_t *	oset;	char oset_[PAD_(sigset_t *)];
};
struct	sigsuspend_args {
	const sigset_t *	sigmask;	char sigmask_[PAD_(const sigset_t *)];
};
struct	sigaction_args {
	int	sig;	char sig_[PAD_(int)];
	const struct sigaction *	act;	char act_[PAD_(const struct sigaction *)];
	struct sigaction *	oact;	char oact_[PAD_(struct sigaction *)];
};
struct	sigpending_args {
	sigset_t *	set;	char set_[PAD_(sigset_t *)];
};
struct	sigreturn_args {
	ucontext_t *	sigcntxp;	char sigcntxp_[PAD_(ucontext_t *)];
};
struct	__acl_get_file_args {
	const char *	path;	char path_[PAD_(const char *)];
	acl_type_t	type;	char type_[PAD_(acl_type_t)];
	struct acl *	aclp;	char aclp_[PAD_(struct acl *)];
};
struct	__acl_set_file_args {
	const char *	path;	char path_[PAD_(const char *)];
	acl_type_t	type;	char type_[PAD_(acl_type_t)];
	struct acl *	aclp;	char aclp_[PAD_(struct acl *)];
};
struct	__acl_get_fd_args {
	int	filedes;	char filedes_[PAD_(int)];
	acl_type_t	type;	char type_[PAD_(acl_type_t)];
	struct acl *	aclp;	char aclp_[PAD_(struct acl *)];
};
struct	__acl_set_fd_args {
	int	filedes;	char filedes_[PAD_(int)];
	acl_type_t	type;	char type_[PAD_(acl_type_t)];
	struct acl *	aclp;	char aclp_[PAD_(struct acl *)];
};
struct	__acl_delete_file_args {
	const char *	path;	char path_[PAD_(const char *)];
	acl_type_t	type;	char type_[PAD_(acl_type_t)];
};
struct	__acl_delete_fd_args {
	int	filedes;	char filedes_[PAD_(int)];
	acl_type_t	type;	char type_[PAD_(acl_type_t)];
};
struct	__acl_aclcheck_file_args {
	const char *	path;	char path_[PAD_(const char *)];
	acl_type_t	type;	char type_[PAD_(acl_type_t)];
	struct acl *	aclp;	char aclp_[PAD_(struct acl *)];
};
struct	__acl_aclcheck_fd_args {
	int	filedes;	char filedes_[PAD_(int)];
	acl_type_t	type;	char type_[PAD_(acl_type_t)];
	struct acl *	aclp;	char aclp_[PAD_(struct acl *)];
};
struct	extattrctl_args {
	const char *	path;	char path_[PAD_(const char *)];
	int	cmd;	char cmd_[PAD_(int)];
	const char *	attrname;	char attrname_[PAD_(const char *)];
	char *	arg;	char arg_[PAD_(char *)];
};
struct	extattr_set_file_args {
	const char *	path;	char path_[PAD_(const char *)];
	const char *	attrname;	char attrname_[PAD_(const char *)];
	struct iovec *	iovp;	char iovp_[PAD_(struct iovec *)];
	unsigned	iovcnt;	char iovcnt_[PAD_(unsigned)];
};
struct	extattr_get_file_args {
	const char *	path;	char path_[PAD_(const char *)];
	const char *	attrname;	char attrname_[PAD_(const char *)];
	struct iovec *	iovp;	char iovp_[PAD_(struct iovec *)];
	unsigned	iovcnt;	char iovcnt_[PAD_(unsigned)];
};
struct	extattr_delete_file_args {
	const char *	path;	char path_[PAD_(const char *)];
	const char *	attrname;	char attrname_[PAD_(const char *)];
};
struct	aio_waitcomplete_args {
	struct aiocb **	aiocbp;	char aiocbp_[PAD_(struct aiocb **)];
	struct timespec *	timeout;	char timeout_[PAD_(struct timespec *)];
};
struct	getresuid_args {
	uid_t *	ruid;	char ruid_[PAD_(uid_t *)];
	uid_t *	euid;	char euid_[PAD_(uid_t *)];
	uid_t *	suid;	char suid_[PAD_(uid_t *)];
};
struct	getresgid_args {
	gid_t *	rgid;	char rgid_[PAD_(gid_t *)];
	gid_t *	egid;	char egid_[PAD_(gid_t *)];
	gid_t *	sgid;	char sgid_[PAD_(gid_t *)];
};
struct	kqueue_args {
	register_t dummy;
};
struct	kevent_args {
	int	fd;	char fd_[PAD_(int)];
	const struct kevent *	changelist;	char changelist_[PAD_(const struct kevent *)];
	int	nchanges;	char nchanges_[PAD_(int)];
	struct kevent *	eventlist;	char eventlist_[PAD_(struct kevent *)];
	int	nevents;	char nevents_[PAD_(int)];
	const struct timespec *	timeout;	char timeout_[PAD_(const struct timespec *)];
};
struct	sendfile_args {
	int	fd;	char fd_[PAD_(int)];
	int	s;	char s_[PAD_(int)];
	off_t	offset;	char offset_[PAD_(off_t)];
	size_t	nbytes;	char nbytes_[PAD_(size_t)];
	struct sf_hdtr *	hdtr;	char hdtr_[PAD_(struct sf_hdtr *)];
	off_t *	sbytes;	char sbytes_[PAD_(off_t *)];
	int	flags;	char flags_[PAD_(int)];
};
int	nosys __P((struct proc *, struct nosys_args *));
void	sys_exit __P((struct proc *, struct sys_exit_args *));
int	fork __P((struct proc *, struct fork_args *));
int	read __P((struct proc *, struct read_args *));
int	write __P((struct proc *, struct write_args *));
int	open __P((struct proc *, struct open_args *));
int	close __P((struct proc *, struct close_args *));
int	wait4 __P((struct proc *, struct wait_args *));
int	link __P((struct proc *, struct link_args *));
int	unlink __P((struct proc *, struct unlink_args *));
int	chdir __P((struct proc *, struct chdir_args *));
int	fchdir __P((struct proc *, struct fchdir_args *));
int	mknod __P((struct proc *, struct mknod_args *));
int	chmod __P((struct proc *, struct chmod_args *));
int	chown __P((struct proc *, struct chown_args *));
int	obreak __P((struct proc *, struct obreak_args *));
int	getfsstat __P((struct proc *, struct getfsstat_args *));
int	getpid __P((struct proc *, struct getpid_args *));
int	mount __P((struct proc *, struct mount_args *));
int	unmount __P((struct proc *, struct unmount_args *));
int	setuid __P((struct proc *, struct setuid_args *));
int	getuid __P((struct proc *, struct getuid_args *));
int	geteuid __P((struct proc *, struct geteuid_args *));
int	ptrace __P((struct proc *, struct ptrace_args *));
int	recvmsg __P((struct proc *, struct recvmsg_args *));
int	sendmsg __P((struct proc *, struct sendmsg_args *));
int	recvfrom __P((struct proc *, struct recvfrom_args *));
int	accept __P((struct proc *, struct accept_args *));
int	getpeername __P((struct proc *, struct getpeername_args *));
int	getsockname __P((struct proc *, struct getsockname_args *));
int	access __P((struct proc *, struct access_args *));
int	chflags __P((struct proc *, struct chflags_args *));
int	fchflags __P((struct proc *, struct fchflags_args *));
int	sync __P((struct proc *, struct sync_args *));
int	kill __P((struct proc *, struct kill_args *));
int	getppid __P((struct proc *, struct getppid_args *));
int	dup __P((struct proc *, struct dup_args *));
int	pipe __P((struct proc *, struct pipe_args *));
int	getegid __P((struct proc *, struct getegid_args *));
int	profil __P((struct proc *, struct profil_args *));
int	ktrace __P((struct proc *, struct ktrace_args *));
int	getgid __P((struct proc *, struct getgid_args *));
int	getlogin __P((struct proc *, struct getlogin_args *));
int	setlogin __P((struct proc *, struct setlogin_args *));
int	acct __P((struct proc *, struct acct_args *));
int	sigaltstack __P((struct proc *, struct sigaltstack_args *));
int	ioctl __P((struct proc *, struct ioctl_args *));
int	reboot __P((struct proc *, struct reboot_args *));
int	revoke __P((struct proc *, struct revoke_args *));
int	symlink __P((struct proc *, struct symlink_args *));
int	readlink __P((struct proc *, struct readlink_args *));
int	execve __P((struct proc *, struct execve_args *));
int	umask __P((struct proc *, struct umask_args *));
int	chroot __P((struct proc *, struct chroot_args *));
int	msync __P((struct proc *, struct msync_args *));
int	vfork __P((struct proc *, struct vfork_args *));
int	sbrk __P((struct proc *, struct sbrk_args *));
int	sstk __P((struct proc *, struct sstk_args *));
int	ovadvise __P((struct proc *, struct ovadvise_args *));
int	munmap __P((struct proc *, struct munmap_args *));
int	mprotect __P((struct proc *, struct mprotect_args *));
int	madvise __P((struct proc *, struct madvise_args *));
int	mincore __P((struct proc *, struct mincore_args *));
int	getgroups __P((struct proc *, struct getgroups_args *));
int	setgroups __P((struct proc *, struct setgroups_args *));
int	getpgrp __P((struct proc *, struct getpgrp_args *));
int	setpgid __P((struct proc *, struct setpgid_args *));
int	setitimer __P((struct proc *, struct setitimer_args *));
int	swapon __P((struct proc *, struct swapon_args *));
int	getitimer __P((struct proc *, struct getitimer_args *));
int	getdtablesize __P((struct proc *, struct getdtablesize_args *));
int	dup2 __P((struct proc *, struct dup2_args *));
int	fcntl __P((struct proc *, struct fcntl_args *));
int	select __P((struct proc *, struct select_args *));
int	fsync __P((struct proc *, struct fsync_args *));
int	setpriority __P((struct proc *, struct setpriority_args *));
int	socket __P((struct proc *, struct socket_args *));
int	connect __P((struct proc *, struct connect_args *));
int	getpriority __P((struct proc *, struct getpriority_args *));
int	bind __P((struct proc *, struct bind_args *));
int	setsockopt __P((struct proc *, struct setsockopt_args *));
int	listen __P((struct proc *, struct listen_args *));
int	gettimeofday __P((struct proc *, struct gettimeofday_args *));
int	getrusage __P((struct proc *, struct getrusage_args *));
int	getsockopt __P((struct proc *, struct getsockopt_args *));
int	readv __P((struct proc *, struct readv_args *));
int	writev __P((struct proc *, struct writev_args *));
int	settimeofday __P((struct proc *, struct settimeofday_args *));
int	fchown __P((struct proc *, struct fchown_args *));
int	fchmod __P((struct proc *, struct fchmod_args *));
int	setreuid __P((struct proc *, struct setreuid_args *));
int	setregid __P((struct proc *, struct setregid_args *));
int	rename __P((struct proc *, struct rename_args *));
int	flock __P((struct proc *, struct flock_args *));
int	mkfifo __P((struct proc *, struct mkfifo_args *));
int	sendto __P((struct proc *, struct sendto_args *));
int	shutdown __P((struct proc *, struct shutdown_args *));
int	socketpair __P((struct proc *, struct socketpair_args *));
int	mkdir __P((struct proc *, struct mkdir_args *));
int	rmdir __P((struct proc *, struct rmdir_args *));
int	utimes __P((struct proc *, struct utimes_args *));
int	adjtime __P((struct proc *, struct adjtime_args *));
int	setsid __P((struct proc *, struct setsid_args *));
int	quotactl __P((struct proc *, struct quotactl_args *));
int	nfssvc __P((struct proc *, struct nfssvc_args *));
int	statfs __P((struct proc *, struct statfs_args *));
int	fstatfs __P((struct proc *, struct fstatfs_args *));
int	getfh __P((struct proc *, struct getfh_args *));
int	getdomainname __P((struct proc *, struct getdomainname_args *));
int	setdomainname __P((struct proc *, struct setdomainname_args *));
int	uname __P((struct proc *, struct uname_args *));
int	sysarch __P((struct proc *, struct sysarch_args *));
int	rtprio __P((struct proc *, struct rtprio_args *));
int	semsys __P((struct proc *, struct semsys_args *));
int	msgsys __P((struct proc *, struct msgsys_args *));
int	shmsys __P((struct proc *, struct shmsys_args *));
int	pread __P((struct proc *, struct pread_args *));
int	pwrite __P((struct proc *, struct pwrite_args *));
int	ntp_adjtime __P((struct proc *, struct ntp_adjtime_args *));
int	setgid __P((struct proc *, struct setgid_args *));
int	setegid __P((struct proc *, struct setegid_args *));
int	seteuid __P((struct proc *, struct seteuid_args *));
int	stat __P((struct proc *, struct stat_args *));
int	fstat __P((struct proc *, struct fstat_args *));
int	lstat __P((struct proc *, struct lstat_args *));
int	pathconf __P((struct proc *, struct pathconf_args *));
int	fpathconf __P((struct proc *, struct fpathconf_args *));
int	getrlimit __P((struct proc *, struct __getrlimit_args *));
int	setrlimit __P((struct proc *, struct __setrlimit_args *));
int	getdirentries __P((struct proc *, struct getdirentries_args *));
int	mmap __P((struct proc *, struct mmap_args *));
int	lseek __P((struct proc *, struct lseek_args *));
int	truncate __P((struct proc *, struct truncate_args *));
int	ftruncate __P((struct proc *, struct ftruncate_args *));
int	__sysctl __P((struct proc *, struct sysctl_args *));
int	mlock __P((struct proc *, struct mlock_args *));
int	munlock __P((struct proc *, struct munlock_args *));
int	undelete __P((struct proc *, struct undelete_args *));
int	futimes __P((struct proc *, struct futimes_args *));
int	getpgid __P((struct proc *, struct getpgid_args *));
int	poll __P((struct proc *, struct poll_args *));
int	lkmnosys __P((struct proc *, struct nosys_args *));
int	__semctl __P((struct proc *, struct __semctl_args *));
int	semget __P((struct proc *, struct semget_args *));
int	semop __P((struct proc *, struct semop_args *));
int	msgctl __P((struct proc *, struct msgctl_args *));
int	msgget __P((struct proc *, struct msgget_args *));
int	msgsnd __P((struct proc *, struct msgsnd_args *));
int	msgrcv __P((struct proc *, struct msgrcv_args *));
int	shmat __P((struct proc *, struct shmat_args *));
int	shmctl __P((struct proc *, struct shmctl_args *));
int	shmdt __P((struct proc *, struct shmdt_args *));
int	shmget __P((struct proc *, struct shmget_args *));
int	clock_gettime __P((struct proc *, struct clock_gettime_args *));
int	clock_settime __P((struct proc *, struct clock_settime_args *));
int	clock_getres __P((struct proc *, struct clock_getres_args *));
int	nanosleep __P((struct proc *, struct nanosleep_args *));
int	minherit __P((struct proc *, struct minherit_args *));
int	rfork __P((struct proc *, struct rfork_args *));
int	openbsd_poll __P((struct proc *, struct openbsd_poll_args *));
int	issetugid __P((struct proc *, struct issetugid_args *));
int	lchown __P((struct proc *, struct lchown_args *));
int	getdents __P((struct proc *, struct getdents_args *));
int	lchmod __P((struct proc *, struct lchmod_args *));
int	lutimes __P((struct proc *, struct lutimes_args *));
int	nstat __P((struct proc *, struct nstat_args *));
int	nfstat __P((struct proc *, struct nfstat_args *));
int	nlstat __P((struct proc *, struct nlstat_args *));
int	fhstatfs __P((struct proc *, struct fhstatfs_args *));
int	fhopen __P((struct proc *, struct fhopen_args *));
int	fhstat __P((struct proc *, struct fhstat_args *));
int	modnext __P((struct proc *, struct modnext_args *));
int	modstat __P((struct proc *, struct modstat_args *));
int	modfnext __P((struct proc *, struct modfnext_args *));
int	modfind __P((struct proc *, struct modfind_args *));
int	kldload __P((struct proc *, struct kldload_args *));
int	kldunload __P((struct proc *, struct kldunload_args *));
int	kldfind __P((struct proc *, struct kldfind_args *));
int	kldnext __P((struct proc *, struct kldnext_args *));
int	kldstat __P((struct proc *, struct kldstat_args *));
int	kldfirstmod __P((struct proc *, struct kldfirstmod_args *));
int	getsid __P((struct proc *, struct getsid_args *));
int	setresuid __P((struct proc *, struct setresuid_args *));
int	setresgid __P((struct proc *, struct setresgid_args *));
int	aio_return __P((struct proc *, struct aio_return_args *));
int	aio_suspend __P((struct proc *, struct aio_suspend_args *));
int	aio_cancel __P((struct proc *, struct aio_cancel_args *));
int	aio_error __P((struct proc *, struct aio_error_args *));
int	aio_read __P((struct proc *, struct aio_read_args *));
int	aio_write __P((struct proc *, struct aio_write_args *));
int	lio_listio __P((struct proc *, struct lio_listio_args *));
int	yield __P((struct proc *, struct yield_args *));
int	thr_sleep __P((struct proc *, struct thr_sleep_args *));
int	thr_wakeup __P((struct proc *, struct thr_wakeup_args *));
int	mlockall __P((struct proc *, struct mlockall_args *));
int	munlockall __P((struct proc *, struct munlockall_args *));
int	__getcwd __P((struct proc *, struct __getcwd_args *));
int	sched_setparam __P((struct proc *, struct sched_setparam_args *));
int	sched_getparam __P((struct proc *, struct sched_getparam_args *));
int	sched_setscheduler __P((struct proc *, struct sched_setscheduler_args *));
int	sched_getscheduler __P((struct proc *, struct sched_getscheduler_args *));
int	sched_yield __P((struct proc *, struct sched_yield_args *));
int	sched_get_priority_max __P((struct proc *, struct sched_get_priority_max_args *));
int	sched_get_priority_min __P((struct proc *, struct sched_get_priority_min_args *));
int	sched_rr_get_interval __P((struct proc *, struct sched_rr_get_interval_args *));
int	utrace __P((struct proc *, struct utrace_args *));
int	kldsym __P((struct proc *, struct kldsym_args *));
int	jail __P((struct proc *, struct jail_args *));
int	sigprocmask __P((struct proc *, struct sigprocmask_args *));
int	sigsuspend __P((struct proc *, struct sigsuspend_args *));
int	sigaction __P((struct proc *, struct sigaction_args *));
int	sigpending __P((struct proc *, struct sigpending_args *));
int	sigreturn __P((struct proc *, struct sigreturn_args *));
int	__acl_get_file __P((struct proc *, struct __acl_get_file_args *));
int	__acl_set_file __P((struct proc *, struct __acl_set_file_args *));
int	__acl_get_fd __P((struct proc *, struct __acl_get_fd_args *));
int	__acl_set_fd __P((struct proc *, struct __acl_set_fd_args *));
int	__acl_delete_file __P((struct proc *, struct __acl_delete_file_args *));
int	__acl_delete_fd __P((struct proc *, struct __acl_delete_fd_args *));
int	__acl_aclcheck_file __P((struct proc *, struct __acl_aclcheck_file_args *));
int	__acl_aclcheck_fd __P((struct proc *, struct __acl_aclcheck_fd_args *));
int	extattrctl __P((struct proc *, struct extattrctl_args *));
int	extattr_set_file __P((struct proc *, struct extattr_set_file_args *));
int	extattr_get_file __P((struct proc *, struct extattr_get_file_args *));
int	extattr_delete_file __P((struct proc *, struct extattr_delete_file_args *));
int	aio_waitcomplete __P((struct proc *, struct aio_waitcomplete_args *));
int	getresuid __P((struct proc *, struct getresuid_args *));
int	getresgid __P((struct proc *, struct getresgid_args *));
int	kqueue __P((struct proc *, struct kqueue_args *));
int	kevent __P((struct proc *, struct kevent_args *));
int	sendfile __P((struct proc *, struct sendfile_args *));

#ifdef COMPAT_43

struct	ocreat_args {
	char *	path;	char path_[PAD_(char *)];
	int	mode;	char mode_[PAD_(int)];
};
struct	olseek_args {
	int	fd;	char fd_[PAD_(int)];
	long	offset;	char offset_[PAD_(long)];
	int	whence;	char whence_[PAD_(int)];
};
struct	ostat_args {
	char *	path;	char path_[PAD_(char *)];
	struct ostat *	ub;	char ub_[PAD_(struct ostat *)];
};
struct	olstat_args {
	char *	path;	char path_[PAD_(char *)];
	struct ostat *	ub;	char ub_[PAD_(struct ostat *)];
};
struct	osigaction_args {
	int	signum;	char signum_[PAD_(int)];
	struct osigaction *	nsa;	char nsa_[PAD_(struct osigaction *)];
	struct osigaction *	osa;	char osa_[PAD_(struct osigaction *)];
};
struct	osigprocmask_args {
	int	how;	char how_[PAD_(int)];
	osigset_t	mask;	char mask_[PAD_(osigset_t)];
};
struct	ofstat_args {
	int	fd;	char fd_[PAD_(int)];
	struct ostat *	sb;	char sb_[PAD_(struct ostat *)];
};
struct	getkerninfo_args {
	int	op;	char op_[PAD_(int)];
	char *	where;	char where_[PAD_(char *)];
	size_t *	size;	char size_[PAD_(size_t *)];
	int	arg;	char arg_[PAD_(int)];
};
struct	ommap_args {
	void *	addr;	char addr_[PAD_(void *)];
	int	len;	char len_[PAD_(int)];
	int	prot;	char prot_[PAD_(int)];
	int	flags;	char flags_[PAD_(int)];
	int	fd;	char fd_[PAD_(int)];
	long	pos;	char pos_[PAD_(long)];
};
struct	gethostname_args {
	char *	hostname;	char hostname_[PAD_(char *)];
	u_int	len;	char len_[PAD_(u_int)];
};
struct	sethostname_args {
	char *	hostname;	char hostname_[PAD_(char *)];
	u_int	len;	char len_[PAD_(u_int)];
};
struct	osend_args {
	int	s;	char s_[PAD_(int)];
	caddr_t	buf;	char buf_[PAD_(caddr_t)];
	int	len;	char len_[PAD_(int)];
	int	flags;	char flags_[PAD_(int)];
};
struct	orecv_args {
	int	s;	char s_[PAD_(int)];
	caddr_t	buf;	char buf_[PAD_(caddr_t)];
	int	len;	char len_[PAD_(int)];
	int	flags;	char flags_[PAD_(int)];
};
struct	osigreturn_args {
	struct osigcontext *	sigcntxp;	char sigcntxp_[PAD_(struct osigcontext *)];
};
struct	osigvec_args {
	int	signum;	char signum_[PAD_(int)];
	struct sigvec *	nsv;	char nsv_[PAD_(struct sigvec *)];
	struct sigvec *	osv;	char osv_[PAD_(struct sigvec *)];
};
struct	osigblock_args {
	int	mask;	char mask_[PAD_(int)];
};
struct	osigsetmask_args {
	int	mask;	char mask_[PAD_(int)];
};
struct	osigsuspend_args {
	osigset_t	mask;	char mask_[PAD_(osigset_t)];
};
struct	osigstack_args {
	struct sigstack *	nss;	char nss_[PAD_(struct sigstack *)];
	struct sigstack *	oss;	char oss_[PAD_(struct sigstack *)];
};
struct	orecvmsg_args {
	int	s;	char s_[PAD_(int)];
	struct omsghdr *	msg;	char msg_[PAD_(struct omsghdr *)];
	int	flags;	char flags_[PAD_(int)];
};
struct	osendmsg_args {
	int	s;	char s_[PAD_(int)];
	caddr_t	msg;	char msg_[PAD_(caddr_t)];
	int	flags;	char flags_[PAD_(int)];
};
struct	otruncate_args {
	char *	path;	char path_[PAD_(char *)];
	long	length;	char length_[PAD_(long)];
};
struct	oftruncate_args {
	int	fd;	char fd_[PAD_(int)];
	long	length;	char length_[PAD_(long)];
};
struct	ogetpeername_args {
	int	fdes;	char fdes_[PAD_(int)];
	caddr_t	asa;	char asa_[PAD_(caddr_t)];
	int *	alen;	char alen_[PAD_(int *)];
};
struct	osethostid_args {
	long	hostid;	char hostid_[PAD_(long)];
};
struct	ogetrlimit_args {
	u_int	which;	char which_[PAD_(u_int)];
	struct orlimit *	rlp;	char rlp_[PAD_(struct orlimit *)];
};
struct	osetrlimit_args {
	u_int	which;	char which_[PAD_(u_int)];
	struct orlimit *	rlp;	char rlp_[PAD_(struct orlimit *)];
};
struct	okillpg_args {
	int	pgid;	char pgid_[PAD_(int)];
	int	signum;	char signum_[PAD_(int)];
};
struct	ogetdirentries_args {
	int	fd;	char fd_[PAD_(int)];
	char *	buf;	char buf_[PAD_(char *)];
	u_int	count;	char count_[PAD_(u_int)];
	long *	basep;	char basep_[PAD_(long *)];
};
struct	osendfile_args {
	int	fd;	char fd_[PAD_(int)];
	int	s;	char s_[PAD_(int)];
	off_t	offset;	char offset_[PAD_(off_t)];
	size_t	nbytes;	char nbytes_[PAD_(size_t)];
	struct sf_hdtr *	hdtr;	char hdtr_[PAD_(struct sf_hdtr *)];
	off_t *	sbytes;	char sbytes_[PAD_(off_t *)];
	int	flags;	char flags_[PAD_(int)];
};
int	ocreat __P((struct proc *, struct ocreat_args *));
int	olseek __P((struct proc *, struct olseek_args *));
int	ostat __P((struct proc *, struct ostat_args *));
int	olstat __P((struct proc *, struct olstat_args *));
int	osigaction __P((struct proc *, struct osigaction_args *));
int	osigprocmask __P((struct proc *, struct osigprocmask_args *));
int	osigpending __P((struct proc *, struct osigpending_args *));
int	ofstat __P((struct proc *, struct ofstat_args *));
int	ogetkerninfo __P((struct proc *, struct getkerninfo_args *));
int	ogetpagesize __P((struct proc *, struct getpagesize_args *));
int	ommap __P((struct proc *, struct ommap_args *));
int	owait __P((struct proc *, struct owait_args *));
int	ogethostname __P((struct proc *, struct gethostname_args *));
int	osethostname __P((struct proc *, struct sethostname_args *));
int	oaccept __P((struct proc *, struct accept_args *));
int	osend __P((struct proc *, struct osend_args *));
int	orecv __P((struct proc *, struct orecv_args *));
int	osigreturn __P((struct proc *, struct osigreturn_args *));
int	osigvec __P((struct proc *, struct osigvec_args *));
int	osigblock __P((struct proc *, struct osigblock_args *));
int	osigsetmask __P((struct proc *, struct osigsetmask_args *));
int	osigsuspend __P((struct proc *, struct osigsuspend_args *));
int	osigstack __P((struct proc *, struct osigstack_args *));
int	orecvmsg __P((struct proc *, struct orecvmsg_args *));
int	osendmsg __P((struct proc *, struct osendmsg_args *));
int	orecvfrom __P((struct proc *, struct recvfrom_args *));
int	otruncate __P((struct proc *, struct otruncate_args *));
int	oftruncate __P((struct proc *, struct oftruncate_args *));
int	ogetpeername __P((struct proc *, struct ogetpeername_args *));
int	ogethostid __P((struct proc *, struct ogethostid_args *));
int	osethostid __P((struct proc *, struct osethostid_args *));
int	ogetrlimit __P((struct proc *, struct ogetrlimit_args *));
int	osetrlimit __P((struct proc *, struct osetrlimit_args *));
int	okillpg __P((struct proc *, struct okillpg_args *));
int	oquota __P((struct proc *, struct oquota_args *));
int	ogetsockname __P((struct proc *, struct getsockname_args *));
int	ogetdirentries __P((struct proc *, struct ogetdirentries_args *));
int	osendfile __P((struct proc *, struct osendfile_args *));

#endif /* COMPAT_43 */

#undef PAD_

#endif /* !_SYS_SYSPROTO_H_ */
