/*
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Copyright (c) 1998-2003 Apple Computer, Inc.  All Rights Reserved.
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

#ifndef _IOUSBCONTROLLERLISTELEMENT_H
#define _IOUSBCONTROLLERLISTELEMENT_H


#include <libkern/c++/OSObject.h>

#include <IOKit/IOTypes.h>

// #include <IOKit/usb/IOUSBControllerV2.h>
#include <IOKit/usb/USB.h>

typedef struct IOUSBControllerIsochEndpointStruct
IOUSBControllerIsochEndpoint,
*IOUSBControllerIsochEndpointPtr;


class IOUSBControllerListElement : public OSObject
{
    OSDeclareDefaultStructors(IOUSBControllerListElement)
	
private:    
	
public:
	
    virtual void					SetPhysicalLink(IOPhysicalAddress next) = 0;
    virtual IOPhysicalAddress		GetPhysicalLink(void) = 0;
    virtual IOPhysicalAddress		GetPhysicalAddrWithType(void) = 0;
    virtual void					print(int level);
	
    IOPhysicalAddress				_sharedPhysical;			// phys address of the memory shared with the controller			
    void *							_sharedLogical;				// logical address of the above
    IOUSBControllerListElement		*_logicalNext;				// the next element in the list
    
};


class IOUSBControllerV2;										// needed for a parameter

class IOUSBControllerIsochListElement : public IOUSBControllerListElement
{
    OSDeclareDefaultStructors(IOUSBControllerIsochListElement)
	
private:
    
public:
	
    virtual void					SetPhysicalLink(IOPhysicalAddress next) = 0;
    virtual IOPhysicalAddress		GetPhysicalLink(void) = 0;
    virtual IOPhysicalAddress		GetPhysicalAddrWithType(void) = 0;
    virtual void					print(int level);
	
    IOUSBControllerIsochEndpointPtr	_pEndpoint;
    IOUSBIsocFrame					*_pFrames;
    IOUSBIsocCompletion				_completion;
    Boolean							_lowLatency;
	UInt8							_framesInTD;			// used for HS Isoch only
    UInt64							_frameNumber;			// frame number for scheduling purposes
    UInt32							_frameIndex;			// index into the myFrames array
    IOUSBControllerIsochListElement *_doneQueueLink;		// linkage used by done queue processing
	
    // pure virtual methods which must be implemented by descendants
    virtual IOReturn				UpdateFrameList(AbsoluteTime timeStamp) = 0;
    virtual IOReturn				Deallocate(IOUSBControllerV2 *uim) = 0;
};


// this is an internal "endpoint" data sructure used to track bandwidth and other
// issues in Isoch connections. It has no "shared" counterpart in the hardware
struct IOUSBControllerIsochEndpointStruct {
    IOUSBControllerIsochEndpointPtr		nextEP;
    IOUSBControllerIsochListElement  	*toDoList;					// ITD or SITD
    IOUSBControllerIsochListElement  	*toDoEnd;					// ITD or SITD
    IOUSBControllerIsochListElement  	*doneQueue;					// ITD or SITD
    IOUSBControllerIsochListElement  	*doneEnd;					// ITD or SITD
    IOUSBControllerIsochListElement  	*deferredQueue;				// ITD or SITD
    IOUSBControllerIsochListElement  	*deferredEnd;				// ITD or SITD
    UInt64								firstAvailableFrame;		// next frame available for a transfer on this EP
    UInt32								maxPacketSize;
    UInt32								activeTDs;					// + when added to todo list, - when taken from done queue
    UInt32								onToDoList;					// + when added to todo list, - when taken from done queue
    UInt32								onDoneQueue;					// + when added to todo list, - when taken from done queue
	UInt32								scheduledTDs;				// + when linked onto periodic list, - when unlinked
	UInt32								deferredTDs;
	UInt32								onProducerQ;
	UInt32								onReversedList;
    IOReturn							accumulatedStatus;
	void								*hiPtr;						// pointer to the Transaction Translator (for Split EP)
    UInt16								inSlot;						// where Isoc TDs are being put in the periodic list 
    short								oneMPS;						// For high bandwidth
    short								mult;						// how many oneMPS sized transactions to do
    short								functionAddress;
    short								endpointNumber;
    USBDeviceAddress					highSpeedHub;
    int									highSpeedPort;
    UInt8								direction;
	UInt8								interval;					// this is the processed interval value for HS endpoints
	UInt8								bandwidthUsed[8];			// how many bytes I use on each microframe
	UInt8								startSplitFlags;
	UInt8								completeSplitFlags;
	bool								useBackPtr;
	bool								aborting;
};


#endif

