/*
	NSTabViewItem.h
        Application Kit
        Copyright (c) 2000-2005, Apple Computer, Inc.
        All rights reserved.
*/

#import <Foundation/NSObject.h>
#import <Foundation/NSGeometry.h>
#import <AppKit/NSView.h>

@class NSColor, NSTabView, NSView;

typedef enum _NSTabState {
    NSSelectedTab = 0,
    NSBackgroundTab = 1,
    NSPressedTab = 2
} NSTabState;

@interface NSTabViewItem : NSObject <NSCoding>
{
    @private
    
    	/* Persistent properties */
    
    id			_identifier;    
    NSString		*_label;			// the label
    NSView		*_view;				// view to be displayed
    NSView		*_initialFirstResponder;	// initial first responder for that view
    NSColor		*_color;			// the color of the tab. By default [NSColor controlColor]
    NSTabView		*_tabView;			// back pointer to the tabView. Could be nil.

    	/* Non-persistent properties */
    
    NSTabState		_tabState;			// NSSelectedTab, NSBackgroundTab, or NSPressedTab
    NSView		*_lastKeyView;			// The "last" view in this items keyboard loop

    struct __tviFlags {
	unsigned int hasCustomColor:1;			// YES if _color != [NSColor controlColor]
	unsigned int labelSizeIsValid:1;		// YES if _labelSize is valid
	unsigned int autoGeneratedIFR:1;
	unsigned int isTabDisabled:1;
	unsigned int RESERVED:28;
    } _tviFlags;
    
    NSSize		_labelSize;			// Cached label size. Valid if _labelSizeValid equal YES
    NSRect		_tabRect;			// Cached tabRect
    NSToolTipTag	_tabToolTipTag;			// Saved tool tip tag, for when text label is truncated.
    id _auxiliaryStorage;
}

	/* Initialization */

- (id)initWithIdentifier:(id)identifier;

    	/* Getters */

- (id)identifier;
- (id)view;
- (id)initialFirstResponder;
- (NSString *)label;
- (NSColor *)color;
- (NSTabState)tabState;
- (NSTabView *)tabView;

    	/* Setters */

- (void)setIdentifier:(id)identifier;
- (void)setLabel:(NSString *)label;
- (void)setColor:(NSColor *)color;
- (void)setView:(NSView *)view;
- (void)setInitialFirstResponder:(NSView *)view;

	/* Tab Drawing/Measuring */

/* This method draws the tab label assuming a local coordinate system whose label axis runs along the x axis.  Assume the label axis runs along the length of the label (perpendicular to the direction of the tab).  'labelRect' is the area in between the curved end caps.  'shouldTruncateLabel' is a hint that the label should be truncated.  ie. if shouldTruncateLabel is YES, then labelRect.size < ceil([sizeOfLabel:NO])
*/
- (void)drawLabel:(BOOL)shouldTruncateLabel inRect:(NSRect)labelRect;

/* This method returns the minimum or nominal size of the tab label.  The width of the label is measured along the label axis, and height is measured in the direction parallel to the tab direction.  'computeMin' indicates whether you should return the minimum or nominal label size.  The returned value is used to compute the range of legal sizes for the tab label.
*/
- (NSSize)sizeOfLabel:(BOOL)computeMin;

@end

