%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/home/gub/NewGub/gub/target/linux-x86/src/lilypond-git.sv.gnu.org--lilypond.git-stable-2.20/input/regression/stencil-hacking.ly"
\sourcefileline 0
\version "2.19.21"

\header { texidoc=" You can write stencil callbacks in Scheme, thus
providing custom glyphs for notation elements.  A simple example is
adding parentheses to existing stencil callbacks.

The parenthesized beam is less successful due to implementation of the
Beam. The note head is also rather naive, since the extent of the
parens are also not seen by accidentals.
"
	
}

#(define (parenthesize-callback callback)
   "Construct a function that will do CALLBACK and add parentheses.
Example usage:

  \\override NoteHead.stencil
  =
  #(parenthesize-callback ly:note-head::print)"
   
   (define (parenthesize-stencil grob)
     "This function adds parentheses to the original callback for
GROB.  It does not affect the dimensions of the stencil.
"
     
     (let* ((fn (ly:grob-default-font grob))
	    (pclose (ly:font-get-glyph fn "accidentals.rightparen"))
	    (popen (ly:font-get-glyph fn "accidentals.leftparen"))
	    (subject (callback grob))

	    ; remember old size
	    (subject-dim-x (ly:stencil-extent subject X))
	    (subject-dim-y (ly:stencil-extent subject Y)))

        ;; add parens
        (set! subject
	     (ly:stencil-combine-at-edge 
	      (ly:stencil-combine-at-edge subject X RIGHT pclose 0.2)
	      X LEFT popen  0.2))

	; revert old size.
       (ly:make-stencil
        (ly:stencil-expr subject) subject-dim-x subject-dim-y)))
   parenthesize-stencil)
    

\layout { ragged-right = ##t }
\relative {
    c'4 e

    \override NoteHead.stencil
    =
    #(parenthesize-callback ly:note-head::print)
    g bes
    \revert NoteHead.stencil

    \override Beam.stencil
    =
    #(parenthesize-callback ly:beam::print)

    a8 gis8 a2.
    
}






% ****************************************************************
% end ly snippet
% ****************************************************************
