%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/home/gub/gub/target/linux-x86/src/lilypond-git.sv.gnu.org--lilypond.git-stable-2.16/input/regression/slur-multiple.ly"
\sourcefileline 0
\version "2.16.0"

#(ly:set-option 'warning-as-error #f)
#(ly:expect-warning (_ "already have slur"))
#(ly:expect-warning (_ "cannot end slur"))
#(ly:expect-warning (_ "unterminated slur"))

\header {
  texidoc = "LilyPond does not support multiple concurrent slurs with the 
parentheses syntax.  In this case, warnings will be given and the nested
slur will not be generated.  However, one can can create a second slur with
a different spanner-id."
}

sp=#(define-event-function (parser location n e) (index? ly:event?)
     (set! (ly:music-property e 'spanner-id) (format "sp~a" n))
     e)

\relative c'' { 
  % This will give warnings ("Already have slur" and "Cannot end slur")
  c4((\sp1( d4)(\sp1( e4) f) |
  % This will give two overlapping slurs and "unterminated slur" from above
  d(  d\sp2( e) f\sp2) |
  
}



% ****************************************************************
% end ly snippet
% ****************************************************************
