%% Generated by lilypond-book.py
%% Options: [alt=[image of music],printfilename,indent=0\mm,texidoc,line-width=160\mm]
\include "lilypond-book-preamble.ly"







% ****************************************************************
% Start cut-&-pastable-section 
% ****************************************************************

\paper {
  #(define dump-extents #t)
  
  indent = 0\mm
  line-width = 160\mm
}

\layout {
  
}



% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "quote-transposition.ly"

\header
{

    texidoc = "Quotations take into account the transposition of both
source and target.  In this example, all instruments play sounding
central C, the target is a instrument in F.  The target part may be
@code{\\transpose}d.  In this case, all the pitches (including the
quoted ones) will transposed as well.  "

}



\layout { ragged-right = ##t }


\addquote clarinet  {
    \transposition bes
    d'16 d'16 d'8 
    d'16 d'16 d'8 
    d'16 d'16 d'8 
    d'16 d'16 d'8 
}

\addquote sax  {
    \transposition es'
    a8 a a a a a  a a 
}

quoteTest = {
    \transposition f  % french horn
    
    g'4
    << \quoteDuring #"clarinet" { \skip 4 } s4^"clar" >> 
    << \quoteDuring #"sax" { \skip 4 } s4^"sax" >> 
}


<< \quoteTest
   \new Staff
   << \transpose c' d' \quoteTest
     s4_"up 1 tone"
  >>
>>



% ****************************************************************
% end ly snippet
% ****************************************************************
