%% Generated by lilypond-book.py
%% Options: [alt=[image of music],printfilename,indent=0\mm,texidoc,line-width=160\mm]

#(set! toplevel-score-handler print-score-with-defaults)
#(set! toplevel-music-handler
  (lambda (p m)
   (if (not (eq? (ly:music-property m 'void) #t))
        (print-score-with-defaults
         p (scorify-music m p)))))

#(ly:set-option (quote no-point-and-click))
#(define inside-lilypond-book #t)
#(define version-seen? #t)







% ****************************************************************
% Start cut-&-pastable-section 
% ****************************************************************

\paper {
  #(define dump-extents #t)
  
  indent = 0\mm
  line-width = 160\mm
}

\layout {
  
}



% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "music-map.ly"
\header {

  texidoc =

  "With @code{music-map}, you can apply functions operating on a
single piece of music to an entire music expression. In this example,
the the function @code{notes-to-skip} changes a note to a skip. When
applied to an entire music expression in the 1st measure, the scripts
and dynamics are left over. These are put onto the 2nd measure."

}

\version "2.7.39"

#(define (notes-to-skip m)
  "Convert all stuff with duration (notes, lyrics, bass figures, etc.) to skips.
Scripts and dynamics are maintained.
"
  (if (memq 'rhythmic-event (ly:music-property m 'types))
   (let* ((newmus (make-music 'SkipEvent)))
    (map
     (lambda (x) (ly:music-set-property! newmus (car x) (cdr x)))
     (ly:music-mutable-properties m))
    newmus
  )
   m)
)


\layout { ragged-right= ##t }

foobar =  \transpose c c' { c4\>-^ c4-^ c4\!-^ c4-^  } 


\relative c''  \context Voice {
  \foobar

  << \applyMusic #(lambda (x) (music-map notes-to-skip x))
     \foobar
     { d2 d2 } >> 
}



% ****************************************************************
% end ly snippet
% ****************************************************************
