%% Generated by lilypond-book.py
%% Options: [alt=[image of music],printfilename,indent=0\mm,texidoc,line-width=160\mm]

#(set! toplevel-score-handler print-score-with-defaults)
#(set! toplevel-music-handler
  (lambda (p m)
   (if (not (eq? (ly:music-property m 'void) #t))
        (print-score-with-defaults
         p (scorify-music m p)))))

#(ly:set-option (quote no-point-and-click))
#(define inside-lilypond-book #t)
#(define version-seen? #t)







% ****************************************************************
% Start cut-&-pastable-section 
% ****************************************************************

\paper {
  #(define dump-extents #t)
  
  indent = 0\mm
  line-width = 160\mm
}

\layout {
  
}



% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "lily-in-scheme.ly"
\header { texidoc = "LilyPond syntax can be used inside scheme to
    build music expressions, with the @code{#@{ ... #@}} syntax.
    Scheme forms can be introduced inside these blocks by escaping
    them with a @code{$}, both in a LilyPond context or in a Scheme
    context.

In this example, the @code{\withpaddingA}, @code{\withpaddingB} and
@code{\withpaddingC} music functions set different kinds of padding on
the @code{TextScript} grob.

"
          
      }

\version "2.7.39"
\layout { ragged-right = ##t }

withPaddingA = #(define-music-function (parser location padding music) (number? ly:music?)
		 #{ \override TextScript #'padding = #$padding
		 $music 
		 \revert TextScript #'padding #})

withPaddingB = #(define-music-function (parser location padding music) (number? ly:music?)
		 #{ \override TextScript #'padding = #$(* padding 2)
		 $music 
		 \revert TextScript #'padding #})

withPaddingC = #(define-music-function (parser location padding music) (number? ly:music?)
		 #{ \override TextScript #'padding = #(+ 1 $(* padding 2))
		    $music 
		    \revert TextScript #'padding #})

{
    c'^"1"
    \withPaddingA #2
    { c'^"2" c'^"3"}
    c'^"4"
    \withPaddingB #2
    { c'^"5" c'^"6"}
    c'^"7"
    \withPaddingC #2
    { c'^"8" c'^"9"}
    c'^"10"
}



% ****************************************************************
% end ly snippet
% ****************************************************************
