%% Generated by lilypond-book.py
%% Options: [alt=[image of music],printfilename,indent=0\mm,texidoc,line-width=160\mm]

#(set! toplevel-score-handler print-score-with-defaults)
#(set! toplevel-music-handler
  (lambda (p m)
   (if (not (eq? (ly:music-property m 'void) #t))
        (print-score-with-defaults
         p (scorify-music m p)))))

#(ly:set-option (quote no-point-and-click))
#(define inside-lilypond-book #t)
#(define version-seen? #t)







% ****************************************************************
% Start cut-&-pastable-section 
% ****************************************************************

\paper {
  #(define dump-extents #t)
  
  indent = 0\mm
  line-width = 160\mm
}

\layout {
  
}



% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "beam-extreme.ly"

\version "2.7.39"
\header{
texidoc="
Beams should behave reasonably well, even under extreme circumstances.
Stems may be short, but noteheads should never touch the beam.  Note that
under normal circumstances, these beams would get knees here
@code{Beam.auto-knee-gap} was set to false.
"
}

\layout{
  %%    ragged-right = ##t
  ragged-right = ##t
}

extreme = \relative c'' {
  \stemNeutral
   g8[ c c,]
   c16[ c'' a f]
  \stemUp 
   c,,32[ c'' a f]

  %%%%%%%
  \stemNeutral
  \times 2/3{ d16[ fis' d,]} \times 2/3{ cis[ g'' cis,,]}
  a'16 cis a, g''' % Used to give a nice beam directed upwards.
  \stemNeutral

  \transpose c c {
	  \stemDown  e'8[ e e']
      }
}

{
				% If we want to test extreme beams,
				% we should not have them auto-kneed
  \override Beam  #'auto-knee-gap = ##f
  \extreme
}



% ****************************************************************
% end ly snippet
% ****************************************************************
