%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm,quote]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
  line-width = 160\mm - 2.0 * 10.16\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "extending-glissandi-across-repeats.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.di.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.19.22"

\header {
%% Translation of GIT committish: 98ac53591234404cd70c5eebd370a598ec74095b
  texidoces = "
Se puede simular un glissando que se extiende hasta el interior de
varios bloques @code{\alternative} de primera y segunda vez mediante
la adición de una nota de adorno oculta con un glissando al comienzo
de cada bloque @code{\alternative}.  La nota de adorno debe estar a la
misma altura que la nota que da inicio al primer glissando.  Esto se
implementa aquí con una función musical que toma como argumento la
altura de la nota de adorno.

Observe que en música polifónica la nota de adorno debe coincidir con
las notas de adorno correspondientes en todas las otras voces.

"
  doctitlees = "Extender glissandos sobre repeticiones"

%% Translation of GIT committish: e0808cc5f4890c5f8f03ed1be48fc911627afea4
  texidocit = "
Un glissando che si estende in vari blocchi @code{\\alternative} può
essere simulato aggiungendo all'inizio di ogni blocco @code{\\alternative}
una nota di abbellimento nascosta da cui inizia un glissando.  La nota di
abbellimento deve avere la stessa altezza della nota da cui parte il
glissando iniziale.  In questo frammento si usa una funzione musicale
che prende come argomento l'altezza  della nota di abbellimento.

Attenzione: nella musica polifonica la nota di abbellimento deve avere una nota
di abbellimento corrispondente in tutte le altre voci.

"
  doctitleit = "Estendere i glissandi sulle volte delle ripetizioni"

%% Translation of GIT committish: 958e95822083954cad00e0a598eb9f12ceba67b9
  texidocfr = "
Un glissando qui se prolonge sur plusieurs sections @code{\\alternative}
peut se rappeler à l'aide d'une note d'ornement supplémentaire et
masquée, à laquelle sera attaché le départ du glissando, ce dans chaque
bloc @code{\\alternative}.  Cette note d'ornement devrait avoir la même
hauteur que la note où commençait le glissando originel.  Ceci est géré
par une fonction musicale qui prendra en argument la hauteur de la note
d'ornement.

Dans le cadre d'un musicque polyphonique, il ne faudra pas oublier
d'ajouter une note d'ornement dans toutes les autres voix afin de
préserver la synchronisation.

"
  doctitlefr = "Rappel du glissando à l'occasion d'une alternative"

  lsrtags = "staff-notation, tweaks-and-overrides"

  texidoc = "
A glissando which extends into several @code{\\alternative} blocks can
be simulated by adding a hidden grace note with a glissando at the
start of each @code{\\alternative} block.  The grace note should be at
the same pitch as the note which starts the initial glissando.  This is
implemented here with a music function which takes the pitch of the
grace note as its argument.

Note that in polyphonic music the grace note must be matched with
corresponding grace notes in all other voices.

"
  doctitle = "Extending glissandi across repeats"
} % begin verbatim

repeatGliss = #(define-music-function (grace)
  (ly:pitch?)
  #{
    % the next two lines ensure the glissando is long enough
    % to be visible
    \once \override Glissando.springs-and-rods
      = #ly:spanner::set-spacing-rods
    \once \override Glissando.minimum-length = #3.5
    \once \hideNotes
    \grace $grace \glissando
  #})

\score {
  \relative c'' {
    \repeat volta 3 { c4 d e f\glissando }
    \alternative {
      { g2 d }
      { \repeatGliss f g2 e }
      { \repeatGliss f e2 d }
    }
  }
}

music =  \relative c' {
  \voiceOne
  \repeat volta 2 {
    g a b c\glissando
  }
  \alternative {
    { d1 }
    { \repeatGliss c \once \omit StringNumber e1\2 }
  }
}

\score {
  \new StaffGroup <<
    \new Staff <<
      \context Voice { \clef "G_8" \music }
    >>
    \new TabStaff  <<
      \context TabVoice { \clef "moderntab" \music }
    >>
  >>
}



% ****************************************************************
% end ly snippet
% ****************************************************************
