%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "flamenco-notation.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.di.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.18.0"

\header {
%% Translation of GIT committish: 8ffecf6be17c6ec2ff87cf31873121a8cce29b09
  texidoces = "
Para la guitarra flamenca se utilizan ciertos elementos de notación
especiales:


@itemize

@item un símbolo para indicar un golpe sobre la caja de la guitarra
con el nudillo del dedo anular

@item una flecha para indicar la dirección de los rasgueos

@item distintas legras para las digitaciones (@qq{p}: pulgar, @qq{i}:
índice, @qq{m}: medio, @qq{a}: anular y @qq{x}: meñique)

@item Rasgueados de 3 y cautro dedos: hacia arriba con todos los dedos
y terminando con arriba y abajo con el índice

@item abanicos: rasgueos en serie con el pulgar, hacia abajo y el
meñique y el índice hacia arriba (hay también un abanico 2 en el que
los dedos medio y anular se usan en lugar del meñique)

@item alza púa: pulsaciones rápidas con el pulgar

@end itemize


Casi todas las figuras utilizan flechas combinadas con digitaciones;
con los abanicos y los rasgueados, las notas se imprimen con cabeza
sólo en el primer acorde.

Este fragmento de código contiene código de tipo cabecera que se puede
copiar como @file{flamenco.ly} e incluirse en los documentos fuente.

"
  doctitlees = "Notación del flamenco"

%% Translation of GIT committish: 8eae9a75fb3ec1d0b6633103c8a652608c8fa630
  texidocfr = "
La guitare flamenco fait appel à des éléments de notation particuliers :

-- le @emph{golpe} : coup frappé sur la caisse de résonance avec
   l'ongle de l'annulaire,

-- une flèche pour indiquer le sens des butés (@emph{strokes}),

-- les doigtés : « p » pouce, « i » index, « m » majeur, « a »
   annulaire et « x » auriculaire,

-- les @emph{rasgueados} sur trois ou quatre doigts : grattage des
   cordes en étendant les doigts rapidement les uns après les autres
   dans un mouvement continu, se terminant sur l'index,

-- les @emph{abanicos} : séries de butés du pouce, index et auriculaire.
   Il existe aussi un @emph{abanico 2} pour lequel l'index et
   l'annulaire remplacent l'auriculaire.

-- @emph{alza púa} : jeu rapide du pouce.

La plupart de ces symboles utilisent une flèche en plus des doigtés.
Dans le cas d'un @emph{abanico}, les têtes de note ne sont imprimées que
pour le premier accord.

Le début du code ci-dessous répertorie le paramétrage de ces différents
symboles, que vous pouvez copier dans un fichier @file{flamenco.ly}
pour inclusion dans vos propres compositions.

"
  doctitlefr = "Notation de flamenco"

  lsrtags = "fretted-strings, specific-notation, stylesheet, version-specific"

  texidoc = "
For flamenco guitar, special notation is used:


* a golpe symbol to indicate a slap on the guitar body with the nail of
the ring finger * an arrow to indicate (the direction of) strokes *
different letters for fingering (@qq{p}: thumb, @qq{i}: index finger,
@qq{m}: middle finger, @qq{a}: ring finger and @qq{x}: little finger) *
3- and 4-finger rasgueados; stroke upwards with all fingers, ending
with an up- and down using the index finger * abanicos: strokes (in
tuples) with thumb (down), little and index finger (both up). There's
also an abanico 2 where middle and ring finger are used instead of the
little finger. * alza pua: fast playing with the thumb


Most figures use arrows in combination with fingering; with abanicos
and rasgueados, noteheads are printed only for the first chord.

This snippet contains some header-like code that can be copied as
@samp{flamenco.ly} and included in source files.

"
  doctitle = "Flamenco notation"
} % begin verbatim

%%%%%%%  Cut here ----- Start 'flamenco.ly'

% Text indicators :
abanico = ^\markup\small { \italic Abanico }
rasgueado = ^\markup\small { \italic Ras. }
alzapua = ^\markup\small { \italic Alzapua }

% Finger stroke symbols :
strokeUp = \markup\combine\override #'(thickness . 1.3) \draw-line #'(0 . 2)\raise #2 \arrow-head #Y #UP ##f
strokeDown = \markup\combine\arrow-head #Y #DOWN ##f \override #'(thickness . 1.3) \draw-line #'(0 . 2)

% Golpe symbol :
golpe = \markup {
  \filled-box #'(0 . 1) #'(0 . 1) #0
  \hspace #-1.6
  \with-color #white
  \filled-box #'(0.15 . 0.85) #'(0.15 . 0.85) #0
}

% Strokes, fingers and golpe command :
RHp = \rightHandFinger #1
RHi = \rightHandFinger #2
RHm = \rightHandFinger #3
RHa = \rightHandFinger #4
RHx = \rightHandFinger #5
RHu = \rightHandFinger \strokeUp
RHd = \rightHandFinger \strokeDown
RHg = \rightHandFinger \golpe

% Just handy :)
tupletOff = {
  \once \omit TupletNumber
  \once \omit TupletBracket
}

tupletsOff = {
  \omit TupletNumber
  \override TupletBracket.bracket-visibility = #'if-no-beam
}

tupletsOn = {
  \override TupletBracket.bracket-visibility = #'default
  \undo \omit TupletNumber
}

headsOff = {
  \hide TabNoteHead
  \hide NoteHead
  \override NoteHead.no-ledgers = ##t
}

headsOn = {
  \override TabNoteHead.transparent = ##f
  \override NoteHead.transparent = ##f
  \override NoteHead.no-ledgers = ##f
}

%%%%%%%  Cut here ----- End 'flamenco.ly'
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

part = \relative c' {
  \set strokeFingerOrientations = #'(up)
  \override StrokeFinger.add-stem-support = ##t
  \key a\major
  <a, e' a cis e\RHu\RHi>8
  <a e' a cis e\RHd\RHi>8
  r4
  r2^\markup\golpe
  <a e' a cis e\RHu\RHi>8
  <a e' a cis e\RHd\RHi>8
  <a e' a cis e\RHu\RHi\RHg>8
  <a e' a cis e\RHd\RHi>8
  r2
  <a e' a cis e\RHu\RHa>16\rasgueado
  \headsOff
  <a e' a cis e\RHu\RHm>
  <a e' a cis e\RHu\RHi>
  <a e' a cis e\RHd\RHi>~
  \headsOn
  <a e' a cis e>2
  r4
  \tupletOff
  \tuplet 5/4 {
    <a e' a cis e\RHu\RHx>16\rasgueado
    \headsOff
    <a e' a cis e\RHu\RHa>
    <a e' a cis e\RHu\RHm>
    <a e' a cis e\RHu\RHi>
    <a e' a cis e\RHd\RHi>~
    \headsOn
  }
  <a e' a cis e>2
  r4
  \tupletsOff
  \tuplet 3/2 {
    <a e' a cis e\RHd\RHp>8\abanico
    \headsOff
    <a e' a cis e\RHu\RHx>
    <a e' a cis e\RHu\RHi>
    \headsOn
  }
  \tuplet 3/2 {
    <a e' a cis e\RHd\RHp>8
    \headsOff
    <a e' a cis e\RHu\RHx>
    <a e' a cis e\RHu\RHi>
    \headsOn
  }
  \tuplet 3/2 {
    <a e' a cis e\RHd\RHp>8
    \headsOff
    <a e' a cis e\RHu\RHx>
    <a e' a cis e\RHu\RHi>
    \headsOn
  }
  \tuplet 3/2 {
    <a e' a cis e\RHd\RHp>8
    \headsOff
    <a e' a cis e\RHu\RHx>
    <a e' a cis e\RHu\RHi>
    \headsOn
  }
  \tupletsOff
  \override Beam.positions = #'(2 . 2)
  \tuplet 3/2 {
    a8\RHp\alzapua
    <e' a\RHu\RHg>
    <e a\RHd>
  }
  \tuplet 3/2 {
    a,8\RHp
    <e' a\RHu\RHg>
    <e a\RHd>
  }
  \tuplet 3/2 {
    a,8\RHp
    <e' a\RHu\RHg>
    <e a\RHd>
  }
  \tuplet 3/2 {
    a,8\RHp
    <e' a\RHu\RHg>
    <e a\RHd>
  }
  \tupletsOn
  <a, e' a\RHu\RHm>1
  \bar "|."
}

\score {
  \new StaffGroup <<
    \context Staff = "part" <<
      \clef "G_8"
      {
        \part
      }
    >>
    \context TabStaff {
      \part
    }
  >>
  \layout {
    ragged-right = ##t
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
