%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "combining-two-parts-on-the-same-staff.ly"
\sourcefileline 0
% DO NOT EDIT this file manually; it is automatically
% generated from Documentation/snippets/new
% Make any changes in Documentation/snippets/new/
% and then run scripts/auxiliar/makelsr.py
%
% This file is in the public domain.
%% Note: this file works from version 2.19.56
\version "2.19.56"

\header {
%% Translation of GIT committish: 3f57efa0cde39bf0642fb6fb3672a19262ceda83
  texidoces = "
La herramienta de combinación de partes (instrucción
@code{\\partcombine}) permite la combinación de varias partes
diferentes sobre el mismo pentagrama.  Las indicaciones textuales
tales como @qq{solo} o @qq{a2} se añaden de forma predeterminada; para
quitarlas, sencillamente establezca la propiedad
@code{printPartCombineTexts} al valor @qq{falso}.  Para partituras
vocales (como himnos), no hay necesidad de añadir los textos @qq{solo}
o @qq{a2}, por lo que se deben desactivar.  Sin embargo, podría ser
mejor no usarlo si hay solos, porque éstos no se indicarán.  En tales
casos podría ser preferible la notación polifónica estándar.

Este fragmento de código presenta las tres formas en que se pueden
imprimir dos partes sobre un solo pentagrama: polifonía estándar,
@code{\\partcombine} sin textos, y @code{\\partcombine} con
textos.

"
  doctitlees = "Combinar dos partes sobre el mismo pentagrama"

%% Translation of GIT committish: e0808cc5f4890c5f8f03ed1be48fc911627afea4
  texidocit = "
Lo strumento di unione delle parti (il comando @code{\\partcombine}) permette
di combinare varie parti sullo stesso rigo.  Indicazioni testuali come
@qq{solo} e @qq{a2} sono aggiunte automaticamente; per toglierele basta
impostare la proprietà @code{printPartCombineTexts} su @code{f}.
Per le partiture vocali (inni), non c'è bisogno di aggiungere i testi
@qq{solo/a2}, quindi dovrebbero essere disattivati.   Tuttavia potrebbe
convenire non usarlo se c'è una qualche parte solista, perché non
verrebbe indicata.  In tali casi è preferibile usare la notazione
polifonica normale.

Questo frammento illustra i tre modi con cui due parti possono essere stampate
su uno stesso rigo: normale polifonia, @code{\\partcombine} senza testo e
@code{\\partcombine} con testo.

"
  doctitleit = "Combinare due parti sullo stesso rigo"

%% Translation of GIT committish: 0a868be38a775ecb1ef935b079000cebbc64de40
  texidocde = "
Die Funktion, die Stimmen kombiniert (also der @code{\\partcombine}-Befehl)
ermöglicht die Kombination unterschiedlicher Stimmen auf einem
System.  Textanweisungen wie \"solo\" oder \"a2\" werden automatisch
hinzugefügt.  Wenn man sie entfernen will, muss man die Eigenschaft
@code{printPartCombineTexts} auf falsch setzen.  Für Klavierauszüge
muss natürlich kein \"solo\"/\"a2\" usw. hinzugefügt werden, man
sollte sie also ausschalten.  Wenn aber Solo-Stellen in einem
Klavierauszug oder einer Chorpartitur angezeigt werden, ist es besser,
normale Polyphonie zu verwenden, weil so die Solostellen angezeigt
werden, auch wenn der Text des Stimmenkombinierers ausgeschaltet ist.

Der Schnipsel zeigt drei Möglichkeiten, Stimmen auf einem System zu
kombinieren: Standardpolyphonie, @code{\\partcombine} ohne Text und
@code{\\partcombine} mit Text.

"
  doctitlede = "Zwei Stimmen auf einem System kombinieren"

%% Translation of GIT committish: de694eef021e3c38119b08370f79809bffc52a9b
  texidocfr = "
L'outil de combinaison de parties (la commande @code{\\partcombine})
permet d'avoir deux parties différentes sur une même portée.  LilyPond
ajoute automatiquement des indications textuelles, telles que « solo »
ou « a2 ».  Si votre intention n'est que de fusionner les parties, sans
ajouter de texte, assignez faux à la propriété
@code{printPartCombineTexts}.  Dans le cas de partitions vocales, et
plus particulièrement d'hymnes, ces « solo/a2 » ne sont d'aucune
utilité, aussi vaut-il mieux les désactiver.  Dans le cas où il y aurait
alternance entre @emph{solo} et @emph{tutti}, il vaut mieux faire appel
à de la musique polyphonique standard.

Voici trois moyens d'imprimer deux parties sur une même portée : en
polyphonie normale, avec @code{\\partcombine} sans indication
supplémentaire, et avec @code{\\partcombine} commentée.

"
  doctitlefr = "Combinaison de deux parties sur une même portée"

  lsrtags = "simultaneous-notes, syntax-and-expressions, text"

  texidoc = "
The part combiner tool ( @code{\\partcombine} command ) allows the
combination of several different parts on the same staff.  Text
directions such as @qq{solo} or @qq{a2} are added by default; to remove
them, simply set the property @code{printPartCombineTexts} to @code{f}.
For vocal scores (hymns), there is no need to add @qq{solo/a2} texts,
so they should be switched off.  However, it might be better not to use
it if there are any solos, as they won't be indicated.  In such cases,
standard polyphonic notation may be preferable.

This snippet presents the three ways two parts can be printed on a same
staff: standard polyphony, @code{\\partcombine} without texts, and
@code{\\partcombine} with texts.




"
  doctitle = "Combining two parts on the same staff"
} % begin verbatim

%% Combining pedal notes with clef changes

musicUp = \relative c'' {
  \time 4/4
  a4 c4.( g8) a4 |
  g4 e' g,( a8 b) |
  c b a2.
} % begin verbatim


musicDown = \relative c'' {
  g4 e4.( d8) c4 |
  r2 g'4( f8 e) |
  d2 \stemDown a
}

\score {
    <<
    \new Staff \with { instrumentName = #"Standard polyphony" }

      << \musicUp \\ \musicDown >>

    \new Staff \with {
      instrumentName = #"PartCombine without text"
      printPartCombineTexts = ##f
    }

    \partcombine \musicUp \musicDown

    \new Staff \with { instrumentName = #"PartCombine with text" }
      \partcombine \musicUp \musicDown
    >>
  \layout {
    indent = 6.0\cm
    \context {
      \Score
      \override SystemStartBar.collapse-height = #30
    }
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
