%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "horizontally-aligning-custom-dynamics-e.g.-sempre-pp,-piu-f,-subito-p.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.di.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.18.0"

\header {
%% Translation of GIT committish: 5db593aa3737cf8c60f9c4c4fcbe317c2d832766
  texidoces = "
Algunas expresiones de matiz dinámico llevan texto adicional, como
@qq{sempre pp}.  Dado que los matices suelen ir centrados bajo la
nota, el \\pp se imprimiría mucho después de la nota a la que se
aplica el matiz.

Para alinear correctamente el @qq{sempre pp} en sentido horizontal, de
manera que se alinee como si estuviese solamente el \\pp, hay varios
enfoques:

* Sencillamente usar @code{\\once\\override DynamicText.X-offset =
#-9.2} antes de la nota que lleva el matiz, para desplazarlo
manualmente a la posicion correcta.  Inconveniente: hay que hacerlo
manualmente cada vez que usamos esa indicación dinámica.

* Añadir algo de relleno (@code{#:hspace 7.1}) dentro de la definición
de nuestra indicación dinámica personalizada, de forma que despues de
que lilypond la ha centrado, ya esté alineada correctamente.
Inconveniente: el relleno realmente ocupa ese espacio y no permite que
se imprima ningún otro elemento de marcado o matiz dinámico en esa
posición.

* Fijar las dimensiones del texto adicional a cero (usando
@code{#:with-dimensions '(0 . 0) '(0 . 0)}).  Inconveniente: para
LilyPond @qq{sempre} no tiene dimensiones, por lo que podría imprimir
otros elementos en su mismo lugar y producir colisiones (que no serían
advertidas por el mecanismo de detección de colisiones).  Asimismo,
aparentemente hay algún espacio, y por tanto no es exactamente la
misma alineación que sin el texto adicional.

* Añadir un desplazamiento explícito directamente dentro de la función
de Scheme que produce el elemento dynamic-script.

* Fijar una alineación explícita dentro del dynamic-script.  De forma
predeterminada, esto no tendría ningún efecto, a no ser que fijásemos
un valor para X-offset.  Inconveniente: tenemos que dar un valor a
@code{DynamicText #'X-offset} ¡que se aplicaría a todos los textos de
dinámica!.  Asimismo, se alinea con el extremo derecho del texto
adicional, no con el centro del pp.

"
  doctitlees = "Alinear horizontalmente indicaciones dinámicas personalizadas (p.ej. \"sempre pp\"\"piu f\"\"subito p\")"

%% Translation of GIT committish: 08c1ead90d9f49e66ce54208639fb9ef48ca52a6
  texidocfr = "
Certaines indications de nuance requièrent un complément textuel, comme
« sempre pp ».  Dans la mesure où les nuances sont habituellement
centrées sous la note, le @emph{pp} se trouvera repoussé loin après la
note à laquelle il s'applique.

Différentes approches permettent de correctement aligner horizontalement
ce « sempre pp » :

-- Un simple @code{\\once \\override DynamicText.X-offset = #-9.2}
   avant la note considérée de telle sorte que la nuance soit décalée
   manuellement à la bonne place.  Inconvénient : il faut le faire
   manuellement à chaque fois qu'intervient ce @emph{markup}.

-- L'intégration d'un rembourrage (@code{#:hspace 7.1}) à la définition
   de cette nuance personnalisée afin qu'une fois centrée par LilyPond
   elle soit correctement alignée.  Inconvénient : le rembourrage
   occupera exactement cet espace et ne permettra à aucun autre
   @emph{markup} ou nuance d'apparaître à cet endroit.

-- L'application d'un décalage au script de nuance
   @code{\\once \\override @dots{} X-offset = @dots{}}.
   Inconvénient : là aussi il faut le faire à chaque fois.

-- L'attribution arbitraire d'une dimension à 0 du texte additionnel à
   l'aide d'un @code{#:with-dimensions '(0 . 0) '(0 . 0)}.
   Inconvénient : LilyPond considère que « sempre » n'occupe pas
   d'espace, et donc pourra mettre à cet endroit d'autres éléments, ce
   qui pourrait générer des collisions qui ne seront pas détectées par
   les routines @emph{ad hoc}.  D'autre part, il semble persister un
   espacement, ce qui laisse l'impression d'un alignement différent en
   l'absence de texte additionnel.

-- L'ajout, explicite, du décalage directement dans la fonction Scheme
   du script de nuance.

-- La définition d'un alignement explicite au sein du script de nuance.
   Ceci ne sera suivi d'effet, par défaut, qu'en jouant sur
   @code{X-offset}.  Inconvénient : il faut définir
   @code{DynamicText.X-offset}, ce qui s'appliquera à toutes les
   nuances textuelles.  Par ailleurs, l'alignement sera réalisé sur le
   bord droit du texte additionnel, non sur le milieu de @emph{pp}.

"
  doctitlefr = "Alignement de nuances personnalisées comme \"sempre pp\" \"più f\" \"subito p\""

  lsrtags = "expressive-marks, tweaks-and-overrides, version-specific"

  texidoc = "
Some dynamic expressions involve additional text, like @qq{sempre pp}.
Since dynamics are usually centered under the note, the \\pp would be
displayed way after the note it applies to.

To correctly align the @qq{sempre pp} horizontally, so that it is
aligned as if it were only the \\pp, there are several approaches:

* Simply use @code{\\once\\override DynamicText.X-offset = #-9.2}
before the note with the dynamics to manually shift it to the correct
position. Drawback: This has to be done manually each time you use that
dynamic markup...

* Add some padding (@code{#:hspace 7.1}) into the definition of your
custom dynamic mark, so that after lilypond center-aligns it, it is
already correctly aligned. Drawback: The padding really takes up that
space and does not allow any other markup or dynamics to be shown in
that position.

* Shift the dynamic script @code{\\once\\override ... .X-offset = ..}.
Drawback: @code{\\once\\override} is needed for every invocation!

* Set the dimensions of the additional text to 0 (using
@code{#:with-dimensions '(0 . 0) '(0 . 0)}). Drawback: To LilyPond
@qq{sempre} has no extent, so it might put other stuff there and create
collisions (which are not detected by the collision detection!). Also,
there seems to be some spacing, so it's not exactly the same alignment
as without the additional text

* Add an explicit shifting directly inside the scheme function for the
dynamic-script.

* Set an explicit alignment inside the dynamic-script. By default, this
won't have any effect, only if one sets X-offset! Drawback: One needs
to set @code{DynamicText.X-offset}, which will apply to all dynamic
texts! Also, it is aligned at the right edge of the additional text,
not at the center of pp.




"
  doctitle = "Horizontally aligning custom dynamics (e.g. \"sempre pp\" \"piu f\" \"subito p\")"
} % begin verbatim

\paper {
  ragged-right = ##f
  indent = 2.5\cm
}

% Solution 1: Using a simple markup with a particular halign value
% Drawback: It's a markup, not a dynamic command, so \dynamicDown
%           etc. will have no effect
semppMarkup = \markup { \halign #1.4 \italic "sempre" \dynamic "pp" }

% Solution 2: Using a dynamic script & shifting with
%             \once \override ...X-offset = ..
% Drawback: \once \override needed for every invocation
semppK =
#(make-dynamic-script
  (markup #:line
          (#:normal-text
           #:italic "sempre"
           #:dynamic "pp")))

% Solution 3: Padding the dynamic script so the center-alignment
%             puts it at the correct position
% Drawback: the padding really reserves the space, nothing else can be there
semppT =
#(make-dynamic-script
  (markup #:line
          (#:normal-text
           #:italic "sempre"
           #:dynamic "pp"
           #:hspace 7.1)))

% Solution 4: Dynamic, setting the dimensions of the additional text to 0
% Drawback: To lilypond "sempre" has no extent, so it might put
%           other stuff there => collisions
% Drawback: Also, there seems to be some spacing, so it's not exactly the
%           same alignment as without the additional text
semppM =
#(make-dynamic-script
  (markup #:line
          (#:with-dimensions '(0 . 0) '(0 . 0)
                             #:right-align
                             #:normal-text
                             #:italic "sempre"
                             #:dynamic "pp")))

% Solution 5: Dynamic with explicit shifting inside the scheme function
semppG =
#(make-dynamic-script
  (markup #:hspace 0
          #:translate '(-18.85 . 0)
          #:line (#:normal-text
                  #:italic "sempre"
                  #:dynamic "pp")))

% Solution 6: Dynamic with explicit alignment. This has only effect
%             if one sets X-offset!
% Drawback: One needs to set DynamicText.X-offset!
% Drawback: Aligned at the right edge of the additional text,
%           not at the center of pp
semppMII =
#(make-dynamic-script
  (markup #:line (#:right-align
                  #:normal-text
                  #:italic "sempre"
                  #:dynamic "pp")))

\context StaffGroup <<
  \context Staff = "s" <<
    \set Staff.instrumentName = #"Normal"
    \relative c'' {
      \override Staff.InstrumentName.self-alignment-X = #LEFT
      \key es \major
      c4\pp c\p c c | c\ff c c\pp c
    }
  >>
  \context Staff = "sMarkup" <<
    \set Staff.instrumentName = \markup \column { Normal markup }
    \relative c'' {
      \override Staff.InstrumentName.self-alignment-X = #LEFT
      \key es \major
      c4-\semppMarkup c\p c c | c\ff c c-\semppMarkup c
    }
  >>
  \context Staff = "sK" <<
    \set Staff.instrumentName = \markup \column { Explicit shifting }
    \relative c'' {
      \override Staff.InstrumentName.self-alignment-X = #LEFT
      \key es \major
      \once \override DynamicText.X-offset = #-9.2
      c4\semppK c\p c c
      c4\ff c
      \once \override DynamicText.X-offset = #-9.2
      c4\semppK c
    }
  >>
  \context Staff = "sT" <<
    \set Staff.instrumentName = \markup \column { Right padding }
    \relative c'' {
      \override Staff.InstrumentName.self-alignment-X = #LEFT
      \key es \major
      c4\semppT c\p c c | c\ff c c\semppT c
    }
  >>
  \context Staff = "sM" <<
    \set Staff.instrumentName = \markup \column { Setting dimension "to zero" }
    \relative c'' {
      \override Staff.InstrumentName.self-alignment-X = #LEFT
      \key es \major
      c4\semppM c\p c c | c\ff c c\semppM c
    }
  >>
  \context Staff = "sG" <<
    \set Staff.instrumentName = \markup \column { Shifting inside dynamics }
    \relative c'' {
      \override Staff.InstrumentName.self-alignment-X = #LEFT
      \key es \major
      c4\semppG c\p c c | c\ff c c\semppG c
    }
  >>
  \context Staff = "sMII" <<
    \set Staff.instrumentName = \markup \column { Alignment inside dynamics }
    \relative c'' {
      \override Staff.InstrumentName.self-alignment-X = #LEFT
      \key es \major
      % Setting to ##f (false) gives the same result
      \override DynamicText.X-offset = #0
      c4\semppMII c\p c c | c\ff c c\semppMII c
    }
  >>
>>



% ****************************************************************
% end ly snippet
% ****************************************************************
