%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "changing-midi-output-to-one-channel-per-voice.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.di.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.18.0"

\header {
%% Translation of GIT committish: 45dd19546e9b75b3e1e977732f0962f35dd3290e
  texidoces = "
Al producir una salida MIDI, el comportamiento predeterminado es que
cada pentagrama representa un canal MIDI, con todas las voces de dicho
pentagrama mezcladas.  Esto reduce al mínimo el riesgo de que se agote
el número de canales MIDI disponibles, pues existe un máximo de 16
canales por cada puerto MIDI, y la mayoría de los dispositivos sólo
tiene un puerto.

Sin embargo, cuando se traslada el interpretador
@code{Staff_performer} al contexto @code{Voice}, cada voz de un
pentagrama puede tener su propio canal MIDI, como se muestra en el
siguiente ejemplo: a pesar de estar sobre el mismo pentagrama, se
crean dos canales MIDI, cada uno con un @code{midiInstrument}
distinto.

"
  doctitlees = "Modificar la salida MIDI para que tenga un canal por cada voz"

%% Translation of GIT committish: a51b7ab55aed341ffd8af27a357212ed7ef528b9
  texidocit = "
Nella creazione del file di output MIDI, il comportamento predefinito prevede
che ogni rigo sia assegnato a un canale MIDI, con tutte le voci del rigo
amalgamate in un canale. Ciò diminuisce il rischio di esaurire i canali
MIDI disponibili, dato che ce ne sono solo 16 per traccia.

Tuttavia, spostando @code{Staff_performer} nel contesto @code{Voice}, ogni
voce in un rigo può avere il proprio canale MIDI, come è illustrato
nell'esempio seguente: sebbene le voci siano sullo stesso rigo, vengono
creati due canali MIDI, ciascuno con un diverso strumento MIDI
(@code{midiInstrument}).

"
  doctitleit = "Impostare l'output MIDI su un canale per voce"


%% Translation of GIT committish: 8eae9a75fb3ec1d0b6633103c8a652608c8fa630
  texidocfr = "
Lorsque LilyPond génère un fichier MIDI, chaque portée sera par défaut
affectée à un canal, quel que soit le nombre de voix qu'elle contient.
Ceci permet d'éviter de se retrouver à court de canaux, sachant qu'il
n'y en a que seize de disponibles par piste.

Le fait de déplacer le @code{Staff_performer} dans le contexte
@code{Voice} permet d'affecter à chaque voix d'une même portée un canal
MIDI spécifique.  Dans l'exemple suivant, la même portée donnera lieu à
deux canaux MIDI différents, chacun étant affecté de son propre
@code{midiInstrument}.

"
  doctitlefr = "Affectation d'un canal MIDI par voix"

  lsrtags = "contexts-and-engravers, midi, real-music"

  texidoc = "
When outputting MIDI, the default behavior is for each staff to
represent one MIDI channel, with all the voices on a staff amalgamated.
This minimizes the risk of running out of MIDI channels, since there
are only 16 available per track.

However, by moving the @code{Staff_performer} to the @code{Voice}
context, each voice on a staff can have its own MIDI channel, as is
demonstrated by the following example: despite being on the same staff,
two MIDI channels are created, each with a different
@code{midiInstrument}.

"
  doctitle = "Changing MIDI output to one channel per voice"
} % begin verbatim

\score {
  \new Staff <<
    \new Voice \relative c''' {
      \set midiInstrument = #"flute"
      \voiceOne
      \key g \major
      \time 2/2
      r2 g-"Flute" ~
      g fis ~
      fis4 g8 fis e2 ~
      e4 d8 cis d2
    }
    \new Voice \relative c'' {
      \set midiInstrument = #"clarinet"
      \voiceTwo
      b1-"Clarinet"
      a2. b8 a
      g2. fis8 e
      fis2 r
    }
  >>
  \layout { }
  \midi {
    \context {
      \Staff
      \remove "Staff_performer"
    }
    \context {
      \Voice
      \consists "Staff_performer"
    }
    \tempo 2 = 72
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
