%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm,quote,ragged-right]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
  line-width = 160\mm - 2.0 * 10.16\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
  ragged-right = ##t
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "partcombine-and-autobeamoff.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.di.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.18.0"

\header {
%% Translation of GIT committish: 26a079ca2393d053315ef8dbef626c897dc9645a
  texidoces = "
Puede ser difícil comprender la función de @code{\\autoBeamOff} cuando
se usa con @code{\\partcombine}.

Puede ser preferible usar


@code{\\set Staff.autoBeaming = ##f}


en su lugar, para asegurarse de que el barrado automático se desactiva
para todo el pentagrama.


@code{\\partcombine} funciona aparentemente con tres voces: plica
arriba cuando hay una sola voz, plica abajo con la otra, y plica
arriba cuando está combinada.


Una llamada a @code{\\autoBeamOff} en el primer argumento de
partcombine se aplica a la voz que está activa en el momento en que se
procesa la llamada, ya sea voz única con la plica hacia arriba, hacia
abajo o combinadas.  Una llamada a @code{\\autoBeamOff} en el segundo
argumento se aplica a la voz que está sola con la plica abajo.


Para pode usar @code{\\autoBeamOff} con el objeto de detener todo el
barrado automático cuando se usa con @code{\\partcombine}, es
necesario hacer tres llamadas a @code{\\autoBeamOff}.

"
  doctitlees = "Partcombine y autoBeamOff"

%% Translation of GIT committish: a51b7ab55aed341ffd8af27a357212ed7ef528b9
  texidocit = "
La funzione @code{\\autoBeamOff}, se usata insieme a
@code{\\partcombine}, può essere difficile da comprendere.

È preferibile usare invece


@code{\\set Staff.autoBeaming = ##f}


per assicurarsi che la disposizione delle travature sia disabilitata
per tutto il rigo.


@code{\\partcombine} funziona con 3 voci -- gambo in su singolo,
gambo in giù singolo, gambo in su unito.


L'uso di @code{\\autoBeamOff} all'interno del primo argomento di partcombine
ha effetto sulla voce che è attiva al momento in cui la funzione viene elaborata,
ovvero sul gambo in su singolo o sul gambo in giù unito. L'uso di @code{\\autoBeamOff}
nel secondo argomento avrà effetto sulla voce che ha il gambo in giù singolo.


Per poter usare @code{\\autoBeamOff} per impedire tutte le disposizioni automatiche
delle travature, se usato con @code{\\partcombine}, è necessario richiamare
tre volte la funzione @code{\\autoBeamOff}.

"
  doctitleit = "Partcombine e autoBeamOff"

%%   Translation of GIT committish: ab9e3136d78bfaf15cc6d77ed1975d252c3fe506

  texidocde = "
Die Funktionsweise von @code{@bs{}autoBeamOff}, wenn es zusammen mit
@code{@bs{}partcombine} eingesetzt wird, kann schwer zu verstehen sein.
Es kann besser sein, anstatt dessen

@example
\set Staff.autobeaming = ##f
@end example

@noindent
zu benutzen, um sicherzustellen, dass die automatische Bebalkung für das
gesamte System ausgeschaltet ist.

@code{\partcombine} funktioniert offensichtlich mit 3 Stimme (Hals nach oben
einfach, Hals nach unten einfach, Hals nach oben kombiniert).

Ein @code{\autoBeamOff}-Befehl im ersten Argument von @code{\partcombine}
gilt für die Stimme, die zu dem Zeitpunkt aktiv ist, an dem der Befehl
verarbeitet wird, entweder für Hals nach oben, nach unten oder Hals nach
oben kombiniert.  Ein @code{\autoBeamOff}-Befehl im zweiten Argument gilt
für die Stimme, die mit Hals nach unten einfach ist.

Um @code{\autoBeamOff} zu benutzen, damit alle automatischen Balken aufhören,
wenn man es mit @code{\partcombine} verwendet, muss @code{\autoBeamOff}
@emph{dreimal} aufgerufen werden.

"
doctitlede = "Partcombine und autoBeamOff"


%% Translation of GIT committish: 8eae9a75fb3ec1d0b6633103c8a652608c8fa630
  texidocfr = "
La fonction @code{\\autoBeamOff} dans le cadre d'un @code{\\partcombine}
agit de façon bien particulière ; c'est pourquoi il vaut mieux tout
d'abord recourir à

@example
\set Staff.autobeaming = ##f
@end example

@noindent
pour désactiver les ligatures automatiques pour l'ensemble de la portée
concernée.

L'instruction @code{\\partcombine} fonctionne apparemment sur la base de
trois voix : solo hampes montantes, solo hampes descendantes et ensemble
hampes montantes.

Lorsque @code{\\autoBeamOff} apparaît dans le premier argument de la
combinaison, il s'applique à la voix active à ce moment précis, qu'il
s'agisse du solo hampes montantes ou du combiné hampes montantes.
Lorsqu'elle est introduite dans le second argument, la commande
@code{\\autoBeamOff} s'appliquera au solo hampes descendantes.

Vous devrez donc, afin que @code{\\autoBeamOff} soit pleinement
opérationnel dans le cadre d'un @code{\\partcombine}, l'introduire aux
@strong{trois} niveaux.

"
  doctitlefr = "Partcombine et autoBeamOff"

  lsrtags = "rhythms"

  texidoc = "
The function of @code{\\autoBeamOff} when used with
@code{\\partcombine} can be difficult to understand.

It may be preferable to use


@code{\\set Staff.autoBeaming = ##f}


instead, to ensure that autobeaming will be turned off for the entire
staff.


@code{\\partcombine} apparently works with 3 voices -- stem up single,
stem down single, stem up combined.


An @code{\\autoBeamOff} call in the first argument to partcombine will
apply to the voice that is active at the time the call is processed,
either stem up single or stem up combined. An @code{\\autoBeamOff} call
in the second argument will apply to the voice that is stem down single.


In order to use @code{\\autoBeamOff} to stop all autobeaming when used
with @code{\\partcombine}, it will be necessary to use three calls to
@code{\\autoBeamOff}.




"
  doctitle = "Partcombine and autoBeamOff"
} % begin verbatim

{
  %\set Staff.autoBeaming = ##f % turns off all autobeaming
  \partcombine
  {
    \autoBeamOff % applies to split up stems
    \repeat unfold 4 a'16
    %\autoBeamOff % applies to combined up stems
    \repeat unfold 4 a'8
    \repeat unfold 4 a'16
  }
  {
    \autoBeamOff % applies to down stems
    \repeat unfold 4 f'8
    \repeat unfold 8 f'16 |
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
