%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "creating-custom-dynamics-in-midi-output.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.di.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.18.0"

\header {
%% Translation of GIT committish: 958e95822083954cad00e0a598eb9f12ceba67b9
  texidocfr = "
L'exemple suivant illustre la manière de créer une indication de nuance,
absente de la liste par défaut, et de lui assigner une valeur spécifique
utile à la sortie MIDI.

L'indication de nuance @code{\\rfz} (@notation{rinforzando}) se voit
attribué une valeur de @code{0.9}.

"

  doctitlefr = "Création de nuance particulière pour la sortie MIDI"

  lsrtags = "midi, scheme-language"

  texidoc = "
The following example shows how to create a dynamic marking, not
included in the default list, and assign it a specific value so that it
can be used to affect MIDI output.


The dynamic mark @code{\\rfz} is assigned a value of @code{0.9}.

"
  doctitle = "Creating custom dynamics in MIDI output"
} % begin verbatim

#(define (myDynamics dynamic)
    (if (equal? dynamic "rfz")
      0.9
      (default-dynamic-absolute-volume dynamic)))

\score {
  \new Staff {
    \set Staff.midiInstrument = #"cello"
    \set Score.dynamicAbsoluteVolumeFunction = #myDynamics
    \new Voice {
      \relative {
        a'4\pp b c-\rfz
      }
    }
  }
  \layout {}
  \midi {}
}



% ****************************************************************
% end ly snippet
% ****************************************************************
