%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "showing-the-same-articulation-above-and-below-a-note-or-chord.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.di.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.18.0"

\header {
%% Translation of GIT committish: 56145dfed8f19bb34459d5b40cab388776d2ec49
  texidoces = "
De forma predeterminada, LilyPond no permite poner la misma
articulación (p.ej., un acento, un calderón, un círculo de armónico,
etc.) encima y debajo de la nota.  Por ejemplo, c4_\\fermata^\\fermata
imprime solamente el calderón inferior.  El calderón superior
sencillamente se ignora.  Sin embargo, se pueden adosar inscripciones
(de igual forma que las digitaciones) dentro de un acorde, lo que
significa que es posible tener tantas articulaciones como se desee.
Este enfoque tiene la ventaja de que ignora la plica y posiciona la
articulación de forma relativa a la cabeza de la nota.  Puede verse
esto en el caso de los flageolets (indicaciones de armónico) que
aparecen en el fragmento de código.  Para recrear el comportamiento de
las inscripciones fuera del acorde, se requiere 'add-stem-support.
Así, la solución consiste en escribir la nota como un acorde y añadir
las articulaciones dentro de los paréntesis en ángulo <...>.  La
dirección siempre será hacia arriba, pero podemos retocar esto por
medio de una instrucción \\tweak: @code{<c-\\tweak dirección
#DOWN-\\fermata^\\fermata>}

"
  doctitlees = "Imprimir la misma articulación encima y debajo de la misma nota o acorde"

%% Translation of GIT committish: 8eae9a75fb3ec1d0b6633103c8a652608c8fa630
  texidocfr = "
LilyPond ne permet pas, par défaut, qu'une même articulation (accent,
flageolet, point d'orgue, etc.) se retrouve à la fois au-dessus et
au-dessous d'une note.  Par exemple, @code{c4_\\fermata^\\fermata} ne
donnera qu'un seul point d'orgue en dessous du do ; celui du dessus sera
tout bonnement ignoré.  On peut néanmoins accoler des scripts, tels des
doigtés, à l'intérieur d'un accord ; il peut donc y avoir autant
d'articulations que de besoin, ce qui, par voie de conséquence, permet
de s'affranchir de la présence des hampes et de positionner
l'articulation relativement à la tête de note comme dans le cas du
flageolet ci-dessous.  L'imitation du traitement d'un script
externe à un accord requérant un @code{add-stem-support} demande
de libeller la note comme étant un accord et d'ajouter les
articulations au sein de la construction @code{<@dots{}>}.  Un simple
amendement permettra de rectifier le positionnement habituel en
surplomb : @code{<c-\\tweak direction #DOWN-\\fermata^\\fermata>}

"
  doctitlefr = "Impression d'une même articulation des deux côtés d'une note ou d'un accord"

  lsrtags = "expressive-marks, tweaks-and-overrides, version-specific"

  texidoc = "
By default, LilyPond does not allow the same articulation (e.g., an
accent, a fermata, a flageolet, etc.) to be displayed above and below a
note. For example, c4_\\fermata^\\fermata will only show a fermata
below. The fermata above will simply be ignored. However, one can stick
scripts (just like fingerings) inside a chord, which means it is
possible to have as many articulations as desired. This approach has
the advantage that it ignores the stem and positions the articulation
relative to the note head. This can be seen in the case of the
flageolets in the snippet. To mimic the behaviour of scripts outside a
chord, 'add-stem-support would be required. So, the solution is to
write the note as a chord and add the articulations inside the <...>.
The direction will always be above, but one can tweak this via a
\\tweak: @code{<c-\\tweak direction #DOWN-\\fermata^\\fermata>}

"
  doctitle = "Showing the same articulation above and below a note or chord"
} % begin verbatim

% The same as \flageolet, just a little smaller
smallFlageolet =
#(let ((m (make-articulation "flageolet")))
   (set! (ly:music-property m 'tweaks)
         (acons 'font-size -2
                (ly:music-property m 'tweaks)))
   m)

\relative c' {
  s4^"Wrong:"
  c4_\fermata^\fermata % The second fermata is ignored!
  <e d'>4^\smallFlageolet_\smallFlageolet

  s4^"Works if written inside a chord:"
  <e_\smallFlageolet d'^\smallFlageolet>4
  <e_\flageolet d'^\flageolet>4
  <e_\smallFlageolet^\smallFlageolet>4
  <e_\fermata^\fermata>4
}



% ****************************************************************
% end ly snippet
% ****************************************************************
