%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "center-text-below-hairpin-dynamics.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.di.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.18.0"

\header {
%% Translation of GIT committish: 56145dfed8f19bb34459d5b40cab388776d2ec49
  texidoces = "
Este ejemplo proporciona una función para tipografiar un regulador con
texto por debajo, como @qq{molto} o @qq{poco}.  El texto añadido
cambia la dirección de acuerdo con la del regulador.  El objeto
Hairpin está alineado con DynamicText.

El ejemplo ilustra también cómo modificar la manera en que se imprime
normalmente un objeto, utilizando código de Scheme.

"
  doctitlees = "Centrar texto debajo de un regulador"

%% Translation of GIT committish: 8eae9a75fb3ec1d0b6633103c8a652608c8fa630
  texidocfr = "
La fonction comprise dans l'extrait suivant permet d'ajouter du texte
-- comme « molto » ou « poco » -- en dessous d'un soufflet de
(de)crescendo.  Cet exemple présente aussi comment, à l'aide de code
Scheme, influencer la manière dont un objet est normalement imprimé.

"
  doctitlefr = "Texte centré sous un soufflet"

  lsrtags = "expressive-marks, really-cool, scheme-language, text"

  texidoc = "
This example provides a function to typeset a hairpin (de)crescendo
with some additional text below it, such as @qq{molto} or @qq{poco}.
The added text will change the direction according to the direction of
the hairpin. The Hairpin is aligned to DynamicText.

The example also illustrates how to modify the way an object is
normally printed, using some Scheme code.

"
  doctitle = "Center text below hairpin dynamics"
} % begin verbatim

hairpinWithCenteredText =
#(define-music-function (parser location text) (markup?)
  #{
    \once \override Voice.Hairpin.after-line-breaking =
      #(lambda (grob)
        (let* ((stencil (ly:hairpin::print grob))
               (par-y (ly:grob-parent grob Y))
               (dir (ly:grob-property par-y 'direction))
               (new-stencil (ly:stencil-aligned-to
                 (ly:stencil-combine-at-edge
                   (ly:stencil-aligned-to stencil X CENTER)
                   Y dir
                   (ly:stencil-aligned-to (grob-interpret-markup grob text) X CENTER))
                 X LEFT))
               (staff-space (ly:output-def-lookup (ly:grob-layout grob) 'staff-space))
               (staff-line-thickness
                 (ly:output-def-lookup (ly:grob-layout grob) 'line-thickness))
               (grob-name (lambda (x) (assq-ref (ly:grob-property x 'meta) 'name)))
               (par-x (ly:grob-parent grob X))
               (dyn-text (eq? (grob-name par-x) 'DynamicText ))
               (dyn-text-stencil-x-length
                 (if dyn-text
                   (interval-length
                     (ly:stencil-extent (ly:grob-property par-x 'stencil) X))
                   0))
               (x-shift
                 (if dyn-text
                   (-
                     (+ staff-space dyn-text-stencil-x-length)
                     (* 0.5 staff-line-thickness)) 0)))

        (ly:grob-set-property! grob 'Y-offset 0)
        (ly:grob-set-property! grob 'stencil
           (ly:stencil-translate-axis
            new-stencil
            x-shift X))))
  #})

hairpinMolto =
\hairpinWithCenteredText \markup { \italic molto }

hairpinMore =
\hairpinWithCenteredText \markup { \larger moltissimo }

\layout { ragged-right = ##f }

\relative c' {
  \hairpinMolto
  c2\< c\f
  \hairpinMore
  c2\ppppp\< c\f
  \break
  \hairpinMolto
  c2^\< c\f
  \hairpinMore
  c2\ppppp\< c\f
}



% ****************************************************************
% end ly snippet
% ****************************************************************
