%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "how-to-change-fret-diagram-position.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.dsi.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.16.0"

\header {
%% Translation of GIT committish: e99967817ff985eb5bd5b0220b2fbf552963f9de
  texidocfr = "
Différents moyens permettent de repositionner un diagramme de fret pour
éviter des collisions ou le placer entre deux notes :

-- La modification des valeurs de @code{#'padding} ou de
   @code{#'extra-offset}comme pour le second diagramme;

-- L'adjonction d'une voix invisible dans laquelle les diagrammes sont
   attachés à des notes invisibles comme pour le troisième diagramme.

Lorsque le diagramme doit correspondre à une position rythmique dans la
mesure,  comme au troisième temps de la deuxième mesure, la seconde
méthode est plus appropriée, puisque le diagramme sera aligné sur le
temps.

"
  doctitlefr = "Repositionnement d'un diagramme de fret"

  lsrtags = "fretted-strings, specific-notation, tweaks-and-overrides"

  texidoc = "
If you want to move the position of a fret diagram, for example, to
avoid collision, or to place it between two notes, you have various
possibilities:

1) modify #'padding or #'extra-offset values (as shown in the first
snippet)

2) you can add an invisible voice and attach the fret diagrams to the
invisible notes in that voice (as shown in the second example).

 If you need to move the fret according with a rythmic position inside
the bar (in the example, the third beat of the measure) the second
example is better, because the fret is aligned with the third beat
itself.

"
  doctitle = "How to change fret diagram position"
} % begin verbatim


harmonies = \chordmode
{
  a8:13
% THE FOLLOWING IS THE COMMAND TO MOVE THE CHORD NAME
  \once \override ChordNames.ChordName #'extra-offset = #'(10 . 0)
  b8:13 s2.
% THIS LINE IS THE SECOND METHOD
    s4 s4  b4:13
}

\score
{
  <<
    \context ChordNames \harmonies
    \context Staff
    {a8^\markup { \fret-diagram  #"6-x;5-0;4-2;3-0;2-0;1-2;"  }
% THE FOLLOWING IS THE COMMAND TO MOVE THE FRET DIAGRAM
     \once \override TextScript #'extra-offset = #'(10 . 0)
     b4.~^\markup { \fret-diagram  #"6-x;5-2;4-4;3-2;2-2;1-4;"  } b4. a8\break
% HERE IS THE SECOND METHOD
     <<
       { a8 b4.~ b4. a8}
       { s4 s4 s4^\markup { \fret-diagram  #"6-x;5-2;4-4;3-2;2-2;1-4;"  }
       }
     >>
   }
  >>
}



% ****************************************************************
% end ly snippet
% ****************************************************************
