%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/home/gub/gub/target/linux-x86/src/lilypond-git.sv.gnu.org--lilypond.git-stable-2.16/input/regression/lily-in-scheme.ly"
\sourcefileline 0
\header { texidoc = "LilyPond syntax can be used inside scheme to
    build music expressions, with the @code{#@{ ... #@}} syntax.
    Scheme forms can be introduced inside these blocks by escaping
    them with a @code{$}, both in a LilyPond context or in a Scheme
    context.

In this example, the @code{\\withpaddingA}, @code{\\withpaddingB} and
@code{\\withpaddingC} music functions set different kinds of padding on
the @code{TextScript} grob.

"
          
      }

\version "2.16.0"
\layout { ragged-right = ##t }

withPaddingA = #(define-music-function (parser location padding music) (number? ly:music?)
		 #{ \override TextScript #'padding = #padding
		 $music 
		 \revert TextScript #'padding #})

withPaddingB = #(define-music-function (parser location padding music) (number? ly:music?)
		 #{ \override TextScript #'padding = #(* padding 2)
		 $music 
		 \revert TextScript #'padding #})

withPaddingC = #(define-music-function (parser location padding music) (number? ly:music?)
		 #{ \override TextScript #'padding = #(+ 1 (* padding 2))
		    $music 
		    \revert TextScript #'padding #})

{
    c'^"1"
    \withPaddingA #2
    { c'^"2" c'^"3"}
    c'^"4"
    \withPaddingB #2
    { c'^"5" c'^"6"}
    c'^"7"
    \withPaddingC #2
    { c'^"8" c'^"9"}
    c'^"10"
}



% ****************************************************************
% end ly snippet
% ****************************************************************
