%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/main/src/gub/target/linux-x86/src/lilypond-git.sv.gnu.org--lilypond.git-stable-2.16/input/regression/optional-args-backup.ly"
\sourcefileline 0
\version "2.16.0"

\header{
  texidoc= "Test backup of predicate-based optional music function arguments.

Unit expressions like @code{3\cm} can't be parsed as optional
arguments in one go since they would require lookahead after @code{3}.
The predicate is checked after @code{3}, and if it is suitable,
Lilypond commits to parsing as a unit number, and checks the result
again.  For the predicate @code{integer?} and @code{3\cm}, you would
actually get a syntax error (since the combination is no longer an
integer) rather than Lilypond trying to see @code{3\cm} as two
separate arguments."

}

\layout { ragged-right = ##t }

test=#(define-void-function (parser location expect . rest)
       (list? (string? "def1") (integer? "def2") (fraction? "def3") integer?)
       (if (not (equal? expect rest))
	(ly:parser-error parser
	 (format #f "Expected ~s, got ~s.\n" expect rest)
	 location)))

twice=2

\test #'("x" 3 (3 . 4) 8)        x 3 3/4 4\twice
\test #'("x" 3 "def3" 8)         x 3 4\twice
\test #'("x" 8 "def3" 10)        x 4\twice 5\twice
\test #'("def1" "def2" "def3" 8) 4\twice



% ****************************************************************
% end ly snippet
% ****************************************************************
