%% Generated by lilypond-book.py
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "using-ly-grob-object-to-access-grobs-with--tweak.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.dsi.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.16.0"

\header {
%% Translation of GIT committish: 596761e4a1c62fc2e85fe3396a378b814504e7b1

  texidoces = "

Se puede acceder @qq{lateralmente} a algunos grobs desde dentro de la
función de callback de otro grob.  Éstos se encuentran relacionados
normalmente como @qq{layout objects} (objetos de presentación) en la
sección @qq{Internal properties} (propiedades internas) de un
interface de grob.  Se usa la función @code{ly:grob-object} para
acceder a estos grobs.


Se presentan más abajo como ejemplo algunas formas de addecer a grobs
desde dentro de una función de callback de NoteHead, pero la técnica
no se limita a las cabezas de nota.  Sin embargo, la función de
callback de NoteHead es especialmente importante, porque es la función
de callback implícita que utiliza la instrucción @code{\\tweak}.


La función de ejemplo que se define abajo (\"display-grobs\") no es
probablemente tan útil, pero muestra que se está accediendo
efectivamente a los grobs.


Salida de ejemplo de la consola:


@example
--------------------
#-Grob Accidental -
#-Grob Arpeggio -
#-Grob Stem -
@end example


"

  doctitlees = "Utilizar ly:grob-object para acceder a los grobs con \\tweak"


%% Translation of GIT committish: cc3b9e1430f4cc9c54da7252e504f3d274a7ea17
  texidocfr = "
Certains objets graphiques ne sont accessibles que par le biais d'un
@emph{callback} à partir d'un autre @code{grob}.  Ils sont normalement
listés dans les « @emph{layout objects} » au sein de la section
« Propriétés internes » d'une @emph{grob-interface}.  La fonction
@code{ly:grob-object} permet d'accéder à ces objets.

Voici plusieurs moyens d'accéder aux objets par un @emph{callback} sur
@code{NoteHead}.  D'autres biais sont naturellement possible ;
@code{NoteHead} a cependant l'avantage incontestable d'être utilisé
implicitement par la commande @code{\\tweak}.

La fonction @code{display-grobs} définie ci-dessous n'est probablement
pas très utile.  Elle indique toutefois qu'il est tout à fait possible
d'accéder aux objets.

Voici par exemple ce qui sera émis dans la console :

@example
--------------------
#<Grob Accidental >
#<Grob Arpeggio >
#<Grob Stem >
@end example

"
  doctitlefr = "Utilisation de ly:grob-object pour accéder aux grobs avec \\tweak"

  lsrtags = "devel, scheme-language, tweaks-and-overrides"

  texidoc = "
Some grobs can be accessed @qq{laterally} from within another grob's
callback. These are usually listed as @qq{layout objects} in the
@qq{Internal properties} section of a grob-interface. The function
@code{ly:grob-object} is used to access these grobs.


Demonstrated below are some ways of accessing grobs from within a
NoteHead callback, but the technique is not limited to NoteHeads.
However, the NoteHead callback is particularly important, since it is
the implicit callback used by the @code{\\tweak} command.


The example function defined below (\"display-grobs\") is probably not
that useful, but it demonstrates that the grobs are indeed being
accessed.


Example console output:


-------------------- #-Grob Accidental - #-Grob Arpeggio - #-Grob Stem -



"
  doctitle = "Using ly:grob-object to access grobs with \\tweak"
} % begin verbatim

#(define (notehead-get-accidental notehead)
   ;; notehead is grob
   (ly:grob-object notehead 'accidental-grob))

#(define (notehead-get-arpeggio notehead)
   ;; notehead is grob
   (let ((notecolumn (notehead-get-notecolumn notehead)))
     (ly:grob-object notecolumn 'arpeggio)))

#(define (notehead-get-notecolumn notehead)
   ;; notehead is grob
   (ly:grob-parent notehead X))

#(define (notehead-get-stem notehead)
   ;; notehead is grob
   (let ((notecolumn (notehead-get-notecolumn notehead)))
     (ly:grob-object notecolumn 'stem)))

#(define (display-grobs notehead)
   ;; notehead is grob
   (let ((accidental (notehead-get-accidental notehead))
         (arpeggio (notehead-get-arpeggio notehead))
         (stem (notehead-get-stem notehead)))
     (format (current-error-port) "~2&~a\n" (make-string 20 #\-))
     (for-each
      (lambda (x) (format (current-error-port) "~a\n" x))
      (list accidental arpeggio stem))))

\relative c' {
  %% display grobs for each note head:
  %\override NoteHead #'before-line-breaking = #display-grobs
  <c
  %% or just for one:
  \tweak #'before-line-breaking #display-grobs
  es
  g>1\arpeggio
}



% ****************************************************************
% end ly snippet
% ****************************************************************
